<?php
/*
 * This is the config file for the theme.
 */

define("TD_THEME_NAME", "Newspaper");
define("TD_THEME_VERSION", "9.2.2");
define("TD_THEME_DEMO_URL", "https://demo.tagdiv.com/" . strtolower(TD_THEME_NAME));
define("TD_THEME_DEMO_DOC_URL", 'http://forum.tagdiv.com/demos_introduction/');  //the url to the demo documentation
define("TD_PLUGINS_URL", 'https://cloud.tagdiv.com/td_plugins/');  //plugins url
define("TD_FEATURED_CAT", "Featured"); //featured cat name
define("TD_FEATURED_CAT_SLUG", "featured"); //featured cat slug
define("TD_THEME_OPTIONS_NAME", "td_011"); //where to store our options

define("TD_AURORA_VERSION", "__td_aurora_deploy_version__");

define("TD_THEME_WP_BOOSTER", "3.0"); // prevents multiple instances of the framework

//if no deploy mode is selected, we use the final deploy built
if (!defined('TD_DEPLOY_MODE')) {
    define("TD_DEPLOY_MODE", 'deploy');
}






switch (TD_DEPLOY_MODE) {
    default:
        //deploy version - this is the version that we ship!
        define("TD_DEBUG_LIVE_THEME_STYLE", false);
        define("TD_DEBUG_IOS_REDIRECT", false);
        define("TD_DEBUG_USE_LESS", false);
        break;

    case 'dev':
        //dev version
        define("TD_DEBUG_LIVE_THEME_STYLE", true);
        define("TD_DEBUG_IOS_REDIRECT", false);
        define("TD_DEBUG_USE_LESS", true); //use less on dev
        break;

    case 'demo':
        //demo version
        define("TD_DEBUG_LIVE_THEME_STYLE", true);
        define("TD_DEBUG_IOS_REDIRECT", true); // remove themeforest iframe from ios devices on demo only!
        define("TD_DEBUG_USE_LESS", false);
        break;
}



/**
 * speed booster v 3.0 hooks - prepare the framework for the theme
 * is also used by td_deploy - that's why it's a static class
 * Class td_wp_booster_hooks
 */
class td_config {


    /**
     * @throws ErrorException
     */
    static function on_td_global_after_config() {



        /**
         * js files list
         */
        td_global::$js_files = array(


	        'tdAnalytics' =>             '/includes/wp_booster/js_dev/tdAnalytics.js',
	        'tdExternal' =>             '/includes/wp_booster/js_dev/tdExternal.js',
            'tdDetect' =>               '/includes/wp_booster/js_dev/tdDetect.js',

	        'tdViewport' =>             '/includes/wp_booster/js_dev/tdViewport.js',

            'tdMenu' =>                 '/includes/wp_booster/js_dev/tdMenu.js',
            //'tdLocalCache' =>         '/includes/wp_booster/js_dev/tdLocalCache.js',
            'tdUtil' =>                 '/includes/wp_booster/js_dev/tdUtil.js',
            'tdAffix' =>                '/includes/wp_booster/js_dev/tdAffix.js',
            //'td_scroll_animation' =>  '/includes/wp_booster/js_dev/td_scroll_animation.js',
            'td_site' =>                '/includes/wp_booster/js_dev/td_site.js',

            'tdLoadingBox' =>           '/includes/wp_booster/js_dev/tdLoadingBox.js',
            'tdAjaxSearch' =>           '/includes/wp_booster/js_dev/tdAjaxSearch.js',
            'tdPostImages' =>           '/includes/wp_booster/js_dev/tdPostImages.js',
            'tdBlocks' =>               '/includes/wp_booster/js_dev/tdBlocks.js',
            'tdLogin' =>                '/includes/wp_booster/js_dev/tdLogin.js',
            'tdLoginMobile' =>          '/includes/wp_booster/js_dev/tdLoginMobile.js',
            'tdStyleCustomizer' =>      '/includes/wp_booster/js_dev/tdStyleCustomizer.js',
            'tdTrendingNow' =>          '/includes/wp_booster/js_dev/tdTrendingNow.js',
            'td_history' =>             '/includes/wp_booster/js_dev/td_history.js',
            'tdSmartSidebar' =>         '/includes/wp_booster/js_dev/tdSmartSidebar.js',
            'tdInfiniteLoader' =>       '/includes/wp_booster/js_dev/tdInfiniteLoader.js',
	        'vimeo_froogaloop' =>       '/includes/wp_booster/js_dev/vimeo_froogaloop.js',

	        'tdCustomEvents' =>         '/includes/js_files/tdCustomEvents.js',
	        'tdEvents' =>               '/includes/wp_booster/js_dev/tdEvents.js',

	        'tdAjaxCount' =>            '/includes/wp_booster/js_dev/tdAjaxCount.js',
            'tdVideoPlaylist' =>        '/includes/wp_booster/js_dev/tdVideoPlaylist.js',
	        'td_slide' =>               '/includes/wp_booster/js_dev/td_slide.js',
            'tdPullDown' =>             '/includes/wp_booster/js_dev/tdPullDown.js',

            //'td_main' =>              '/includes/js_files/td_main.js',
            'td_fps' =>                 '/includes/js_files/td_fps.js',
	        'tdAnimationScroll' =>      '/includes/wp_booster/js_dev/tdAnimationScroll.js',
	        'tdHomepageFull' =>         '/includes/wp_booster/js_dev/tdHomepageFull.js',
	        'tdBackstr' =>              '/includes/wp_booster/js_dev/tdBackstr.js',

            //'td_scroll_effects.js' => '/includes/js_files/td_scroll_effects.js',

	        'tdAnimationStack' =>       '/includes/wp_booster/js_dev/tdAnimationStack.js',
	        'td_main' =>                '/includes/js_files/td_main.js',

            'td_loop_ajax' =>           '/includes/wp_booster/js_dev/tdLoopAjax.js',

	        'tdWeather' =>              '/includes/wp_booster/js_dev/tdWeather.js',
            'tdLastInit' =>             '/includes/wp_booster/js_dev/tdLastInit.js',
            'tdAnimationSprite' =>      '/includes/wp_booster/js_dev/tdAnimationSprite.js',
            'tdDatei18n' =>             '/includes/wp_booster/js_dev/tdDatei18n.js',
            'tdSocialSharing'=>         '/includes/wp_booster/js_dev/tdSocialSharing.js'

        );


	    /**
	     * tdViewport intervals in crescendo order
	     */
	    td_global::$td_viewport_intervals = array(
		    array(
			    "limitBottom" => 767,
			    "sidebarWidth" => 228,
		    ),
		    array(
			    "limitBottom" => 1018,
			    "sidebarWidth" => 300,
		    ),
		    array(
			    "limitBottom" => 1140,
			    "sidebarWidth" => 324,
		    ),
	    );


	    /**
	     * - td animation stack effects used in the 'loading animation image' theme panel section
	     * - the first element is a special case, it representing the default type 'type0' @see animation-stack.less
	     * - the 'val' parameter is the type effect
	     * - the 'specific_selectors' parameter is the css selector used to look for new elements inside of some specific sections [ex. at ajax req]
	     * - the 'general_selectors' parameter is the css selector used to look for elements on extended sections [ex. entire page]
	     * - Important! the 'general_selectors' is not used by the default 'type0'
	     */
	    td_global::$td_animation_stack_effects = array(
		    array(
			    'text' => 'Fade [full]',
			    'val' => '', // empty, as a default value
			    'specific_selectors' => '.entry-thumb, img',
			    'general_selectors' => '.td-animation-stack img, .td-animation-stack .entry-thumb, .post img',
		    ),

            array(
                'text' => 'Fade & Scale',
                'val' => 'type1',
                'specific_selectors' => '.entry-thumb, img[class*="wp-image-"], a.td-sml-link-to-image > img',
                'general_selectors' => '.td-animation-stack .entry-thumb, .post .entry-thumb, .post img[class*="wp-image-"], .post a.td-sml-link-to-image > img',
            ),


            array(
                'text' => 'Up fade',
                'val' => 'type2',
                'specific_selectors' => '.entry-thumb, img[class*="wp-image-"], a.td-sml-link-to-image > img',
                'general_selectors' => '.td-animation-stack .entry-thumb, .post .entry-thumb, .post img[class*="wp-image-"], a.td-sml-link-to-image > img',
            ),


        );



        /**
         * single template list
         */
	    td_api_single_template::add('single_template',
		    array(
			    'file' => td_global::$get_template_directory . '/single.php',
			    'text' => 'Single template',
			    'img' => td_global::$get_template_directory_uri . '/images/panel/single_templates/single_template_0.png',
			    'show_featured_image_on_all_pages' => false,
			    'bg_disable_background' => false,          // disable the featured image
			    'bg_box_layout_config' => 'auto',                // auto | td-boxed-layout | td-full-layout
			    'bg_use_featured_image_as_background' => false,   // uses the featured image as a background
			    'exclude_ad_content_top' => false,
		    )
	    );

        td_api_single_template::add('single_template_1',
            array(
                'file' => td_global::$get_template_directory . '/single_template_1.php',
                'text' => 'Single template 1',
                'img' => td_global::$get_template_directory_uri . '/images/panel/single_templates/single_template_1.png',
                'show_featured_image_on_all_pages' => false,
                'bg_disable_background' => false,          // disable the featured image
                'bg_box_layout_config' => 'auto',                // auto | td-boxed-layout | td-full-layout
                'bg_use_featured_image_as_background' => false,   // uses the featured image as a background
                'exclude_ad_content_top' => true,
            )
        );

        td_api_single_template::add('single_template_2',
            array(
                'file' => td_global::$get_template_directory . '/single_template_2.php',
                'text' => 'Single template 2',
                'img' => td_global::$get_template_directory_uri . '/images/panel/single_templates/single_template_2.png',
                'show_featured_image_on_all_pages' => false,
                'bg_disable_background' => false,          // disable the featured image
                'bg_box_layout_config' => 'auto',                // auto | td-boxed-layout | td-full-layout
                'bg_use_featured_image_as_background' => false,   // uses the featured image as a background
                'exclude_ad_content_top' => false,
            )
        );

        td_api_single_template::add('single_template_3',
            array(
                'file' => td_global::$get_template_directory . '/single_template_3.php',
                'text' => 'Single template 3',
                'img' => td_global::$get_template_directory_uri . '/images/panel/single_templates/single_template_3.png',
                'show_featured_image_on_all_pages' => true, //shows the featured image on all the pages
                'bg_disable_background' => false,          // disable the featured image
                'bg_box_layout_config' => 'auto',                // auto | td-boxed-layout | td-full-layout
                'bg_use_featured_image_as_background' => false,   // uses the featured image as a background
                'exclude_ad_content_top' => false,
            )
        );

        td_api_single_template::add('single_template_4',
            array(
                'file' => td_global::$get_template_directory . '/single_template_4.php',
                'text' => 'Single template 4',
                'img' => td_global::$get_template_directory_uri . '/images/panel/single_templates/single_template_4.png',
                'show_featured_image_on_all_pages' => true, //shows the featured image on all the pages
                'bg_disable_background' => false,          // disable the featured image
                'bg_box_layout_config' => 'auto',                // auto | td-boxed-layout | td-full-layout
                'bg_use_featured_image_as_background' => false,   // uses the featured image as a background
                'exclude_ad_content_top' => false,
            )
        );

        td_api_single_template::add('single_template_5',
            array(
                'file' => td_global::$get_template_directory . '/single_template_5.php',
                'text' => 'Single template 5',
                'img' => td_global::$get_template_directory_uri . '/images/panel/single_templates/single_template_5.png',
                'show_featured_image_on_all_pages' => false,
                'bg_disable_background' => false,          // disable the featured image
                'bg_box_layout_config' => 'auto',                // auto | td-boxed-layout | td-full-layout
                'bg_use_featured_image_as_background' => false,   // uses the featured image as a background
                'exclude_ad_content_top' => false,
            )
        );

        td_api_single_template::add('single_template_6',
            array(
                'file' => td_global::$get_template_directory . '/single_template_6.php',
                'text' => 'Single template 6',
                'img' => td_global::$get_template_directory_uri . '/images/panel/single_templates/single_template_6.png',
                'show_featured_image_on_all_pages' => true, //shows the featured image on all the pages
                'disable_background' => false,
                'use_featured_image_as_background' => true,
                'bg_disable_background' => false,          // disable the featured image
                'bg_box_layout_config' => 'auto',                // auto | td-boxed-layout | td-full-layout
                'bg_use_featured_image_as_background' => false,   // uses the featured image as a background
                'exclude_ad_content_top' => false,
            )
        );

        td_api_single_template::add('single_template_7',
            array(
                'file' => td_global::$get_template_directory . '/single_template_7.php',
                'text' => 'Single template 7',
                'img' => td_global::$get_template_directory_uri . '/images/panel/single_templates/single_template_7.png',
                'show_featured_image_on_all_pages' => true, //shows the featured image on all the pages
                'bg_disable_background' => false,          // disable the featured image
                'bg_box_layout_config' => 'auto',                // auto | td-boxed-layout | td-full-layout
                'bg_use_featured_image_as_background' => false,   // uses the featured image as a background
                'exclude_ad_content_top' => false,
            )
        );

        td_api_single_template::add('single_template_8',
            array(
                'file' => td_global::$get_template_directory . '/single_template_8.php',
                'text' => 'Single template 8',
                'img' => td_global::$get_template_directory_uri . '/images/panel/single_templates/single_template_8.png',
                'show_featured_image_on_all_pages' => true, //shows the featured image on all the pages
                'bg_disable_background' => false,          // disable the featured image
                'bg_box_layout_config' => 'td-boxed-layout',                // auto | td-boxed-layout | td-full-layout
                'bg_use_featured_image_as_background' => true,   // uses the featured image as a background
                'exclude_ad_content_top' => false,
            )
        );

        td_api_single_template::add('single_template_9',
            array(
                'file' => td_global::$get_template_directory . '/single_template_9.php',
                'text' => 'Single template 9',
                'img' => td_global::$get_template_directory_uri . '/images/panel/single_templates/single_template_9.png',
                'show_featured_image_on_all_pages' => false,
                'bg_disable_background' => false,          // disable the featured image
                'bg_box_layout_config' => 'auto',                // auto | td-boxed-layout | td-full-layout
                'bg_use_featured_image_as_background' => false,   // uses the featured image as a background
                'exclude_ad_content_top' => false,
            )
        );
        td_api_single_template::add('single_template_10',
            array(
                'file' => td_global::$get_template_directory . '/single_template_10.php',
                'text' => 'Single template 10',
                'img' => td_global::$get_template_directory_uri . '/images/panel/single_templates/single_template_10.png',
                'show_featured_image_on_all_pages' => true, //shows the featured image on all the pages
                'bg_disable_background' => false,          // disable the featured image
                'bg_box_layout_config' => 'auto',                // auto | td-boxed-layout | td-full-layout
                'bg_use_featured_image_as_background' => false,   // uses the featured image as a background
                'exclude_ad_content_top' => false,
            )
        );
        td_api_single_template::add('single_template_11',
            array(
                'file' => td_global::$get_template_directory . '/single_template_11.php',
                'text' => 'Single template 11',
                'img' => td_global::$get_template_directory_uri . '/images/panel/single_templates/single_template_11.png',
                'show_featured_image_on_all_pages' => true, //shows the featured image on all the pages
                'bg_disable_background' => false,          // disable the featured image
                'bg_box_layout_config' => 'auto',                // auto | td-boxed-layout | td-full-layout
                'bg_use_featured_image_as_background' => false,   // uses the featured image as a background
                'exclude_ad_content_top' => false,
            )
        );
        td_api_single_template::add('single_template_12',
            array(
                'file' => td_global::$get_template_directory . '/single_template_12.php',
                'text' => 'Single template 12',
                'img' => td_global::$get_template_directory_uri . '/images/panel/single_templates/single_template_12.png',
                'show_featured_image_on_all_pages' => true, //shows the featured image on all the pages
                'bg_disable_background' => false,          // disable the featured image
                'bg_box_layout_config' => 'auto',                // auto | td-boxed-layout | td-full-layout
                'bg_use_featured_image_as_background' => false,   // uses the featured image as a background
                'exclude_ad_content_top' => false,
            )
        );
        td_api_single_template::add('single_template_13',
            array(
                'file' => td_global::$get_template_directory . '/single_template_13.php',
                'text' => 'Single template 13',
                'img' => td_global::$get_template_directory_uri . '/images/panel/single_templates/single_template_13.png',
                'show_featured_image_on_all_pages' => true, //shows the featured image on all the pages
                'bg_disable_background' => false,          // disable the featured image
                'bg_box_layout_config' => 'auto',                // auto | td-boxed-layout | td-full-layout
                'bg_use_featured_image_as_background' => false,   // uses the featured image as a background
                'exclude_ad_content_top' => false,
            )
        );



        /**
         * smart lists
         */
        td_api_smart_list::add('td_smart_list_1',
            array(
                'file' => td_global::$get_template_directory . '/includes/smart_lists/td_smart_list_1.php',
                'text' => 'Smart list 1',
                'img' => td_global::$get_template_directory_uri . '/images/panel/smart_lists/td_smart_list_1.png',
	            'extract_first_image' => true,
                'group' => '' // '' - main theme, 'mob' - mobile theme, 'woo' - woo theme
            )
        );
        td_api_smart_list::add('td_smart_list_2',
            array(
                'file' => td_global::$get_template_directory . '/includes/smart_lists/td_smart_list_2.php',
                'text' => 'Smart list 2',
                'img' => td_global::$get_template_directory_uri . '/images/panel/smart_lists/td_smart_list_2.png',
                'extract_first_image' => true,
                'group' => '' // '' - main theme, 'mob' - mobile theme, 'woo' - woo theme
            )
        );
        td_api_smart_list::add('td_smart_list_3',
            array(
                'file' => td_global::$get_template_directory . '/includes/smart_lists/td_smart_list_3.php',
                'text' => 'Smart list 3',
                'img' => td_global::$get_template_directory_uri . '/images/panel/smart_lists/td_smart_list_3.png',
                'extract_first_image' => true,
                'group' => '' // '' - main theme, 'mob' - mobile theme, 'woo' - woo theme
            )
        );
        td_api_smart_list::add('td_smart_list_4',
            array(
                'file' => td_global::$get_template_directory . '/includes/smart_lists/td_smart_list_4.php',
                'text' => 'Smart list 4',
                'img' => td_global::$get_template_directory_uri . '/images/panel/smart_lists/td_smart_list_4.png',
                'extract_first_image' => true,
                'group' => '' // '' - main theme, 'mob' - mobile theme, 'woo' - woo theme
            )
        );
        td_api_smart_list::add('td_smart_list_5',
            array(
                'file' => td_global::$get_template_directory . '/includes/smart_lists/td_smart_list_5.php',
                'text' => 'Smart list 5',
                'img' => td_global::$get_template_directory_uri . '/images/panel/smart_lists/td_smart_list_5.png',
                'extract_first_image' => true,
                'group' => '' // '' - main theme, 'mob' - mobile theme, 'woo' - woo theme
            )
        );
        td_api_smart_list::add('td_smart_list_6',
            array(
                'file' => td_global::$get_template_directory . '/includes/smart_lists/td_smart_list_6.php',
                'text' => 'Smart list 6',
                'img' => td_global::$get_template_directory_uri . '/images/panel/smart_lists/td_smart_list_6.png',
                'extract_first_image' => true,
                'group' => '' // '' - main theme, 'mob' - mobile theme, 'woo' - woo theme
            )
        );
        td_api_smart_list::add('td_smart_list_7',
            array(
                'file' => td_global::$get_template_directory . '/includes/smart_lists/td_smart_list_7.php',
                'text' => 'Smart list 7',
                'img' => td_global::$get_template_directory_uri . '/images/panel/smart_lists/td_smart_list_7.png',
                'extract_first_image' => true,
                'group' => '' // '' - main theme, 'mob' - mobile theme, 'woo' - woo theme
            )
        );
        td_api_smart_list::add('td_smart_list_8',
            array(
                'file' => td_global::$get_template_directory . '/includes/smart_lists/td_smart_list_8.php',
                'text' => 'Smart list 8',
                'img' => td_global::$get_template_directory_uri . '/images/panel/smart_lists/td_smart_list_8.png',
                'extract_first_image' => false,
                'group' => '' // '' - main theme, 'mob' - mobile theme, 'woo' - woo theme
            )
        );



        /**
         * modules list
         */
        td_api_module::add('td_module_1',
            array(
                'file' => td_global::$get_template_directory . '/includes/modules/td_module_1.php',
                'text' => 'Module 1',
                'img' => td_global::$get_template_directory_uri . '/images/panel/modules/td_module_1.png',
                'used_on_blocks' => array('td_block_3'),
                'excerpt_title' => 12,
                'excerpt_content' => '',
                'enabled_on_more_articles_box' => true,
                'enabled_on_loops' => true,
                'uses_columns' => true,
                'category_label' => true,
                'class' => 'td_module_wrap td-animation-stack',
	            'group' => '' // '' - main theme, 'mob' - mobile theme, 'woo' - woo theme
            )
        );

        td_api_module::add('td_module_2',
            array(
                'file' => td_global::$get_template_directory . '/includes/modules/td_module_2.php',
                'text' => 'Module 2',
                'img' => td_global::$get_template_directory_uri . '/images/panel/modules/td_module_2.png',
                'used_on_blocks' => array('td_block_2', 'td_block_4'),
                'excerpt_title' => 12,
                'excerpt_content' => 25,
                'enabled_on_more_articles_box' => true,
                'enabled_on_loops' => true,
                'uses_columns' => true,                      // if the module uses columns on the page template + loop
                'category_label' => true,
                'class' => 'td_module_wrap td-animation-stack',
	            'group' => '' // '' - main theme, 'mob' - mobile theme, 'woo' - woo theme
            )
        );

        td_api_module::add('td_module_3',
            array(
                'file' => td_global::$get_template_directory . '/includes/modules/td_module_3.php',
                'text' => 'Module 3',
                'img' => td_global::$get_template_directory_uri . '/images/panel/modules/td_module_3.png',
                'used_on_blocks' => array('td_block_5'),
                'excerpt_title' => 12,
                'excerpt_content' => '',
                'enabled_on_more_articles_box' => true,
                'enabled_on_loops' => true,
                'uses_columns' => true,                      // if the module uses columns on the page template + loop
                'category_label' => true,
                'class' => 'td_module_wrap td-animation-stack',
                'group' => '' // '' - main theme, 'mob' - mobile theme, 'woo' - woo theme
            )
        );

        td_api_module::add('td_module_4',
            array(
                'file' => td_global::$get_template_directory . '/includes/modules/td_module_4.php',
                'text' => 'Module 4',
                'img' => td_global::$get_template_directory_uri . '/images/panel/modules/td_module_4.png',
                'used_on_blocks' => array('td_block_1', 'td_block_17'),
                'excerpt_title' => 12,
                'excerpt_content' => 25,
                'enabled_on_more_articles_box' => true,
                'enabled_on_loops' => true,
                'uses_columns' => true,                      // if the module uses columns on the page template + loop
                'category_label' => true,
                'class' => 'td_module_wrap td-animation-stack',
                'group' => '' // '' - main theme, 'mob' - mobile theme, 'woo' - woo theme
            )
        );

        td_api_module::add('td_module_5',
            array(
                'file' => td_global::$get_template_directory . '/includes/modules/td_module_5.php',
                'text' => 'Module 5',
                'img' => td_global::$get_template_directory_uri . '/images/panel/modules/td_module_5.png',
                'used_on_blocks' => array('td_block_6'),
                'excerpt_title' => 12,
                'excerpt_content' => 25,
                'enabled_on_more_articles_box' => true,
                'enabled_on_loops' => true,
                'uses_columns' => true,                      // if the module uses columns on the page template + loop
                'category_label' => true,
                'class' => 'td_module_wrap td-animation-stack',
                'group' => '' // '' - main theme, 'mob' - mobile theme, 'woo' - woo theme
            )
        );

        td_api_module::add('td_module_6',
            array(
                'file' => td_global::$get_template_directory . '/includes/modules/td_module_6.php',
                'text' => 'Module 6',
                'img' => td_global::$get_template_directory_uri . '/images/panel/modules/td_module_6.png',
                'used_on_blocks' => array('td_block_1', 'td_block_2', 'td_block_7', 'td_block_16', 'td_block_25'),
                'excerpt_title' => 12,
                'excerpt_content' => '',
                'enabled_on_more_articles_box' => true,
                'enabled_on_loops' => true,
                'uses_columns' => true,                      // if the module uses columns on the page template + loop
                'category_label' => true,
                'class' => 'td_module_wrap td-animation-stack',
                'group' => '' // '' - main theme, 'mob' - mobile theme, 'woo' - woo theme
            )
        );

        td_api_module::add('td_module_7',
            array(
                'file' => td_global::$get_template_directory . '/includes/modules/td_module_7.php',
                'text' => 'Module 7',
                'img' => td_global::$get_template_directory_uri . '/images/panel/modules/td_module_7.png',
                'used_on_blocks' => array('td_block_8'),
                'excerpt_title' => 12,
                'excerpt_content' => '',
                'enabled_on_more_articles_box' => true,
                'enabled_on_loops' => true,
                'uses_columns' => true,                      // if the module uses columns on the page template + loop
                'category_label' => true,
                'class' => 'td_module_wrap td-animation-stack',
                'group' => '' // '' - main theme, 'mob' - mobile theme, 'woo' - woo theme
            )
        );

        td_api_module::add('td_module_8',
            array(
                'file' => td_global::$get_template_directory . '/includes/modules/td_module_8.php',
                'text' => 'Module 8',
                'img' => td_global::$get_template_directory_uri . '/images/panel/modules/td_module_8.png',
                'used_on_blocks' => array('td_block_9', 'td_block_17'),
                'excerpt_title' => 15,
                'excerpt_content' => '',
                'enabled_on_more_articles_box' => true,
                'enabled_on_loops' => true,
                'uses_columns' => true,                      // if the module uses columns on the page template + loop
                'category_label' => true,
                'class' => 'td_module_wrap',
                'group' => '' // '' - main theme, 'mob' - mobile theme, 'woo' - woo theme
            )
        );

        td_api_module::add('td_module_9',
            array(
                'file' => td_global::$get_template_directory . '/includes/modules/td_module_9.php',
                'text' => 'Module 9',
                'img' => td_global::$get_template_directory_uri . '/images/panel/modules/td_module_9.png',
                'used_on_blocks' => array('td_block_10'),
                'excerpt_title' => 15,
                'excerpt_content' => '',
                'enabled_on_more_articles_box' => true,
                'enabled_on_loops' => true,
                'uses_columns' => true,                      // if the module uses columns on the page template + loop
                'category_label' => true,
                'class' => 'td_module_wrap',
                'group' => '' // '' - main theme, 'mob' - mobile theme, 'woo' - woo theme
            )
        );

        td_api_module::add('td_module_10',
            array(
                'file' => td_global::$get_template_directory . '/includes/modules/td_module_10.php',
                'text' => 'Module 10',
                'img' => td_global::$get_template_directory_uri . '/images/panel/modules/td_module_10.png',
                'used_on_blocks' => array('td_block_11', 'td_block_18'),
                'excerpt_title' => 15,
                'excerpt_content' => 25,
                'enabled_on_more_articles_box' => false,
                'enabled_on_loops' => true,
                'uses_columns' => false,                      // if the module uses columns on the page template + loop
                'category_label' => true,
                'class' => 'td_module_wrap td-animation-stack',
                'group' => '' // '' - main theme, 'mob' - mobile theme, 'woo' - woo theme
            )
        );

        td_api_module::add('td_module_11',
            array(
                'file' => td_global::$get_template_directory . '/includes/modules/td_module_11.php',
                'text' => 'Module 11',
                'img' => td_global::$get_template_directory_uri . '/images/panel/modules/td_module_11.png',
                'used_on_blocks' => array('td_block_12'),
                'excerpt_title' => 15,
                'excerpt_content' => 35,
                'enabled_on_more_articles_box' => false,
                'enabled_on_loops' => true,
                'uses_columns' => false,                      // if the module uses columns on the page template + loop
                'category_label' => true,
                'class' => 'td_module_wrap td-animation-stack',
                'group' => '' // '' - main theme, 'mob' - mobile theme, 'woo' - woo theme
            )
        );

        td_api_module::add('td_module_12',
            array(
                'file' => td_global::$get_template_directory . '/includes/modules/td_module_12.php',
                'text' => 'Module 12',
                'img' => td_global::$get_template_directory_uri . '/images/panel/modules/td_module_12.png',
                'used_on_blocks' => '',
                'excerpt_title' => 30,
                'excerpt_content' => 60,
                'enabled_on_more_articles_box' => false,
                'enabled_on_loops' => true,
                'uses_columns' => false,                      // if the module uses columns on the page template + loop
                'category_label' => true,
                'class' => 'td_module_wrap td-animation-stack',
                'group' => '' // '' - main theme, 'mob' - mobile theme, 'woo' - woo theme
            )
        );

        td_api_module::add('td_module_13',
            array(
                'file' => td_global::$get_template_directory . '/includes/modules/td_module_13.php',
                'text' => 'Module 13',
                'img' => td_global::$get_template_directory_uri . '/images/panel/modules/td_module_13.png',
                'used_on_blocks' => '',
                'excerpt_title' => 30,
                'excerpt_content' => '',
                'enabled_on_more_articles_box' => false,
                'enabled_on_loops' => true,
                'uses_columns' => false,                      // if the module uses columns on the page template + loop
                'category_label' => true,
                'class' => 'td_module_wrap td-animation-stack',
                'group' => '' // '' - main theme, 'mob' - mobile theme, 'woo' - woo theme
            )
        );

        td_api_module::add('td_module_14',
            array(
                'file' => td_global::$get_template_directory . '/includes/modules/td_module_14.php',
                'text' => 'Module 14',
                'img' => td_global::$get_template_directory_uri . '/images/panel/modules/td_module_14.png',
                'used_on_blocks' => array('td_block_13', 'td_block_20'),
                'excerpt_title' => 30,
                'excerpt_content' => 40,
                'enabled_on_more_articles_box' => false,
                'enabled_on_loops' => true,
                'uses_columns' => false,                      // if the module uses columns on the page template + loop
                'category_label' => true,
                'class' => 'td_module_wrap td-animation-stack',
                'group' => '' // '' - main theme, 'mob' - mobile theme, 'woo' - woo theme
            )
        );

        td_api_module::add('td_module_15',
            array(
                'file' => td_global::$get_template_directory . '/includes/modules/td_module_15.php',
                'text' => 'Module 15',
                'img' => td_global::$get_template_directory_uri . '/images/panel/modules/td_module_15.png',
                'used_on_blocks' => '',
                'excerpt_title' => '',
                'excerpt_content' => '',
                'enabled_on_more_articles_box' => false,
                'enabled_on_loops' => true,
                'uses_columns' => false,                      // if the module uses columns on the page template + loop
                'category_label' => true,
                'class' => 'td-animation-stack',
                'group' => '' // '' - main theme, 'mob' - mobile theme, 'woo' - woo theme
            )
        );

        td_api_module::add('td_module_16',
            array(
                'file' => td_global::$get_template_directory . '/includes/modules/td_module_16.php',
                'text' => 'Module 16',
                'img' => td_global::$get_template_directory_uri . '/images/panel/modules/td_module_16.png',
                'used_on_blocks' =>  array('td_block_21','Search Page'),
                'excerpt_title' => 15,
                'excerpt_content' => 25,
                'enabled_on_more_articles_box' => false,
                'enabled_on_loops' => true,
                'uses_columns' => false,                      // if the module uses columns on the page template + loop
                'category_label' => true,
                'class' => 'td_module_wrap td-animation-stack',
                'group' => '' // '' - main theme, 'mob' - mobile theme, 'woo' - woo theme
            )
        );

        td_api_module::add('td_module_17',
            array(
                'file' => td_global::$get_template_directory . '/includes/modules/td_module_17.php',
                'text' => 'Module 17',
                'img' => td_global::$get_template_directory_uri . '/images/panel/modules/td_module_17.png',
                'used_on_blocks' => array('td_block_22'),
                'excerpt_title' => 30,
                'excerpt_content' => 45,
                'enabled_on_more_articles_box' => false,
                'enabled_on_loops' => true,
                'uses_columns' => false,                      // if the module uses columns on the page template + loop
                'category_label' => true,
                'class' => 'td_module_wrap td-animation-stack',
                'group' => '' // '' - main theme, 'mob' - mobile theme, 'woo' - woo theme
            )
        );

        td_api_module::add('td_module_18',
            array(
                'file' => td_global::$get_template_directory . '/includes/modules/td_module_18.php',
                'text' => 'Module 18',
                'img' => td_global::$get_template_directory_uri . '/images/panel/modules/td_module_18.png',
                'used_on_blocks' => array('td_block_23'),
                'excerpt_title' => 30,
                'excerpt_content' => 60,
                'enabled_on_more_articles_box' => false,
                'enabled_on_loops' => true,
                'uses_columns' => false,                      // if the module uses columns on the page template + loop
                'category_label' => true,
                'class' => 'td_module_wrap td-animation-stack',
                'group' => '' // '' - main theme, 'mob' - mobile theme, 'woo' - woo theme
            )
        );

        td_api_module::add('td_module_19',
            array(
                'file' => td_global::$get_template_directory . '/includes/modules/td_module_19.php',
                'text' => 'Module 19',
                'img' => td_global::$get_template_directory_uri . '/images/panel/modules/td_module_19.png',
                'used_on_blocks' => array('td_block_24'),
                'excerpt_title' => 30,
                'excerpt_content' => 50,
                'enabled_on_more_articles_box' => false,
                'enabled_on_loops' => true,
                'uses_columns' => false,                      // if the module uses columns on the page template + loop
                'category_label' => true,
                'class' => 'td_module_wrap td-animation-stack',
                'group' => '' // '' - main theme, 'mob' - mobile theme, 'woo' - woo theme
            )
        );

        td_api_module::add('td_module_mx1',
            array(
                'file' => td_global::$get_template_directory . '/includes/modules/td_module_mx1.php',
                'text' => 'Module MX1',
                'img' => '',
                'used_on_blocks' => array('td_block_14', 'td_block_19'),
                'excerpt_title' => 25,
                'excerpt_content' => '',
                'enabled_on_more_articles_box' => false,
                'enabled_on_loops' => false,
                'uses_columns' => false,                      // if the module uses columns on the page template + loop
                'category_label' => true,
                'class' => 'td_module_wrap td-animation-stack',
                'group' => '' // '' - main theme, 'mob' - mobile theme, 'woo' - woo theme
            )
        );

        td_api_module::add('td_module_mx2',
            array(
                'file' => td_global::$get_template_directory . '/includes/modules/td_module_mx2.php',
                'text' => 'Module MX2',
                'img' => '',
                'used_on_blocks' => array('td_block_18', 'td_block_19', 'Search live'),
                'excerpt_title' => 25,
                'excerpt_content' => '',
                'enabled_on_more_articles_box' => false,
                'enabled_on_loops' => false,
                'uses_columns' => false,                      // if the module uses columns on the page template + loop
                'category_label' => true,
                'class' => 'td_module_wrap td-animation-stack',
                'group' => '' // '' - main theme, 'mob' - mobile theme, 'woo' - woo theme
            )
        );

        td_api_module::add('td_module_mx3',
            array(
                'file' => td_global::$get_template_directory . '/includes/modules/td_module_mx3.php',
                'text' => 'Module MX3',
                'img' => '',
                'used_on_blocks' => array('td_block_13', 'td_block_20'),
                'excerpt_title' => 25,
                'excerpt_content' => '',
                'enabled_on_more_articles_box' => false,
                'enabled_on_loops' => false,
                'uses_columns' => false,                      // if the module uses columns on the page template + loop
                'category_label' => true,
                'class' => 'td_module_wrap td-animation-stack',
                'group' => '' // '' - main theme, 'mob' - mobile theme, 'woo' - woo theme
            )
        );

        td_api_module::add('td_module_mx4',
            array(
                'file' => td_global::$get_template_directory . '/includes/modules/td_module_mx4.php',
                'text' => 'Module MX4',
                'img' => '',
                'used_on_blocks' => array('td_block_15'),
                'excerpt_title' => 12,
                'excerpt_content' => '',
                'enabled_on_more_articles_box' => false,
                'enabled_on_loops' => false,
                'uses_columns' => false,                      // if the module uses columns on the page template + loop
                'category_label' => true,
                'class' => 'td_module_wrap td-animation-stack',
                'group' => '' // '' - main theme, 'mob' - mobile theme, 'woo' - woo theme
            )
        );

        td_api_module::add('td_module_mx5',
            array(
                'file' => td_global::$get_template_directory . '/includes/modules/td_module_mx5.php',
                'text' => 'Module MX5',
                'img' => '',
                'used_on_blocks' => array('td_block_big_grid_1', 'td_block_big_grid_3', 'td_block_big_grid_4', 'td_block_big_grid_6', 'td_block_big_grid_10', 'td_block_big_grid_12'),
                'excerpt_title' => 25,
                'excerpt_content' => '',
                'enabled_on_more_articles_box' => false,
                'enabled_on_loops' => false,
                'uses_columns' => false,
                'category_label' => true,
                'class' => 'td-animation-stack',
                'group' => '' // '' - main theme, 'mob' - mobile theme, 'woo' - woo theme
            )
        );

        td_api_module::add('td_module_mx6',
            array(
                'file' => td_global::$get_template_directory . '/includes/modules/td_module_mx6.php',
                'text' => 'Module MX6',
                'img' => '',
                'used_on_blocks' => array('td_block_big_grid_1', 'td_block_big_grid_3', 'td_block_big_grid_7'),
                'excerpt_title' => 25,
                'excerpt_content' => '',
                'enabled_on_more_articles_box' => false,
                'enabled_on_loops' => false,
                'uses_columns' => false,
                'category_label' => true,
                'class' => 'td-animation-stack',
                'group' => '' // '' - main theme, 'mob' - mobile theme, 'woo' - woo theme
            )
        );

        td_api_module::add('td_module_mx7',
            array(
                'file' => td_global::$get_template_directory . '/includes/modules/td_module_mx7.php',
                'text' => 'Module MX7',
                'img' => '',
                'used_on_blocks' => array('td_block_16'),
                'excerpt_title' => 25,
                'excerpt_content' => 16,
                'enabled_on_more_articles_box' => false,
                'enabled_on_loops' => false,
                'uses_columns' => false,
                'category_label' => true,
                'class' => 'td_module_wrap td-animation-stack',
                'group' => '' // '' - main theme, 'mob' - mobile theme, 'woo' - woo theme
            )
        );

        td_api_module::add('td_module_mx8',
            array(
                'file' => td_global::$get_template_directory . '/includes/modules/td_module_mx8.php',
                'text' => 'Module MX8',
                'img' => '',
                'used_on_blocks' => array('td_block_18'),
                'excerpt_title' => 25,
                'excerpt_content' => '',
                'enabled_on_more_articles_box' => false,
                'enabled_on_loops' => false,
                'uses_columns' => false,
                'category_label' => true,
                'class' => 'td_module_wrap td-animation-stack',
                'group' => '' // '' - main theme, 'mob' - mobile theme, 'woo' - woo theme
            )
        );

        td_api_module::add('td_module_mx9',
            array(
                'file' => td_global::$get_template_directory . '/includes/modules/td_module_mx9.php',
                'text' => 'Module MX9',
                'img' => '',
                'used_on_blocks' => array('td_block_big_grid_2'),
                'excerpt_title' => 25,
                'excerpt_content' => '',
                'enabled_on_more_articles_box' => false,
                'enabled_on_loops' => false,
                'uses_columns' => false,
                'category_label' => true,
                'class' => 'td-animation-stack',
                'group' => '' // '' - main theme, 'mob' - mobile theme, 'woo' - woo theme
            )
        );

        td_api_module::add('td_module_mx10',
            array(
                'file' => td_global::$get_template_directory . '/includes/modules/td_module_mx10.php',
                'text' => 'Module MX10',
                'img' => '',
                'used_on_blocks' => array('td_block_big_grid_2'),
                'excerpt_title' => 25,
                'excerpt_content' => '',
                'enabled_on_more_articles_box' => false,
                'enabled_on_loops' => false,
                'uses_columns' => false,
                'category_label' => true,
                'class' => 'td-animation-stack',
                'group' => '' // '' - main theme, 'mob' - mobile theme, 'woo' - woo theme
            )
        );

        td_api_module::add('td_module_mx11',
            array(
                'file' => td_global::$get_template_directory . '/includes/modules/td_module_mx11.php',
                'text' => 'Module MX11',
                'img' => '',
                'used_on_blocks' => array('td_block_big_grid_3', 'td_block_big_grid_12'),
                'excerpt_title' => 25,
                'excerpt_content' => '',
                'enabled_on_more_articles_box' => false,
                'enabled_on_loops' => false,
                'uses_columns' => false,
                'category_label' => true,
                'class' => 'td-animation-stack',
                'group' => '' // '' - main theme, 'mob' - mobile theme, 'woo' - woo theme
            )
        );

        td_api_module::add('td_module_mx12',
            array(
                'file' => td_global::$get_template_directory . '/includes/modules/td_module_mx12.php',
                'text' => 'Module MX12',
                'img' => '',
                'used_on_blocks' => array('td_block_big_grid_5', 'td_block_big_grid_7', 'td_block_big_grid_8'),
                'excerpt_title' => 25,
                'excerpt_content' => '',
                'enabled_on_more_articles_box' => false,
                'enabled_on_loops' => false,
                'uses_columns' => false,
                'category_label' => true,
                'class' => 'td-animation-stack',
                'group' => '' // '' - main theme, 'mob' - mobile theme, 'woo' - woo theme
            )
        );

        td_api_module::add('td_module_mx13',
            array(
                'file' => td_global::$get_template_directory . '/includes/modules/td_module_mx13.php',
                'text' => 'Module MX13',
                'img' => '',
                'used_on_blocks' => array('td_block_big_grid_6'),
                'excerpt_title' => 25,
                'excerpt_content' => '',
                'enabled_on_more_articles_box' => false,
                'enabled_on_loops' => false,
                'uses_columns' => false,
                'category_label' => true,
                'class' => 'td-animation-stack',
                'group' => '' // '' - main theme, 'mob' - mobile theme, 'woo' - woo theme
            )
        );

        td_api_module::add('td_module_mx14',
            array(
                'file' => td_global::$get_template_directory . '/includes/modules/td_module_mx14.php',
                'text' => 'Module MX14',
                'img' => '',
                'used_on_blocks' => array('td_block_big_grid_8'),
                'excerpt_title' => 25,
                'excerpt_content' => '',
                'enabled_on_more_articles_box' => false,
                'enabled_on_loops' => false,
                'uses_columns' => false,
                'category_label' => true,
                'class' => 'td-animation-stack',
                'group' => '' // '' - main theme, 'mob' - mobile theme, 'woo' - woo theme
            )
        );

        td_api_module::add('td_module_mx15',
            array(
                'file' => td_global::$get_template_directory . '/includes/modules/td_module_mx15.php',
                'text' => 'Module MX15',
                'img' => '',
                'used_on_blocks' => array('td_block_big_grid_9', 'td_block_big_grid_10'),
                'excerpt_title' => 16,
                'excerpt_content' => '',
                'enabled_on_more_articles_box' => false,
                'enabled_on_loops' => false,
                'uses_columns' => false,
                'category_label' => true,
                'class' => 'td-animation-stack',
                'group' => '' // '' - main theme, 'mob' - mobile theme, 'woo' - woo theme
            )
        );

        td_api_module::add('td_module_mx16',
            array(
                'file' => td_global::$get_template_directory . '/includes/modules/td_module_mx16.php',
                'text' => 'Module MX16',
                'img' => '',
                'used_on_blocks' => array('td_block_24'),
                'excerpt_title' => 25,
                'excerpt_content' => 18,
                'enabled_on_more_articles_box' => false,
                'enabled_on_loops' => false,
                'uses_columns' => false,
                'category_label' => true,
                'class' => 'td_module_wrap td-animation-stack',
                'group' => '' // '' - main theme, 'mob' - mobile theme, 'woo' - woo theme
            )
        );

        td_api_module::add('td_module_mx17',
            array(
                'file' => td_global::$get_template_directory . '/includes/modules/td_module_mx17.php',
                'text' => 'Module MX17',
                'img' => '',
                'used_on_blocks' => array('td_block_25'),
                'excerpt_title' => 25,
                'excerpt_content' => '',
                'enabled_on_more_articles_box' => false,
                'enabled_on_loops' => false,
                'uses_columns' => false,
                'category_label' => true,
                'class' => 'td_module_wrap td-animation-stack',
                'group' => '' // '' - main theme, 'mob' - mobile theme, 'woo' - woo theme
            )
        );

        td_api_module::add('td_module_mx18',
            array(
                'file' => td_global::$get_template_directory . '/includes/modules/td_module_mx18.php',
                'text' => 'Module MX18',
                'img' => '',
                'used_on_blocks' => array('td_block_big_grid_fl_1'),
                'excerpt_title' => 25,
                'excerpt_content' => '',
                'enabled_on_more_articles_box' => false,
                'enabled_on_loops' => false,
                'uses_columns' => false,
                'category_label' => true,
                'class' => 'td_module_wrap td-animation-stack',
                'group' => '' // '' - main theme, 'mob' - mobile theme, 'woo' - woo theme
            )
        );

        td_api_module::add('td_module_mx19',
            array(
                'file' => td_global::$get_template_directory . '/includes/modules/td_module_mx19.php',
                'text' => 'Module MX19',
                'img' => '',
                'used_on_blocks' => array('td_block_big_grid_fl_2'),
                'excerpt_title' => 25,
                'excerpt_content' => '',
                'enabled_on_more_articles_box' => false,
                'enabled_on_loops' => false,
                'uses_columns' => false,
                'category_label' => true,
                'class' => 'td_module_wrap td-animation-stack',
                'group' => '' // '' - main theme, 'mob' - mobile theme, 'woo' - woo theme
            )
        );

        td_api_module::add('td_module_mx20',
            array(
                'file' => td_global::$get_template_directory . '/includes/modules/td_module_mx20.php',
                'text' => 'Module MX20',
                'img' => '',
                'used_on_blocks' => array('td_block_big_grid_fl_3'),
                'excerpt_title' => 25,
                'excerpt_content' => '',
                'enabled_on_more_articles_box' => false,
                'enabled_on_loops' => false,
                'uses_columns' => false,
                'category_label' => true,
                'class' => 'td_module_wrap td-animation-stack',
                'group' => '' // '' - main theme, 'mob' - mobile theme, 'woo' - woo theme
            )
        );

        td_api_module::add('td_module_mx21',
            array(
                'file' => td_global::$get_template_directory . '/includes/modules/td_module_mx21.php',
                'text' => 'Module MX21',
                'img' => '',
                'used_on_blocks' => array('td_block_big_grid_fl_4'),
                'excerpt_title' => 25,
                'excerpt_content' => '',
                'enabled_on_more_articles_box' => false,
                'enabled_on_loops' => false,
                'uses_columns' => false,
                'category_label' => true,
                'class' => 'td_module_wrap td-animation-stack',
                'group' => '' // '' - main theme, 'mob' - mobile theme, 'woo' - woo theme
            )
        );

        td_api_module::add('td_module_mx22',
            array(
                'file' => td_global::$get_template_directory . '/includes/modules/td_module_mx22.php',
                'text' => 'Module MX22',
                'img' => '',
                'used_on_blocks' => array('td_block_big_grid_fl_6'),
                'excerpt_title' => 25,
                'excerpt_content' => '',
                'enabled_on_more_articles_box' => false,
                'enabled_on_loops' => false,
                'uses_columns' => false,
                'category_label' => true,
                'class' => 'td_module_wrap td-animation-stack',
                'group' => '' // '' - main theme, 'mob' - mobile theme, 'woo' - woo theme
            )
        );

        td_api_module::add('td_module_mx23',
            array(
                'file' => td_global::$get_template_directory . '/includes/modules/td_module_mx23.php',
                'text' => 'Module MX23',
                'img' => '',
                'used_on_blocks' => array('td_block_big_grid_fl_7'),
                'excerpt_title' => 25,
                'excerpt_content' => '',
                'enabled_on_more_articles_box' => false,
                'enabled_on_loops' => false,
                'uses_columns' => false,
                'category_label' => true,
                'class' => 'td_module_wrap td-animation-stack',
                'group' => '' // '' - main theme, 'mob' - mobile theme, 'woo' - woo theme
            )
        );

        td_api_module::add('td_module_mx24',
            array(
                'file' => td_global::$get_template_directory . '/includes/modules/td_module_mx24.php',
                'text' => 'Module MX24',
                'img' => '',
                'used_on_blocks' => array('td_block_big_grid_fl_7'),
                'excerpt_title' => 25,
                'excerpt_content' => '',
                'enabled_on_more_articles_box' => false,
                'enabled_on_loops' => false,
                'uses_columns' => false,
                'category_label' => true,
                'class' => 'td_module_wrap td-animation-stack',
                'group' => '' // '' - main theme, 'mob' - mobile theme, 'woo' - woo theme
            )
        );

        td_api_module::add('td_module_mx25',
            array(
                'file' => td_global::$get_template_directory . '/includes/modules/td_module_mx25.php',
                'text' => 'Module MX25',
                'img' => '',
                'used_on_blocks' => array('td_block_big_grid_fl_8'),
                'excerpt_title' => 25,
                'excerpt_content' => '',
                'enabled_on_more_articles_box' => false,
                'enabled_on_loops' => false,
                'uses_columns' => false,
                'category_label' => true,
                'class' => 'td_module_wrap td-animation-stack',
                'group' => '' // '' - main theme, 'mob' - mobile theme, 'woo' - woo theme
            )
        );

        td_api_module::add('td_module_mx26',
            array(
                'file' => td_global::$get_template_directory . '/includes/modules/td_module_mx26.php',
                'text' => 'Module MX26',
                'img' => '',
                'used_on_blocks' => array('td_block_big_grid_fl_9'),
                'excerpt_title' => 25,
                'excerpt_content' => '',
                'enabled_on_more_articles_box' => false,
                'enabled_on_loops' => false,
                'uses_columns' => false,
                'category_label' => true,
                'class' => 'td_module_wrap td-animation-stack',
                'group' => '' // '' - main theme, 'mob' - mobile theme, 'woo' - woo theme
            )
        );

        td_api_module::add('td_module_mx_empty',
            array(
                'file' => td_global::$get_template_directory . '/includes/modules/td_module_mx_empty.php',
                'text' => 'Module MX Empty',
                'img' => '',
                'used_on_blocks' => array('td_block_big_grid_1'),
                'excerpt_title' => '',
                'excerpt_content' => '',
                'enabled_on_more_articles_box' => false,
                'enabled_on_loops' => false,
                'uses_columns' => false,
                'category_label' => false,
                'class' => 'td-animation-stack',
                'group' => '' // '' - main theme, 'mob' - mobile theme, 'woo' - woo theme
            )
        );

        td_api_module::add('td_module_related_posts',
            array(
                'file' => td_global::$get_template_directory . '/includes/modules/td_module_related_posts.php',
                'text' => 'Related posts module',
                'img' => '',
                'used_on_blocks' => array('td_block_related_posts'),
                'excerpt_title' => 25,
                'excerpt_content' => '',
                'enabled_on_more_articles_box' => false,
                'enabled_on_loops' => false,
                'uses_columns' => false,
                'category_label' => true,
                'class' => 'td-animation-stack',
                'group' => '' // '' - main theme, 'mob' - mobile theme, 'woo' - woo theme
            )
        );

        td_api_module::add('td_module_mega_menu',
            array(
                'file' => td_global::$get_template_directory . '/includes/modules/td_module_mega_menu.php',
                'text' => 'Mega menu module',
                'img' => '',
                'used_on_blocks' => array('td_block_mega_menu'),
                'excerpt_title' => '12',
                'excerpt_content' => '',
                'enabled_on_more_articles_box' => false,
                'enabled_on_loops' => false,
                'uses_columns' => false,                      // if the module uses columns on the page template + loop
                'category_label' => true,
                'class' => 'td-animation-stack',
                'group' => '' // '' - main theme, 'mob' - mobile theme, 'woo' - woo theme
            )
        );

        td_api_module::add('td_module_slide',
            array(
                'file' => td_global::$get_template_directory . '/includes/modules/td_module_slide.php',
                'text' => 'Slider module',
                'img' => '',
                'used_on_blocks' => array('td_block_slide'),
                'excerpt_title' => 25,
                'excerpt_content' => '',
                'enabled_on_more_articles_box' => false,
                'enabled_on_loops' => false,
                'uses_columns' => false,                      // if the module uses columns on the page template + loop
                'category_label' => true,
                'class' => 'td-animation-stack',
                'group' => '' // '' - main theme, 'mob' - mobile theme, 'woo' - woo theme
            )
        );

        td_api_module::add('td_module_trending_now',
            array(  // this module is for internal use only
                'file' => td_global::$get_template_directory . '/includes/modules/td_module_trending_now.php',
                'text' => 'Trending now module',
                'img' => '',
                'used_on_blocks' => '',
                'excerpt_title' => 25,
                'excerpt_content' => '',
                'enabled_on_more_articles_box' => false,
                'enabled_on_loops' => false,
                'uses_columns' => false,                      // if the module uses columns on the page template + loop
                'category_label' => false,
                'class' => '',
                'group' => '' // '' - main theme, 'mob' - mobile theme, 'woo' - woo theme
            )
        );

        td_api_module::add('td_module_single',
            array(  // this module is for internal use only
                'file' => td_global::$get_template_directory . '/includes/modules/td_module_single.php',
                'text' => 'Single Module',
                'img' => '',
                'used_on_blocks' => '',
                'excerpt_title' => '',
                'excerpt_content' => '',
                'enabled_on_more_articles_box' => false,
                'enabled_on_loops' => false,
                'uses_columns' => false,                      // if the module uses columns on the page template + loop
                'category_label' => false,
                'class' => '',
                'group' => '' // '' - main theme, 'mob' - mobile theme, 'woo' - woo theme
            )
        );

        td_api_module::add( 'td_module_flex_1',
            array(
                'file'                         => td_global::$get_template_directory . '/includes/modules/td_module_flex_1.php',
                'text'                         => 'Module Flex 1',
                'img'                          => '',
                'used_on_blocks'               => array( 'td_flex_block_1' ),
                'excerpt_title'                => 25,
                'excerpt_content'              => 25,
                'enabled_on_more_articles_box' => false,
                'enabled_on_loops'             => false,
                'uses_columns'                 => false,
                // if the module uses columns on the page template + loop
                'category_label'               => true,
                'class'                        => 'td_module_wrap td-animation-stack',
                'group'                        => ''
                // '' - main theme, 'mob' - mobile theme, 'woo' - woo theme
            )
        );

        td_api_module::add( 'td_module_flex_2',
            array(
                'file'                         => td_global::$get_template_directory . '/includes/modules/td_module_flex_2.php',
                'text'                         => 'Module Flex 2',
                'img'                          => '',
                'used_on_blocks'               => array( 'td_flex_block_2' ),
                'excerpt_title'                => 25,
                'excerpt_content'              => 25,
                'enabled_on_more_articles_box' => false,
                'enabled_on_loops'             => false,
                'uses_columns'                 => false,
                // if the module uses columns on the page template + loop
                'category_label'               => true,
                'class'                        => 'td_module_wrap td-animation-stack',
                'group'                        => ''
                // '' - main theme, 'mob' - mobile theme, 'woo' - woo theme
            )
        );

        td_api_module::add( 'td_module_flex_3',
            array(
                'file'                         => td_global::$get_template_directory . '/includes/modules/td_module_flex_3.php',
                'text'                         => 'Module Flex 3',
                'img'                          => '',
                'used_on_blocks'               => array( 'td_flex_block_3' ),
                'excerpt_title'                => 25,
                'excerpt_content'              => 25,
                'enabled_on_more_articles_box' => false,
                'enabled_on_loops'             => false,
                'uses_columns'                 => false,
                // if the module uses columns on the page template + loop
                'category_label'               => true,
                'class'                        => 'td_module_wrap td-animation-stack',
                'group'                        => ''
                // '' - main theme, 'mob' - mobile theme, 'woo' - woo theme
            )
        );

        td_api_module::add( 'td_module_flex_4',
            array(
                'file'                         => td_global::$get_template_directory . '/includes/modules/td_module_flex_4.php',
                'text'                         => 'Module Flex 4',
                'img'                          => '',
                'used_on_blocks'               => array( 'td_flex_block_4' ),
                'excerpt_title'                => 25,
                'excerpt_content'              => 25,
                'enabled_on_more_articles_box' => false,
                'enabled_on_loops'             => false,
                'uses_columns'                 => false,
                // if the module uses columns on the page template + loop
                'category_label'               => true,
                'class'                        => 'td_module_wrap td-animation-stack',
                'group'                        => ''
                // '' - main theme, 'mob' - mobile theme, 'woo' - woo theme
            )
        );

        td_api_module::add( 'td_module_flex_5',
            array(
                'file'                         => td_global::$get_template_directory . '/includes/modules/td_module_flex_5.php',
                'text'                         => 'Module Flex 5',
                'img'                          => '',
                'used_on_blocks'               => array( 'td_module_flex_5' ),
                'excerpt_title'                => 25,
                'excerpt_content'              => 25,
                'enabled_on_more_articles_box' => false,
                'enabled_on_loops'             => false,
                'uses_columns'                 => false,
                // if the module uses columns on the page template + loop
                'category_label'               => true,
                'class'                        => 'td_module_wrap td-animation-stack',
                'group'                        => ''
                // '' - main theme, 'mob' - mobile theme, 'woo' - woo theme
            )
        );

        td_api_module::add( 'td_module_flex_6',
            array(
                'file'                         => td_global::$get_template_directory . '/includes/modules/td_module_flex_6.php',
                'text'                         => 'Module Flex 6',
                'img'                          => '',
                'used_on_blocks'               => array( 'td_module_flex_6' ),
                'excerpt_title'                => 25,
                'excerpt_content'              => 0,
                'enabled_on_more_articles_box' => false,
                'enabled_on_loops'             => false,
                'uses_columns'                 => false,
                // if the module uses columns on the page template + loop
                'category_label'               => true,
                'class'                        => 'td-animation-stack',
                'group'                        => ''
                // '' - main theme, 'mob' - mobile theme, 'woo' - woo theme
            )
        );

        td_api_module::add( 'td_module_flex_7',
            array(
                'file'                         => td_global::$get_template_directory . '/includes/modules/td_module_flex_7.php',
                'text'                         => 'Module Flex 7',
                'img'                          => '',
                'used_on_blocks'               => array( 'td_module_flex_7' ),
                'excerpt_title'                => 25,
                'excerpt_content'              => 0,
                'enabled_on_more_articles_box' => false,
                'enabled_on_loops'             => false,
                'uses_columns'                 => false,
                // if the module uses columns on the page template + loop
                'category_label'               => true,
                'class'                        => 'td-animation-stack',
                'group'                        => ''
                // '' - main theme, 'mob' - mobile theme, 'woo' - woo theme
            )
        );

        td_api_module::add( 'td_module_flex_8',
            array(
                'file'                         => td_global::$get_template_directory . '/includes/modules/td_module_flex_8.php',
                'text'                         => 'Module Flex 8',
                'img'                          => '',
                'used_on_blocks'               => array( 'td_module_flex_8' ),
                'excerpt_title'                => 25,
                'excerpt_content'              => 0,
                'enabled_on_more_articles_box' => false,
                'enabled_on_loops'             => false,
                'uses_columns'                 => false,
                // if the module uses columns on the page template + loop
                'category_label'               => true,
                'class'                        => 'td-animation-stack',
                'group'                        => ''
                // '' - main theme, 'mob' - mobile theme, 'woo' - woo theme
            )
        );

        td_api_module::add( 'td_module_flex_empty',
            array(
                'file'                         => td_global::$get_template_directory . '/includes/modules/td_module_flex_empty.php',
                'text'                         => 'Module Flex Empty',
                'img'                          => '',
                'used_on_blocks'               => array( 'td_module_flex_empty' ),
                'excerpt_title'                => 25,
                'excerpt_content'              => 0,
                'enabled_on_more_articles_box' => false,
                'enabled_on_loops'             => false,
                'uses_columns'                 => false,
                // if the module uses columns on the page template + loop
                'category_label'               => true,
                'class'                        => 'td-animation-stack',
                'group'                        => ''
                // '' - main theme, 'mob' - mobile theme, 'woo' - woo theme
            )
        );



        /**
         * the thumbs used by the  theme
         * Thumb id => array parameters. Wp booster only cuts if the option is set from theme panel
         */


        td_api_thumb::add('td_80x60',
            array(
                'name' => 'td_80x60',
                'width' => 80,
                'height' => 60,
                'crop' => array('center', 'top'),
                'post_format_icon_size' => 'small',
                'used_on' => array(
                    'Module MX2',
	                'Block 18, 19',
	                'Live search',
	                'tagDiv Image Gallery thumbs'
                ),
                'no_image_path' => td_global::$get_template_directory_uri,
                'b64_encoded' => 'data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAFAAAAA8AQMAAADL6a/PAAAAA1BMVEWurq51dlI4AAAAAXRSTlMmkutdmwAAAA5JREFUKM9jGAWjYJABAAKUAAHoEAeuAAAAAElFTkSuQmCC',
            )
        );

        td_api_thumb::add('td_100x70',
            array(
                'name' => 'td_100x70',
                'width' => 100,
                'height' => 70,
                'crop' => array('center', 'top'),
                'post_format_icon_size' => 'small',
                'used_on' => array(
                    'Module 6, 7',
	                'Block 1, 2, 7, 8, 16, 25'
                ),
                'no_image_path' => td_global::$get_template_directory_uri,
                'b64_encoded' => 'data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAGQAAABGAQMAAAAASKMqAAAAA1BMVEWurq51dlI4AAAAAXRSTlMmkutdmwAAABBJREFUKM9jGAWjYBQMKwAAA9QAAQWBn6cAAAAASUVORK5CYII=',
            )
        );

        td_api_thumb::add('td_218x150',
            array(
                'name' => 'td_218x150',
                'width' => 218,
                'height' => 150,
                'crop' => array('center', 'top'),
                'post_format_icon_size' => 'normal',
                'used_on' => array(
                    'Module 10, MX4, MX7, MX13, Mega menu, Related posts',
	                'Block 11, 15, 16, 18',
	                'Big grid 6'
                ),
                'no_image_path' => td_global::$get_template_directory_uri,
                'b64_encoded' => 'data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAANoAAACWAQMAAACCSQSPAAAAA1BMVEWurq51dlI4AAAAAXRSTlMmkutdmwAAABpJREFUWMPtwQENAAAAwiD7p7bHBwwAAAAg7RD+AAGXD7BoAAAAAElFTkSuQmCC',
            )
        );

        td_api_thumb::add('td_265x198',
            array(
                'name' => 'td_265x198',
                'width' => 265,
                'height' => 198,
                'crop' => array('center', 'top'),
                'post_format_icon_size' => 'normal',
                'used_on' => array(
                    'Big grid 1, 3, 7'
                ),
                'no_image_path' => td_global::$get_template_directory_uri,
                'b64_encoded' => 'data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAQkAAADGAQMAAAD7b+fyAAAAA1BMVEWurq51dlI4AAAAAXRSTlMmkutdmwAAAB1JREFUWMPtwQENAAAAwiD7p7bHBwwAAAAAAADSDhsSAAGoWlW2AAAAAElFTkSuQmCC',
            )
        );

        td_api_thumb::add('td_324x160',
            array(
                'name' => 'td_324x160',
                'width' => 324,
                'height' => 160,
                'crop' => array('center', 'top'),
                'post_format_icon_size' => 'normal',
                'used_on' => array(
                    'Module 1, 2',
	                'Block 2, 3, 4',
	                'Big grid 2'
                ),
                'no_image_path' => td_global::$get_template_directory_uri,
                'b64_encoded' => 'data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAUQAAACgAQMAAABOhoelAAAAA1BMVEWurq51dlI4AAAAAXRSTlMmkutdmwAAAB1JREFUWMPtwTEBAAAAwiD7p/ZdCGAAAAAAAAAQBxpAAAH8le3bAAAAAElFTkSuQmCC',
            )
        );

        td_api_thumb::add('td_324x235',
            array(
                'name' => 'td_324x235',
                'width' => 324,
                'height' => 235,
                'crop' => array('center', 'top'),
                'post_format_icon_size' => 'normal',
                'used_on' => array(
                    'Module 3, 4, 5, 11, MX3',
	                'Block 1, 5, 6, 13, 17, 20'
                ),
                'no_image_path' => td_global::$get_template_directory_uri,
                'b64_encoded' => 'data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAUQAAADrAQMAAAArGX0KAAAAA1BMVEWurq51dlI4AAAAAXRSTlMmkutdmwAAACBJREFUaN7twTEBAAAAwiD7pzbEXmAAAAAAAAAAAACQHSaOAAGSp1GBAAAAAElFTkSuQmCC',
            )
        );

        td_api_thumb::add('td_324x400',
            array(
                'name' => 'td_324x400',
                'width' => 324,
                'height' => 400,
                'crop' => array('center', 'top'),
                'post_format_icon_size' => 'normal',
                'used_on' => array(
                    'Slide - 1 column',
	                'Flex Block 1'
                ),
                'no_image_path' => td_global::$get_template_directory_uri,
                'b64_encoded' => 'data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAUQAAAGQAQMAAADsi4u8AAAAA1BMVEWurq51dlI4AAAAAXRSTlMmkutdmwAAACdJREFUeNrtwYEAAAAAw6D7U99gBNUAAAAAAAAAAAAAAAAAAAAASAdBoAABzZKptAAAAABJRU5ErkJggg==',
            )
        );

        td_api_thumb::add('td_356x220',
            array(
                'name' => 'td_356x220',
                'width' => 356,
                'height' => 220,
                'crop' => array('center', 'top'),
                'post_format_icon_size' => 'normal',
                'used_on' => array(
                    'Module MX1, MX12',
	                'Block 14, 19',
	                'Big grid 5, 7, 8'
                ),
                'no_image_path' => td_global::$get_template_directory_uri,
                'b64_encoded' => 'data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAWQAAADcAQMAAAB9O0nPAAAAA1BMVEWurq51dlI4AAAAAXRSTlMmkutdmwAAACBJREFUaN7twTEBAAAAwiD7p7bDbmAAAAAAAAAAAABAdieIAAGQh2mWAAAAAElFTkSuQmCC',
            )
        );

        td_api_thumb::add('td_356x364',
            array(
                'name' => 'td_356x364',
                'width' => 356,
                'height' => 364,
                'crop' => array('center', 'top'),
                'post_format_icon_size' => 'normal',
                'used_on' => array(
                    'Module MX14, MX16',
	                'Big grid 8, 9, 10'
                ),
                'no_image_path' => td_global::$get_template_directory_uri,
                'b64_encoded' => 'data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAWQAAAFsAQMAAADBhlEOAAAAA1BMVEWurq51dlI4AAAAAXRSTlMmkutdmwAAACZJREFUeNrtwQEBAAAAgqD+r26IwAAAAAAAAAAAAAAAAAAAAAAiDkFoAAFfZct7AAAAAElFTkSuQmCC',
            )
        );

        td_api_thumb::add('td_485x360',
            array(
                'name' => 'td_485x360',
                'width' => 485,
                'height' => 360,
                'crop' => array('center', 'top'),
                'post_format_icon_size' => 'small',
                'used_on' => array(
                    'Module MX24, MX25',
	                'Big grid full 7, 8, 9, 10'
                ),
                'no_image_path' => td_global::$get_template_directory_uri,
                'b64_encoded' => 'data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAeUAAAFoAQMAAABT0HEnAAAAA1BMVEWurq51dlI4AAAAAXRSTlMmkutdmwAAACxJREFUeNrtwTEBAAAAwiD7p7bGDmAAAAAAAAAAAAAAAAAAAAAAAAAAAAAQcFcwAAFIn2pxAAAAAElFTkSuQmCC',
            )
        );

        td_api_thumb::add('td_533x261',
            array(
                'name' => 'td_533x261',
                'width' => 533,
                'height' => 261,
                'crop' => array('center', 'top'),
                'post_format_icon_size' => 'normal',
                'used_on' => array(
                    'Module MX11', 'Big grid 3, 12'
                ),
                'no_image_path' => td_global::$get_template_directory_uri,
                'b64_encoded' => 'data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAhUAAAEFAQMAAABuFIc7AAAAA1BMVEWurq51dlI4AAAAAXRSTlMmkutdmwAAACdJREFUeNrtwQENAAAAwiD7p7bHBwwAAAAAAAAAAAAAAAAAAAAAIORFVAABqJvmiQAAAABJRU5ErkJggg==',
            )
        );

        td_api_thumb::add('td_534x462',
            array(
                'name' => 'td_534x462',
                'width' => 534,
                'height' => 462,
                'crop' => array('center', 'top'),
                'post_format_icon_size' => 'normal',
                'used_on' => array(
                    'Module 19, MX5, MX17, MX21',
	                'Big grid 1, 3, 4, 6, 10, 12, full 4, 5'
                ),
                'no_image_path' => td_global::$get_template_directory_uri,
                'b64_encoded' => 'data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAhYAAAHOAQMAAAD+DNJPAAAAA1BMVEWurq51dlI4AAAAAXRSTlMmkutdmwAAADVJREFUeNrtwQENAAAAwiD7p7bHBwwAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAICEA3q4AAGK1CNoAAAAAElFTkSuQmCC',
            )
        );

        td_api_thumb::add('td_696x0',
            array(
                'name' => 'td_696x0',
                'width' => 696,
                'height' => 0,
                'crop' => array('center', 'top'),
                'post_format_icon_size' => 'normal',
                'used_on' => array(
                    'Default post template,
                     Post template 2, 11',
	                'Module 12, 13, 15, MX20, MX22, MX23',
	                'Big grid full 3, 6, 7',
	                'Smart list style 1, 2, 5, 6, 7, 8',
	                'Flex Block 1'
                ),
                'no_image_path' => td_global::$get_template_directory_uri,
                'b64_encoded' => 'data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAArgAAAG0AQMAAADjJMaKAAAAA1BMVEWurq51dlI4AAAAAXRSTlMmkutdmwAAADxJREFUeNrtwQENAAAAwiD7pzbHN2AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAUQeV4AAB10TPnAAAAABJRU5ErkJggg==',
            )
        );

        td_api_thumb::add('td_696x385',
            array(
                'name' => 'td_696x385',
                'width' => 696,
                'height' => 385,
                'crop' => array('center', 'top'),
                'post_format_icon_size' => 'normal',
                'used_on' => array(
                    'Module 14, 17, 18, MX8',
	                'Block 13, 18, 20',
	                'Slide - 2 columns'
                ),
                'no_image_path' => td_global::$get_template_directory_uri,
                'b64_encoded' => 'data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAArgAAAGBAQMAAAC3k1CUAAAAA1BMVEWurq51dlI4AAAAAXRSTlMmkutdmwAAADdJREFUeNrtwTEBAAAAwiD7p7bETmAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAEDuhFgAARFpDB8AAAAASUVORK5CYII=',
            )
        );

        td_api_thumb::add('td_741x486',
            array(
                'name' => 'td_741x486',
                'width' => 741,
                'height' => 486,
                'crop' => array('center', 'top'),
                'post_format_icon_size' => 'normal',
                'used_on' => array(
                    'Module MX9',
                    'Big grid 2'
                ),
                'no_image_path' => td_global::$get_template_directory_uri,
                'b64_encoded' => 'data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAuUAAAHmAQMAAADuiGKOAAAAA1BMVEWurq51dlI4AAAAAXRSTlMmkutdmwAAAENJREFUeNrtwYEAAAAAw6D7Ux9gCtUAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAIgDsnQAAavKUH8AAAAASUVORK5CYII=',
            )
        );

        td_api_thumb::add('td_1068x580',
            array(
                'name' => 'td_1068x580',
                'width' => 1068,
                'height' => 580,
                'crop' => array('center', 'top'),
                'post_format_icon_size' => 'normal',
                'used_on' => array(
                    'Module MX26',
                    'Big grid full 9',
                    'Slide - 3 column'
                ),
                'no_image_path' => td_global::$get_template_directory_uri,
                'b64_encoded' => 'data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAABCwAAAJEAQMAAADnqyfeAAAAA1BMVEWurq51dlI4AAAAAXRSTlMmkutdmwAAAG9JREFUeNrswYEAAAAAgKD9qRepAgAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAADg9uCQAAAAAEDQ/9fOsAAAAAAAAAAAAAAAAAAAAAAAsAox6wABwRHV3QAAAABJRU5ErkJggg==',
            )
        );

        td_api_thumb::add('td_1068x0',
            array(
                'name' => 'td_1068x0',
                'width' => 1068,
                'height' => 0,
                'crop' => array('center', 'top'),
                'post_format_icon_size' => 'normal',
                'used_on' => array(
                    'Post template 3, 4, 9, 10',
	                'Smart list style 1, 2, 5, 6, 7, 8',
                    'Module MX19',
                    'Big grid full 2, 8, 9, 10',
	                'Flex Block 1'
                ),
                'no_image_path' => td_global::$get_template_directory_uri,
                'b64_encoded' => 'data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAABCwAAAJEAQMAAADnqyfeAAAAA1BMVEWurq51dlI4AAAAAXRSTlMmkutdmwAAAG9JREFUeNrswYEAAAAAgKD9qRepAgAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAADg9uCQAAAAAEDQ/9fOsAAAAAAAAAAAAAAAAAAAAAAAsAox6wABwRHV3QAAAABJRU5ErkJggg==',
            )
        );

        td_api_thumb::add('td_0x420',
            array(
                'name' => 'td_0x420',
                'width' => 0,
                'height' => 420,
                'crop' => array('center', 'top'),
                'post_format_icon_size' => 'normal', //what play icon to load (small or normal)
                'used_on' => array(
                    'tagDiv Image Gallery'
                ),
                'no_image_path' => td_global::$get_template_directory_uri,
                'b64_encoded' => 'data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAfQAAAGkAQMAAAD9lkU+AAAAA1BMVEWurq51dlI4AAAAAXRSTlMmkutdmwAAADFJREFUeNrtwTEBAAAAwiD7pzbDfmAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAANEBaQAAAZUbkzMAAAAASUVORK5CYII=',
            )
        );

        td_api_thumb::add('td_1920x0',
            array(
                'name' => 'td_1920x0',
                'width' => 1920,
                'height' => 0,
                'crop' => array('center', 'top'),
                'post_format_icon_size' => 'normal',
                'used_on' => array(
                    'Module MX18',
	                'Big grid full 1, 6',
	                'Flex Block 1'
                ),
                'no_image_path' => td_global::$get_template_directory_uri,
                'b64_encoded' => 'data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAB4AAAAIwAQMAAABdnuRXAAAAA1BMVEWurq51dlI4AAAAAXRSTlMmkutdmwAAALJJREFUeNrswYEAAAAAgKD9qRepAgAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAABg9uBAAAAAAADI/7URVFVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVWlPTgQAAAAABDkbz3BBhUAAAAAAAAAAAAAAAArD04AAVCiTaUAAAAASUVORK5CYII=',
            )
        );


        /**
         * the headers
         */

        td_api_header_style::add('1',
            array(
                'text' => 'Style 1',
                'file' => td_global::$get_template_directory . '/parts/header/header-style-1.php',
                'img' => td_global::$get_template_directory_uri . '/images/panel/menu/icon-menu-1.png'
            )
        );

        td_api_header_style::add('2',
            array(
                'text' => 'Style 2',
                'file' => td_global::$get_template_directory . '/parts/header/header-style-2.php',
                'img' => td_global::$get_template_directory_uri . '/images/panel/menu/icon-menu-2.png'
            )
        );

        td_api_header_style::add('3',
            array(
                'text' => 'Style 3',
                'file' => td_global::$get_template_directory . '/parts/header/header-style-3.php',
                'img' => td_global::$get_template_directory_uri . '/images/panel/menu/icon-menu-3.png'
            )
        );

        td_api_header_style::add('4',
            array(
                'text' => 'Style 4',
                'file' => td_global::$get_template_directory . '/parts/header/header-style-4.php',
                'img' => td_global::$get_template_directory_uri . '/images/panel/menu/icon-menu-4.png'
            )
        );

        td_api_header_style::add('5',
            array(
                'text' => 'Style 5',
                'file' => td_global::$get_template_directory . '/parts/header/header-style-5.php',
                'img' => td_global::$get_template_directory_uri . '/images/panel/menu/icon-menu-5.png'
            )
        );

        td_api_header_style::add('6',
            array(
                'text' => 'Style 6',
                'file' => td_global::$get_template_directory . '/parts/header/header-style-6.php',
                'img' => td_global::$get_template_directory_uri . '/images/panel/menu/icon-menu-6.png'
            )
        );

        td_api_header_style::add('7',
            array(
                'text' => 'Style 7',
                'file' => td_global::$get_template_directory . '/parts/header/header-style-7.php',
                'img' => td_global::$get_template_directory_uri . '/images/panel/menu/icon-menu-7.png'
            )
        );

        td_api_header_style::add('8',
            array(
                'text' => 'Style 8',
                'file' => td_global::$get_template_directory . '/parts/header/header-style-8.php',
                'img' => td_global::$get_template_directory_uri . '/images/panel/menu/icon-menu-8.png'
            )
        );

        td_api_header_style::add('9',
            array(
                'text' => 'Style 9',
                'file' => td_global::$get_template_directory . '/parts/header/header-style-9.php',
                'img' => td_global::$get_template_directory_uri . '/images/panel/menu/icon-menu-9.png'
            )
        );

        td_api_header_style::add('10',
            array(
                'text' => 'Style 10',
                'file' => td_global::$get_template_directory . '/parts/header/header-style-10.php',
                'img' => td_global::$get_template_directory_uri . '/images/panel/menu/icon-menu-10.png'
            )
        );

        td_api_header_style::add('11',
            array(
                'text' => 'Style 11',
                'file' => td_global::$get_template_directory . '/parts/header/header-style-11.php',
                'img' => td_global::$get_template_directory_uri . '/images/panel/menu/icon-menu-11.png'
            )
        );

        td_api_header_style::add('12',
            array(
                'text' => 'Style 12',
                'file' => td_global::$get_template_directory . '/parts/header/header-style-12.php',
                'img' => td_global::$get_template_directory_uri . '/images/panel/menu/icon-menu-12.png'
            )
        );

        /**
         * the styles for big grids. This styles will show up in the panel @see td_panel_categories.php and on each big grid block
         * This has to be before the blocks are added! The grids blocks are made with this
         */
        td_global::$big_grid_styles_list = array(
            'td-grid-style-1' => array(  // td-grid-style-1 - THIS HAS TO BE THE DEFAULT
                'text' => 'Grid style 1 - Default'
            ),
            'td-grid-style-2' => array(
                'text' => 'Grid style 2 - Colours'
            ),
            'td-grid-style-3' => array(
                'text' => 'Grid style 3 - Flat colours'
            ),
            'td-grid-style-4' => array(
                'text' => 'Grid style 4 - Bottom box'
            ),
            'td-grid-style-5' => array(
                'text' => 'Grid style 5 - Black middle'
            ),
            'td-grid-style-6' => array(
                'text' => 'Grid style 6 - Lightsky'
            ),
            'td-grid-style-7' => array(
                'text' => 'Grid style 7 - Rainbow'
            )
        );



	    /**
         * block templates
         */
        td_api_block_template::add('td_block_template_1',
            array (
                'text' => 'Block Header 1 - Default',
                'img' => td_global::$get_template_directory_uri . '/images/panel/block_templates/icon-block-header-1.png',
                'file' => td_global::$get_template_directory . '/includes/block_templates/td_block_template_1.php',
	            'params' => array(
					// title settings
                    array(
                        "type" => "colorpicker",
                        "holder" => "div",
                        "class" => "",
                        "heading" => 'Title background color:',
                        "param_name" => "header_color",
                        "value" => '',
                        "description" => 'Optional - Choose a custom background color for this header',
                        'td_type' => 'block_template',
                    ),
					array(
						"type" => "colorpicker",
						"holder" => "div",
						"class" => "",
						"heading" => 'Title text color:',
						"param_name" => "header_text_color",
						"value" => '',
						"description" => 'Optional - Choose a custom title text color for this header',
						'td_type' => 'block_template',
					),
		            array(
			            "type" => "colorpicker",
			            "holder" => "div",
			            "class" => "",
			            "heading" => 'Accent hover color:',
			            "param_name" => "accent_text_color",
			            "value" => '',
			            "description" => 'Optional - Choose a custom accent hover color for this block',
			            'td_type' => 'block_template',
		            )
				)//end generic array
            )
        );

        td_api_block_template::add('td_block_template_2',
            array (
                'text' => 'Block Header 2',
                'img' => td_global::$get_template_directory_uri . '/images/panel/block_templates/icon-block-header-2.png',
                'file' => td_global::$get_template_directory . '/includes/block_templates/td_block_template_2.php',
	            'params' => array(
					// title settings
					array(
						"type" => "colorpicker",
						"holder" => "div",
						"class" => "",
						"heading" => 'Title text color:',
						"param_name" => "header_text_color",
						"value" => '',
						"description" => 'Optional - Choose a custom title text color for this header',
						'td_type' => 'block_template',
					),
		            array(
			            "type" => "colorpicker",
			            "holder" => "div",
			            "class" => "",
			            "heading" => 'Accent hover color:',
			            "param_name" => "accent_text_color",
			            "value" => '',
			            "description" => 'Optional - Choose a custom accent hover color for this block',
			            'td_type' => 'block_template',
		            )
				)//end generic array
            )
        );

        td_api_block_template::add('td_block_template_3',
            array (
                'text' => 'Block Header 3',
                'img' => td_global::$get_template_directory_uri . '/images/panel/block_templates/icon-block-header-3.png',
                'file' => td_global::$get_template_directory . '/includes/block_templates/td_block_template_3.php',
	            'params' => array(
					// title settings
                    array(
                        "type" => "colorpicker",
                        "holder" => "div",
                        "class" => "",
                        "heading" => 'Title background color:',
                        "param_name" => "header_color",
                        "value" => '',
                        "description" => 'Optional - Choose a custom background color for this header',
                        'td_type' => 'block_template',
                    ),
					array(
						"type" => "colorpicker",
						"holder" => "div",
						"class" => "",
						"heading" => 'Title text color:',
						"param_name" => "header_text_color",
						"value" => '',
						"description" => 'Optional - Choose a custom title text color for this header',
						'td_type' => 'block_template',
					),
		            array(
			            "type" => "colorpicker",
			            "holder" => "div",
			            "class" => "",
			            "heading" => 'Accent hover color:',
			            "param_name" => "accent_text_color",
			            "value" => '',
			            "description" => 'Optional - Choose a custom accent hover color for this block',
			            'td_type' => 'block_template',
		            )
				)//end generic array
            )
        );

        td_api_block_template::add('td_block_template_4',
            array (
                'text' => 'Block Header 4',
                'img' => td_global::$get_template_directory_uri . '/images/panel/block_templates/icon-block-header-4.png',
                'file' => td_global::$get_template_directory . '/includes/block_templates/td_block_template_4.php',
	            'params' => array(
					// title settings
                    array(
                        "type" => "colorpicker",
                        "holder" => "div",
                        "class" => "",
                        "heading" => 'Title background color:',
                        "param_name" => "header_color",
                        "value" => '',
                        "description" => 'Optional - Choose a custom background color for this header',
                        'td_type' => 'block_template',
                    ),
					array(
						"type" => "colorpicker",
						"holder" => "div",
						"class" => "",
						"heading" => 'Title text color:',
						"param_name" => "header_text_color",
						"value" => '',
						"description" => 'Optional - Choose a custom title text color for this header',
						'td_type' => 'block_template',
					),
		            array(
			            "type" => "colorpicker",
			            "holder" => "div",
			            "class" => "",
			            "heading" => 'Accent hover color:',
			            "param_name" => "accent_text_color",
			            "value" => '',
			            "description" => 'Optional - Choose a custom accent hover color for this block',
			            'td_type' => 'block_template',
		            )
				)//end generic array
            )
        );

        td_api_block_template::add('td_block_template_5',
            array (
                'text' => 'Block Header 5',
                'img' => td_global::$get_template_directory_uri . '/images/panel/block_templates/icon-block-header-5.png',
                'file' => td_global::$get_template_directory . '/includes/block_templates/td_block_template_5.php',
	            'params' => array(
					// title settings
                    array(
                        "type" => "colorpicker",
                        "holder" => "div",
                        "class" => "",
                        "heading" => 'Title background color:',
                        "param_name" => "header_color",
                        "value" => '',
                        "description" => 'Optional - Choose a custom background color for this header',
                        'td_type' => 'block_template',
                    ),
					array(
						"type" => "colorpicker",
						"holder" => "div",
						"class" => "",
						"heading" => 'Title text color:',
						"param_name" => "header_text_color",
						"value" => '',
						"description" => 'Optional - Choose a custom title text color for this header',
						'td_type' => 'block_template',
					),
		            array(
			            "type" => "colorpicker",
			            "holder" => "div",
			            "class" => "",
			            "heading" => 'Accent hover color:',
			            "param_name" => "accent_text_color",
			            "value" => '',
			            "description" => 'Optional - Choose a custom accent hover color for this block',
			            'td_type' => 'block_template',
		            )
				)//end generic array
            )
        );

        td_api_block_template::add('td_block_template_6',
            array (
                'text' => 'Block Header 6',
                'img' => td_global::$get_template_directory_uri . '/images/panel/block_templates/icon-block-header-6.png',
                'file' => td_global::$get_template_directory . '/includes/block_templates/td_block_template_6.php',
	            'params' => array(
					// title settings
					array(
						"type" => "colorpicker",
						"holder" => "div",
						"class" => "",
						"heading" => 'Title text color:',
						"param_name" => "header_text_color",
						"value" => '',
						"description" => 'Optional - Choose a custom title text color for this header',
						'td_type' => 'block_template',
					),
                    array(
                        "type" => "attach_image",
                        "holder" => "div",
                        "class" => "",
                        "heading" => "Header background",
                        "param_name" => "header_image",
                        "value" => '',
                        "description" => "Optional - Choose a custom background image for this header",
                        'td_type' => 'block_template',
                    ),
                    array(
                        "type" => "colorpicker",
                        "holder" => "div",
                        "class" => "",
                        "heading" => 'Accent hover color:',
                        "param_name" => "accent_text_color",
                        "value" => '',
                        "description" => 'Optional - Choose a custom accent hover color for this block',
                        'td_type' => 'block_template',
                    )
				)//end generic array
            )
        );

        td_api_block_template::add('td_block_template_7',
            array (
                'text' => 'Block Header 7',
                'img' => td_global::$get_template_directory_uri . '/images/panel/block_templates/icon-block-header-7.png',
                'file' => td_global::$get_template_directory . '/includes/block_templates/td_block_template_7.php',
	            'params' => array(
					// title settings
                    array(
                        "type" => "colorpicker",
                        "holder" => "div",
                        "class" => "",
                        "heading" => 'Title background color:',
                        "param_name" => "header_color",
                        "value" => '',
                        "description" => 'Optional - Choose a custom background color for this header',
                        'td_type' => 'block_template',
                    ),
					array(
						"type" => "colorpicker",
						"holder" => "div",
						"class" => "",
						"heading" => 'Title text color:',
						"param_name" => "header_text_color",
						"value" => '',
						"description" => 'Optional - Choose a custom title text color for this header',
						'td_type' => 'block_template',
					),
                    array(
                        "type" => "colorpicker",
                        "holder" => "div",
                        "class" => "",
                        "heading" => 'Accent hover color:',
                        "param_name" => "accent_text_color",
                        "value" => '',
                        "description" => 'Optional - Choose a custom accent hover color for this block',
                        'td_type' => 'block_template',
                    ),
                    array(
                        "type" => "attach_image",
                        "holder" => "div",
                        "class" => "",
                        "heading" => "Header pattern",
                        "param_name" => "header_image",
                        "value" => '',
                        "description" => "Optional - Choose a custom background image for this header",
                        'td_type' => 'block_template',
                    )
				)//end generic array
            )
        );

        td_api_block_template::add('td_block_template_8',
            array (
                'text' => 'Block Header 8',
                'img' => td_global::$get_template_directory_uri . '/images/panel/block_templates/icon-block-header-8.png',
                'file' => td_global::$get_template_directory . '/includes/block_templates/td_block_template_8.php',
	            'params' => array(
					// title settings
					array(
						"type" => "colorpicker",
						"holder" => "div",
						"class" => "",
						"heading" => 'Title text color:',
						"param_name" => "header_text_color",
						"value" => '',
						"description" => 'Optional - Choose a custom title text color for this header',
						'td_type' => 'block_template',
					),
					array(
						"type" => "colorpicker",
						"holder" => "div",
						"class" => "",
						"heading" => 'Border color:',
						"param_name" => "border_color",
						"value" => '',
						"description" => 'Optional - Choose a custom border color for this header',
						'td_type' => 'block_template',
					),
                    array(
                        "type" => "colorpicker",
                        "holder" => "div",
                        "class" => "",
                        "heading" => 'Accent hover color:',
                        "param_name" => "accent_text_color",
                        "value" => '',
                        "description" => 'Optional - Choose a custom accent hover color for this block',
                        'td_type' => 'block_template',
                    )
				)//end generic array
            )
        );

        td_api_block_template::add('td_block_template_9',
            array (
                'text' => 'Block Header 9',
                'img' => td_global::$get_template_directory_uri . '/images/panel/block_templates/icon-block-header-9.png',
                'file' => td_global::$get_template_directory . '/includes/block_templates/td_block_template_9.php',
	            'params' => array(
					// title settings
					array(
						"type" => "colorpicker",
						"holder" => "div",
						"class" => "",
						"heading" => 'Title text color:',
						"param_name" => "header_text_color",
						"value" => '',
						"description" => 'Optional - Choose a custom title text color for this header',
						'td_type' => 'block_template',
					),
                    array(
                        "type" => "colorpicker",
                        "holder" => "div",
                        "class" => "",
                        "heading" => 'Border color:',
                        "param_name" => "border_color",
                        "value" => '',
                        "description" => 'Optional - Choose a custom border color for this header',
                        'td_type' => 'block_template',
                    ),
                    array(
                        "type" => "colorpicker",
                        "holder" => "div",
                        "class" => "",
                        "heading" => 'Accent hover color:',
                        "param_name" => "accent_text_color",
                        "value" => '',
                        "description" => 'Optional - Choose a custom accent hover color for this block',
                        'td_type' => 'block_template',
                    )
				)//end generic array
            )
        );

        td_api_block_template::add('td_block_template_10',
            array (
                'text' => 'Block Header 10',
                'img' => td_global::$get_template_directory_uri . '/images/panel/block_templates/icon-block-header-10.png',
                'file' => td_global::$get_template_directory . '/includes/block_templates/td_block_template_10.php',
	            'params' => array(
					// title settings
                    array(
                        "type" => "colorpicker",
                        "holder" => "div",
                        "class" => "",
                        "heading" => 'Title text color:',
                        "param_name" => "header_text_color",
                        "value" => '',
                        "description" => 'Optional - Choose a custom title text color for this header',
                        'td_type' => 'block_template',
                    ),
                    array(
                        "type" => "colorpicker",
                        "holder" => "div",
                        "class" => "",
                        "heading" => 'Border color:',
                        "param_name" => "border_color",
                        "value" => '',
                        "description" => 'Optional - Choose a custom border color for this header',
                        'td_type' => 'block_template',
                    ),
                    array(
                        "type" => "colorpicker",
                        "holder" => "div",
                        "class" => "",
                        "heading" => 'Accent hover color:',
                        "param_name" => "accent_text_color",
                        "value" => '',
                        "description" => 'Optional - Choose a custom accent hover color for this block',
                        'td_type' => 'block_template',
                    )
				)//end generic array
            )
        );

        td_api_block_template::add('td_block_template_11',
            array (
                'text' => 'Block Header 11',
                'img' => td_global::$get_template_directory_uri . '/images/panel/block_templates/icon-block-header-11.png',
                'file' => td_global::$get_template_directory . '/includes/block_templates/td_block_template_11.php',
	            'params' => array(
					// title settings
                    array(
                        "type" => "colorpicker",
                        "holder" => "div",
                        "class" => "",
                        "heading" => 'Title text color:',
                        "param_name" => "header_text_color",
                        "value" => '',
                        "description" => 'Optional - Choose a custom title text color for this header',
                        'td_type' => 'block_template',
                    ),
                    array(
                        "type" => "colorpicker",
                        "holder" => "div",
                        "class" => "",
                        "heading" => 'Border color:',
                        "param_name" => "border_color",
                        "value" => '',
                        "description" => 'Optional - Choose a custom border color for this header',
                        'td_type' => 'block_template',
                    ),
                    array(
                        "type" => "colorpicker",
                        "holder" => "div",
                        "class" => "",
                        "heading" => 'Accent hover color:',
                        "param_name" => "accent_text_color",
                        "value" => '',
                        "description" => 'Optional - Choose a custom accent hover color for this block',
                        'td_type' => 'block_template',
                    )
				)//end generic array
            )
        );

        td_api_block_template::add('td_block_template_12',
            array (
                'text' => 'Block Header 12',
                'img' => td_global::$get_template_directory_uri . '/images/panel/block_templates/icon-block-header-12.png',
                'file' => td_global::$get_template_directory . '/includes/block_templates/td_block_template_12.php',
	            'params' => array(
					// title settings
                    array(
                        "type" => "colorpicker",
                        "holder" => "div",
                        "class" => "",
                        "heading" => 'Title text color:',
                        "param_name" => "header_text_color",
                        "value" => '',
                        "description" => 'Optional - Choose a custom title text color for this header',
                        'td_type' => 'block_template',
                    ),
                    array(
                        "type" => "colorpicker",
                        "holder" => "div",
                        "class" => "",
                        "heading" => 'Accent hover color:',
                        "param_name" => "accent_text_color",
                        "value" => '',
                        "description" => 'Optional - Choose a custom accent hover color for this block',
                        'td_type' => 'block_template',
                    ),
                    array(
                        "type" => "textfield",
                        "holder" => "div",
                        "class" => "tdc-textfield-big",
                        "heading" => 'Continue button text:',
                        "param_name" => "button_text",
                        "value" => '',
                        "description" => 'To enable the continue button, choose a category from Filter or write a custom Title URL',
                        'td_type' => 'block_template',
                    ),
                    array(
                        "type" => "colorpicker",
                        "holder" => "div",
                        "class" => "",
                        "heading" => 'Continue button color:',
                        "param_name" => "button_color",
                        "value" => '',
                        "description" => 'Optional - Choose a custom text color for the continue button',
                        'td_type' => 'block_template',
                    )
				)//end generic array
            )
        );

        td_api_block_template::add('td_block_template_13',
            array (
                'text' => 'Block Header 13',
                'img' => td_global::$get_template_directory_uri . '/images/panel/block_templates/icon-block-header-13.png',
                'file' => td_global::$get_template_directory . '/includes/block_templates/td_block_template_13.php',
                'params' => array(
                    // title settings
                    array(
                        "type" => "colorpicker",
                        "holder" => "div",
                        "class" => "",
                        "heading" => 'Title text color:',
                        "param_name" => "header_text_color",
                        "value" => '',
                        "description" => 'Optional - Choose a custom title text color for this header',
                        'td_type' => 'block_template',
                    ),
                    array(
                        "type" => "colorpicker",
                        "holder" => "div",
                        "class" => "",
                        "heading" => 'Accent hover color:',
                        "param_name" => "accent_text_color",
                        "value" => '',
                        "description" => 'Optional - Choose a custom accent hover color for this block',
                        'td_type' => 'block_template',
                    ),
                    array(
                        "type" => "textfield",
                        "holder" => "div",
                        "class" => "tdc-textfield-big",
                        "heading" => 'Big title:',
                        "param_name" => "big_title_text",
                        "value" => '',
                        "description" => 'Optional - Choose a custom big title text for this header',
                        'td_type' => 'block_template',
                    ),
                    array(
                        "type" => "colorpicker",
                        "holder" => "div",
                        "class" => "",
                        "heading" => 'Big title text color:',
                        "param_name" => "big_text_color",
                        "value" => '',
                        "description" => 'Optional - Choose a custom color for the big title',
                        'td_type' => 'block_template',
                    ),
                    array(
                        "type" => "textfield",
                        "holder" => "div",
                        "class" => "tdc-textfield-big",
                        "heading" => 'Continue button text:',
                        "param_name" => "button_text",
                        "value" => '',
                        "description" => 'To enable the continue button, choose a category from Filter or write a custom Title URL',
                        'td_type' => 'block_template',
                    ),
                    array(
                        "type" => "colorpicker",
                        "holder" => "div",
                        "class" => "",
                        "heading" => 'Continue button color:',
                        "param_name" => "button_color",
                        "value" => '',
                        "description" => 'Optional - Choose a custom text color for the continue button',
                        'td_type' => 'block_template',
                    )
                )//end generic array
            )
        );

        td_api_block_template::add('td_block_template_14',
            array (
                'text' => 'Block Header 14',
                'img' => td_global::$get_template_directory_uri . '/images/panel/block_templates/icon-block-header-14.png',
                'file' => td_global::$get_template_directory . '/includes/block_templates/td_block_template_14.php',
                'params' => array(
                    // title settings
                    array(
                        "type" => "colorpicker",
                        "holder" => "div",
                        "class" => "",
                        "heading" => 'Title text color:',
                        "param_name" => "header_text_color",
                        "value" => '',
                        "description" => 'Optional - Choose a custom title text color for this header',
                        'td_type' => 'block_template',
                    ),
                    array(
                        "type" => "colorpicker",
                        "holder" => "div",
                        "class" => "",
                        "heading" => 'Title background color:',
                        "param_name" => "header_color",
                        "value" => '',
                        "description" => 'Optional - Choose a custom background color for this header',
                        'td_type' => 'block_template',
                    ),
                    array(
                        "type" => "colorpicker",
                        "holder" => "div",
                        "class" => "",
                        "heading" => 'Border color:',
                        "param_name" => "border_color",
                        "value" => '',
                        "description" => 'Optional - Choose a custom border color for this header',
                        'td_type' => 'block_template',
                    ),
                    array(
                        "type" => "colorpicker",
                        "holder" => "div",
                        "class" => "",
                        "heading" => 'Accent hover color:',
                        "param_name" => "accent_text_color",
                        "value" => '',
                        "description" => 'Optional - Choose a custom accent hover color for this block',
                        'td_type' => 'block_template',
                    )
                )//end generic array
            )
        );

        td_api_block_template::add('td_block_template_15',
            array (
                'text' => 'Block Header 15',
                'img' => td_global::$get_template_directory_uri . '/images/panel/block_templates/icon-block-header-15.png',
                'file' => td_global::$get_template_directory . '/includes/block_templates/td_block_template_15.php',
                'params' => array(
                    // title settings
                    array(
                        "type" => "colorpicker",
                        "holder" => "div",
                        "class" => "",
                        "heading" => 'Title text color:',
                        "param_name" => "header_text_color",
                        "value" => '',
                        "description" => 'Optional - Choose a custom title text color for this header',
                        'td_type' => 'block_template',
                    ),
                    array(
                        "type" => "colorpicker",
                        "holder" => "div",
                        "class" => "",
                        "heading" => 'Title background color:',
                        "param_name" => "header_color",
                        "value" => '',
                        "description" => 'Optional - Choose a custom background color for this header',
                        'td_type' => 'block_template',
                    ),
                    array(
                        "type" => "colorpicker",
                        "holder" => "div",
                        "class" => "",
                        "heading" => 'Border color:',
                        "param_name" => "border_color",
                        "value" => '',
                        "description" => 'Optional - Choose a custom border color for this header',
                        'td_type' => 'block_template',
                    ),
                    array(
                        "type" => "colorpicker",
                        "holder" => "div",
                        "class" => "",
                        "heading" => 'Top border color:',
                        "param_name" => "top_border_color",
                        "value" => '',
                        "description" => 'Optional - Choose a custom top border color for this header',
                        'td_type' => 'block_template',
                    ),
                    array(
                        "type" => "colorpicker",
                        "holder" => "div",
                        "class" => "",
                        "heading" => 'Accent hover color:',
                        "param_name" => "accent_text_color",
                        "value" => '',
                        "description" => 'Optional - Choose a custom accent hover color for this block',
                        'td_type' => 'block_template',
                    )
                )//end generic array
            )
        );

        td_api_block_template::add('td_block_template_16',
            array (
                'text' => 'Block Header 16',
                'img' => td_global::$get_template_directory_uri . '/images/panel/block_templates/icon-block-header-16.png',
                'file' => td_global::$get_template_directory . '/includes/block_templates/td_block_template_16.php',
                'params' => array(
                    // title settings
                    array(
                        "type" => "colorpicker",
                        "holder" => "div",
                        "class" => "",
                        "heading" => 'Title text color:',
                        "param_name" => "header_text_color",
                        "value" => '',
                        "description" => 'Optional - Choose a custom title text color for this header',
                        'td_type' => 'block_template',
                    ),
                    array(
                        "type" => "colorpicker",
                        "holder" => "div",
                        "class" => "",
                        "heading" => 'Border color:',
                        "param_name" => "border_color",
                        "value" => '',
                        "description" => 'Optional - Choose a custom border color for this header',
                        'td_type' => 'block_template',
                    ),
                    array(
                        "type" => "colorpicker",
                        "holder" => "div",
                        "class" => "",
                        "heading" => 'Accent hover color:',
                        "param_name" => "accent_text_color",
                        "value" => '',
                        "description" => 'Optional - Choose a custom accent hover color for this block',
                        'td_type' => 'block_template',
                    )
                )//end generic array
            )
        );

        td_api_block_template::add('td_block_template_17',
            array (
                'text' => 'Block Header 17',
                'img' => td_global::$get_template_directory_uri . '/images/panel/block_templates/icon-block-header-17.png',
                'file' => td_global::$get_template_directory . '/includes/block_templates/td_block_template_17.php',
                'params' => array(
                    // title settings
                    array(
                        "type" => "colorpicker",
                        "holder" => "div",
                        "class" => "",
                        "heading" => 'Title text color:',
                        "param_name" => "header_text_color",
                        "value" => '',
                        "description" => 'Optional - Choose a custom title text color for this header',
                        'td_type' => 'block_template',
                    ),
                    array(
                        "type" => "colorpicker",
                        "holder" => "div",
                        "class" => "",
                        "heading" => 'Title background color:',
                        "param_name" => "header_color",
                        "value" => '',
                        "description" => 'Optional - Choose a custom background color for this header',
                        'td_type' => 'block_template',
                    ),
                    array(
                        "type" => "colorpicker",
                        "holder" => "div",
                        "class" => "",
                        "heading" => 'Border top color:',
                        "param_name" => "top_border_color",
                        "value" => '',
                        "description" => 'Optional - Choose a custom top border color for this header',
                        'td_type' => 'block_template',
                    ),
                    array(
                        "type" => "colorpicker",
                        "holder" => "div",
                        "class" => "",
                        "heading" => 'Border bottom color:',
                        "param_name" => "bottom_border_color",
                        "value" => '',
                        "description" => 'Optional - Choose a custom bottom border color for this header',
                        'td_type' => 'block_template',
                    ),
                    array(
                        "type" => "colorpicker",
                        "holder" => "div",
                        "class" => "",
                        "heading" => 'Accent hover color:',
                        "param_name" => "accent_text_color",
                        "value" => '',
                        "description" => 'Optional - Choose a custom accent hover color for this block',
                        'td_type' => 'block_template',
                    )
                )//end generic array
            )
        );



        /**
         * the blocks
         */
        td_api_block::add('td_block_1',
            array(
                'map_in_visual_composer' => true,
	            'map_in_td_composer' => true,
                "name" => 'Block 1',
                "base" => 'td_block_1',
                "class" => 'td_block_1',
                "controls" => "full",
                "category" => 'Blocks',
	            'tdc_category' => 'Blocks',
                'icon' => 'icon-pagebuilder-td_block_1',
                'file' => td_global::$get_template_directory . '/includes/shortcodes/td_block_1.php',
	            "params" => array_merge(
                    self::get_map_block_general_array(),

                    array(
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Content length',
                            "value"      => "",
                            "class"      => "",
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Module 4',
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                        ),
                        array(
                            "param_name"  => "m4_tl",
                            "type"        => "textfield",
                            "value"       => '',
                            "heading"     => 'Title length',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-small",
                            "placeholder" => '25',
                        ),
                        array(
                            "param_name"  => "m4_el",
                            "type"        => "textfield",
                            "value"       => '',
                            "heading"     => 'Excerpt length',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-small",
                            "placeholder" => "25",
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Module 6',
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                        ),
                        array(
                            "param_name"  => "m6_tl",
                            "type"        => "textfield",
                            "value"       => '',
                            "heading"     => 'Title length',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-small",
                            "placeholder" => '25',
                        ),
                    ),

                    self::get_map_filter_array(),
                    self::get_map_block_ajax_filter_array(),

                    td_config_helper::block_font(),
                    td_config_helper::module_4_font(),
                    td_config_helper::module_6_font(),

                    self::get_map_block_pagination_array()
                )
            )
        );

        td_api_block::add('td_block_2',
            array(
                'map_in_visual_composer' => true,
	            'map_in_td_composer' => true,
                "name" => 'Block 2',
                "base" => 'td_block_2',
                "class" => 'td_block_2',
                "controls" => "full",
                "category" => 'Blocks',
                'tdc_category' => 'Blocks',
                'icon' => 'icon-pagebuilder-td_block_2',
                'file' => td_global::$get_template_directory . '/includes/shortcodes/td_block_2.php',
                "params" => array_merge(
                    self::get_map_block_general_array(),

                    array(
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Content length',
                            "value"      => "",
                            "class"      => "",
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Module 2',
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                        ),
                        array(
                            "param_name"  => "m2_tl",
                            "type"        => "textfield",
                            "value"       => '',
                            "heading"     => 'Title length',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-small",
                            "placeholder" => '25',
                        ),
                        array(
                            "param_name"  => "m2_el",
                            "type"        => "textfield",
                            "value"       => '',
                            "heading"     => 'Excerpt length',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-small",
                            "placeholder" => '25',
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Module 6',
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                        ),
                        array(
                            "param_name"  => "m6_tl",
                            "type"        => "textfield",
                            "value"       => '',
                            "heading"     => 'Title length',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-small",
                            "placeholder" => '25',
                        ),
                    ),

                    self::get_map_filter_array(),
                    self::get_map_block_ajax_filter_array(),

                    td_config_helper::block_font(),
                    td_config_helper::module_2_font(),
                    td_config_helper::module_6_font(),

                    self::get_map_block_pagination_array()
                )
            )
        );

        td_api_block::add('td_block_3',
            array(
                'map_in_visual_composer' => true,
	            'map_in_td_composer' => true,
                "name" => 'Block 3',
                "base" => 'td_block_3',
                "class" => 'td_block_3',
                "controls" => "full",
                "category" => 'Blocks',
                'tdc_category' => 'Blocks',
                'icon' => 'icon-pagebuilder-td_block_3',
                'file' => td_global::$get_template_directory . '/includes/shortcodes/td_block_3.php',
                "params" => array_merge(
                    self::get_map_block_general_array(),

                    array(
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Content length',
                            "value"      => "",
                            "class"      => "",
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Module 1',
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                        ),
                        array(
                            "param_name"  => "m1_tl",
                            "type"        => "textfield",
                            "value"       => '',
                            "heading"     => 'Title length',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-small",
                            "placeholder" => '25',
                        ),
                    ),

                    self::get_map_filter_array(),
                    self::get_map_block_ajax_filter_array(),

                    td_config_helper::block_font(),
                    td_config_helper::module_1_font(),

                    self::get_map_block_pagination_array()
                )
            )
        );

        td_api_block::add('td_block_4',
            array(
                'map_in_visual_composer' => true,
	            'map_in_td_composer' => true,
                "name" => 'Block 4',
                "base" => 'td_block_4',
                "class" => 'td_block_4',
                "controls" => "full",
                "category" => 'Blocks',
                'tdc_category' => 'Blocks',
                'icon' => 'icon-pagebuilder-td_block_4',
                'file' => td_global::$get_template_directory . '/includes/shortcodes/td_block_4.php',
                "params" => array_merge(
                    self::get_map_block_general_array(),

                    array(
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Content length',
                            "value"      => "",
                            "class"      => "",
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Module 2',
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                        ),
                        array(
                            "param_name"  => "m2_tl",
                            "type"        => "textfield",
                            "value"       => '',
                            "heading"     => 'Title length',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-small",
                            "placeholder" => '25',
                        ),
                        array(
                            "param_name"  => "m2_el",
                            "type"        => "textfield",
                            "value"       => '',
                            "heading"     => 'Excerpt length',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-small",
                            "placeholder" => '25',
                        ),
                    ),

                    self::get_map_filter_array(),
                    self::get_map_block_ajax_filter_array(),

                    td_config_helper::block_font(),
                    td_config_helper::module_2_font(),

                    self::get_map_block_pagination_array()
                )
            )
        );

        td_api_block::add('td_block_5',
            array(
                'map_in_visual_composer' => true,
	            'map_in_td_composer' => true,
                "name" => 'Block 5',
                "base" => 'td_block_5',
                "class" => 'td_block_5',
                "controls" => "full",
                "category" => 'Blocks',
                'tdc_category' => 'Blocks',
                'icon' => 'icon-pagebuilder-td_block_5',
                'file' => td_global::$get_template_directory . '/includes/shortcodes/td_block_5.php',
                "params" => array_merge(
                    self::get_map_block_general_array(),

                    array(
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Content length',
                            "value"      => "",
                            "class"      => "",
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Module 3',
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                        ),
                        array(
                            "param_name"  => "m3_tl",
                            "type"        => "textfield",
                            "value"       => '',
                            "heading"     => 'Title length',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-small",
                            "placeholder" => '25',
                        ),
                    ),

                    self::get_map_filter_array(),
                    self::get_map_block_ajax_filter_array(),

                    td_config_helper::block_font(),
                    td_config_helper::module_3_font(),

                    self::get_map_block_pagination_array()
                )
            )
        );

        td_api_block::add('td_block_6',
            array(
                'map_in_visual_composer' => true,
	            'map_in_td_composer' => true,
                "name" => 'Block 6',
                "base" => 'td_block_6',
                "class" => 'td_block_6',
                "controls" => "full",
                "category" => 'Blocks',
                'tdc_category' => 'Blocks',
                'icon' => 'icon-pagebuilder-td_block_6',
                'file' => td_global::$get_template_directory . '/includes/shortcodes/td_block_6.php',
                "params" => array_merge(
                    self::get_map_block_general_array(),

                    array(
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Content length',
                            "value"      => "",
                            "class"      => "",
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Module 5',
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                        ),
                        array(
                            "param_name"  => "m5_tl",
                            "type"        => "textfield",
                            "value"       => '',
                            "heading"     => 'Title length',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-small",
                            "placeholder" => '25',
                        ),
                        array(
                            "param_name"  => "m5_el",
                            "type"        => "textfield",
                            "value"       => '',
                            "heading"     => 'Excerpt length',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-small",
                            "placeholder" => '25',
                        ),
                    ),

                    self::get_map_filter_array(),
                    self::get_map_block_ajax_filter_array(),

                    td_config_helper::block_font(),
                    td_config_helper::module_5_font(),

                    self::get_map_block_pagination_array()
                )
            )
        );

        td_api_block::add('td_block_7',
            array(
                'map_in_visual_composer' => true,
	            'map_in_td_composer' => true,
                "name" => 'Block 7',
                "base" => 'td_block_7',
                "class" => 'td_block_7',
                "controls" => "full",
                "category" => 'Blocks',
                'tdc_category' => 'Blocks',
                'icon' => 'icon-pagebuilder-td_block_7',
                'file' => td_global::$get_template_directory . '/includes/shortcodes/td_block_7.php',
                "params" => array_merge(
                    self::get_map_block_general_array(),

                    array(
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Content length',
                            "value"      => "",
                            "class"      => "",
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Module 6',
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                        ),
                        array(
                            "param_name"  => "m6_tl",
                            "type"        => "textfield",
                            "value"       => '',
                            "heading"     => 'Title length',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-small",
                            "placeholder" => '25',
                        ),
                    ),

                    self::get_map_filter_array(),
                    self::get_map_block_ajax_filter_array(),

                    td_config_helper::block_font(),
                    td_config_helper::module_6_font(),

                    self::get_map_block_pagination_array()
                )
            )
        );

        td_api_block::add('td_block_8',
            array(
                'map_in_visual_composer' => true,
	            'map_in_td_composer' => true,
                "name" => 'Block 8',
                "base" => 'td_block_8',
                "class" => 'td_block_8',
                "controls" => "full",
                "category" => 'Blocks',
                'tdc_category' => 'Blocks',
                'icon' => 'icon-pagebuilder-td_block_8',
                'file' => td_global::$get_template_directory . '/includes/shortcodes/td_block_8.php',
                "params" => array_merge(
                    self::get_map_block_general_array(),

                    array(
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Content length',
                            "value"      => "",
                            "class"      => "",
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Module 7',
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                        ),
                        array(
                            "param_name"  => "m7_tl",
                            "type"        => "textfield",
                            "value"       => '',
                            "heading"     => 'Title length',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-small",
                            "placeholder" => '25',
                        ),
                    ),

                    self::get_map_filter_array(),
                    self::get_map_block_ajax_filter_array(),

                    td_config_helper::block_font(),
                    td_config_helper::module_7_font(),

                    self::get_map_block_pagination_array()
                )
            )
        );

        td_api_block::add('td_block_9',
            array(
                'map_in_visual_composer' => true,
	            'map_in_td_composer' => true,
                "name" => 'Block 9',
                "base" => 'td_block_9',
                "class" => 'td_block_9',
                "controls" => "full",
                "category" => 'Blocks',
                'tdc_category' => 'Blocks',
                'icon' => 'icon-pagebuilder-td_block_9',
                'file' => td_global::$get_template_directory . '/includes/shortcodes/td_block_9.php',
                "params" => array_merge(
                    self::get_map_block_general_array(),

                    array(
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Content length',
                            "value"      => "",
                            "class"      => "",
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Module 8',
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                        ),
                        array(
                            "param_name"  => "m8_tl",
                            "type"        => "textfield",
                            "value"       => '',
                            "heading"     => 'Title length',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-small",
                            "placeholder" => '25',
                        ),
                    ),

                    self::get_map_filter_array(),
                    self::get_map_block_ajax_filter_array(),

                    td_config_helper::block_font(),
                    td_config_helper::module_8_font(),

                    self::get_map_block_pagination_array()
                )
            )
        );

        td_api_block::add('td_block_10',
            array(
                'map_in_visual_composer' => true,
	            'map_in_td_composer' => true,
                "name" => 'Block 10',
                "base" => 'td_block_10',
                "class" => 'td_block_10',
                "controls" => "full",
                "category" => 'Blocks',
                'tdc_category' => 'Blocks',
                'icon' => 'icon-pagebuilder-td_block_10',
                'file' => td_global::$get_template_directory . '/includes/shortcodes/td_block_10.php',
                "params" => array_merge(
                    self::get_map_block_general_array(),

                    array(
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Content length',
                            "value"      => "",
                            "class"      => "",
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Module 9',
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                        ),
                        array(
                            "param_name"  => "m9_tl",
                            "type"        => "textfield",
                            "value"       => '',
                            "heading"     => 'Title length',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-small",
                            "placeholder" => '25',
                        ),
                    ),

                    self::get_map_filter_array(),
                    self::get_map_block_ajax_filter_array(),

                    td_config_helper::block_font(),
                    td_config_helper::module_9_font(),

                    self::get_map_block_pagination_array()
                )
            )
        );

        td_api_block::add('td_block_11',
            array(
                'map_in_visual_composer' => true,
	            'map_in_td_composer' => true,
                "name" => 'Block 11',
                "base" => 'td_block_11',
                "class" => 'td_block_11',
                "controls" => "full",
                "category" => 'Blocks',
                'tdc_category' => 'Blocks',
                'icon' => 'icon-pagebuilder-td_block_11',
                'file' => td_global::$get_template_directory . '/includes/shortcodes/td_block_11.php',
                "params" => array_merge(
                    self::get_map_block_general_array(),

                    array(
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Content length',
                            "value"      => "",
                            "class"      => "",
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Module 10',
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                        ),
                        array(
                            "param_name"  => "m10_tl",
                            "type"        => "textfield",
                            "value"       => '',
                            "heading"     => 'Title length',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-small",
                            "placeholder" => '25',
                        ),
                        array(
                            "param_name"  => "m10_el",
                            "type"        => "textfield",
                            "value"       => '',
                            "heading"     => 'Excerpt length',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-small",
                            "placeholder" => '25',
                        ),
                    ),

                    self::get_map_filter_array(),
                    self::get_map_block_ajax_filter_array(),

                    td_config_helper::block_font(),
                    td_config_helper::module_10_font(),

                    self::get_map_block_pagination_array()
                )
            )
        );

        td_api_block::add('td_block_12',
            array(
                'map_in_visual_composer' => true,
	            'map_in_td_composer' => true,
                "name" => 'Block 12',
                "base" => 'td_block_12',
                "class" => 'td_block_12',
                "controls" => "full",
                "category" => 'Blocks',
                'tdc_category' => 'Blocks',
                'icon' => 'icon-pagebuilder-td_block_12',
                'file' => td_global::$get_template_directory . '/includes/shortcodes/td_block_12.php',
                "params" => array_merge(
                    self::get_map_block_general_array(),

                    array(
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Content length',
                            "value"      => "",
                            "class"      => "",
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Module 11',
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                        ),
                        array(
                            "param_name"  => "m11_tl",
                            "type"        => "textfield",
                            "value"       => '',
                            "heading"     => 'Title length',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-small",
                            "placeholder" => '25',
                        ),
                        array(
                            "param_name"  => "m11_el",
                            "type"        => "textfield",
                            "value"       => '',
                            "heading"     => 'Excerpt length',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-small",
                            "placeholder" => '25',
                        ),
                    ),

                    self::get_map_filter_array(),
                    self::get_map_block_ajax_filter_array(),

                    td_config_helper::block_font(),
                    td_config_helper::module_11_font(),

                    self::get_map_block_pagination_array()
                )
            )
        );

        td_api_block::add('td_block_13',
            array(
                'map_in_visual_composer' => true,
	            'map_in_td_composer' => true,
                "name" => 'Block 13',
                "base" => 'td_block_13',
                "class" => 'td_block_13',
                "controls" => "full",
                "category" => 'Blocks',
                'tdc_category' => 'Blocks',
                'icon' => 'icon-pagebuilder-td_block_13',
                'file' => td_global::$get_template_directory . '/includes/shortcodes/td_block_13.php',
                "params" => array_merge(
                    self::get_map_block_general_array(),

                    array(
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Content length',
                            "value"      => "",
                            "class"      => "",
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Module MX3',
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                        ),
                        array(
                            "param_name"  => "mx3_tl",
                            "type"        => "textfield",
                            "value"       => '',
                            "heading"     => 'Title length',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-small",
                            "placeholder" => '25',
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Module 14',
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                        ),
                        array(
                            "param_name"  => "m14_tl",
                            "type"        => "textfield",
                            "value"       => '',
                            "heading"     => 'Title length',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-small",
                            "placeholder" => '25',
                        ),
                        array(
                            "param_name"  => "m14_el",
                            "type"        => "textfield",
                            "value"       => '',
                            "heading"     => 'Excerpt length',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-small",
                            "placeholder" => '25',
                        ),
                    ),

                    self::get_map_filter_array(),
                    self::get_map_block_ajax_filter_array(),

                    td_config_helper::block_font(),
                    td_config_helper::module_mx3_font(),
                    td_config_helper::module_14_font(),

                    self::get_map_block_pagination_array()
                )
            )
        );

        td_api_block::add('td_block_14',
            array(
                'map_in_visual_composer' => true,
	            'map_in_td_composer' => true,
                "name" => 'Block 14',
                "base" => 'td_block_14',
                "class" => 'td_block_14',
                "controls" => "full",
                "category" => 'Blocks',
                'tdc_category' => 'Blocks',
                'icon' => 'icon-pagebuilder-td_block_14',
                'file' => td_global::$get_template_directory . '/includes/shortcodes/td_block_14.php',
                "params" => array_merge(
                    self::get_map_block_general_array(),

                    array(
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Content length',
                            "value"      => "",
                            "class"      => "",
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Module MX1',
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                        ),
                        array(
                            "param_name"  => "mx1_tl",
                            "type"        => "textfield",
                            "value"       => '',
                            "heading"     => 'Title length',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-small",
                            "placeholder" => '25',
                        ),
                    ),

                    self::get_map_filter_array(),
                    self::get_map_block_ajax_filter_array(),

                    td_config_helper::block_font(),
                    td_config_helper::module_mx1_font(),

                    self::get_map_block_pagination_array()
                )
            )
        );

        td_api_block::add('td_block_15',
            array(
                'map_in_visual_composer' => true,
	            'map_in_td_composer' => true,
                "name" => 'Block 15',
                "base" => 'td_block_15',
                "class" => 'td_block_15',
                "controls" => "full",
                "category" => 'Blocks',
                'tdc_category' => 'Blocks',
                'icon' => 'icon-pagebuilder-td_block_15',
                'file' => td_global::$get_template_directory . '/includes/shortcodes/td_block_15.php',
                "params" => array_merge(
                    self::get_map_block_general_array(),

                    array(
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Content length',
                            "value"      => "",
                            "class"      => "",
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Module MX4',
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                        ),
                        array(
                            "param_name"  => "mx4_tl",
                            "type"        => "textfield",
                            "value"       => '',
                            "heading"     => 'Title length',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-small",
                            "placeholder" => '25',
                        ),
                    ),

                    self::get_map_filter_array(),
                    self::get_map_block_ajax_filter_array(),

                    td_config_helper::block_font(),
                    td_config_helper::module_mx4_font(),

                    self::get_map_block_pagination_array()
                )
            )
        );

        td_api_block::add('td_block_16',
            array(
                'map_in_visual_composer' => true,
	            'map_in_td_composer' => true,
                "name" => 'Block 16',
                "base" => 'td_block_16',
                "class" => 'td_block_16',
                "controls" => "full",
                "category" => 'Blocks',
                'tdc_category' => 'Blocks',
                'icon' => 'icon-pagebuilder-td_block_16',
                'file' => td_global::$get_template_directory . '/includes/shortcodes/td_block_16.php',
                "params" => array_merge(
                    self::get_map_block_general_array(),

                    array(
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Content length',
                            "value"      => "",
                            "class"      => "",
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Module MX7',
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                        ),
                        array(
                            "param_name"  => "mx7_tl",
                            "type"        => "textfield",
                            "value"       => '',
                            "heading"     => 'Title length',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-small",
                            "placeholder" => '25',
                        ),
                        array(
                            "param_name"  => "mx7_el",
                            "type"        => "textfield",
                            "value"       => '',
                            "heading"     => 'Excerpt length',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-small",
                            "placeholder" => '25',
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Module 6',
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                        ),
                        array(
                            "param_name"  => "m6_tl",
                            "type"        => "textfield",
                            "value"       => '',
                            "heading"     => 'Title length',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-small",
                            "placeholder" => '25',
                        ),
                    ),

                    self::get_map_filter_array(),
                    self::get_map_block_ajax_filter_array(),

                    td_config_helper::block_font(),
                    td_config_helper::module_mx7_font(),
                    td_config_helper::module_6_font(),

                    self::get_map_block_pagination_array()
                )
            )
        );

        td_api_block::add('td_block_17',
            array(
                'map_in_visual_composer' => true,
	            'map_in_td_composer' => true,
                "name" => 'Block 17',
                "base" => 'td_block_17',
                "class" => 'td_block_17',
                "controls" => "full",
                "category" => 'Blocks',
                'tdc_category' => 'Blocks',
                'icon' => 'icon-pagebuilder-td_block_17',
                'file' => td_global::$get_template_directory . '/includes/shortcodes/td_block_17.php',
                "params" => array_merge(
                    self::get_map_block_general_array(),

                    array(
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Content length',
                            "value"      => "",
                            "class"      => "",
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Module 4',
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                        ),
                        array(
                            "param_name"  => "m4_tl",
                            "type"        => "textfield",
                            "value"       => '',
                            "heading"     => 'Title length',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-small",
                            "placeholder" => '25',
                        ),
                        array(
                            "param_name"  => "m4_el",
                            "type"        => "textfield",
                            "value"       => '',
                            "heading"     => 'Excerpt length',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-small",
                            "placeholder" => '25',
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Module 8',
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                        ),
                        array(
                            "param_name"  => "m8_tl",
                            "type"        => "textfield",
                            "value"       => '',
                            "heading"     => 'Title length',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-small",
                            "placeholder" => '25',
                        ),
                    ),

                    self::get_map_filter_array(),
                    self::get_map_block_ajax_filter_array(),

                    td_config_helper::block_font(),
                    td_config_helper::module_4_font(),
                    td_config_helper::module_8_font(),

                    self::get_map_block_pagination_array()
                )
            )
        );

        td_api_block::add('td_block_18',
            array(
                'map_in_visual_composer' => true,
	            'map_in_td_composer' => true,
                "name" => 'Block 18',
                "base" => 'td_block_18',
                "class" => 'td_block_18',
                "controls" => "full",
                "category" => 'Blocks',
                'tdc_category' => 'Blocks',
                'icon' => 'icon-pagebuilder-td_block_18',
                'file' => td_global::$get_template_directory . '/includes/shortcodes/td_block_18.php',
                "params" => array_merge(
                    self::get_map_block_general_array(),

                    array(
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Content length',
                            "value"      => "",
                            "class"      => "",
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Module MX8',
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                        ),
                        array(
                            "param_name"  => "mx8_tl",
                            "type"        => "textfield",
                            "value"       => '',
                            "heading"     => 'Title length',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-small",
                            "placeholder" => '25',
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Module 10',
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                        ),
                        array(
                            "param_name"  => "m10_tl",
                            "type"        => "textfield",
                            "value"       => '',
                            "heading"     => 'Title length',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-small",
                            "placeholder" => '25',
                        ),
                        array(
                            "param_name"  => "m10_el",
                            "type"        => "textfield",
                            "value"       => '',
                            "heading"     => 'Excerpt length',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-small",
                            "placeholder" => '25',
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Module MX2',
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                        ),
                        array(
                            "param_name"  => "mx2_tl",
                            "type"        => "textfield",
                            "value"       => '',
                            "heading"     => 'Title length',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-small",
                            "placeholder" => '25',
                        ),
                    ),

                    self::get_map_filter_array(),
                    self::get_map_block_ajax_filter_array(),

                    td_config_helper::block_font(),
                    td_config_helper::module_mx8_font(),
                    td_config_helper::module_10_font(),
                    td_config_helper::module_mx2_font(),

                    self::get_map_block_pagination_array()
                )
            )
        );

        td_api_block::add('td_block_19',
            array(
                'map_in_visual_composer' => true,
	            'map_in_td_composer' => true,
                "name" => 'Block 19',
                "base" => 'td_block_19',
                "class" => 'td_block_19',
                "controls" => "full",
                "category" => 'Blocks',
                'tdc_category' => 'Blocks',
                'icon' => 'icon-pagebuilder-td_block_19',
                'file' => td_global::$get_template_directory . '/includes/shortcodes/td_block_19.php',
                "params" => array_merge(
                    self::get_map_block_general_array(),

                    array(
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Content length',
                            "value"      => "",
                            "class"      => "",
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Module MX1',
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                        ),
                        array(
                            "param_name"  => "mx1_tl",
                            "type"        => "textfield",
                            "value"       => '',
                            "heading"     => 'Title length',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-small",
                            "placeholder" => '25',
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Module MX2',
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                        ),
                        array(
                            "param_name"  => "mx2_tl",
                            "type"        => "textfield",
                            "value"       => '',
                            "heading"     => 'Title length',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-small",
                            "placeholder" => '25',
                        ),
                    ),

                    self::get_map_filter_array(),
                    self::get_map_block_ajax_filter_array(),

                    td_config_helper::block_font(),
                    td_config_helper::module_mx1_font(),
                    td_config_helper::module_mx2_font(),

                    self::get_map_block_pagination_array()
                )
            )
        );

        td_api_block::add('td_block_20',
            array(
                'map_in_visual_composer' => true,
	            'map_in_td_composer' => true,
                "name" => 'Block 20',
                "base" => 'td_block_20',
                "class" => 'td_block_20',
                "controls" => "full",
                "category" => 'Blocks',
                'tdc_category' => 'Blocks',
                'icon' => 'icon-pagebuilder-td_block_20',
                'file' => td_global::$get_template_directory . '/includes/shortcodes/td_block_20.php',
                "params" => array_merge(
                    self::get_map_block_general_array(),

                    array(
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Content length',
                            "value"      => "",
                            "class"      => "",
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Module MX3',
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                        ),
                        array(
                            "param_name"  => "mx3_tl",
                            "type"        => "textfield",
                            "value"       => '',
                            "heading"     => 'Title length',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-small",
                            "placeholder" => '25',
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Module 14',
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                        ),
                        array(
                            "param_name"  => "m14_tl",
                            "type"        => "textfield",
                            "value"       => '',
                            "heading"     => 'Title length',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-small",
                            "placeholder" => '25',
                        ),
                        array(
                            "param_name"  => "m14_el",
                            "type"        => "textfield",
                            "value"       => '',
                            "heading"     => 'Excerpt length',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-small",
                            "placeholder" => '25',
                        ),
                    ),

                    self::get_map_filter_array(),
                    self::get_map_block_ajax_filter_array(),

                    td_config_helper::block_font(),
                    td_config_helper::module_mx3_font(),
                    td_config_helper::module_14_font(),

                    self::get_map_block_pagination_array()
                )
            )
        );

        td_api_block::add('td_block_21',
            array(
                'map_in_visual_composer' => true,
	            'map_in_td_composer' => true,
                "name" => 'Block 21',
                "base" => 'td_block_21',
                "class" => 'td_block_21',
                "controls" => "full",
                "category" => 'Blocks',
                'tdc_category' => 'Blocks',
                'icon' => 'icon-pagebuilder-td_block_21',
                'file' => td_global::$get_template_directory . '/includes/shortcodes/td_block_21.php',
                "params" => array_merge(
                    self::get_map_block_general_array(),

                    array(
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Content length',
                            "value"      => "",
                            "class"      => "",
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Module 16',
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                        ),
                        array(
                            "param_name"  => "m16_tl",
                            "type"        => "textfield",
                            "value"       => '',
                            "heading"     => 'Title length',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-small",
                            "placeholder" => '25',
                        ),
                        array(
                            "param_name"  => "m16_el",
                            "type"        => "textfield",
                            "value"       => '',
                            "heading"     => 'Excerpt length',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-small",
                            "placeholder" => '25',
                        ),
                    ),

                    self::get_map_filter_array(),
                    self::get_map_block_ajax_filter_array(),

                    td_config_helper::block_font(),
                    td_config_helper::module_16_font(),

                    self::get_map_block_pagination_array()
                )
            )
        );

        td_api_block::add('td_block_22',
            array(
                'map_in_visual_composer' => true,
	            'map_in_td_composer' => true,
                "name" => 'Block 22',
                "base" => 'td_block_22',
                "class" => 'td_block_22',
                "controls" => "full",
                "category" => 'Blocks',
                'tdc_category' => 'Blocks',
                'icon' => 'icon-pagebuilder-td_block_22',
                'file' => td_global::$get_template_directory . '/includes/shortcodes/td_block_22.php',
                "params" => array_merge(
                    self::get_map_block_general_array(),

                    array(
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Content length',
                            "value"      => "",
                            "class"      => "",
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Module 17',
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                        ),
                        array(
                            "param_name"  => "m17_tl",
                            "type"        => "textfield",
                            "value"       => '',
                            "heading"     => 'Title length',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-small",
                            "placeholder" => '25',
                        ),
                        array(
                            "param_name"  => "m17_el",
                            "type"        => "textfield",
                            "value"       => '',
                            "heading"     => 'Excerpt length',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-small",
                            "placeholder" => '25',
                        ),
                    ),

                    self::get_map_filter_array(),
                    self::get_map_block_ajax_filter_array(),

                    td_config_helper::block_font(),
                    td_config_helper::module_17_font(),

                    self::get_map_block_pagination_array()
                )
            )
        );

        td_api_block::add('td_block_23',
            array(
                'map_in_visual_composer' => true,
	            'map_in_td_composer' => true,
                "name" => 'Block 23',
                "base" => 'td_block_23',
                "class" => 'td_block_23',
                "controls" => "full",
                "category" => 'Blocks',
                'tdc_category' => 'Blocks',
                'icon' => 'icon-pagebuilder-td_block_23',
                'file' => td_global::$get_template_directory . '/includes/shortcodes/td_block_23.php',
                "params" => array_merge(
                    self::get_map_block_general_array(),

                    array(
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Content length',
                            "value"      => "",
                            "class"      => "",
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Module 18',
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                        ),
                        array(
                            "param_name"  => "m18_tl",
                            "type"        => "textfield",
                            "value"       => '',
                            "heading"     => 'Title length',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-small",
                            "placeholder" => '25',
                        ),
                        array(
                            "param_name"  => "m18_el",
                            "type"        => "textfield",
                            "value"       => '',
                            "heading"     => 'Excerpt length',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-small",
                            "placeholder" => '25',
                        ),
                    ),

                    self::get_map_filter_array(),
                    self::get_map_block_ajax_filter_array(),

                    td_config_helper::block_font(),
                    td_config_helper::module_18_font(),

                    self::get_map_block_pagination_array()
                )
            )
        );

        td_api_block::add('td_block_24',
            array(
                'map_in_visual_composer' => true,
	            'map_in_td_composer' => true,
                "name" => 'Block 24',
                "base" => 'td_block_24',
                "class" => 'td_block_24',
                "controls" => "full",
                "category" => 'Blocks',
                'tdc_category' => 'Blocks',
                'icon' => 'icon-pagebuilder-td_block_24',
                'file' => td_global::$get_template_directory . '/includes/shortcodes/td_block_24.php',
                "params" => array_merge(
                    self::get_map_block_general_array(),

                    array(
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Content length',
                            "value"      => "",
                            "class"      => "",
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Module MX16',
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                        ),
                        array(
                            "param_name"  => "mx16_tl",
                            "type"        => "textfield",
                            "value"       => '',
                            "heading"     => 'Title length',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-small",
                            "placeholder" => '25',
                        ),
                        array(
                            "param_name"  => "mx16_el",
                            "type"        => "textfield",
                            "value"       => '',
                            "heading"     => 'Excerpt length',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-small",
                            "placeholder" => '25',
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Module 19',
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                        ),
                        array(
                            "param_name"  => "m19_tl",
                            "type"        => "textfield",
                            "value"       => '',
                            "heading"     => 'Title length',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-small",
                            "placeholder" => '25',
                        ),
                        array(
                            "param_name"  => "m19_el",
                            "type"        => "textfield",
                            "value"       => '',
                            "heading"     => 'Excerpt length',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-small",
                            "placeholder" => '25',
                        ),
                    ),

                    self::get_map_filter_array(),
                    self::get_map_block_ajax_filter_array(),

                    td_config_helper::block_font(),
                    td_config_helper::module_mx16_font(),
                    td_config_helper::module_19_font(),

                    self::get_map_block_pagination_array()
                )
            )
        );

        td_api_block::add('td_block_25',
            array(
                'map_in_visual_composer' => true,
	            'map_in_td_composer' => true,
                "name" => 'Block 25',
                "base" => 'td_block_25',
                "class" => 'td_block_25',
                "controls" => "full",
                "category" => 'Blocks',
                'tdc_category' => 'Blocks',
                'icon' => 'icon-pagebuilder-td_block_25',
                'file' => td_global::$get_template_directory . '/includes/shortcodes/td_block_25.php',
                "params" => array_merge(
                    self::get_map_block_general_array(),

                    array(
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Content length',
                            "value"      => "",
                            "class"      => "",
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Module MX17',
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                        ),
                        array(
                            "param_name"  => "mx17_tl",
                            "type"        => "textfield",
                            "value"       => '',
                            "heading"     => 'Title length',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-small",
                            "placeholder" => '25',
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Module 6',
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                        ),
                        array(
                            "param_name"  => "m6_tl",
                            "type"        => "textfield",
                            "value"       => '',
                            "heading"     => 'Title length',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-small",
                            "placeholder" => '25',
                        ),
                    ),

                    self::get_map_filter_array(),
                    self::get_map_block_ajax_filter_array(),

                    td_config_helper::block_font(),
                    td_config_helper::module_mx17_font(),
                    td_config_helper::module_6_font(),

                    self::get_map_block_pagination_array()
                )
            )
        );

        td_api_block::add('td_block_big_grid_1',
            array(
                'map_in_visual_composer' => true,
	            'map_in_td_composer' => true,
                "name" => 'Big Grid 1',
                "base" => 'td_block_big_grid_1',
                "class" => 'td_block_big_grid_1',
                "controls" => "full",
                "category" => 'Blocks',
                'tdc_category' => 'Big Grids',
                'icon' => 'icon-pagebuilder-td_block_big_grid_1',
                'file' => td_global::$get_template_directory . '/includes/shortcodes/td_block_big_grid_1.php',
                "params" => array_merge(
                    self::td_block_big_grid_style(),
                    array(
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Content length',
                            "value"      => "",
                            "class"      => "",
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Module MX5',
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                        ),
                        array(
                            "param_name"  => "mx5_tl",
                            "type"        => "textfield",
                            "value"       => '',
                            "heading"     => 'Title length',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-small",
                            "placeholder" => '25',
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Module MX6',
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                        ),
                        array(
                            "param_name"  => "mx6_tl",
                            "type"        => "textfield",
                            "value"       => '',
                            "heading"     => 'Title length',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-small",
                            "placeholder" => '25',
                        ),
                    ),
                    self::td_block_big_grid_params(),
                    td_config_helper::module_mx5_font(),
                    td_config_helper::module_mx6_font(),
                    self::get_map_css_tab()
                )
            )
        );

        td_api_block::add('td_block_big_grid_2',
            array(
                'map_in_visual_composer' => true,
	            'map_in_td_composer' => true,
                "name" => 'Big Grid 2',
                "base" => 'td_block_big_grid_2',
                "class" => 'td_block_big_grid_2',
                "controls" => "full",
                "category" => 'Blocks',
                'tdc_category' => 'Big Grids',
                'icon' => 'icon-pagebuilder-td_block_big_grid_2',
                'file' => td_global::$get_template_directory . '/includes/shortcodes/td_block_big_grid_2.php',
                "params" => array_merge(
                    self::td_block_big_grid_style(),

                    array(
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Content length',
                            "value"      => "",
                            "class"      => "",
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Module MX9',
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                        ),
                        array(
                            "param_name"  => "mx9_tl",
                            "type"        => "textfield",
                            "value"       => '',
                            "heading"     => 'Title length',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-small",
                            "placeholder" => '25',
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Module MX10',
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                        ),
                        array(
                            "param_name"  => "mx10_tl",
                            "type"        => "textfield",
                            "value"       => '',
                            "heading"     => 'Title length',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-small",
                            "placeholder" => '25',
                        ),
                    ),

                    self::td_block_big_grid_params(),
                    td_config_helper::module_mx9_font(),
                    td_config_helper::module_mx10_font(),
                    self::get_map_css_tab()
                )
            )
        );

        td_api_block::add('td_block_big_grid_3',
            array(
                'map_in_visual_composer' => true,
	            'map_in_td_composer' => true,
                "name" => 'Big Grid 3',
                "base" => 'td_block_big_grid_3',
                "class" => 'td_block_big_grid_3',
                "controls" => "full",
                "category" => 'Blocks',
                'tdc_category' => 'Big Grids',
                'icon' => 'icon-pagebuilder-td_block_big_grid_3',
                'file' => td_global::$get_template_directory . '/includes/shortcodes/td_block_big_grid_3.php',
                "params" => array_merge(
                    self::td_block_big_grid_style(),

                    array(
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Content length',
                            "value"      => "",
                            "class"      => "",
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Module MX5',
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                        ),
                        array(
                            "param_name"  => "mx5_tl",
                            "type"        => "textfield",
                            "value"       => '',
                            "heading"     => 'Title length',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-small",
                            "placeholder" => '25',
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Module MX11',
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                        ),
                        array(
                            "param_name"  => "mx11_tl",
                            "type"        => "textfield",
                            "value"       => '',
                            "heading"     => 'Title length',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-small",
                            "placeholder" => '25',
                        ),

                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Module MX6',
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                        ),
                        array(
                            "param_name"  => "mx6_tl",
                            "type"        => "textfield",
                            "value"       => '',
                            "heading"     => 'Title length',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-small",
                            "placeholder" => '25',
                        ),
                    ),

                    self::td_block_big_grid_params(),
                    td_config_helper::module_mx5_font(),
                    td_config_helper::module_mx11_font(),
                    td_config_helper::module_mx6_font(),
                    self::get_map_css_tab()
                )
            )
        );

        td_api_block::add('td_block_big_grid_4',
            array(
                'map_in_visual_composer' => true,
	            'map_in_td_composer' => true,
                "name" => 'Big Grid 4',
                "base" => 'td_block_big_grid_4',
                "class" => 'td_block_big_grid_4',
                "controls" => "full",
                "category" => 'Blocks',
                'tdc_category' => 'Big Grids',
                'icon' => 'icon-pagebuilder-td_block_big_grid_4',
                'file' => td_global::$get_template_directory . '/includes/shortcodes/td_block_big_grid_4.php',
                "params" => array_merge(
                    self::td_block_big_grid_style(),

                    array(
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Content length',
                            "value"      => "",
                            "class"      => "",
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Module MX5',
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                        ),
                        array(
                            "param_name"  => "mx5_tl",
                            "type"        => "textfield",
                            "value"       => '',
                            "heading"     => 'Title length',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-small",
                            "placeholder" => '25',
                        ),
                    ),

                    self::td_block_big_grid_params(),
                    td_config_helper::module_mx5_font(),
                    self::get_map_css_tab()
                )
            )
        );

        td_api_block::add('td_block_big_grid_5',
            array(
                'map_in_visual_composer' => true,
	            'map_in_td_composer' => true,
                "name" => 'Big Grid 5',
                "base" => 'td_block_big_grid_5',
                "class" => 'td_block_big_grid_5',
                "controls" => "full",
                "category" => 'Blocks',
                'tdc_category' => 'Big Grids',
                'icon' => 'icon-pagebuilder-td_block_big_grid_5',
                'file' => td_global::$get_template_directory . '/includes/shortcodes/td_block_big_grid_5.php',
                "params" => array_merge(
                    self::td_block_big_grid_style(),

                    array(
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Content length',
                            "value"      => "",
                            "class"      => "",
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Module MX12',
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                        ),
                        array(
                            "param_name"  => "mx12_tl",
                            "type"        => "textfield",
                            "value"       => '',
                            "heading"     => 'Title length',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-small",
                            "placeholder" => '25',
                        ),
                    ),

                    self::td_block_big_grid_params(),
                    td_config_helper::module_mx12_font(),
                    self::get_map_css_tab()
                )
            )
        );

        td_api_block::add('td_block_big_grid_6',
            array(
                'map_in_visual_composer' => true,
	            'map_in_td_composer' => true,
                "name" => 'Big Grid 6',
                "base" => 'td_block_big_grid_6',
                "class" => 'td_block_big_grid_6',
                "controls" => "full",
                "category" => 'Blocks',
                'tdc_category' => 'Big Grids',
                'icon' => 'icon-pagebuilder-td_block_big_grid_6',
                'file' => td_global::$get_template_directory . '/includes/shortcodes/td_block_big_grid_6.php',
                "params" => array_merge(
                    self::td_block_big_grid_style(),

                    array(
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Content length',
                            "value"      => "",
                            "class"      => "",
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Module MX5',
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                        ),
                        array(
                            "param_name"  => "mx5_tl",
                            "type"        => "textfield",
                            "value"       => '',
                            "heading"     => 'Title length',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-small",
                            "placeholder" => '25',
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Module MX13',
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                        ),
                        array(
                            "param_name"  => "mx13_tl",
                            "type"        => "textfield",
                            "value"       => '',
                            "heading"     => 'Title length',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-small",
                            "placeholder" => '25',
                        ),
                    ),

                    self::td_block_big_grid_params(),
                    td_config_helper::module_mx5_font(),
                    td_config_helper::module_mx13_font(),
                    self::get_map_css_tab()
                )
            )
        );

        td_api_block::add('td_block_big_grid_7',
            array(
                'map_in_visual_composer' => true,
	            'map_in_td_composer' => true,
                "name" => 'Big Grid 7',
                "base" => 'td_block_big_grid_7',
                "class" => 'td_block_big_grid_7',
                "controls" => "full",
                "category" => 'Blocks',
                'tdc_category' => 'Big Grids',
                'icon' => 'icon-pagebuilder-td_block_big_grid_7',
                'file' => td_global::$get_template_directory . '/includes/shortcodes/td_block_big_grid_7.php',
                "params" => array_merge(
                    self::td_block_big_grid_style(),

                    array(
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Content length',
                            "value"      => "",
                            "class"      => "",
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Module MX12',
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                        ),
                        array(
                            "param_name"  => "mx12_tl",
                            "type"        => "textfield",
                            "value"       => '',
                            "heading"     => 'Title length',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-small",
                            "placeholder" => '25',
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Module MX6',
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                        ),
                        array(
                            "param_name"  => "mx6_tl",
                            "type"        => "textfield",
                            "value"       => '',
                            "heading"     => 'Title length',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-small",
                            "placeholder" => '25',
                        ),
                    ),

                    self::td_block_big_grid_params(),
                    td_config_helper::module_mx12_font(),
                    td_config_helper::module_mx6_font(),
                    self::get_map_css_tab()
                )
            )
        );

        td_api_block::add('td_block_big_grid_8',
            array(
                'map_in_visual_composer' => true,
	            'map_in_td_composer' => true,
                "name" => 'Big Grid 8',
                "base" => 'td_block_big_grid_8',
                "class" => 'td_block_big_grid_8',
                "controls" => "full",
                "category" => 'Blocks',
                'tdc_category' => 'Big Grids',
                'icon' => 'icon-pagebuilder-td_block_big_grid_8',
                'file' => td_global::$get_template_directory . '/includes/shortcodes/td_block_big_grid_8.php',
                "params" => array_merge(
                    self::td_block_big_grid_style(),

                    array(
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Content length',
                            "value"      => "",
                            "class"      => "",
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Module MX14',
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                        ),
                        array(
                            "param_name"  => "mx14_tl",
                            "type"        => "textfield",
                            "value"       => '',
                            "heading"     => 'Title length',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-small",
                            "placeholder" => '25',
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Module MX12',
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                        ),
                        array(
                            "param_name"  => "mx12_tl",
                            "type"        => "textfield",
                            "value"       => '',
                            "heading"     => 'Title length',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-small",
                            "placeholder" => '25',
                        ),
                    ),

                    self::td_block_big_grid_params(),
                    td_config_helper::module_mx14_font(),
                    td_config_helper::module_mx12_font(),
                    self::get_map_css_tab()
                )
            )
        );

        td_api_block::add('td_block_big_grid_9',
            array(
                'map_in_visual_composer' => true,
	            'map_in_td_composer' => true,
                "name" => 'Big Grid 9',
                "base" => 'td_block_big_grid_9',
                "class" => 'td_block_big_grid_9',
                "controls" => "full",
                "category" => 'Blocks',
                'tdc_category' => 'Big Grids',
                'icon' => 'icon-pagebuilder-td_block_big_grid_9',
                'file' => td_global::$get_template_directory . '/includes/shortcodes/td_block_big_grid_9.php',
                "params" => array_merge(
                    self::td_block_big_grid_style(),

                    array(
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Content length',
                            "value"      => "",
                            "class"      => "",
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Module MX15',
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                        ),
                        array(
                            "param_name"  => "mx15_tl",
                            "type"        => "textfield",
                            "value"       => '',
                            "heading"     => 'Title length',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-small",
                            "placeholder" => '25',
                        ),
                    ),

                    self::td_block_big_grid_params(),
                    td_config_helper::module_mx15_font(),
                    self::get_map_css_tab()
                )
            )
        );

        td_api_block::add('td_block_big_grid_10',
            array(
                'map_in_visual_composer' => true,
	            'map_in_td_composer' => true,
                "name" => 'Big Grid 10',
                "base" => 'td_block_big_grid_10',
                "class" => 'td_block_big_grid_10',
                "controls" => "full",
                "category" => 'Blocks',
                'tdc_category' => 'Big Grids',
                'icon' => 'icon-pagebuilder-td_block_big_grid_10',
                'file' => td_global::$get_template_directory . '/includes/shortcodes/td_block_big_grid_10.php',
                "params" => array_merge(
                    self::td_block_big_grid_style(),

                    array(
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Content length',
                            "value"      => "",
                            "class"      => "",
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Module MX5',
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                        ),
                        array(
                            "param_name"  => "mx5_tl",
                            "type"        => "textfield",
                            "value"       => '',
                            "heading"     => 'Title length',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-small",
                            "placeholder" => '25',
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Module MX15',
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                        ),
                        array(
                            "param_name"  => "mx15_tl",
                            "type"        => "textfield",
                            "value"       => '',
                            "heading"     => 'Title length',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-small",
                            "placeholder" => '25',
                        ),
                    ),

                    self::td_block_big_grid_params(),
                    td_config_helper::module_mx5_font(),
                    td_config_helper::module_mx15_font(),
                    self::get_map_css_tab()
                )
            )
        );

        td_api_block::add('td_block_big_grid_11',
            array(
                'map_in_visual_composer' => true,
	            'map_in_td_composer' => true,
                "name" => 'Big Grid 11',
                "base" => 'td_block_big_grid_11',
                "class" => 'td_block_big_grid_11',
                "controls" => "full",
                "category" => 'Blocks',
                'tdc_category' => 'Big Grids',
                'icon' => 'icon-pagebuilder-td_block_big_grid_11',
                'file' => td_global::$get_template_directory . '/includes/shortcodes/td_block_big_grid_11.php',
                "params" => array_merge(
                    self::td_block_big_grid_style(),

                    array(
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Content length',
                            "value"      => "",
                            "class"      => "",
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Module MX15',
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                        ),
                        array(
                            "param_name"  => "mx15_tl",
                            "type"        => "textfield",
                            "value"       => '',
                            "heading"     => 'Title length',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-small",
                            "placeholder" => '25',
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Module MX11',
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                        ),
                        array(
                            "param_name"  => "mx11_tl",
                            "type"        => "textfield",
                            "value"       => '',
                            "heading"     => 'Title length',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-small",
                            "placeholder" => '25',
                        ),
                    ),

                    self::td_block_big_grid_params(),
                    td_config_helper::module_mx15_font(),
                    td_config_helper::module_mx11_font(),
                    self::get_map_css_tab()
                )
            )
        );

        td_api_block::add('td_block_big_grid_12',
            array(
                'map_in_visual_composer' => true,
	            'map_in_td_composer' => true,
                "name" => 'Big Grid 12',
                "base" => 'td_block_big_grid_12',
                "class" => 'td_block_big_grid_12',
                "controls" => "full",
                "category" => 'Blocks',
                'tdc_category' => 'Big Grids',
                'icon' => 'icon-pagebuilder-td_block_big_grid_12',
                'file' => td_global::$get_template_directory . '/includes/shortcodes/td_block_big_grid_12.php',
                'tdc_in_row' => true,
                "params" => array_merge(
                    self::td_block_big_grid_style(),

                    array(
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Content length',
                            "value"      => "",
                            "class"      => "",
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Module MX5',
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                        ),
                        array(
                            "param_name"  => "mx5_tl",
                            "type"        => "textfield",
                            "value"       => '',
                            "heading"     => 'Title length',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-small",
                            "placeholder" => '25',
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Module MX11',
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                        ),
                        array(
                            "param_name"  => "mx11_tl",
                            "type"        => "textfield",
                            "value"       => '',
                            "heading"     => 'Title length',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-small",
                            "placeholder" => '25',
                        ),
                    ),

                    self::td_block_big_grid_params(),
                    td_config_helper::module_mx5_font(),
                    td_config_helper::module_mx11_font(),
                    self::get_map_css_tab()
                )
            )
        );

        td_api_block::add('td_block_big_grid_fl_1',
            array(
                'map_in_visual_composer' => true,
	            'map_in_td_composer' => true,
                "name" => 'Big Grid Full 1',
                "base" => 'td_block_big_grid_fl_1',
                "class" => 'td_block_big_grid_fl_1',
                "controls" => "full",
                "category" => 'Blocks',
                'tdc_category' => 'Big Grids',
                'icon' => 'icon-pagebuilder-td_block_big_grid_fl_1',
                'file' => td_global::$get_template_directory . '/includes/shortcodes/td_block_big_grid_fl_1.php',
	            'tdc_in_row' => true,
	            'tdc_row_start_values' => base64_encode(
	                json_encode(
	                    array(
	                        'full_width'  => 'stretch_row_content td-stretch-content',
	                    )
	                )
	            ),
                "params" => array_merge(
                    self::td_block_big_grid_style(),

                    array(
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Content length',
                            "value"      => "",
                            "class"      => "",
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Module MX18',
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                        ),
                        array(
                            "param_name"  => "mx18_tl",
                            "type"        => "textfield",
                            "value"       => '',
                            "heading"     => 'Title length',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-small",
                            "placeholder" => '25',
                        ),
                    ),

                    self::td_block_big_grid_params(),
                    td_config_helper::module_mx18_font(),
                    self::get_map_css_tab()
                )
            )
        );

        td_api_block::add('td_block_big_grid_fl_2',
            array(
                'map_in_visual_composer' => true,
	            'map_in_td_composer' => true,
                "name" => 'Big Grid Full 2',
                "base" => 'td_block_big_grid_fl_2',
                "class" => 'td_block_big_grid_fl_2',
                "controls" => "full",
                "category" => 'Blocks',
                'tdc_category' => 'Big Grids',
                'icon' => 'icon-pagebuilder-td_block_big_grid_fl_2',
                'file' => td_global::$get_template_directory . '/includes/shortcodes/td_block_big_grid_fl_2.php',
	            'tdc_in_row' => true,
	            'tdc_row_start_values' => base64_encode(
	                json_encode(
	                    array(
	                        'full_width'  => 'stretch_row_content td-stretch-content',
	                    )
	                )
	            ),
                "params" => array_merge(
                    self::td_block_big_grid_style(),

                    array(
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Content length',
                            "value"      => "",
                            "class"      => "",
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Module MX19',
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                        ),
                        array(
                            "param_name"  => "mx19_tl",
                            "type"        => "textfield",
                            "value"       => '',
                            "heading"     => 'Title length',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-small",
                            "placeholder" => '25',
                        ),
                    ),

                    self::td_block_big_grid_params(),
                    td_config_helper::module_mx19_font(),
                    self::get_map_css_tab()
                )
            )
        );

        td_api_block::add('td_block_big_grid_fl_3',
            array(
                'map_in_visual_composer' => true,
	            'map_in_td_composer' => true,
                "name" => 'Big Grid Full 3',
                "base" => 'td_block_big_grid_fl_3',
                "class" => 'td_block_big_grid_fl_3',
                "controls" => "full",
                "category" => 'Blocks',
                'tdc_category' => 'Big Grids',
                'icon' => 'icon-pagebuilder-td_block_big_grid_fl_3',
                'file' => td_global::$get_template_directory . '/includes/shortcodes/td_block_big_grid_fl_3.php',
	            'tdc_in_row' => true,
	            'tdc_row_start_values' => base64_encode(
	                json_encode(
	                    array(
	                        'full_width'  => 'stretch_row_content td-stretch-content',
	                    )
	                )
	            ),
                "params" => array_merge(
                    self::td_block_big_grid_style(),

                    array(
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Content length',
                            "value"      => "",
                            "class"      => "",
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Module MX20',
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                        ),
                        array(
                            "param_name"  => "mx20_tl",
                            "type"        => "textfield",
                            "value"       => '',
                            "heading"     => 'Title length',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-small",
                            "placeholder" => '25',
                        ),
                    ),

                    self::td_block_big_grid_params(),
                    td_config_helper::module_mx20_font(),
                    self::get_map_css_tab()
                )
            )
        );

        td_api_block::add('td_block_big_grid_fl_4',
            array(
                'map_in_visual_composer' => true,
	            'map_in_td_composer' => true,
                "name" => 'Big Grid Full 4',
                "base" => 'td_block_big_grid_fl_4',
                "class" => 'td_block_big_grid_fl_4',
                "controls" => "full",
                "category" => 'Blocks',
                'tdc_category' => 'Big Grids',
                'icon' => 'icon-pagebuilder-td_block_big_grid_fl_4',
                'file' => td_global::$get_template_directory . '/includes/shortcodes/td_block_big_grid_fl_4.php',
	            'tdc_in_row' => true,
	            'tdc_row_start_values' => base64_encode(
	                json_encode(
	                    array(
	                        'full_width'  => 'stretch_row_content td-stretch-content',
	                    )
	                )
	            ),
                "params" => array_merge(
                    self::td_block_big_grid_style(),

                    array(
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Content length',
                            "value"      => "",
                            "class"      => "",
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Module MX21',
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                        ),
                        array(
                            "param_name"  => "mx21_tl",
                            "type"        => "textfield",
                            "value"       => '',
                            "heading"     => 'Title length',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-small",
                            "placeholder" => '25',
                        ),
                    ),

                    self::td_block_big_grid_params(),
                    td_config_helper::module_mx21_font(),
                    self::get_map_css_tab()
                )
            )
        );

        td_api_block::add('td_block_big_grid_fl_5',
            array(
                'map_in_visual_composer' => true,
	            'map_in_td_composer' => true,
                "name" => 'Big Grid Full 5',
                "base" => 'td_block_big_grid_fl_5',
                "class" => 'td_block_big_grid_fl_5',
                "controls" => "full",
                "category" => 'Blocks',
                'tdc_category' => 'Big Grids',
                'icon' => 'icon-pagebuilder-td_block_big_grid_fl_5',
                'file' => td_global::$get_template_directory . '/includes/shortcodes/td_block_big_grid_fl_5.php',
	            'tdc_in_row' => true,
	            'tdc_row_start_values' => base64_encode(
	                json_encode(
	                    array(
	                        'full_width'  => 'stretch_row_content td-stretch-content',
	                    )
	                )
	            ),
                "params" => array_merge(
                    self::td_block_big_grid_style(),

                    array(
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Content length',
                            "value"      => "",
                            "class"      => "",
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Module MX21',
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                        ),
                        array(
                            "param_name"  => "mx21_tl",
                            "type"        => "textfield",
                            "value"       => '',
                            "heading"     => 'Title length',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-small",
                            "placeholder" => '25',
                        ),
                    ),

                    self::td_block_big_grid_params(),
                    td_config_helper::module_mx21_font(),
                    self::get_map_css_tab()
                )
            )
        );

        td_api_block::add('td_block_big_grid_fl_6',
            array(
                'map_in_visual_composer' => true,
	            'map_in_td_composer' => true,
                "name" => 'Big Grid Full 6',
                "base" => 'td_block_big_grid_fl_6',
                "class" => 'td_block_big_grid_fl_6',
                "controls" => "full",
                "category" => 'Blocks',
                'tdc_category' => 'Big Grids',
                'icon' => 'icon-pagebuilder-td_block_big_grid_fl_6',
                'file' => td_global::$get_template_directory . '/includes/shortcodes/td_block_big_grid_fl_6.php',
	            'tdc_in_row' => true,
	            'tdc_row_start_values' => base64_encode(
	                json_encode(
	                    array(
	                        'full_width'  => 'stretch_row_content td-stretch-content',
	                    )
	                )
	            ),
                "params" => array_merge(
                    self::td_block_big_grid_style(),

                    array(
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Content length',
                            "value"      => "",
                            "class"      => "",
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Module MX18',
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                        ),
                        array(
                            "param_name"  => "mx18_tl",
                            "type"        => "textfield",
                            "value"       => '',
                            "heading"     => 'Title length',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-small",
                            "placeholder" => '25',
                        ),

                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Module MX22',
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                        ),
                        array(
                            "param_name"  => "mx22_tl",
                            "type"        => "textfield",
                            "value"       => '',
                            "heading"     => 'Title length',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-small",
                            "placeholder" => '25',
                        ),
                    ),

                    self::td_block_big_grid_params(),
                    td_config_helper::module_mx18_font(),
                    td_config_helper::module_mx22_font(),
                    self::get_map_css_tab()
                )
            )
        );

        td_api_block::add('td_block_big_grid_fl_7',
            array(
                'map_in_visual_composer' => true,
	            'map_in_td_composer' => true,
                "name" => 'Big Grid Full 7',
                "base" => 'td_block_big_grid_fl_7',
                "class" => 'td_block_big_grid_fl_7',
                "controls" => "full",
                "category" => 'Blocks',
                'tdc_category' => 'Big Grids',
                'icon' => 'icon-pagebuilder-td_block_big_grid_fl_7',
                'file' => td_global::$get_template_directory . '/includes/shortcodes/td_block_big_grid_fl_7.php',
	            'tdc_in_row' => true,
	            'tdc_row_start_values' => base64_encode(
	                json_encode(
	                    array(
	                        'full_width'  => 'stretch_row_content td-stretch-content',
	                    )
	                )
	            ),
                "params" => array_merge(
                    self::td_block_big_grid_style(),

                    array(
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Content length',
                            "value"      => "",
                            "class"      => "",
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Module MX23',
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                        ),
                        array(
                            "param_name"  => "mx23_tl",
                            "type"        => "textfield",
                            "value"       => '',
                            "heading"     => 'Title length',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-small",
                            "placeholder" => '25',
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Module MX24',
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                        ),
                        array(
                            "param_name"  => "mx24_tl",
                            "type"        => "textfield",
                            "value"       => '',
                            "heading"     => 'Title length',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-small",
                            "placeholder" => '25',
                        ),
                    ),

                    self::td_block_big_grid_params(),
                    td_config_helper::module_mx23_font(),
                    td_config_helper::module_mx24_font(),
                    self::get_map_css_tab()
                )
            )
        );

        td_api_block::add('td_block_big_grid_fl_8',
            array(
                'map_in_visual_composer' => true,
	            'map_in_td_composer' => true,
                "name" => 'Big Grid Full 8',
                "base" => 'td_block_big_grid_fl_8',
                "class" => 'td_block_big_grid_fl_8',
                "controls" => "full",
                "category" => 'Blocks',
                'tdc_category' => 'Big Grids',
                'icon' => 'icon-pagebuilder-td_block_big_grid_fl_8',
                'file' => td_global::$get_template_directory . '/includes/shortcodes/td_block_big_grid_fl_8.php',
	            'tdc_in_row' => true,
	            'tdc_row_start_values' => base64_encode(
	                json_encode(
	                    array(
	                        'full_width'  => 'stretch_row_content td-stretch-content',
	                    )
	                )
	            ),
                "params" => array_merge(
                    self::td_block_big_grid_style(),

                    array(
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Content length',
                            "value"      => "",
                            "class"      => "",
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Module MX19',
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                        ),
                        array(
                            "param_name"  => "mx19_tl",
                            "type"        => "textfield",
                            "value"       => '',
                            "heading"     => 'Title length',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-small",
                            "placeholder" => '25',
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Module MX25',
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                        ),
                        array(
                            "param_name"  => "mx25_tl",
                            "type"        => "textfield",
                            "value"       => '',
                            "heading"     => 'Title length',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-small",
                            "placeholder" => '25',
                        ),
                    ),

                    self::td_block_big_grid_params(),
                    td_config_helper::module_mx19_font(),
                    td_config_helper::module_mx25_font(),
                    self::get_map_css_tab()
                )
            )
        );

        td_api_block::add('td_block_big_grid_fl_9',
            array(
                'map_in_visual_composer' => true,
	            'map_in_td_composer' => true,
                "name" => 'Big Grid Full 9',
                "base" => 'td_block_big_grid_fl_9',
                "class" => 'td_block_big_grid_fl_9',
                "controls" => "full",
                "category" => 'Blocks',
                'tdc_category' => 'Big Grids',
                'icon' => 'icon-pagebuilder-td_block_big_grid_fl_9',
                'file' => td_global::$get_template_directory . '/includes/shortcodes/td_block_big_grid_fl_9.php',
	            'tdc_in_row' => true,
	            'tdc_row_start_values' => base64_encode(
	                json_encode(
	                    array(
	                        'full_width'  => 'stretch_row_content td-stretch-content',
	                    )
	                )
	            ),
                "params" => array_merge(
                    self::td_block_big_grid_style(),

                    array(
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Content length',
                            "value"      => "",
                            "class"      => "",
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Module MX19',
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                        ),
                        array(
                            "param_name"  => "mx19_tl",
                            "type"        => "textfield",
                            "value"       => '',
                            "heading"     => 'Title length',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-small",
                            "placeholder" => '25',
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Module MX26',
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                        ),
                        array(
                            "param_name"  => "mx26_tl",
                            "type"        => "textfield",
                            "value"       => '',
                            "heading"     => 'Title length',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-small",
                            "placeholder" => '25',
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Module MX25',
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                        ),
                        array(
                            "param_name"  => "mx25_tl",
                            "type"        => "textfield",
                            "value"       => '',
                            "heading"     => 'Title length',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-small",
                            "placeholder" => '25',
                        ),
                    ),

                    self::td_block_big_grid_params(),
                    td_config_helper::module_mx19_font(),
                    td_config_helper::module_mx26_font(),
                    td_config_helper::module_mx25_font(),
                    self::get_map_css_tab()
                )
            )
        );

        td_api_block::add('td_block_big_grid_fl_10',
            array(
                'map_in_visual_composer' => true,
	            'map_in_td_composer' => true,
                "name" => 'Big Grid Full 10',
                "base" => 'td_block_big_grid_fl_10',
                "class" => 'td_block_big_grid_fl_10',
                "controls" => "full",
                "category" => 'Blocks',
                'tdc_category' => 'Big Grids',
                'icon' => 'icon-pagebuilder-td_block_big_grid_fl_10',
                'file' => td_global::$get_template_directory . '/includes/shortcodes/td_block_big_grid_fl_10.php',
	            'tdc_in_row' => true,
	            'tdc_row_start_values' => base64_encode(
	                json_encode(
	                    array(
	                        'full_width'  => 'stretch_row_content td-stretch-content',
	                    )
	                )
	            ),
                "params" => array_merge(
                    self::td_block_big_grid_style(),

                    array(
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Content length',
                            "value"      => "",
                            "class"      => "",
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Module MX25',
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                        ),
                        array(
                            "param_name"  => "mx25_tl",
                            "type"        => "textfield",
                            "value"       => '',
                            "heading"     => 'Title length',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-small",
                            "placeholder" => '25',
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Module MX19',
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                        ),
                        array(
                            "param_name"  => "mx19_tl",
                            "type"        => "textfield",
                            "value"       => '',
                            "heading"     => 'Title length',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-small",
                            "placeholder" => '25',
                        ),
                    ),

                    self::td_block_big_grid_params(),
                    td_config_helper::module_mx25_font(),
                    td_config_helper::module_mx19_font(),
                    self::get_map_css_tab()
                )
            )
        );

        td_api_block::add('td_block_big_grid_flex_1',
            array(
                'map_in_visual_composer' => false,
                'map_in_td_composer' => true,
                "name" => 'Big Grid Flex 1',
                "base" => 'td_block_big_grid_flex_1',
                "class" => 'td_block_big_grid_flex_1',
                "controls" => "full",
                "category" => 'Blocks',
                'tdc_category' => 'Big Grids',
                'icon' => 'icon-pagebuilder-td_block_big_grid_flex_1',
                'file' => td_global::$get_template_directory . '/includes/shortcodes/td_block_big_grid_flex_1.php',
                'tdc_style_params' => array(
                    'custom_title',
                    'custom_url',
                    'post_ids',
                    'category_id',
                    'category_ids',
                    'tag_slug',
                    'autors_id',
                    'installed_post_types',
                    'sort',
                    'offset',
                    'grid_layout',
                    'image_height',
                    'el_class'
                ),
                'tdc_start_values' => base64_encode(
                    json_encode(
                        array(
                            array(
                                "grid_layout" => "2",
                                "image_height" => "eyJhbGwiOiI4NSIsInBob25lIjoiODAifQ==",
                                "image_zoom" => "yes",
                                "meta_info_vert" => "content-vert-bottom",
                                "modules_category" => "above",
                                "overlay_general" => "eyJ0eXBlIjoiZ3JhZGllbnQiLCJjb2xvcjEiOiJyZ2JhKDAsMCwwLDApIiwiY29sb3IyIjoicmdiYSgwLDAsMCwwLjcpIiwibWl4ZWRDb2xvcnMiOlt7ImNvbG9yIjoicmdiYSgwLDAsMCwwKSIsInBlcmNlbnRhZ2UiOjYwfV0sImNzcyI6ImJhY2tncm91bmQ6IC13ZWJraXQtbGluZWFyLWdyYWRpZW50KDBkZWcscmdiYSgwLDAsMCwwLjcpLHJnYmEoMCwwLDAsMCkgNjAlLHJnYmEoMCwwLDAsMCkpO2JhY2tncm91bmQ6IGxpbmVhci1ncmFkaWVudCgwZGVnLHJnYmEoMCwwLDAsMC43KSxyZ2JhKDAsMCwwLDApIDYwJSxyZ2JhKDAsMCwwLDApKTsiLCJjc3NQYXJhbXMiOiIwZGVnLHJnYmEoMCwwLDAsMC43KSxyZ2JhKDAsMCwwLDApIDYwJSxyZ2JhKDAsMCwwLDApIn0=",
                                "cat_bg_hover" => "#4db2ec",
                                "review_stars" => "#fff",
                                "f_title_font_size" => "eyJsYW5kc2NhcGUiOiIyMiIsInBvcnRyYWl0IjoiMTYiLCJwaG9uZSI6IjIyIn0=",
                                "f_title_font_line_height" => "eyJsYW5kc2NhcGUiOiIyOHB4IiwicG9ydHJhaXQiOiIyMHB4IiwicGhvbmUiOiIyOHB4In0=",
                            ),

                            array(
                                'tdc_preset_name' => 'Font family',
                                'tdc_preset_class' => 'tdcp_separator tdcp_separator_font',
                            ),
                            array(
                                'tdc_preset_name' => '', // Font - Montserrat
                                'tdc_preset_class' => 'tdcp_img tdcp_font tdcp_font1',
                                'tdc_preset_individual' => '1',
                                "f_title_font_family" =>        "394",
                            ),
                            array(
                                'tdc_preset_name' => '', // Font - Source Serif
                                'tdc_preset_class' => 'tdcp_img tdcp_font tdcp_font2',
                                'tdc_preset_individual' =>      '1',
                                "f_title_font_family" =>        "721",
                            ),
                            array(
                                'tdc_preset_name' => '', // Font - Raleway
                                'tdc_preset_class' => 'tdcp_img tdcp_font tdcp_font3',
                                'tdc_preset_individual' => '1',
                                "f_title_font_family" =>        "507",
                            ),
                            array(
                                'tdc_preset_name' => '', // Font - Work Sans
                                'tdc_preset_class' => 'tdcp_img tdcp_font tdcp_font4',
                                'tdc_preset_individual' => '1',
                                "f_title_font_family" =>        "653",
                            ),
                            array(
                                'tdc_preset_name' => '', // Font - Courgette
                                'tdc_preset_class' => 'tdcp_img tdcp_font tdcp_font5',
                                'tdc_preset_individual' => '1',
                                "f_title_font_family" =>        "147",
                            ),
                            array(
                                'tdc_preset_name' => '', // Font - Oswald
                                'tdc_preset_class' => 'tdcp_img tdcp_font tdcp_font7',
                                'tdc_preset_individual' => '1',
                                "f_title_font_family" =>        "445",
                            ),
                            array(
                                'tdc_preset_name' => '', // Font - Muli
                                'tdc_preset_class' => 'tdcp_img tdcp_font tdcp_font8',
                                'tdc_preset_individual' => '1',
                                "f_title_font_family" =>        "406",
                            ),
                            array(
                                'tdc_preset_name' => '', // Font - Wendy One
                                'tdc_preset_class' => 'tdcp_img tdcp_font tdcp_font9',
                                'tdc_preset_individual' => '1',
                                "f_title_font_family" =>        "646",
                            ),
                            array(
                                'tdc_preset_name' => '', // Font - Anton
                                'tdc_preset_class' => 'tdcp_img tdcp_font tdcp_font10',
                                'tdc_preset_individual' => '1',
                                "f_title_font_family" =>        "41",
                            ),
                            array(
                                'tdc_preset_name' => '', // Font - Quicksand
                                'tdc_preset_class' => 'tdcp_img tdcp_font tdcp_font11',
                                'tdc_preset_individual' => '1',
                                "f_title_font_family" =>        "502",
                            ),
                            array(
                                'tdc_preset_name' => '', // Font - Libre Baskerville
                                'tdc_preset_class' => 'tdcp_img tdcp_font tdcp_font12',
                                'tdc_preset_individual' => '1',
                                "f_title_font_family" =>        "331",
                            ),
                            array(
                                'tdc_preset_name' => '', // Font - Caveat
                                'tdc_preset_class' => 'tdcp_img tdcp_font tdcp_font13',
                                'tdc_preset_individual' => '1',
                                "f_title_font_family" =>        "663",
                            ),
                            array(
                                'tdc_preset_name' => '', // Font - Volkorn
                                'tdc_preset_class' => 'tdcp_img tdcp_font tdcp_font14',
                                'tdc_preset_individual' => '1',
                                "f_title_font_family" =>        "639",
                            ),
                            array(
                                'tdc_preset_name' => '', // Font - Default
                                'tdc_preset_class' => 'tdcp_img tdcp_font tdcp_font6',
                                'tdc_preset_individual' => '1',
                                "f_title_font_family" =>        "",
                            ),

                            array(
                                'tdc_preset_name' => 'Font size',
                                'tdc_preset_class' => 'tdcp_separator tdcp_separator_size',
                            ),
                            array(
                                'tdc_preset_name' => '', // Size - XS 13/13/12/14
                                'tdc_preset_class' => 'tdcp_img tdcp_size tdcp_size1',
                                'tdc_preset_individual' => '1',
                                "f_title_font_size" => "eyJhbGwiOiIxMyIsInBvcnRyYWl0IjoiMTIiLCJwaG9uZSI6IjE0In0=",
                                "f_title_font_line_height" => "1.3",
                            ),
                            array(
                                'tdc_preset_name' => '', // Size - S 14/13/12/14
                                'tdc_preset_class' => 'tdcp_img tdcp_size tdcp_size2',
                                'tdc_preset_individual' => '1',
                                "f_title_font_size" => "eyJhbGwiOiIxNCIsImxhbmRzY2FwZSI6IjEzIiwicG9ydHJhaXQiOiIxMiJ9",
                                "f_title_font_line_height" => "1.4",
                            ),
                            array(
                                'tdc_preset_name' => '', // Size - M 21/21/17/21
                                'tdc_preset_class' => 'tdcp_img tdcp_size tdcp_size3',
                                'tdc_preset_individual' => '1',
                                "f_title_font_size" => "eyJhbGwiOiIyMSIsImxhbmRzY2FwZSI6IjIwIiwicG9ydHJhaXQiOiIxNyJ9",
                                "f_title_font_line_height" => "1.2",
                            ),
                            array(
                                'tdc_preset_name' => '', // Size - L 26/25/21/21
                                'tdc_preset_class' => 'tdcp_img tdcp_size tdcp_size4',
                                'tdc_preset_individual' => '1',
                                "f_title_font_size" => "eyJhbGwiOiIyNiIsImxhbmRzY2FwZSI6IjI1IiwicG9ydHJhaXQiOiIyMSIsInBob25lIjoiMjEifQ==",
                                "f_title_font_line_height" => "1.2",

                            ),
                            array(
                                'tdc_preset_name' => '', // Size - XL 30/28/24/21
                                'tdc_preset_class' => 'tdcp_img tdcp_size tdcp_size5',
                                'tdc_preset_individual' => '1',
                                "f_title_font_size" => "eyJhbGwiOiIzMCIsImxhbmRzY2FwZSI6IjI4IiwicG9ydHJhaXQiOiIyNCIsInBob25lIjoiMjEifQ==",
                                "f_title_font_line_height" => "1.2",
                            ),
                            array(
                                'tdc_preset_name' => '', // Size - XXL 36/32/26/21
                                'tdc_preset_class' => 'tdcp_img tdcp_size tdcp_size6',
                                'tdc_preset_individual' => '1',
                                "f_title_font_size" => "eyJhbGwiOiIzNiIsImxhbmRzY2FwZSI6IjMyIiwicGhvbmUiOiIyMSIsInBvcnRyYWl0IjoiMjYifQ==",
                                "f_title_font_line_height" => "eyJhbGwiOiIxLjEiLCJwaG9uZSI6IjEuMiJ9",
                            ),

                            array(
                                'tdc_preset_name' => 'Text horizontal alignment',
                                'tdc_preset_class' => 'tdcp_separator tdcp_separator_align',
                            ),
                            array(
                                'tdc_preset_name' => '', // Text alignment - left
                                'tdc_preset_class' => 'tdcp_img tdcp_align tdcp_align1',
                                'tdc_preset_individual' => '1',
                                "meta_info_horiz" => "content-horiz-left",
                            ),
                            array(
                                'tdc_preset_name' => '', // Text alignment - center
                                'tdc_preset_class' => 'tdcp_img tdcp_align tdcp_align2',
                                'tdc_preset_individual' => '1',
                                "meta_info_horiz" => "content-horiz-center",
                            ),
                            array(
                                'tdc_preset_name' => '', // Text alignment - right
                                'tdc_preset_class' => 'tdcp_img tdcp_align tdcp_align3',
                                'tdc_preset_individual' => '1',
                                "meta_info_horiz" => "content-horiz-right",
                            ),

                            array(
                                'tdc_preset_name' => 'Text vertical alignment',
                                'tdc_preset_class' => 'tdcp_separator tdcp_separator_align_v',
                            ),
                            array(
                                'tdc_preset_name' => '', // Text vertical alignment - top
                                'tdc_preset_class' => 'tdcp_img tdcp_align tdcp_align_v1',
                                'tdc_preset_individual' => '1',
                                "meta_info_vert" => "content-vert-top",
                            ),
                            array(
                                'tdc_preset_name' => '', // Text vertical alignment - middle
                                'tdc_preset_class' => 'tdcp_img tdcp_align tdcp_align_v2',
                                'tdc_preset_individual' => '1',
                                "meta_info_vert" => "content-vert-center",
                            ),
                            array(
                                'tdc_preset_name' => '', // Text vertical alignment - bottom
                                'tdc_preset_class' => 'tdcp_img tdcp_align tdcp_align_v3',
                                'tdc_preset_individual' => '1',
                                "meta_info_vert" => "content-vert-bottom",
                            ),

                            array(
                                'tdc_preset_name' => 'Grid height',
                                'tdc_preset_class' => 'tdcp_separator tdcp_separator_grid_height',
                            ),
                            array(
                                'tdc_preset_name' => '', // Grid height - 2:3
                                'tdc_preset_class' => 'tdcp_img tdcp_grid_height tdcp_grid_height1',
                                'tdc_preset_individual' => '1',
                                "image_height" => "150",
                                "hide_image" => "",
                            ),
                            array(
                                'tdc_preset_name' => '', // Image format - 3:4
                                'tdc_preset_class' => 'tdcp_img tdcp_image tdcp_grid_height2',
                                'tdc_preset_individual' => '1',
                                "image_height" => "133",
                                "hide_image" => "",
                            ),
                            array(
                                'tdc_preset_name' => '', // Grid height - 7:8
                                'tdc_preset_class' => 'tdcp_img tdcp_image tdcp_grid_height3',
                                'tdc_preset_individual' => '1',
                                "image_height" => "114",
                                "hide_image" => "",
                            ),
                            array(
                                'tdc_preset_name' => '', // Grid height - 1:1
                                'tdc_preset_class' => 'tdcp_img tdcp_image tdcp_grid_height4',
                                'tdc_preset_individual' => '1',
                                "image_height" => "100",
                                "hide_image" => "",
                            ),
                            array(
                                'tdc_preset_name' => '', // Grid height - 4:3
                                'tdc_preset_class' => 'tdcp_img tdcp_image tdcp_grid_height5',
                                'tdc_preset_individual' => '1',
                                "image_height" => "75",
                                "hide_image" => "",
                            ),
                            array(
                                'tdc_preset_name' => '', // Grid height - 16:9
                                'tdc_preset_class' => 'tdcp_img tdcp_image tdcp_grid_height6',
                                'tdc_preset_individual' => '1',
                                "image_height" => "56",
                                "hide_image" => "",
                            ),

                            array(
                                'tdc_preset_name' => 'Columns',
                                'tdc_preset_class' => 'tdcp_separator tdcp_separator_col',
                            ),
                            array(
                                'tdc_preset_name' => '', // Columns - 1
                                'tdc_preset_class' => 'tdcp_img tdcp_col tdcp_col1',
                                'tdc_preset_individual' => '1',
                                "grid_layout" => "1",
                                "image_height" => "eyJhbGwiOiI1MCIsInBob25lIjoiNzAifQ==",
                            ),
                            array(
                                'tdc_preset_name' => '', // Columns - 2
                                'tdc_preset_class' => 'tdcp_img tdcp_col tdcp_col2',
                                'tdc_preset_individual' => '1',
                                "grid_layout" => "2",
                                "image_height" => "eyJhbGwiOiI4NSIsInBob25lIjoiODAifQ==",
                            ),
                            array(
                                'tdc_preset_name' => '', // Columns - 3
                                'tdc_preset_class' => 'tdcp_img tdcp_col tdcp_col3',
                                'tdc_preset_individual' => '1',
                                "grid_layout" => "3",
                                "image_height" => "eyJhbGwiOiI4NSIsInBob25lIjoiODAifQ==",
                            ),
                            array(
                                'tdc_preset_name' => '', // Columns - 4
                                'tdc_preset_class' => 'tdcp_img tdcp_col tdcp_col4',
                                'tdc_preset_individual' => '1',
                                "grid_layout" => "4",
                                "image_height" => "eyJhbGwiOiIxMjAiLCJwaG9uZSI6IjUwIn0=",
                            ),
                            array(
                                'tdc_preset_name' => '', // Columns - 5
                                'tdc_preset_class' => 'tdcp_img tdcp_col tdcp_col5',
                                'tdc_preset_individual' => '1',
                                "grid_layout" => "5",
                                "image_height" => "eyJhbGwiOiIxMjAiLCJwaG9uZSI6IjUwIn0=",
                            ),

                            array(
                                'tdc_preset_name' => 'Style',
                                'tdc_preset_class' => 'tdcp_separator tdcp_separator_style',
                            ),
                            array(
                                'tdc_preset_name' => '', // Style 1 - default
                                'tdc_preset_class' => 'tdcp_img tdcp_style tdcp_style1',
                                'tdc_preset_individual' => '1',
                                "overlay_general" => "eyJ0eXBlIjoiZ3JhZGllbnQiLCJjb2xvcjEiOiJyZ2JhKDAsMCwwLDApIiwiY29sb3IyIjoicmdiYSgwLDAsMCwwLjcpIiwibWl4ZWRDb2xvcnMiOlt7ImNvbG9yIjoicmdiYSgwLDAsMCwwKSIsInBlcmNlbnRhZ2UiOjYwfV0sImNzcyI6ImJhY2tncm91bmQ6IC13ZWJraXQtbGluZWFyLWdyYWRpZW50KDBkZWcscmdiYSgwLDAsMCwwLjcpLHJnYmEoMCwwLDAsMCkgNjAlLHJnYmEoMCwwLDAsMCkpO2JhY2tncm91bmQ6IGxpbmVhci1ncmFkaWVudCgwZGVnLHJnYmEoMCwwLDAsMC43KSxyZ2JhKDAsMCwwLDApIDYwJSxyZ2JhKDAsMCwwLDApKTsiLCJjc3NQYXJhbXMiOiIwZGVnLHJnYmEoMCwwLDAsMC43KSxyZ2JhKDAsMCwwLDApIDYwJSxyZ2JhKDAsMCwwLDApIn0=",
                                "overlay_h_general" => "",
                                "overlay_1" => "",
                                "overlay_2" => "",
                                "overlay_3" => "",
                                "overlay_4" => "",
                                "lightsky" => "",
                            ),
                            array(
                                'tdc_preset_name' => '', // Style 2 - colors
                                'tdc_preset_class' => 'tdcp_img tdcp_style tdcp_style2',
                                'tdc_preset_individual' => '1',
                                "overlay_h_general" => "",
                                "overlay_1" => "eyJ0eXBlIjoiZ3JhZGllbnQiLCJjb2xvcjEiOiJyZ2JhKDc0LDE0Myw5NCwwLjYpIiwiY29sb3IyIjoicmdiYSg3NywxNzgsMjM2LDAuNikiLCJtaXhlZENvbG9ycyI6W10sImRlZ3JlZSI6IjQ1IiwiY3NzIjoiYmFja2dyb3VuZDogLXdlYmtpdC1saW5lYXItZ3JhZGllbnQoNDVkZWcscmdiYSg3NywxNzgsMjM2LDAuNikscmdiYSg3NCwxNDMsOTQsMC42KSk7YmFja2dyb3VuZDogbGluZWFyLWdyYWRpZW50KDQ1ZGVnLHJnYmEoNzcsMTc4LDIzNiwwLjYpLHJnYmEoNzQsMTQzLDk0LDAuNikpOyIsImNzc1BhcmFtcyI6IjQ1ZGVnLHJnYmEoNzcsMTc4LDIzNiwwLjYpLHJnYmEoNzQsMTQzLDk0LDAuNikifQ==",
                                "overlay_2" => "eyJ0eXBlIjoiZ3JhZGllbnQiLCJjb2xvcjEiOiJyZ2JhKDE5OCw1Nyw1NywwLjYpIiwiY29sb3IyIjoicmdiYSgyMDksMTE4LDcwLDAuNikiLCJtaXhlZENvbG9ycyI6W10sImRlZ3JlZSI6IjQ1IiwiY3NzIjoiYmFja2dyb3VuZDogLXdlYmtpdC1saW5lYXItZ3JhZGllbnQoNDVkZWcscmdiYSgyMDksMTE4LDcwLDAuNikscmdiYSgxOTgsNTcsNTcsMC42KSk7YmFja2dyb3VuZDogbGluZWFyLWdyYWRpZW50KDQ1ZGVnLHJnYmEoMjA5LDExOCw3MCwwLjYpLHJnYmEoMTk4LDU3LDU3LDAuNikpOyIsImNzc1BhcmFtcyI6IjQ1ZGVnLHJnYmEoMjA5LDExOCw3MCwwLjYpLHJnYmEoMTk4LDU3LDU3LDAuNikifQ==",
                                "overlay_3" => "eyJ0eXBlIjoiZ3JhZGllbnQiLCJjb2xvcjEiOiJyZ2JhKDU5LDEyMCwxODAsMC41OSkiLCJjb2xvcjIiOiJyZ2JhKDIxNSw5NiwxODMsMC42KSIsIm1peGVkQ29sb3JzIjpbXSwiZGVncmVlIjoiLTQ1IiwiY3NzIjoiYmFja2dyb3VuZDogLXdlYmtpdC1saW5lYXItZ3JhZGllbnQoLTQ1ZGVnLHJnYmEoMjE1LDk2LDE4MywwLjYpLHJnYmEoNTksMTIwLDE4MCwwLjU5KSk7YmFja2dyb3VuZDogbGluZWFyLWdyYWRpZW50KC00NWRlZyxyZ2JhKDIxNSw5NiwxODMsMC42KSxyZ2JhKDU5LDEyMCwxODAsMC41OSkpOyIsImNzc1BhcmFtcyI6Ii00NWRlZyxyZ2JhKDIxNSw5NiwxODMsMC42KSxyZ2JhKDU5LDEyMCwxODAsMC41OSkifQ==",
                                "overlay_4" => "eyJ0eXBlIjoiZ3JhZGllbnQiLCJjb2xvcjEiOiJyZ2JhKDI0MiwxMjIsNTMsMC42KSIsImNvbG9yMiI6InJnYmEoMjQ0LDIwOCw2MywwLjYpIiwibWl4ZWRDb2xvcnMiOltdLCJkZWdyZWUiOiItNDUiLCJjc3MiOiJiYWNrZ3JvdW5kOiAtd2Via2l0LWxpbmVhci1ncmFkaWVudCgtNDVkZWcscmdiYSgyNDQsMjA4LDYzLDAuNikscmdiYSgyNDIsMTIyLDUzLDAuNikpO2JhY2tncm91bmQ6IGxpbmVhci1ncmFkaWVudCgtNDVkZWcscmdiYSgyNDQsMjA4LDYzLDAuNikscmdiYSgyNDIsMTIyLDUzLDAuNikpOyIsImNzc1BhcmFtcyI6Ii00NWRlZyxyZ2JhKDI0NCwyMDgsNjMsMC42KSxyZ2JhKDI0MiwxMjIsNTMsMC42KSJ9",
                                "lightsky" => "",
                            ),
                            array(
                                'tdc_preset_name' => '', // Style 3 - flat colors
                                'tdc_preset_class' => 'tdcp_img tdcp_style tdcp_style3',
                                'tdc_preset_individual' => '1',
                                "overlay_h_general" => "",
                                "overlay_1" => "eyJ0eXBlIjoiZ3JhZGllbnQiLCJjb2xvcjEiOiJyZ2JhKDc0LDE0Myw5NCwwLjgpIiwiY29sb3IyIjoicmdiYSg3NywxNzgsMjM2LDAuOCkiLCJtaXhlZENvbG9ycyI6W10sImRlZ3JlZSI6IjQ1IiwiY3NzIjoiYmFja2dyb3VuZDogLXdlYmtpdC1saW5lYXItZ3JhZGllbnQoNDVkZWcscmdiYSg3NywxNzgsMjM2LDAuOCkscmdiYSg3NCwxNDMsOTQsMC44KSk7YmFja2dyb3VuZDogbGluZWFyLWdyYWRpZW50KDQ1ZGVnLHJnYmEoNzcsMTc4LDIzNiwwLjgpLHJnYmEoNzQsMTQzLDk0LDAuOCkpOyIsImNzc1BhcmFtcyI6IjQ1ZGVnLHJnYmEoNzcsMTc4LDIzNiwwLjgpLHJnYmEoNzQsMTQzLDk0LDAuOCkifQ==",
                                "overlay_2" => "eyJ0eXBlIjoiZ3JhZGllbnQiLCJjb2xvcjEiOiJyZ2JhKDE5OCw1Nyw1NywwLjgpIiwiY29sb3IyIjoicmdiYSgyMDksMTE4LDcwLDAuOCkiLCJtaXhlZENvbG9ycyI6W10sImRlZ3JlZSI6IjQ1IiwiY3NzIjoiYmFja2dyb3VuZDogLXdlYmtpdC1saW5lYXItZ3JhZGllbnQoNDVkZWcscmdiYSgyMDksMTE4LDcwLDAuOCkscmdiYSgxOTgsNTcsNTcsMC44KSk7YmFja2dyb3VuZDogbGluZWFyLWdyYWRpZW50KDQ1ZGVnLHJnYmEoMjA5LDExOCw3MCwwLjgpLHJnYmEoMTk4LDU3LDU3LDAuOCkpOyIsImNzc1BhcmFtcyI6IjQ1ZGVnLHJnYmEoMjA5LDExOCw3MCwwLjgpLHJnYmEoMTk4LDU3LDU3LDAuOCkifQ==",
                                "overlay_3" => "eyJ0eXBlIjoiZ3JhZGllbnQiLCJjb2xvcjEiOiJyZ2JhKDU5LDEyMCwxODAsMC44KSIsImNvbG9yMiI6InJnYmEoMjE1LDk2LDE4MywwLjgpIiwibWl4ZWRDb2xvcnMiOltdLCJkZWdyZWUiOiItNDUiLCJjc3MiOiJiYWNrZ3JvdW5kOiAtd2Via2l0LWxpbmVhci1ncmFkaWVudCgtNDVkZWcscmdiYSgyMTUsOTYsMTgzLDAuOCkscmdiYSg1OSwxMjAsMTgwLDAuOCkpO2JhY2tncm91bmQ6IGxpbmVhci1ncmFkaWVudCgtNDVkZWcscmdiYSgyMTUsOTYsMTgzLDAuOCkscmdiYSg1OSwxMjAsMTgwLDAuOCkpOyIsImNzc1BhcmFtcyI6Ii00NWRlZyxyZ2JhKDIxNSw5NiwxODMsMC44KSxyZ2JhKDU5LDEyMCwxODAsMC44KSJ9",
                                "overlay_4" => "eyJ0eXBlIjoiZ3JhZGllbnQiLCJjb2xvcjEiOiJyZ2JhKDI0MiwxMjIsNTMsMC44KSIsImNvbG9yMiI6InJnYmEoMjQ0LDIwOCw2MywwLjgpIiwibWl4ZWRDb2xvcnMiOltdLCJkZWdyZWUiOiItNDUiLCJjc3MiOiJiYWNrZ3JvdW5kOiAtd2Via2l0LWxpbmVhci1ncmFkaWVudCgtNDVkZWcscmdiYSgyNDQsMjA4LDYzLDAuOCkscmdiYSgyNDIsMTIyLDUzLDAuOCkpO2JhY2tncm91bmQ6IGxpbmVhci1ncmFkaWVudCgtNDVkZWcscmdiYSgyNDQsMjA4LDYzLDAuOCkscmdiYSgyNDIsMTIyLDUzLDAuOCkpOyIsImNzc1BhcmFtcyI6Ii00NWRlZyxyZ2JhKDI0NCwyMDgsNjMsMC44KSxyZ2JhKDI0MiwxMjIsNTMsMC44KSJ9",
                                "lightsky" => "",
                            ),
                            array(
                                'tdc_preset_name' => '', // Style 4 - light sky
                                'tdc_preset_class' => 'tdcp_img tdcp_style tdcp_style4',
                                'tdc_preset_individual' => '1',
                                "overlay_general" => "rgba(0,0,0,0.7)",
                                "overlay_h_general" => "rgba(77,178,236,0.3)",
                                "overlay_1" => "",
                                "overlay_2" => "",
                                "overlay_3" => "",
                                "overlay_4" => "",
                                "lightsky" => "yes",
                            ),
                            array(
                                'tdc_preset_name' => '', // Style 5 - rainbow
                                'tdc_preset_class' => 'tdcp_img tdcp_style tdcp_style5',
                                'tdc_preset_individual' => '1',
                                "overlay_h_general" => "",
                                "overlay_1" => "eyJ0eXBlIjoiZ3JhZGllbnQiLCJjb2xvcjEiOiJyZ2JhKDI1NSwxMTEsNDksMC42KSIsImNvbG9yMiI6InJnYmEoNjUsMTIsMTg4LDAuNikiLCJtaXhlZENvbG9ycyI6W10sImRlZ3JlZSI6IjIwIiwiY3NzIjoiYmFja2dyb3VuZDogLXdlYmtpdC1saW5lYXItZ3JhZGllbnQoMjBkZWcscmdiYSg2NSwxMiwxODgsMC42KSxyZ2JhKDI1NSwxMTEsNDksMC42KSk7YmFja2dyb3VuZDogbGluZWFyLWdyYWRpZW50KDIwZGVnLHJnYmEoNjUsMTIsMTg4LDAuNikscmdiYSgyNTUsMTExLDQ5LDAuNikpOyIsImNzc1BhcmFtcyI6IjIwZGVnLHJnYmEoNjUsMTIsMTg4LDAuNikscmdiYSgyNTUsMTExLDQ5LDAuNikifQ==",
                                "overlay_2" => "eyJ0eXBlIjoiZ3JhZGllbnQiLCJjb2xvcjEiOiJyZ2JhKDExMiwyNTUsMTUzLDAuNikiLCJjb2xvcjIiOiJyZ2JhKDI0NCwxMzYsMTMsMC42KSIsIm1peGVkQ29sb3JzIjpbXSwiZGVncmVlIjoiMjAiLCJjc3MiOiJiYWNrZ3JvdW5kOiAtd2Via2l0LWxpbmVhci1ncmFkaWVudCgyMGRlZyxyZ2JhKDI0NCwxMzYsMTMsMC42KSxyZ2JhKDExMiwyNTUsMTUzLDAuNikpO2JhY2tncm91bmQ6IGxpbmVhci1ncmFkaWVudCgyMGRlZyxyZ2JhKDI0NCwxMzYsMTMsMC42KSxyZ2JhKDExMiwyNTUsMTUzLDAuNikpOyIsImNzc1BhcmFtcyI6IjIwZGVnLHJnYmEoMjQ0LDEzNiwxMywwLjYpLHJnYmEoMTEyLDI1NSwxNTMsMC42KSJ9",
                                "overlay_3" => "eyJ0eXBlIjoiZ3JhZGllbnQiLCJjb2xvcjEiOiJyZ2JhKDEyNiwxOTEsMjU1LDAuNikiLCJjb2xvcjIiOiJyZ2JhKDE5NiwxNSwxMjEsMC42KSIsIm1peGVkQ29sb3JzIjpbXSwiZGVncmVlIjoiMjAiLCJjc3MiOiJiYWNrZ3JvdW5kOiAtd2Via2l0LWxpbmVhci1ncmFkaWVudCgyMGRlZyxyZ2JhKDE5NiwxNSwxMjEsMC42KSxyZ2JhKDEyNiwxOTEsMjU1LDAuNikpO2JhY2tncm91bmQ6IGxpbmVhci1ncmFkaWVudCgyMGRlZyxyZ2JhKDE5NiwxNSwxMjEsMC42KSxyZ2JhKDEyNiwxOTEsMjU1LDAuNikpOyIsImNzc1BhcmFtcyI6IjIwZGVnLHJnYmEoMTk2LDE1LDEyMSwwLjYpLHJnYmEoMTI2LDE5MSwyNTUsMC42KSJ9",
                                "overlay_4" => "eyJ0eXBlIjoiZ3JhZGllbnQiLCJjb2xvcjEiOiJyZ2JhKDQyLDIzNiwxMTYsMC42KSIsImNvbG9yMiI6InJnYmEoMCwyMiwxOTAsMC42KSIsIm1peGVkQ29sb3JzIjpbXSwiZGVncmVlIjoiMjAiLCJjc3MiOiJiYWNrZ3JvdW5kOiAtd2Via2l0LWxpbmVhci1ncmFkaWVudCgyMGRlZyxyZ2JhKDAsMjIsMTkwLDAuNikscmdiYSg0MiwyMzYsMTE2LDAuNikpO2JhY2tncm91bmQ6IGxpbmVhci1ncmFkaWVudCgyMGRlZyxyZ2JhKDAsMjIsMTkwLDAuNikscmdiYSg0MiwyMzYsMTE2LDAuNikpOyIsImNzc1BhcmFtcyI6IjIwZGVnLHJnYmEoMCwyMiwxOTAsMC42KSxyZ2JhKDQyLDIzNiwxMTYsMC42KSJ9",
                                "lightsky" => "",
                            ),
                        )
                    )
                ),
                "params" => array_merge(
                    array(
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Content length',
                            "value"      => "",
                            "class"      => "",
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Module Flex 6',
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                        ),
                        array(
                            "param_name"  => "mf6_tl",
                            "type"        => "textfield",
                            "value"       => '',
                            "heading"     => 'Title length',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-small",
                            "placeholder" => '25',
                        ),
                    ),
                    self::td_block_big_grid_params(),
                    array(
                        array(
                            "param_name" => "grid_layout",
                            "type" => "dropdown",
                            "value" => array(
                                '1 column'  => '1',
                                '2 columns' => '2',
                                '3 columns' => '3',
                                '4 columns' => '4',
                                '5 columns' => '5',
                            ),
                            "heading" => 'Grid layout',
                            "description" => "",
                            "holder" => "div",
                            'tdc_dropdown_images' => true,
                            "class" => "tdc-visual-selector tdc-cat-grid-layout tdc-add-class",
                            "group"       => "Layout",
                        ),
                        array(
                            "param_name"  => "container_width",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Container width (0-100 percent)',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-small",
                            "placeholder" => "100",
                            "group"       => "Layout",
                        ),
                        array(
                            "param_name"  => "modules_gap",
                            "type"        => "textfield-responsive",
                            "value"       => '4',
                            "heading"     => 'Modules gap',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-small",
                            "placeholder" => "20",
                            "group"       => "Layout",
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Article image',
                            "value"      => "",
                            "class"      => "",
                            "group"      => "Layout",
                        ),
                        array(
                            "param_name"  => "image_size",
                            "type"        => "dropdown",
                            "value"       => array(
                                'Small - 696px'  => '',
                                'Large - 1068px' => 'td_1068x0',
                                'Full - 1920px'  => 'td_1920x0'
                            ),
                            "heading"     => 'Image size',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-dropdown-big",
                            "group"       => "Layout",
                        ),
                        array(
                            'param_name'  => 'image_alignment',
                            'type'        => 'range-responsive',
                            'value'       => '50',
                            'heading'     => 'Image V alignment',
                            'description' => '0 - Top / 50 - Center / 100 - Bottom',
                            'class'       => 'tdc-textfield-small',
                            'range_min'   => '0',
                            'range_max'   => '100',
                            'range_step'  => '1',
                            "group"       => "Layout",
                        ),
                        array(
                            "param_name"  => "image_height",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Image height (percent)',
                            "description" => "Default value in percent",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-small",
                            "placeholder" => "50",
                            "group"       => "Layout",
                        ),
                        array(
                            "param_name"  => "image_zoom",
                            "type"        => "checkbox",
                            "value"       => '',
                            "heading"     => "Zoom effect on hover",
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "",
                            "group"       => 'Layout'
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Article meta info',
                            "value"      => "",
                            "class"      => "",
                            "group"      => "Layout",
                        ),
                        array(
                            "param_name" => "meta_info_horiz",
                            "type" => "dropdown",
                            "value" => array(
                                'Left' => 'content-horiz-left',
                                'Center' => 'content-horiz-center',
                                'Right' => 'content-horiz-right'
                            ),
                            "heading" => 'Meta info horiz align',
                            "description" => "",
                            "holder" => "div",
                            'tdc_dropdown_images' => true,
                            "class" => "tdc-visual-selector tdc-add-class",
                            "group"       => "Layout",
                        ),
                        array(
                            "param_name" => "meta_info_vert",
                            "type" => "dropdown",
                            "value" => array(
                                'Left' => 'content-vert-top',
                                'Center' => 'content-vert-center',
                                'Right' => 'content-vert-bottom'
                            ),
                            "heading" => 'Meta info vert align',
                            "description" => "",
                            "holder" => "div",
                            'tdc_dropdown_images' => true,
                            "class" => "tdc-visual-selector tdc-add-class",
                            "group"       => "Layout",
                        ),
                        array(
                            "param_name"  => "meta_width",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Meta info width',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-small",
                            "placeholder" => "100%",
                            "group"       => "Layout",
                        ),
                        array(
                            "param_name"  => "meta_margin",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Meta info margin',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-big",
                            "placeholder" => "0px 0px 0px 0px",
                            "group"       => "Layout",
                        ),
                        array(
                            "param_name"  => "meta_padding",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Meta info padding',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-big",
                            "placeholder" => "22px 20px",
                            "group"       => "Layout",
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "horizontal_separator",
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                            "group"      => "Layout",
                        ),
                        array(
                            "param_name"  => "art_title",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Article title space',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-big",
                            "placeholder" => "0px 0px 9px 0px",
                            "group"       => "Layout",
                        ),
                        array(
                            "param_name"  => "art_title_padd",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Article title padding',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-big",
                            "placeholder" => "0px 0px 0px 0px",
                            "group"       => "Layout",
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "horizontal_separator",
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                            "group"      => "Layout",
                        ),
                        array(
                            "param_name"  => "modules_category",
                            "type"        => "dropdown",
                            "value"       => array(
                                'Inline'      => '',
                                'Above title' => 'above',
                            ),
                            "heading"     => 'Category tag position',
                            "description" => "Float image",
                            "holder"      => "div",
                            "class"       => "tdc-dropdown-big",
                            "group"       => "Layout",
                        ),
                        array(
                            "param_name"  => "modules_category_margin",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Category tag spacing',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-big",
                            "placeholder" => "0px 0px 5px 0px",
                            "group"       => "Layout",
                        ),
                        array(
                            "param_name"  => "modules_category_padding",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Category tag padding',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-big",
                            "placeholder" => "3px 6px 3px 6px",
                            "group"       => "Layout",
                        ),
                        array(
                            "param_name"  => "show_cat",
                            "type"        => "dropdown-responsive",
                            "value"       => array(
                                'Show' => 'inline-block',
                                'Hide' => 'none',
                            ),
                            "heading"     => 'Show category',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-dropdown-big",
                            "group"       => "Layout",
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "horizontal_separator",
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                            "group"      => "Layout",
                        ),
                        array(
                            "param_name"  => "show_author",
                            "type"        => "dropdown-responsive",
                            "value"       => array(
                                'Show' => 'inline-block',
                                'Hide' => 'none',
                            ),
                            "heading"     => 'Show author',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-dropdown-big",
                            "group"       => "Layout",
                        ),
                        array(
                            "param_name"  => "show_date",
                            "type"        => "dropdown-responsive",
                            "value"       => array(
                                'Show' => 'inline-block',
                                'Hide' => 'none',
                            ),
                            "heading"     => 'Show date',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-dropdown-big",
                            "group"       => "Layout",
                        ),
                        array(
                            "param_name"  => "auth_date_padding",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Author & date padding',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-big",
                            "placeholder" => "0px 0px 0px 0px",
                            "group"       => "Layout",
                        ),
                        array(
                            "param_name" => "separator",
                            "type" => "text_separator",
                            'heading' => 'Module fonts',
                            "value" => "",
                            "class" => "",
                            "group" => 'Style',
                        ),
                    ),
                    td_config_helper::get_map_block_font_array( 'f_title', true, 'Article title', 'Style' ),
                    td_config_helper::get_map_block_font_array( 'f_cat', false, 'Article category tag', 'Style' ),
                    td_config_helper::get_map_block_font_array( 'f_meta', false, 'Article meta info', 'Style' ),
                    array(
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Colors',
                            "value"      => "",
                            "class"      => "",
                            "group"      => "Style",
                        ),
                        array(
                            "param_name" => "overlay_general",
                            "holder" => "div",
                            "type" => "gradient",
                            'heading' => "General module overlay color",
                            "value" => "",
                            "class" => "",
                            "group"      => "Style",
                        ),
                        array(
                            "param_name" => "overlay_h_general",
                            "holder" => "div",
                            "type" => "gradient",
                            'heading' => "General module overlay hover color",
                            "value" => "",
                            "class" => "",
                            "group"      => "Style",
                        ),
                        array(
                            "param_name" => "overlay_1",
                            "holder" => "div",
                            "type" => "gradient",
                            'heading' => "Module overlay color 1",
                            "value" => "",
                            "class" => "",
                            "group"      => "Style",
                        ),
                        array(
                            "param_name" => "overlay_2",
                            "holder" => "div",
                            "type" => "gradient",
                            'heading' => "Module overlay color 2",
                            "value" => "",
                            "class" => "",
                            "group"      => "Style",
                        ),
                        array(
                            "param_name" => "overlay_3",
                            "holder" => "div",
                            "type" => "gradient",
                            'heading' => "Module overlay color 3",
                            "value" => "",
                            "class" => "",
                            "group"      => "Style",
                        ),
                        array(
                            "param_name" => "overlay_4",
                            "holder" => "div",
                            "type" => "gradient",
                            'heading' => "Module overlay color 4",
                            "value" => "",
                            "class" => "",
                            "group"      => "Style",
                        ),
                        array(
                            "param_name"  => "lightsky",
                            "type"        => "checkbox",
                            "value"       => '',
                            "heading"     => "Lightsky",
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "",
                            "group"       => 'Style'
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "",
                            "heading"     => 'Meta info background',
                            "param_name"  => "meta_bg",
                            "value"       => '',
                            "description" => '',
                            "group"       => 'Style',
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "horizontal_separator",
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                            "group"      => "Style",
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "",
                            "heading"     => 'Article title text color',
                            "param_name"  => "title_txt",
                            "value"       => '',
                            "description" => '',
                            "group"       => 'Style',
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "",
                            "heading"     => 'Article title text hover',
                            "param_name"  => "title_txt_hover",
                            "value"       => '',
                            "description" => '',
                            "group"       => 'Style',
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "",
                            "heading"     => 'Article title background color',
                            "param_name"  => "title_bg",
                            "value"       => '',
                            "description" => '',
                            "group"       => 'Style',
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "horizontal_separator",
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                            "group"      => "Style",
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "",
                            "heading"     => 'Category background',
                            "param_name"  => "cat_bg",
                            "value"       => '',
                            "description" => '',
                            "group"       => 'Style',
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "",
                            "heading"     => 'Category text color',
                            "param_name"  => "cat_txt",
                            "value"       => '',
                            "description" => '',
                            "group"       => 'Style',
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "",
                            "heading"     => 'Category background hover',
                            "param_name"  => "cat_bg_hover",
                            "value"       => '',
                            "description" => '',
                            "group"       => 'Style',
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "",
                            "heading"     => 'Category text hover',
                            "param_name"  => "cat_txt_hover",
                            "value"       => '',
                            "description" => '',
                            "group"       => 'Style',
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "horizontal_separator",
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                            "group"      => "Style",
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "",
                            "heading"     => 'Author text color',
                            "param_name"  => "author_txt",
                            "value"       => '',
                            "description" => '',
                            "group"       => 'Style',
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "",
                            "heading"     => 'Author text hover',
                            "param_name"  => "author_txt_hover",
                            "value"       => '',
                            "description" => '',
                            "group"       => 'Style',
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "",
                            "heading"     => 'Date text color',
                            "param_name"  => "date_txt",
                            "value"       => '',
                            "description" => '',
                            "group"       => 'Style',
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "",
                            "heading"     => 'Author & date background color',
                            "param_name"  => "auth_date_bg",
                            "value"       => '',
                            "description" => '',
                            "group"       => 'Style',
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "",
                            "heading"     => 'Review stars color',
                            "param_name"  => "review_stars",
                            "value"       => '',
                            "description" => '',
                            "group"       => 'Style',
                        ),
                    ),
                    self::get_map_css_tab()
                )
            )
        );

        td_api_block::add('td_block_big_grid_flex_2',
            array(
                'map_in_visual_composer' => false,
                'map_in_td_composer' => true,
                "name" => 'Big Grid Flex 2',
                "base" => 'td_block_big_grid_flex_2',
                "class" => 'td_block_big_grid_flex_2',
                "controls" => "full",
                "category" => 'Blocks',
                'tdc_category' => 'Big Grids',
                'icon' => 'icon-pagebuilder-td_block_big_grid_flex_2',
                'file' => td_global::$get_template_directory . '/includes/shortcodes/td_block_big_grid_flex_2.php',
                'tdc_style_params' => array(
                    'custom_title',
                    'custom_url',
                    'post_ids',
                    'category_id',
                    'category_ids',
                    'tag_slug',
                    'autors_id',
                    'installed_post_types',
                    'sort',
                    'offset',
                    'el_class'
                ),
                'tdc_start_values' => base64_encode(
                    json_encode(
                        array(
                            array(
                                "meta_info_vert" => "content-vert-bottom",
                                "image_zoom" => "yes",
                                "show_author2" => "none",
                                "show_date2" => "none",
                                "modules_category" => "above",
                                "overlay_general" => "eyJ0eXBlIjoiZ3JhZGllbnQiLCJjb2xvcjEiOiJyZ2JhKDAsMCwwLDApIiwiY29sb3IyIjoicmdiYSgwLDAsMCwwLjcpIiwibWl4ZWRDb2xvcnMiOlt7ImNvbG9yIjoicmdiYSgwLDAsMCwwKSIsInBlcmNlbnRhZ2UiOjYwfV0sImNzcyI6ImJhY2tncm91bmQ6IC13ZWJraXQtbGluZWFyLWdyYWRpZW50KDBkZWcscmdiYSgwLDAsMCwwLjcpLHJnYmEoMCwwLDAsMCkgNjAlLHJnYmEoMCwwLDAsMCkpO2JhY2tncm91bmQ6IGxpbmVhci1ncmFkaWVudCgwZGVnLHJnYmEoMCwwLDAsMC43KSxyZ2JhKDAsMCwwLDApIDYwJSxyZ2JhKDAsMCwwLDApKTsiLCJjc3NQYXJhbXMiOiIwZGVnLHJnYmEoMCwwLDAsMC43KSxyZ2JhKDAsMCwwLDApIDYwJSxyZ2JhKDAsMCwwLDApIn0=",
                                "image_height2" => "eyJsYW5kc2NhcGUiOiIxNzNweCIsInBob25lIjoiMTY1cHgiLCJwb3J0cmFpdCI6IjEzM3B4In0=",
                                "image_height1" => "eyJwaG9uZSI6IjI2MHB4IiwibGFuZHNjYXBlIjoiMzUwcHgiLCJwb3J0cmFpdCI6IjI3MHB4In0=",
                                "modules_gap" => "eyJwaG9uZSI6IjMifQ==",
                                "meta_padding2" => "eyJsYW5kc2NhcGUiOiIxNnB4IDE1cHggMTFweCIsInBvcnRyYWl0IjoiMTZweCAxNXB4IDExcHgiLCJwaG9uZSI6IjE2cHggMTVweCAxMXB4In0=",
                                "meta_padding1" => "eyJwaG9uZSI6IjE1cHggMThweCJ9",
                                "cat_bg_hover" => "#4db2ec",
                                "review_stars" => "#fff",
                                "image_size2" => "td_324x400",
                                "image_size" => "",
                                "image_width1" => "eyJwaG9uZSI6IjEwMCJ9",
                                "image_width2" => "eyJwaG9uZSI6IjgwIn0=",
                            ),

                            array(
                                'tdc_preset_name' => 'Font family',
                                'tdc_preset_class' => 'tdcp_separator tdcp_separator_font',
                            ),
                            array(
                                'tdc_preset_name' => '', // Font - Montserrat
                                'tdc_preset_class' => 'tdcp_img tdcp_font tdcp_font1',
                                'tdc_preset_individual' => '1',
                                "f_title1_font_family" =>        "394",
                                "f_title2_font_family" =>        "394",
                            ),
                            array(
                                'tdc_preset_name' => '', // Font - Source Serif
                                'tdc_preset_class' => 'tdcp_img tdcp_font tdcp_font2',
                                'tdc_preset_individual' =>      '1',
                                "f_title1_font_family" =>        "721",
                                "f_title2_font_family" =>        "721",
                            ),
                            array(
                                'tdc_preset_name' => '', // Font - Raleway
                                'tdc_preset_class' => 'tdcp_img tdcp_font tdcp_font3',
                                'tdc_preset_individual' => '1',
                                "f_title1_font_family" =>        "507",
                                "f_title2_font_family" =>        "507",
                            ),
                            array(
                                'tdc_preset_name' => '', // Font - Work Sans
                                'tdc_preset_class' => 'tdcp_img tdcp_font tdcp_font4',
                                'tdc_preset_individual' => '1',
                                "f_title1_font_family" =>        "653",
                                "f_title2_font_family" =>        "653",
                            ),
                            array(
                                'tdc_preset_name' => '', // Font - Courgette
                                'tdc_preset_class' => 'tdcp_img tdcp_font tdcp_font5',
                                'tdc_preset_individual' => '1',
                                "f_title1_font_family" =>        "147",
                                "f_title2_font_family" =>        "147",
                            ),
                            array(
                                'tdc_preset_name' => '', // Font - Oswald
                                'tdc_preset_class' => 'tdcp_img tdcp_font tdcp_font7',
                                'tdc_preset_individual' => '1',
                                "f_title1_font_family" =>        "445",
                                "f_title2_font_family" =>        "445",
                            ),
                            array(
                                'tdc_preset_name' => '', // Font - Muli
                                'tdc_preset_class' => 'tdcp_img tdcp_font tdcp_font8',
                                'tdc_preset_individual' => '1',
                                "f_title1_font_family" =>        "406",
                                "f_title2_font_family" =>        "406",
                            ),
                            array(
                                'tdc_preset_name' => '', // Font - Wendy One
                                'tdc_preset_class' => 'tdcp_img tdcp_font tdcp_font9',
                                'tdc_preset_individual' => '1',
                                "f_title1_font_family" =>        "646",
                                "f_title2_font_family" =>        "646",
                            ),
                            array(
                                'tdc_preset_name' => '', // Font - Anton
                                'tdc_preset_class' => 'tdcp_img tdcp_font tdcp_font10',
                                'tdc_preset_individual' => '1',
                                "f_title1_font_family" =>        "41",
                                "f_title2_font_family" =>        "41",
                            ),
                            array(
                                'tdc_preset_name' => '', // Font - Quicksand
                                'tdc_preset_class' => 'tdcp_img tdcp_font tdcp_font11',
                                'tdc_preset_individual' => '1',
                                "f_title1_font_family" =>        "502",
                                "f_title2_font_family" =>        "502",
                            ),
                            array(
                                'tdc_preset_name' => '', // Font - Libre Baskerville
                                'tdc_preset_class' => 'tdcp_img tdcp_font tdcp_font12',
                                'tdc_preset_individual' => '1',
                                "f_title1_font_family" =>        "331",
                                "f_title2_font_family" =>        "331",
                            ),
                            array(
                                'tdc_preset_name' => '', // Font - Caveat
                                'tdc_preset_class' => 'tdcp_img tdcp_font tdcp_font13',
                                'tdc_preset_individual' => '1',
                                "f_title1_font_family" =>        "663",
                                "f_title2_font_family" =>        "663",
                            ),
                            array(
                                'tdc_preset_name' => '', // Font - Volkorn
                                'tdc_preset_class' => 'tdcp_img tdcp_font tdcp_font14',
                                'tdc_preset_individual' => '1',
                                "f_title1_font_family" =>        "639",
                                "f_title2_font_family" =>        "639",
                            ),
                            array(
                                'tdc_preset_name' => '', // Font - Default
                                'tdc_preset_class' => 'tdcp_img tdcp_font tdcp_font6',
                                'tdc_preset_individual' => '1',
                                "f_title1_font_family" =>        "",
                                "f_title2_font_family" =>        "",
                            ),

                            array(
                                'tdc_preset_name' => 'Font size',
                                'tdc_preset_class' => 'tdcp_separator tdcp_separator_size',
                            ),
                            array(
                                'tdc_preset_name' => '', // Size - XS 13/13/12/14
                                'tdc_preset_class' => 'tdcp_img tdcp_size tdcp_size1',
                                'tdc_preset_individual' => '1',
                                "f_title1_font_size" => "eyJhbGwiOiIxMyIsInBvcnRyYWl0IjoiMTIiLCJwaG9uZSI6IjE0In0=",
                                "f_title1_font_line_height" => "1.3",
                                "f_title2_font_size" => "eyJhbGwiOiIxMyIsInBvcnRyYWl0IjoiMTIiLCJwaG9uZSI6IjE0In0=",
                                "f_title2_font_line_height" => "1.3",
                            ),
                            array(
                                'tdc_preset_name' => '', // Size - S 14/13/12/14
                                'tdc_preset_class' => 'tdcp_img tdcp_size tdcp_size2',
                                'tdc_preset_individual' => '1',
                                "f_title1_font_size" => "eyJhbGwiOiIxNCIsImxhbmRzY2FwZSI6IjEzIiwicG9ydHJhaXQiOiIxMiJ9",
                                "f_title1_font_line_height" => "1.4",
                                "f_title2_font_size" => "eyJhbGwiOiIxNCIsImxhbmRzY2FwZSI6IjEzIiwicG9ydHJhaXQiOiIxMiJ9",
                                "f_title2_font_line_height" => "1.4",
                            ),
                            array(
                                'tdc_preset_name' => '', // Size - M 21/21/17/21
                                'tdc_preset_class' => 'tdcp_img tdcp_size tdcp_size3',
                                'tdc_preset_individual' => '1',
                                "f_title1_font_size" => "eyJhbGwiOiIyMSIsImxhbmRzY2FwZSI6IjIwIiwicG9ydHJhaXQiOiIxNyJ9",
                                "f_title1_font_line_height" => "1.2",
                                "f_title2_font_size" => "eyJhbGwiOiIxNSIsInBvcnRyYWl0IjoiMTMifQ==",
                                "f_title2_font_line_height" => "1.3",
                            ),
                            array(
                                'tdc_preset_name' => '', // Size - L 26/25/21/21
                                'tdc_preset_class' => 'tdcp_img tdcp_size tdcp_size4',
                                'tdc_preset_individual' => '1',
                                "f_title1_font_size" => "eyJhbGwiOiIyNiIsImxhbmRzY2FwZSI6IjI1IiwicG9ydHJhaXQiOiIyMSIsInBob25lIjoiMjEifQ==",
                                "f_title1_font_line_height" => "1.2",
                                "f_title2_font_size" => "",
                                "f_title2_font_line_height" => "",

                            ),
                            array(
                                'tdc_preset_name' => '', // Size - XL 30/28/24/21
                                'tdc_preset_class' => 'tdcp_img tdcp_size tdcp_size5',
                                'tdc_preset_individual' => '1',
                                "f_title1_font_size" => "eyJhbGwiOiIzMCIsImxhbmRzY2FwZSI6IjI4IiwicG9ydHJhaXQiOiIyNCIsInBob25lIjoiMjEifQ==",
                                "f_title1_font_line_height" => "1.2",
                                "f_title2_font_size" => "",
                                "f_title2_font_line_height" => "",
                            ),
                            array(
                                'tdc_preset_name' => '', // Size - XXL 36/32/26/21
                                'tdc_preset_class' => 'tdcp_img tdcp_size tdcp_size6',
                                'tdc_preset_individual' => '1',
                                "f_title1_font_size" => "eyJhbGwiOiIzNiIsImxhbmRzY2FwZSI6IjMyIiwicGhvbmUiOiIyMSIsInBvcnRyYWl0IjoiMjYifQ==",
                                "f_title1_font_line_height" => "eyJhbGwiOiIxLjEiLCJwaG9uZSI6IjEuMiJ9",
                                "f_title2_font_size" => "eyJhbGwiOiIxOCIsImxhbmRzY2FwZSI6IjE3IiwicG9ydHJhaXQiOiIxNiIsInBob25lIjoiMTYifQ==",
                                "f_title2_font_line_height" => "1.3",
                            ),

                            array(
                                'tdc_preset_name' => 'Text horizontal alignment',
                                'tdc_preset_class' => 'tdcp_separator tdcp_separator_align',
                            ),
                            array(
                                'tdc_preset_name' => '', // Text alignment - left
                                'tdc_preset_class' => 'tdcp_img tdcp_align tdcp_align1',
                                'tdc_preset_individual' => '1',
                                "meta_info_horiz" => "content-horiz-left",
                            ),
                            array(
                                'tdc_preset_name' => '', // Text alignment - center
                                'tdc_preset_class' => 'tdcp_img tdcp_align tdcp_align2',
                                'tdc_preset_individual' => '1',
                                "meta_info_horiz" => "content-horiz-center",
                            ),
                            array(
                                'tdc_preset_name' => '', // Text alignment - right
                                'tdc_preset_class' => 'tdcp_img tdcp_align tdcp_align3',
                                'tdc_preset_individual' => '1',
                                "meta_info_horiz" => "content-horiz-right",
                            ),

                            array(
                                'tdc_preset_name' => 'Text vertical alignment',
                                'tdc_preset_class' => 'tdcp_separator tdcp_separator_align_v',
                            ),
                            array(
                                'tdc_preset_name' => '', // Text vertical alignment - top
                                'tdc_preset_class' => 'tdcp_img tdcp_align tdcp_align_v1',
                                'tdc_preset_individual' => '1',
                                "meta_info_vert" => "content-vert-top",
                            ),
                            array(
                                'tdc_preset_name' => '', // Text vertical alignment - middle
                                'tdc_preset_class' => 'tdcp_img tdcp_align tdcp_align_v2',
                                'tdc_preset_individual' => '1',
                                "meta_info_vert" => "content-vert-center",
                            ),
                            array(
                                'tdc_preset_name' => '', // Text vertical alignment - bottom
                                'tdc_preset_class' => 'tdcp_img tdcp_align tdcp_align_v3',
                                'tdc_preset_individual' => '1',
                                "meta_info_vert" => "content-vert-bottom",
                            ),

                            array(
                                'tdc_preset_name' => 'Style',
                                'tdc_preset_class' => 'tdcp_separator tdcp_separator_style',
                            ),
                            array(
                                'tdc_preset_name' => '', // Style 1 - default
                                'tdc_preset_class' => 'tdcp_img tdcp_style tdcp_style1',
                                'tdc_preset_individual' => '1',
                                "overlay_general" => "eyJ0eXBlIjoiZ3JhZGllbnQiLCJjb2xvcjEiOiJyZ2JhKDAsMCwwLDApIiwiY29sb3IyIjoicmdiYSgwLDAsMCwwLjcpIiwibWl4ZWRDb2xvcnMiOlt7ImNvbG9yIjoicmdiYSgwLDAsMCwwKSIsInBlcmNlbnRhZ2UiOjYwfV0sImNzcyI6ImJhY2tncm91bmQ6IC13ZWJraXQtbGluZWFyLWdyYWRpZW50KDBkZWcscmdiYSgwLDAsMCwwLjcpLHJnYmEoMCwwLDAsMCkgNjAlLHJnYmEoMCwwLDAsMCkpO2JhY2tncm91bmQ6IGxpbmVhci1ncmFkaWVudCgwZGVnLHJnYmEoMCwwLDAsMC43KSxyZ2JhKDAsMCwwLDApIDYwJSxyZ2JhKDAsMCwwLDApKTsiLCJjc3NQYXJhbXMiOiIwZGVnLHJnYmEoMCwwLDAsMC43KSxyZ2JhKDAsMCwwLDApIDYwJSxyZ2JhKDAsMCwwLDApIn0=",
                                "overlay_h_general" => "",
                                "overlay_1" => "",
                                "overlay_2" => "",
                                "overlay_3" => "",
                                "overlay_4" => "",
                                "overlay_5" => "",
                                "lightsky" => "",
                            ),
                            array(
                                'tdc_preset_name' => '', // Style 2 - colors
                                'tdc_preset_class' => 'tdcp_img tdcp_style tdcp_style2',
                                'tdc_preset_individual' => '1',
                                "overlay_h_general" => "",
                                "overlay_1" => "eyJ0eXBlIjoiZ3JhZGllbnQiLCJjb2xvcjEiOiJyZ2JhKDc0LDE0Myw5NCwwLjYpIiwiY29sb3IyIjoicmdiYSg3NywxNzgsMjM2LDAuNikiLCJtaXhlZENvbG9ycyI6W10sImRlZ3JlZSI6IjQ1IiwiY3NzIjoiYmFja2dyb3VuZDogLXdlYmtpdC1saW5lYXItZ3JhZGllbnQoNDVkZWcscmdiYSg3NywxNzgsMjM2LDAuNikscmdiYSg3NCwxNDMsOTQsMC42KSk7YmFja2dyb3VuZDogbGluZWFyLWdyYWRpZW50KDQ1ZGVnLHJnYmEoNzcsMTc4LDIzNiwwLjYpLHJnYmEoNzQsMTQzLDk0LDAuNikpOyIsImNzc1BhcmFtcyI6IjQ1ZGVnLHJnYmEoNzcsMTc4LDIzNiwwLjYpLHJnYmEoNzQsMTQzLDk0LDAuNikifQ==",
                                "overlay_2" => "eyJ0eXBlIjoiZ3JhZGllbnQiLCJjb2xvcjEiOiJyZ2JhKDE5OCw1Nyw1NywwLjYpIiwiY29sb3IyIjoicmdiYSgyMDksMTE4LDcwLDAuNikiLCJtaXhlZENvbG9ycyI6W10sImRlZ3JlZSI6IjQ1IiwiY3NzIjoiYmFja2dyb3VuZDogLXdlYmtpdC1saW5lYXItZ3JhZGllbnQoNDVkZWcscmdiYSgyMDksMTE4LDcwLDAuNikscmdiYSgxOTgsNTcsNTcsMC42KSk7YmFja2dyb3VuZDogbGluZWFyLWdyYWRpZW50KDQ1ZGVnLHJnYmEoMjA5LDExOCw3MCwwLjYpLHJnYmEoMTk4LDU3LDU3LDAuNikpOyIsImNzc1BhcmFtcyI6IjQ1ZGVnLHJnYmEoMjA5LDExOCw3MCwwLjYpLHJnYmEoMTk4LDU3LDU3LDAuNikifQ==",
                                "overlay_3" => "eyJ0eXBlIjoiZ3JhZGllbnQiLCJjb2xvcjEiOiJyZ2JhKDU5LDEyMCwxODAsMC41OSkiLCJjb2xvcjIiOiJyZ2JhKDIxNSw5NiwxODMsMC42KSIsIm1peGVkQ29sb3JzIjpbXSwiZGVncmVlIjoiLTQ1IiwiY3NzIjoiYmFja2dyb3VuZDogLXdlYmtpdC1saW5lYXItZ3JhZGllbnQoLTQ1ZGVnLHJnYmEoMjE1LDk2LDE4MywwLjYpLHJnYmEoNTksMTIwLDE4MCwwLjU5KSk7YmFja2dyb3VuZDogbGluZWFyLWdyYWRpZW50KC00NWRlZyxyZ2JhKDIxNSw5NiwxODMsMC42KSxyZ2JhKDU5LDEyMCwxODAsMC41OSkpOyIsImNzc1BhcmFtcyI6Ii00NWRlZyxyZ2JhKDIxNSw5NiwxODMsMC42KSxyZ2JhKDU5LDEyMCwxODAsMC41OSkifQ==",
                                "overlay_4" => "eyJ0eXBlIjoiZ3JhZGllbnQiLCJjb2xvcjEiOiJyZ2JhKDI0MiwxMjIsNTMsMC42KSIsImNvbG9yMiI6InJnYmEoMjQ0LDIwOCw2MywwLjYpIiwibWl4ZWRDb2xvcnMiOltdLCJkZWdyZWUiOiItNDUiLCJjc3MiOiJiYWNrZ3JvdW5kOiAtd2Via2l0LWxpbmVhci1ncmFkaWVudCgtNDVkZWcscmdiYSgyNDQsMjA4LDYzLDAuNikscmdiYSgyNDIsMTIyLDUzLDAuNikpO2JhY2tncm91bmQ6IGxpbmVhci1ncmFkaWVudCgtNDVkZWcscmdiYSgyNDQsMjA4LDYzLDAuNikscmdiYSgyNDIsMTIyLDUzLDAuNikpOyIsImNzc1BhcmFtcyI6Ii00NWRlZyxyZ2JhKDI0NCwyMDgsNjMsMC42KSxyZ2JhKDI0MiwxMjIsNTMsMC42KSJ9",
                                "overlay_5" => "eyJ0eXBlIjoiZ3JhZGllbnQiLCJjb2xvcjEiOiJyZ2JhKDc0LDE0Myw5NCwwLjYpIiwiY29sb3IyIjoicmdiYSg3NywxNzgsMjM2LDAuNikiLCJtaXhlZENvbG9ycyI6W10sImRlZ3JlZSI6IjQ1IiwiY3NzIjoiYmFja2dyb3VuZDogLXdlYmtpdC1saW5lYXItZ3JhZGllbnQoNDVkZWcscmdiYSg3NywxNzgsMjM2LDAuNikscmdiYSg3NCwxNDMsOTQsMC42KSk7YmFja2dyb3VuZDogbGluZWFyLWdyYWRpZW50KDQ1ZGVnLHJnYmEoNzcsMTc4LDIzNiwwLjYpLHJnYmEoNzQsMTQzLDk0LDAuNikpOyIsImNzc1BhcmFtcyI6IjQ1ZGVnLHJnYmEoNzcsMTc4LDIzNiwwLjYpLHJnYmEoNzQsMTQzLDk0LDAuNikifQ==",
                                "lightsky" => "",
                            ),
                            array(
                                'tdc_preset_name' => '', // Style 3 - flat colors
                                'tdc_preset_class' => 'tdcp_img tdcp_style tdcp_style3',
                                'tdc_preset_individual' => '1',
                                "overlay_h_general" => "",
                                "overlay_1" => "eyJ0eXBlIjoiZ3JhZGllbnQiLCJjb2xvcjEiOiJyZ2JhKDc0LDE0Myw5NCwwLjgpIiwiY29sb3IyIjoicmdiYSg3NywxNzgsMjM2LDAuOCkiLCJtaXhlZENvbG9ycyI6W10sImRlZ3JlZSI6IjQ1IiwiY3NzIjoiYmFja2dyb3VuZDogLXdlYmtpdC1saW5lYXItZ3JhZGllbnQoNDVkZWcscmdiYSg3NywxNzgsMjM2LDAuOCkscmdiYSg3NCwxNDMsOTQsMC44KSk7YmFja2dyb3VuZDogbGluZWFyLWdyYWRpZW50KDQ1ZGVnLHJnYmEoNzcsMTc4LDIzNiwwLjgpLHJnYmEoNzQsMTQzLDk0LDAuOCkpOyIsImNzc1BhcmFtcyI6IjQ1ZGVnLHJnYmEoNzcsMTc4LDIzNiwwLjgpLHJnYmEoNzQsMTQzLDk0LDAuOCkifQ==",
                                "overlay_2" => "eyJ0eXBlIjoiZ3JhZGllbnQiLCJjb2xvcjEiOiJyZ2JhKDE5OCw1Nyw1NywwLjgpIiwiY29sb3IyIjoicmdiYSgyMDksMTE4LDcwLDAuOCkiLCJtaXhlZENvbG9ycyI6W10sImRlZ3JlZSI6IjQ1IiwiY3NzIjoiYmFja2dyb3VuZDogLXdlYmtpdC1saW5lYXItZ3JhZGllbnQoNDVkZWcscmdiYSgyMDksMTE4LDcwLDAuOCkscmdiYSgxOTgsNTcsNTcsMC44KSk7YmFja2dyb3VuZDogbGluZWFyLWdyYWRpZW50KDQ1ZGVnLHJnYmEoMjA5LDExOCw3MCwwLjgpLHJnYmEoMTk4LDU3LDU3LDAuOCkpOyIsImNzc1BhcmFtcyI6IjQ1ZGVnLHJnYmEoMjA5LDExOCw3MCwwLjgpLHJnYmEoMTk4LDU3LDU3LDAuOCkifQ==",
                                "overlay_3" => "eyJ0eXBlIjoiZ3JhZGllbnQiLCJjb2xvcjEiOiJyZ2JhKDU5LDEyMCwxODAsMC44KSIsImNvbG9yMiI6InJnYmEoMjE1LDk2LDE4MywwLjgpIiwibWl4ZWRDb2xvcnMiOltdLCJkZWdyZWUiOiItNDUiLCJjc3MiOiJiYWNrZ3JvdW5kOiAtd2Via2l0LWxpbmVhci1ncmFkaWVudCgtNDVkZWcscmdiYSgyMTUsOTYsMTgzLDAuOCkscmdiYSg1OSwxMjAsMTgwLDAuOCkpO2JhY2tncm91bmQ6IGxpbmVhci1ncmFkaWVudCgtNDVkZWcscmdiYSgyMTUsOTYsMTgzLDAuOCkscmdiYSg1OSwxMjAsMTgwLDAuOCkpOyIsImNzc1BhcmFtcyI6Ii00NWRlZyxyZ2JhKDIxNSw5NiwxODMsMC44KSxyZ2JhKDU5LDEyMCwxODAsMC44KSJ9",
                                "overlay_4" => "eyJ0eXBlIjoiZ3JhZGllbnQiLCJjb2xvcjEiOiJyZ2JhKDI0MiwxMjIsNTMsMC44KSIsImNvbG9yMiI6InJnYmEoMjQ0LDIwOCw2MywwLjgpIiwibWl4ZWRDb2xvcnMiOltdLCJkZWdyZWUiOiItNDUiLCJjc3MiOiJiYWNrZ3JvdW5kOiAtd2Via2l0LWxpbmVhci1ncmFkaWVudCgtNDVkZWcscmdiYSgyNDQsMjA4LDYzLDAuOCkscmdiYSgyNDIsMTIyLDUzLDAuOCkpO2JhY2tncm91bmQ6IGxpbmVhci1ncmFkaWVudCgtNDVkZWcscmdiYSgyNDQsMjA4LDYzLDAuOCkscmdiYSgyNDIsMTIyLDUzLDAuOCkpOyIsImNzc1BhcmFtcyI6Ii00NWRlZyxyZ2JhKDI0NCwyMDgsNjMsMC44KSxyZ2JhKDI0MiwxMjIsNTMsMC44KSJ9",
                                "overlay_5" => "eyJ0eXBlIjoiZ3JhZGllbnQiLCJjb2xvcjEiOiJyZ2JhKDc0LDE0Myw5NCwwLjgpIiwiY29sb3IyIjoicmdiYSg3NywxNzgsMjM2LDAuOCkiLCJtaXhlZENvbG9ycyI6W10sImRlZ3JlZSI6IjQ1IiwiY3NzIjoiYmFja2dyb3VuZDogLXdlYmtpdC1saW5lYXItZ3JhZGllbnQoNDVkZWcscmdiYSg3NywxNzgsMjM2LDAuOCkscmdiYSg3NCwxNDMsOTQsMC44KSk7YmFja2dyb3VuZDogbGluZWFyLWdyYWRpZW50KDQ1ZGVnLHJnYmEoNzcsMTc4LDIzNiwwLjgpLHJnYmEoNzQsMTQzLDk0LDAuOCkpOyIsImNzc1BhcmFtcyI6IjQ1ZGVnLHJnYmEoNzcsMTc4LDIzNiwwLjgpLHJnYmEoNzQsMTQzLDk0LDAuOCkifQ==",
                                "lightsky" => "",
                            ),
                            array(
                                'tdc_preset_name' => '', // Style 4 - light sky
                                'tdc_preset_class' => 'tdcp_img tdcp_style tdcp_style4',
                                'tdc_preset_individual' => '1',
                                "overlay_general" => "rgba(0,0,0,0.7)",
                                "overlay_h_general" => "rgba(77,178,236,0.3)",
                                "overlay_1" => "",
                                "overlay_2" => "",
                                "overlay_3" => "",
                                "overlay_4" => "",
                                "overlay_5" => "",
                                "lightsky" => "yes",
                            ),
                            array(
                                'tdc_preset_name' => '', // Style 5 - rainbow
                                'tdc_preset_class' => 'tdcp_img tdcp_style tdcp_style5',
                                'tdc_preset_individual' => '1',
                                "overlay_h_general" => "",
                                "overlay_1" => "eyJ0eXBlIjoiZ3JhZGllbnQiLCJjb2xvcjEiOiJyZ2JhKDI1NSwxMTEsNDksMC42KSIsImNvbG9yMiI6InJnYmEoNjUsMTIsMTg4LDAuNikiLCJtaXhlZENvbG9ycyI6W10sImRlZ3JlZSI6IjIwIiwiY3NzIjoiYmFja2dyb3VuZDogLXdlYmtpdC1saW5lYXItZ3JhZGllbnQoMjBkZWcscmdiYSg2NSwxMiwxODgsMC42KSxyZ2JhKDI1NSwxMTEsNDksMC42KSk7YmFja2dyb3VuZDogbGluZWFyLWdyYWRpZW50KDIwZGVnLHJnYmEoNjUsMTIsMTg4LDAuNikscmdiYSgyNTUsMTExLDQ5LDAuNikpOyIsImNzc1BhcmFtcyI6IjIwZGVnLHJnYmEoNjUsMTIsMTg4LDAuNikscmdiYSgyNTUsMTExLDQ5LDAuNikifQ==",
                                "overlay_2" => "eyJ0eXBlIjoiZ3JhZGllbnQiLCJjb2xvcjEiOiJyZ2JhKDExMiwyNTUsMTUzLDAuNikiLCJjb2xvcjIiOiJyZ2JhKDI0NCwxMzYsMTMsMC42KSIsIm1peGVkQ29sb3JzIjpbXSwiZGVncmVlIjoiMjAiLCJjc3MiOiJiYWNrZ3JvdW5kOiAtd2Via2l0LWxpbmVhci1ncmFkaWVudCgyMGRlZyxyZ2JhKDI0NCwxMzYsMTMsMC42KSxyZ2JhKDExMiwyNTUsMTUzLDAuNikpO2JhY2tncm91bmQ6IGxpbmVhci1ncmFkaWVudCgyMGRlZyxyZ2JhKDI0NCwxMzYsMTMsMC42KSxyZ2JhKDExMiwyNTUsMTUzLDAuNikpOyIsImNzc1BhcmFtcyI6IjIwZGVnLHJnYmEoMjQ0LDEzNiwxMywwLjYpLHJnYmEoMTEyLDI1NSwxNTMsMC42KSJ9",
                                "overlay_3" => "eyJ0eXBlIjoiZ3JhZGllbnQiLCJjb2xvcjEiOiJyZ2JhKDEyNiwxOTEsMjU1LDAuNikiLCJjb2xvcjIiOiJyZ2JhKDE5NiwxNSwxMjEsMC42KSIsIm1peGVkQ29sb3JzIjpbXSwiZGVncmVlIjoiMjAiLCJjc3MiOiJiYWNrZ3JvdW5kOiAtd2Via2l0LWxpbmVhci1ncmFkaWVudCgyMGRlZyxyZ2JhKDE5NiwxNSwxMjEsMC42KSxyZ2JhKDEyNiwxOTEsMjU1LDAuNikpO2JhY2tncm91bmQ6IGxpbmVhci1ncmFkaWVudCgyMGRlZyxyZ2JhKDE5NiwxNSwxMjEsMC42KSxyZ2JhKDEyNiwxOTEsMjU1LDAuNikpOyIsImNzc1BhcmFtcyI6IjIwZGVnLHJnYmEoMTk2LDE1LDEyMSwwLjYpLHJnYmEoMTI2LDE5MSwyNTUsMC42KSJ9",
                                "overlay_4" => "eyJ0eXBlIjoiZ3JhZGllbnQiLCJjb2xvcjEiOiJyZ2JhKDQyLDIzNiwxMTYsMC42KSIsImNvbG9yMiI6InJnYmEoMCwyMiwxOTAsMC42KSIsIm1peGVkQ29sb3JzIjpbXSwiZGVncmVlIjoiMjAiLCJjc3MiOiJiYWNrZ3JvdW5kOiAtd2Via2l0LWxpbmVhci1ncmFkaWVudCgyMGRlZyxyZ2JhKDAsMjIsMTkwLDAuNikscmdiYSg0MiwyMzYsMTE2LDAuNikpO2JhY2tncm91bmQ6IGxpbmVhci1ncmFkaWVudCgyMGRlZyxyZ2JhKDAsMjIsMTkwLDAuNikscmdiYSg0MiwyMzYsMTE2LDAuNikpOyIsImNzc1BhcmFtcyI6IjIwZGVnLHJnYmEoMCwyMiwxOTAsMC42KSxyZ2JhKDQyLDIzNiwxMTYsMC42KSJ9",
                                "overlay_5" => "eyJ0eXBlIjoiZ3JhZGllbnQiLCJjb2xvcjEiOiJyZ2JhKDI1NSwxMTEsNDksMC42KSIsImNvbG9yMiI6InJnYmEoNjUsMTIsMTg4LDAuNikiLCJtaXhlZENvbG9ycyI6W10sImRlZ3JlZSI6IjIwIiwiY3NzIjoiYmFja2dyb3VuZDogLXdlYmtpdC1saW5lYXItZ3JhZGllbnQoMjBkZWcscmdiYSg2NSwxMiwxODgsMC42KSxyZ2JhKDI1NSwxMTEsNDksMC42KSk7YmFja2dyb3VuZDogbGluZWFyLWdyYWRpZW50KDIwZGVnLHJnYmEoNjUsMTIsMTg4LDAuNikscmdiYSgyNTUsMTExLDQ5LDAuNikpOyIsImNzc1BhcmFtcyI6IjIwZGVnLHJnYmEoNjUsMTIsMTg4LDAuNikscmdiYSgyNTUsMTExLDQ5LDAuNikifQ==",
                                "lightsky" => "",
                            ),
                        )
                    )
                ),
                "params" => array_merge(
                    array(
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Content length',
                            "value"      => "",
                            "class"      => "",
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Module Flex 6',
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                        ),
                        array(
                            "param_name"  => "mf6_tl",
                            "type"        => "textfield",
                            "value"       => '',
                            "heading"     => 'Title length',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-small",
                            "placeholder" => '25',
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Module Flex 7',
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                        ),
                        array(
                            "param_name"  => "mf7_tl",
                            "type"        => "textfield",
                            "value"       => '',
                            "heading"     => 'Title length',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-small",
                            "placeholder" => '25',
                        ),
                    ),
                    self::td_block_big_grid_params(),
                    array(
                        array(
                            "param_name"  => "modules_gap",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Modules gap',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-small",
                            "placeholder" => "4",
                            "group"       => "Layout",
                        ),
                        array(
                            "param_name" => "meta_info_horiz",
                            "type" => "dropdown",
                            "value" => array(
                                'Left' => 'content-horiz-left',
                                'Center' => 'content-horiz-center',
                                'Right' => 'content-horiz-right'
                            ),
                            "heading" => 'Meta info horiz align',
                            "description" => "",
                            "holder" => "div",
                            'tdc_dropdown_images' => true,
                            "class" => "tdc-visual-selector tdc-add-class",
                            "group"       => "Layout",
                        ),
                        array(
                            "param_name" => "meta_info_vert",
                            "type" => "dropdown",
                            "value" => array(
                                'Left' => 'content-vert-top',
                                'Center' => 'content-vert-center',
                                'Right' => 'content-vert-bottom'
                            ),
                            "heading" => 'Meta info vert align',
                            "description" => "",
                            "holder" => "div",
                            'tdc_dropdown_images' => true,
                            "class" => "tdc-visual-selector tdc-add-class",
                            "group"       => "Layout",
                        ),
                        array(
                            "param_name"  => "image_zoom",
                            "type"        => "checkbox",
                            "value"       => '',
                            "heading"     => "Zoom effect on hover",
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "",
                            "group"       => 'Layout'
                        ),
                        array(
                            "param_name"  => "modules_category",
                            "type"        => "dropdown",
                            "value"       => array(
                                'Inline'      => '',
                                'Above title' => 'above',
                            ),
                            "heading"     => 'Category tag position',
                            "description" => "Float image",
                            "holder"      => "div",
                            "class"       => "tdc-dropdown-big",
                            "group"       => "Layout",
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Module Category Grid 1',
                            "value"      => "",
                            "class"      => "",
                            "group"      => "Layout",
                        ),
                        array(
                            "param_name"  => "image_size",
                            "type"        => "dropdown",
                            "value"       => array(
                                'XSmall - 324px' => 'td_324x400',
                                'Small - 696px'  => '',
                                'Large - 1068px' => 'td_1068x0',
                                'Full - 1920px'  => 'td_1920x0'
                            ),
                            "heading"     => 'Image size',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-dropdown-big",
                            "group"       => "Layout",
                        ),
                        array(
                            'param_name'  => 'image_alignment1',
                            'type'        => 'range-responsive',
                            'value'       => '50',
                            'heading'     => 'Image V alignment',
                            'description' => '0 - Top / 50 - Center / 100 - Bottom',
                            'class'       => 'tdc-textfield-small',
                            'range_min'   => '0',
                            'range_max'   => '100',
                            'range_step'  => '1',
                            "group"       => "Layout",
                        ),
                        array(
                            "param_name"  => "image_width1",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Image width (percent)',
                            "description" => "Default value in percent",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-small",
                            "placeholder" => "70",
                            "group"       => "Layout",
                        ),
                        array(
                            "param_name"  => "image_height1",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Image height (percent)',
                            "description" => "Default value in percent",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-small",
                            "placeholder" => "400px",
                            "group"       => "Layout",
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "horizontal_separator",
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                            "group"      => "Layout",
                        ),
                        array(
                            "param_name"  => "meta_width1",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Meta info width',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-small",
                            "placeholder" => "100%",
                            "group"       => "Layout",
                        ),
                        array(
                            "param_name"  => "meta_margin1",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Meta info margin',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-big",
                            "placeholder" => "0px 0px 0px 0px",
                            "group"       => "Layout",
                        ),
                        array(
                            "param_name"  => "meta_padding1",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Meta info padding',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-big",
                            "placeholder" => "22px 20px",
                            "group"       => "Layout",
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "horizontal_separator",
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                            "group"      => "Layout",
                        ),
                        array(
                            "param_name"  => "art_title1",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Article title space',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-big",
                            "placeholder" => "0px 0px 9px 0px",
                            "group"       => "Layout",
                        ),
                        array(
                            "param_name"  => "art_title_padd1",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Article title padding',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-big",
                            "placeholder" => "0px 0px 0px 0px",
                            "group"       => "Layout",
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "horizontal_separator",
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                            "group"      => "Layout",
                        ),
                        array(
                            "param_name"  => "modules_category_margin1",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Category tag spacing',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-big",
                            "placeholder" => "0px 0px 5px 0px",
                            "group"       => "Layout",
                        ),
                        array(
                            "param_name"  => "modules_category_padding1",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Category tag padding',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-big",
                            "placeholder" => "3px 6px 3px 6px",
                            "group"       => "Layout",
                        ),
                        array(
                            "param_name"  => "show_cat1",
                            "type"        => "dropdown-responsive",
                            "value"       => array(
                                'Show' => 'inline-block',
                                'Hide' => 'none',
                            ),
                            "heading"     => 'Show category',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-dropdown-big",
                            "group"       => "Layout",
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "horizontal_separator",
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                            "group"      => "Layout",
                        ),
                        array(
                            "param_name"  => "show_author1",
                            "type"        => "dropdown-responsive",
                            "value"       => array(
                                'Show' => 'inline-block',
                                'Hide' => 'none',
                            ),
                            "heading"     => 'Show author',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-dropdown-big",
                            "group"       => "Layout",
                        ),
                        array(
                            "param_name"  => "show_date1",
                            "type"        => "dropdown-responsive",
                            "value"       => array(
                                'Show' => 'inline-block',
                                'Hide' => 'none',
                            ),
                            "heading"     => 'Show date',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-dropdown-big",
                            "group"       => "Layout",
                        ),
                        array(
                            "param_name"  => "auth_date_padding1",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Author & date padding',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-big",
                            "placeholder" => "0px 0px 0px 0px",
                            "group"       => "Layout",
                        ),

                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Module Category Grid 2',
                            "value"      => "",
                            "class"      => "",
                            "group"      => "Layout",
                        ),
                        array(
                            "param_name"  => "image_size2",
                            "type"        => "dropdown",
                            "value"       => array(
                                'XSmall - 324px' => 'td_324x400',
                                'Small - 696px'  => '',
                                'Large - 1068px' => 'td_1068x0',
                                'Full - 1920px'  => 'td_1920x0'
                            ),
                            "heading"     => 'Image size',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-dropdown-big",
                            "group"       => "Layout",
                        ),
                        array(
                            'param_name'  => 'image_alignment2',
                            'type'        => 'range-responsive',
                            'value'       => '50',
                            'heading'     => 'Image V alignment',
                            'description' => '0 - Top / 50 - Center / 100 - Bottom',
                            'class'       => 'tdc-textfield-small',
                            'range_min'   => '0',
                            'range_max'   => '100',
                            'range_step'  => '1',
                            "group"       => "Layout",
                        ),
                        array(
                            "param_name"  => "image_width2",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Image width (percent)',
                            "description" => "Default value in percent",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-small",
                            "placeholder" => "30",
                            "group"       => "Layout",
                        ),
                        array(
                            "param_name"  => "image_height2",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Image height (percent)',
                            "description" => "Default value in percent",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-small",
                            "placeholder" => "198px",
                            "group"       => "Layout",
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "horizontal_separator",
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                            "group"      => "Layout",
                        ),
                        array(
                            "param_name"  => "meta_width2",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Meta info width',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-small",
                            "placeholder" => "100%",
                            "group"       => "Layout",
                        ),
                        array(
                            "param_name"  => "meta_margin2",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Meta info margin',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-big",
                            "placeholder" => "0px 0px 0px 0px",
                            "group"       => "Layout",
                        ),
                        array(
                            "param_name"  => "meta_padding2",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Meta info padding',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-big",
                            "placeholder" => "11px 17px",
                            "group"       => "Layout",
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "horizontal_separator",
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                            "group"      => "Layout",
                        ),
                        array(
                            "param_name"  => "art_title2",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Article title space',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-big",
                            "placeholder" => "0px 0px 9px 0px",
                            "group"       => "Layout",
                        ),
                        array(
                            "param_name"  => "art_title_padd2",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Article title padding',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-big",
                            "placeholder" => "0px 0px 0px 0px",
                            "group"       => "Layout",
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "horizontal_separator",
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                            "group"      => "Layout",
                        ),
                        array(
                            "param_name"  => "modules_category_margin2",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Category tag spacing',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-big",
                            "placeholder" => "0px 0px 7px 0px",
                            "group"       => "Layout",
                        ),
                        array(
                            "param_name"  => "modules_category_padding2",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Category tag padding',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-big",
                            "placeholder" => "3px 6px 3px 6px",
                            "group"       => "Layout",
                        ),
                        array(
                            "param_name"  => "show_cat2",
                            "type"        => "dropdown-responsive",
                            "value"       => array(
                                'Show' => 'inline-block',
                                'Hide' => 'none',
                            ),
                            "heading"     => 'Show category',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-dropdown-big",
                            "group"       => "Layout",
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "horizontal_separator",
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                            "group"      => "Layout",
                        ),
                        array(
                            "param_name"  => "show_author2",
                            "type"        => "dropdown-responsive",
                            "value"       => array(
                                'Show' => 'inline-block',
                                'Hide' => 'none',
                            ),
                            "heading"     => 'Show author',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-dropdown-big",
                            "group"       => "Layout",
                        ),
                        array(
                            "param_name"  => "show_date2",
                            "type"        => "dropdown-responsive",
                            "value"       => array(
                                'Show' => 'inline-block',
                                'Hide' => 'none',
                            ),
                            "heading"     => 'Show date',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-dropdown-big",
                            "group"       => "Layout",
                        ),
                        array(
                            "param_name"  => "auth_date_padding2",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Author & date padding',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-big",
                            "placeholder" => "0px 0px 0px 0px",
                            "group"       => "Layout",
                        ),
                        array(
                            "param_name" => "separator",
                            "type" => "text_separator",
                            'heading' => 'Module fonts',
                            "value" => "",
                            "class" => "",
                            "group" => 'Style',
                        ),
                    ),
                    td_config_helper::get_map_block_font_array( 'f_title1', true, 'Module 1 title', 'Style' ),
                    td_config_helper::get_map_block_font_array( 'f_cat1', false, 'Module 1 category tag', 'Style' ),
                    td_config_helper::get_map_block_font_array( 'f_meta1', false, 'Module 1 meta info', 'Style' ),
                    td_config_helper::get_map_block_font_array( 'f_title2', false, 'Module 2 title', 'Style' ),
                    td_config_helper::get_map_block_font_array( 'f_cat2', false, 'Module 2 category tag', 'Style' ),
                    td_config_helper::get_map_block_font_array( 'f_meta2', false, 'Module 2 meta info', 'Style' ),
                    array(
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Colors',
                            "value"      => "",
                            "class"      => "",
                            "group"      => "Style",
                        ),
                        array(
                            "param_name" => "overlay_general",
                            "holder" => "div",
                            "type" => "gradient",
                            'heading' => "General module overlay color",
                            "value" => "",
                            "class" => "",
                            "group"      => "Style",
                        ),
                        array(
                            "param_name" => "overlay_h_general",
                            "holder" => "div",
                            "type" => "gradient",
                            'heading' => "General module overlay hover color",
                            "value" => "",
                            "class" => "",
                            "group"      => "Style",
                        ),
                        array(
                            "param_name" => "overlay_1",
                            "holder" => "div",
                            "type" => "gradient",
                            'heading' => "Module overlay color 1",
                            "value" => "",
                            "class" => "",
                            "group"      => "Style",
                        ),
                        array(
                            "param_name" => "overlay_2",
                            "holder" => "div",
                            "type" => "gradient",
                            'heading' => "Module overlay color 2",
                            "value" => "",
                            "class" => "",
                            "group"      => "Style",
                        ),
                        array(
                            "param_name" => "overlay_3",
                            "holder" => "div",
                            "type" => "gradient",
                            'heading' => "Module overlay color 3",
                            "value" => "",
                            "class" => "",
                            "group"      => "Style",
                        ),
                        array(
                            "param_name" => "overlay_4",
                            "holder" => "div",
                            "type" => "gradient",
                            'heading' => "Module overlay color 4",
                            "value" => "",
                            "class" => "",
                            "group"      => "Style",
                        ),
                        array(
                            "param_name" => "overlay_5",
                            "holder" => "div",
                            "type" => "gradient",
                            'heading' => "Module overlay color 5",
                            "value" => "",
                            "class" => "",
                            "group"      => "Style",
                        ),
                        array(
                            "param_name"  => "lightsky",
                            "type"        => "checkbox",
                            "value"       => '',
                            "heading"     => "Lightsky",
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "",
                            "group"       => 'Style'
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "",
                            "heading"     => 'Meta info background',
                            "param_name"  => "meta_bg",
                            "value"       => '',
                            "description" => '',
                            "group"       => 'Style',
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "horizontal_separator",
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                            "group"      => "Style",
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "",
                            "heading"     => 'Article title text color',
                            "param_name"  => "title_txt",
                            "value"       => '',
                            "description" => '',
                            "group"       => 'Style',
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "",
                            "heading"     => 'Article title text hover',
                            "param_name"  => "title_txt_hover",
                            "value"       => '',
                            "description" => '',
                            "group"       => 'Style',
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "",
                            "heading"     => 'Article title background color',
                            "param_name"  => "title_bg",
                            "value"       => '',
                            "description" => '',
                            "group"       => 'Style',
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "horizontal_separator",
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                            "group"      => "Style",
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "",
                            "heading"     => 'Category background',
                            "param_name"  => "cat_bg",
                            "value"       => '',
                            "description" => '',
                            "group"       => 'Style',
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "",
                            "heading"     => 'Category text color',
                            "param_name"  => "cat_txt",
                            "value"       => '',
                            "description" => '',
                            "group"       => 'Style',
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "",
                            "heading"     => 'Category background hover',
                            "param_name"  => "cat_bg_hover",
                            "value"       => '',
                            "description" => '',
                            "group"       => 'Style',
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "",
                            "heading"     => 'Category text hover',
                            "param_name"  => "cat_txt_hover",
                            "value"       => '',
                            "description" => '',
                            "group"       => 'Style',
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "horizontal_separator",
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                            "group"      => "Style",
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "",
                            "heading"     => 'Author text color',
                            "param_name"  => "author_txt",
                            "value"       => '',
                            "description" => '',
                            "group"       => 'Style',
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "",
                            "heading"     => 'Author text hover',
                            "param_name"  => "author_txt_hover",
                            "value"       => '',
                            "description" => '',
                            "group"       => 'Style',
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "",
                            "heading"     => 'Date text color',
                            "param_name"  => "date_txt",
                            "value"       => '',
                            "description" => '',
                            "group"       => 'Style',
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "",
                            "heading"     => 'Author & date background color',
                            "param_name"  => "auth_date_bg",
                            "value"       => '',
                            "description" => '',
                            "group"       => 'Style',
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "",
                            "heading"     => 'Review stars color',
                            "param_name"  => "review_stars",
                            "value"       => '',
                            "description" => '',
                            "group"       => 'Style',
                        ),
                    ),
                    self::get_map_css_tab()
                )
            )
        );

        td_api_block::add('td_block_big_grid_flex_3',
            array(
                'map_in_visual_composer' => false,
                'map_in_td_composer' => true,
                "name" => 'Big Grid Flex 3',
                "base" => 'td_block_big_grid_flex_3',
                "class" => 'td_block_big_grid_flex_3',
                "controls" => "full",
                "category" => 'Blocks',
                'tdc_category' => 'Big Grids',
                'icon' => 'icon-pagebuilder-td_block_big_grid_flex_3',
                'file' => td_global::$get_template_directory . '/includes/shortcodes/td_block_big_grid_flex_3.php',
                'tdc_style_params' => array(
                    'custom_title',
                    'custom_url',
                    'post_ids',
                    'category_id',
                    'category_ids',
                    'tag_slug',
                    'autors_id',
                    'installed_post_types',
                    'sort',
                    'offset',
                    'el_class'
                ),
                'tdc_start_values' => base64_encode(
                    json_encode(
                        array(
                            array(
                                "meta_info_vert" => "content-vert-bottom",
                                "image_zoom" => "yes",
                                "show_author2" => "none",
                                "show_date2" => "none",
                                "modules_category" => "above",
                                "overlay_general" => "eyJ0eXBlIjoiZ3JhZGllbnQiLCJjb2xvcjEiOiJyZ2JhKDAsMCwwLDApIiwiY29sb3IyIjoicmdiYSgwLDAsMCwwLjcpIiwibWl4ZWRDb2xvcnMiOlt7ImNvbG9yIjoicmdiYSgwLDAsMCwwKSIsInBlcmNlbnRhZ2UiOjYwfV0sImNzcyI6ImJhY2tncm91bmQ6IC13ZWJraXQtbGluZWFyLWdyYWRpZW50KDBkZWcscmdiYSgwLDAsMCwwLjcpLHJnYmEoMCwwLDAsMCkgNjAlLHJnYmEoMCwwLDAsMCkpO2JhY2tncm91bmQ6IGxpbmVhci1ncmFkaWVudCgwZGVnLHJnYmEoMCwwLDAsMC43KSxyZ2JhKDAsMCwwLDApIDYwJSxyZ2JhKDAsMCwwLDApKTsiLCJjc3NQYXJhbXMiOiIwZGVnLHJnYmEoMCwwLDAsMC43KSxyZ2JhKDAsMCwwLDApIDYwJSxyZ2JhKDAsMCwwLDApIn0=",
                                "image_height2" => "eyJwaG9uZSI6IjE2NXB4IiwibGFuZHNjYXBlIjoiMTQ1cHgiLCJwb3J0cmFpdCI6IjEwOXB4In0=",
                                "image_height1" => "eyJwaG9uZSI6IjI2MHB4IiwibGFuZHNjYXBlIjoiNDQzcHgiLCJwb3J0cmFpdCI6IjMzNXB4In0=",
                                "modules_gap" => "eyJwaG9uZSI6IjMifQ==",
                                "meta_padding2" => "eyJsYW5kc2NhcGUiOiIxNnB4IDE1cHggMTFweCIsInBvcnRyYWl0IjoiMTZweCAxNXB4IDExcHgiLCJwaG9uZSI6IjE2cHggMTVweCAxMXB4In0=",
                                "meta_padding1" => "eyJwaG9uZSI6IjE1cHggMThweCJ9",
                                "cat_bg_hover" => "#4db2ec",
                                "review_stars" => "#fff",
                                "image_size" => "",
                                "image_size2" => "td_324x400",
                                "image_width1" => "eyJwaG9uZSI6IjEwMCJ9",
                                "image_width2" => "eyJwaG9uZSI6IjgwIn0=",
                            ),

                            array(
                                'tdc_preset_name' => 'Font family',
                                'tdc_preset_class' => 'tdcp_separator tdcp_separator_font',
                            ),
                            array(
                                'tdc_preset_name' => '', // Font - Montserrat
                                'tdc_preset_class' => 'tdcp_img tdcp_font tdcp_font1',
                                'tdc_preset_individual' => '1',
                                "f_title1_font_family" =>        "394",
                                "f_title2_font_family" =>        "394",
                            ),
                            array(
                                'tdc_preset_name' => '', // Font - Source Serif
                                'tdc_preset_class' => 'tdcp_img tdcp_font tdcp_font2',
                                'tdc_preset_individual' =>      '1',
                                "f_title1_font_family" =>        "721",
                                "f_title2_font_family" =>        "721",
                            ),
                            array(
                                'tdc_preset_name' => '', // Font - Raleway
                                'tdc_preset_class' => 'tdcp_img tdcp_font tdcp_font3',
                                'tdc_preset_individual' => '1',
                                "f_title1_font_family" =>        "507",
                                "f_title2_font_family" =>        "507",
                            ),
                            array(
                                'tdc_preset_name' => '', // Font - Work Sans
                                'tdc_preset_class' => 'tdcp_img tdcp_font tdcp_font4',
                                'tdc_preset_individual' => '1',
                                "f_title1_font_family" =>        "653",
                                "f_title2_font_family" =>        "653",
                            ),
                            array(
                                'tdc_preset_name' => '', // Font - Courgette
                                'tdc_preset_class' => 'tdcp_img tdcp_font tdcp_font5',
                                'tdc_preset_individual' => '1',
                                "f_title1_font_family" =>        "147",
                                "f_title2_font_family" =>        "147",
                            ),
                            array(
                                'tdc_preset_name' => '', // Font - Oswald
                                'tdc_preset_class' => 'tdcp_img tdcp_font tdcp_font7',
                                'tdc_preset_individual' => '1',
                                "f_title1_font_family" =>        "445",
                                "f_title2_font_family" =>        "445",
                            ),
                            array(
                                'tdc_preset_name' => '', // Font - Muli
                                'tdc_preset_class' => 'tdcp_img tdcp_font tdcp_font8',
                                'tdc_preset_individual' => '1',
                                "f_title1_font_family" =>        "406",
                                "f_title2_font_family" =>        "406",
                            ),
                            array(
                                'tdc_preset_name' => '', // Font - Wendy One
                                'tdc_preset_class' => 'tdcp_img tdcp_font tdcp_font9',
                                'tdc_preset_individual' => '1',
                                "f_title1_font_family" =>        "646",
                                "f_title2_font_family" =>        "646",
                            ),
                            array(
                                'tdc_preset_name' => '', // Font - Anton
                                'tdc_preset_class' => 'tdcp_img tdcp_font tdcp_font10',
                                'tdc_preset_individual' => '1',
                                "f_title1_font_family" =>        "41",
                                "f_title2_font_family" =>        "41",
                            ),
                            array(
                                'tdc_preset_name' => '', // Font - Quicksand
                                'tdc_preset_class' => 'tdcp_img tdcp_font tdcp_font11',
                                'tdc_preset_individual' => '1',
                                "f_title1_font_family" =>        "502",
                                "f_title2_font_family" =>        "502",
                            ),
                            array(
                                'tdc_preset_name' => '', // Font - Libre Baskerville
                                'tdc_preset_class' => 'tdcp_img tdcp_font tdcp_font12',
                                'tdc_preset_individual' => '1',
                                "f_title1_font_family" =>        "331",
                                "f_title2_font_family" =>        "331",
                            ),
                            array(
                                'tdc_preset_name' => '', // Font - Caveat
                                'tdc_preset_class' => 'tdcp_img tdcp_font tdcp_font13',
                                'tdc_preset_individual' => '1',
                                "f_title1_font_family" =>        "663",
                                "f_title2_font_family" =>        "663",
                            ),
                            array(
                                'tdc_preset_name' => '', // Font - Volkorn
                                'tdc_preset_class' => 'tdcp_img tdcp_font tdcp_font14',
                                'tdc_preset_individual' => '1',
                                "f_title1_font_family" =>        "639",
                                "f_title2_font_family" =>        "639",
                            ),
                            array(
                                'tdc_preset_name' => '', // Font - Default
                                'tdc_preset_class' => 'tdcp_img tdcp_font tdcp_font6',
                                'tdc_preset_individual' => '1',
                                "f_title1_font_family" =>        "",
                                "f_title2_font_family" =>        "",
                            ),

                            array(
                                'tdc_preset_name' => 'Font size',
                                'tdc_preset_class' => 'tdcp_separator tdcp_separator_size',
                            ),
                            array(
                                'tdc_preset_name' => '', // Size - XS 13/13/12/14
                                'tdc_preset_class' => 'tdcp_img tdcp_size tdcp_size1',
                                'tdc_preset_individual' => '1',
                                "f_title1_font_size" => "eyJhbGwiOiIxMyIsInBvcnRyYWl0IjoiMTIiLCJwaG9uZSI6IjE0In0=",
                                "f_title1_font_line_height" => "1.3",
                                "f_title2_font_size" => "eyJhbGwiOiIxMyIsInBvcnRyYWl0IjoiMTIiLCJwaG9uZSI6IjE0In0=",
                                "f_title2_font_line_height" => "1.3",
                            ),
                            array(
                                'tdc_preset_name' => '', // Size - S 14/13/12/14
                                'tdc_preset_class' => 'tdcp_img tdcp_size tdcp_size2',
                                'tdc_preset_individual' => '1',
                                "f_title1_font_size" => "eyJhbGwiOiIxNCIsImxhbmRzY2FwZSI6IjEzIiwicG9ydHJhaXQiOiIxMiJ9",
                                "f_title1_font_line_height" => "1.4",
                                "f_title2_font_size" => "eyJhbGwiOiIxNCIsImxhbmRzY2FwZSI6IjEzIiwicG9ydHJhaXQiOiIxMiJ9",
                                "f_title2_font_line_height" => "1.4",
                            ),
                            array(
                                'tdc_preset_name' => '', // Size - M 21/21/17/21
                                'tdc_preset_class' => 'tdcp_img tdcp_size tdcp_size3',
                                'tdc_preset_individual' => '1',
                                "f_title1_font_size" => "eyJhbGwiOiIyMSIsImxhbmRzY2FwZSI6IjIwIiwicG9ydHJhaXQiOiIxNyJ9",
                                "f_title1_font_line_height" => "1.2",
                                "f_title2_font_size" => "eyJhbGwiOiIxNSIsInBvcnRyYWl0IjoiMTMifQ==",
                                "f_title2_font_line_height" => "1.3",
                            ),
                            array(
                                'tdc_preset_name' => '', // Size - L 26/25/21/21
                                'tdc_preset_class' => 'tdcp_img tdcp_size tdcp_size4',
                                'tdc_preset_individual' => '1',
                                "f_title1_font_size" => "eyJhbGwiOiIyNiIsImxhbmRzY2FwZSI6IjI1IiwicG9ydHJhaXQiOiIyMSIsInBob25lIjoiMjEifQ==",
                                "f_title1_font_line_height" => "1.2",
                                "f_title2_font_size" => "",
                                "f_title2_font_line_height" => "",

                            ),
                            array(
                                'tdc_preset_name' => '', // Size - XL 30/28/24/21
                                'tdc_preset_class' => 'tdcp_img tdcp_size tdcp_size5',
                                'tdc_preset_individual' => '1',
                                "f_title1_font_size" => "eyJhbGwiOiIzMCIsImxhbmRzY2FwZSI6IjI4IiwicG9ydHJhaXQiOiIyNCIsInBob25lIjoiMjEifQ==",
                                "f_title1_font_line_height" => "1.2",
                                "f_title2_font_size" => "",
                                "f_title2_font_line_height" => "",
                            ),
                            array(
                                'tdc_preset_name' => '', // Size - XXL 36/32/26/21
                                'tdc_preset_class' => 'tdcp_img tdcp_size tdcp_size6',
                                'tdc_preset_individual' => '1',
                                "f_title1_font_size" => "eyJhbGwiOiIzNiIsImxhbmRzY2FwZSI6IjMyIiwicGhvbmUiOiIyMSIsInBvcnRyYWl0IjoiMjYifQ==",
                                "f_title1_font_line_height" => "eyJhbGwiOiIxLjEiLCJwaG9uZSI6IjEuMiJ9",
                                "f_title2_font_size" => "eyJhbGwiOiIxOCIsImxhbmRzY2FwZSI6IjE3IiwicG9ydHJhaXQiOiIxNiIsInBob25lIjoiMTYifQ==",
                                "f_title2_font_line_height" => "1.3",
                            ),

                            array(
                                'tdc_preset_name' => 'Text horizontal alignment',
                                'tdc_preset_class' => 'tdcp_separator tdcp_separator_align',
                            ),
                            array(
                                'tdc_preset_name' => '', // Text alignment - left
                                'tdc_preset_class' => 'tdcp_img tdcp_align tdcp_align1',
                                'tdc_preset_individual' => '1',
                                "meta_info_horiz" => "content-horiz-left",
                            ),
                            array(
                                'tdc_preset_name' => '', // Text alignment - center
                                'tdc_preset_class' => 'tdcp_img tdcp_align tdcp_align2',
                                'tdc_preset_individual' => '1',
                                "meta_info_horiz" => "content-horiz-center",
                            ),
                            array(
                                'tdc_preset_name' => '', // Text alignment - right
                                'tdc_preset_class' => 'tdcp_img tdcp_align tdcp_align3',
                                'tdc_preset_individual' => '1',
                                "meta_info_horiz" => "content-horiz-right",
                            ),

                            array(
                                'tdc_preset_name' => 'Text vertical alignment',
                                'tdc_preset_class' => 'tdcp_separator tdcp_separator_align_v',
                            ),
                            array(
                                'tdc_preset_name' => '', // Text vertical alignment - top
                                'tdc_preset_class' => 'tdcp_img tdcp_align tdcp_align_v1',
                                'tdc_preset_individual' => '1',
                                "meta_info_vert" => "content-vert-top",
                            ),
                            array(
                                'tdc_preset_name' => '', // Text vertical alignment - middle
                                'tdc_preset_class' => 'tdcp_img tdcp_align tdcp_align_v2',
                                'tdc_preset_individual' => '1',
                                "meta_info_vert" => "content-vert-center",
                            ),
                            array(
                                'tdc_preset_name' => '', // Text vertical alignment - bottom
                                'tdc_preset_class' => 'tdcp_img tdcp_align tdcp_align_v3',
                                'tdc_preset_individual' => '1',
                                "meta_info_vert" => "content-vert-bottom",
                            ),

                            array(
                                'tdc_preset_name' => 'Style',
                                'tdc_preset_class' => 'tdcp_separator tdcp_separator_style',
                            ),
                            array(
                                'tdc_preset_name' => '', // Style 1 - default
                                'tdc_preset_class' => 'tdcp_img tdcp_style tdcp_style1',
                                'tdc_preset_individual' => '1',
                                "overlay_general" => "eyJ0eXBlIjoiZ3JhZGllbnQiLCJjb2xvcjEiOiJyZ2JhKDAsMCwwLDApIiwiY29sb3IyIjoicmdiYSgwLDAsMCwwLjcpIiwibWl4ZWRDb2xvcnMiOlt7ImNvbG9yIjoicmdiYSgwLDAsMCwwKSIsInBlcmNlbnRhZ2UiOjYwfV0sImNzcyI6ImJhY2tncm91bmQ6IC13ZWJraXQtbGluZWFyLWdyYWRpZW50KDBkZWcscmdiYSgwLDAsMCwwLjcpLHJnYmEoMCwwLDAsMCkgNjAlLHJnYmEoMCwwLDAsMCkpO2JhY2tncm91bmQ6IGxpbmVhci1ncmFkaWVudCgwZGVnLHJnYmEoMCwwLDAsMC43KSxyZ2JhKDAsMCwwLDApIDYwJSxyZ2JhKDAsMCwwLDApKTsiLCJjc3NQYXJhbXMiOiIwZGVnLHJnYmEoMCwwLDAsMC43KSxyZ2JhKDAsMCwwLDApIDYwJSxyZ2JhKDAsMCwwLDApIn0=",
                                "overlay_h_general" => "",
                                "overlay_1" => "",
                                "overlay_2" => "",
                                "overlay_3" => "",
                                "overlay_4" => "",
                                "lightsky" => "",
                            ),
                            array(
                                'tdc_preset_name' => '', // Style 2 - colors
                                'tdc_preset_class' => 'tdcp_img tdcp_style tdcp_style2',
                                'tdc_preset_individual' => '1',
                                "overlay_h_general" => "",
                                "overlay_1" => "eyJ0eXBlIjoiZ3JhZGllbnQiLCJjb2xvcjEiOiJyZ2JhKDc0LDE0Myw5NCwwLjYpIiwiY29sb3IyIjoicmdiYSg3NywxNzgsMjM2LDAuNikiLCJtaXhlZENvbG9ycyI6W10sImRlZ3JlZSI6IjQ1IiwiY3NzIjoiYmFja2dyb3VuZDogLXdlYmtpdC1saW5lYXItZ3JhZGllbnQoNDVkZWcscmdiYSg3NywxNzgsMjM2LDAuNikscmdiYSg3NCwxNDMsOTQsMC42KSk7YmFja2dyb3VuZDogbGluZWFyLWdyYWRpZW50KDQ1ZGVnLHJnYmEoNzcsMTc4LDIzNiwwLjYpLHJnYmEoNzQsMTQzLDk0LDAuNikpOyIsImNzc1BhcmFtcyI6IjQ1ZGVnLHJnYmEoNzcsMTc4LDIzNiwwLjYpLHJnYmEoNzQsMTQzLDk0LDAuNikifQ==",
                                "overlay_2" => "eyJ0eXBlIjoiZ3JhZGllbnQiLCJjb2xvcjEiOiJyZ2JhKDE5OCw1Nyw1NywwLjYpIiwiY29sb3IyIjoicmdiYSgyMDksMTE4LDcwLDAuNikiLCJtaXhlZENvbG9ycyI6W10sImRlZ3JlZSI6IjQ1IiwiY3NzIjoiYmFja2dyb3VuZDogLXdlYmtpdC1saW5lYXItZ3JhZGllbnQoNDVkZWcscmdiYSgyMDksMTE4LDcwLDAuNikscmdiYSgxOTgsNTcsNTcsMC42KSk7YmFja2dyb3VuZDogbGluZWFyLWdyYWRpZW50KDQ1ZGVnLHJnYmEoMjA5LDExOCw3MCwwLjYpLHJnYmEoMTk4LDU3LDU3LDAuNikpOyIsImNzc1BhcmFtcyI6IjQ1ZGVnLHJnYmEoMjA5LDExOCw3MCwwLjYpLHJnYmEoMTk4LDU3LDU3LDAuNikifQ==",
                                "overlay_3" => "eyJ0eXBlIjoiZ3JhZGllbnQiLCJjb2xvcjEiOiJyZ2JhKDU5LDEyMCwxODAsMC41OSkiLCJjb2xvcjIiOiJyZ2JhKDIxNSw5NiwxODMsMC42KSIsIm1peGVkQ29sb3JzIjpbXSwiZGVncmVlIjoiLTQ1IiwiY3NzIjoiYmFja2dyb3VuZDogLXdlYmtpdC1saW5lYXItZ3JhZGllbnQoLTQ1ZGVnLHJnYmEoMjE1LDk2LDE4MywwLjYpLHJnYmEoNTksMTIwLDE4MCwwLjU5KSk7YmFja2dyb3VuZDogbGluZWFyLWdyYWRpZW50KC00NWRlZyxyZ2JhKDIxNSw5NiwxODMsMC42KSxyZ2JhKDU5LDEyMCwxODAsMC41OSkpOyIsImNzc1BhcmFtcyI6Ii00NWRlZyxyZ2JhKDIxNSw5NiwxODMsMC42KSxyZ2JhKDU5LDEyMCwxODAsMC41OSkifQ==",
                                "overlay_4" => "eyJ0eXBlIjoiZ3JhZGllbnQiLCJjb2xvcjEiOiJyZ2JhKDI0MiwxMjIsNTMsMC42KSIsImNvbG9yMiI6InJnYmEoMjQ0LDIwOCw2MywwLjYpIiwibWl4ZWRDb2xvcnMiOltdLCJkZWdyZWUiOiItNDUiLCJjc3MiOiJiYWNrZ3JvdW5kOiAtd2Via2l0LWxpbmVhci1ncmFkaWVudCgtNDVkZWcscmdiYSgyNDQsMjA4LDYzLDAuNikscmdiYSgyNDIsMTIyLDUzLDAuNikpO2JhY2tncm91bmQ6IGxpbmVhci1ncmFkaWVudCgtNDVkZWcscmdiYSgyNDQsMjA4LDYzLDAuNikscmdiYSgyNDIsMTIyLDUzLDAuNikpOyIsImNzc1BhcmFtcyI6Ii00NWRlZyxyZ2JhKDI0NCwyMDgsNjMsMC42KSxyZ2JhKDI0MiwxMjIsNTMsMC42KSJ9",
                                "lightsky" => "",
                            ),
                            array(
                                'tdc_preset_name' => '', // Style 3 - flat colors
                                'tdc_preset_class' => 'tdcp_img tdcp_style tdcp_style3',
                                'tdc_preset_individual' => '1',
                                "overlay_h_general" => "",
                                "overlay_1" => "eyJ0eXBlIjoiZ3JhZGllbnQiLCJjb2xvcjEiOiJyZ2JhKDc0LDE0Myw5NCwwLjgpIiwiY29sb3IyIjoicmdiYSg3NywxNzgsMjM2LDAuOCkiLCJtaXhlZENvbG9ycyI6W10sImRlZ3JlZSI6IjQ1IiwiY3NzIjoiYmFja2dyb3VuZDogLXdlYmtpdC1saW5lYXItZ3JhZGllbnQoNDVkZWcscmdiYSg3NywxNzgsMjM2LDAuOCkscmdiYSg3NCwxNDMsOTQsMC44KSk7YmFja2dyb3VuZDogbGluZWFyLWdyYWRpZW50KDQ1ZGVnLHJnYmEoNzcsMTc4LDIzNiwwLjgpLHJnYmEoNzQsMTQzLDk0LDAuOCkpOyIsImNzc1BhcmFtcyI6IjQ1ZGVnLHJnYmEoNzcsMTc4LDIzNiwwLjgpLHJnYmEoNzQsMTQzLDk0LDAuOCkifQ==",
                                "overlay_2" => "eyJ0eXBlIjoiZ3JhZGllbnQiLCJjb2xvcjEiOiJyZ2JhKDE5OCw1Nyw1NywwLjgpIiwiY29sb3IyIjoicmdiYSgyMDksMTE4LDcwLDAuOCkiLCJtaXhlZENvbG9ycyI6W10sImRlZ3JlZSI6IjQ1IiwiY3NzIjoiYmFja2dyb3VuZDogLXdlYmtpdC1saW5lYXItZ3JhZGllbnQoNDVkZWcscmdiYSgyMDksMTE4LDcwLDAuOCkscmdiYSgxOTgsNTcsNTcsMC44KSk7YmFja2dyb3VuZDogbGluZWFyLWdyYWRpZW50KDQ1ZGVnLHJnYmEoMjA5LDExOCw3MCwwLjgpLHJnYmEoMTk4LDU3LDU3LDAuOCkpOyIsImNzc1BhcmFtcyI6IjQ1ZGVnLHJnYmEoMjA5LDExOCw3MCwwLjgpLHJnYmEoMTk4LDU3LDU3LDAuOCkifQ==",
                                "overlay_3" => "eyJ0eXBlIjoiZ3JhZGllbnQiLCJjb2xvcjEiOiJyZ2JhKDU5LDEyMCwxODAsMC44KSIsImNvbG9yMiI6InJnYmEoMjE1LDk2LDE4MywwLjgpIiwibWl4ZWRDb2xvcnMiOltdLCJkZWdyZWUiOiItNDUiLCJjc3MiOiJiYWNrZ3JvdW5kOiAtd2Via2l0LWxpbmVhci1ncmFkaWVudCgtNDVkZWcscmdiYSgyMTUsOTYsMTgzLDAuOCkscmdiYSg1OSwxMjAsMTgwLDAuOCkpO2JhY2tncm91bmQ6IGxpbmVhci1ncmFkaWVudCgtNDVkZWcscmdiYSgyMTUsOTYsMTgzLDAuOCkscmdiYSg1OSwxMjAsMTgwLDAuOCkpOyIsImNzc1BhcmFtcyI6Ii00NWRlZyxyZ2JhKDIxNSw5NiwxODMsMC44KSxyZ2JhKDU5LDEyMCwxODAsMC44KSJ9",
                                "overlay_4" => "eyJ0eXBlIjoiZ3JhZGllbnQiLCJjb2xvcjEiOiJyZ2JhKDI0MiwxMjIsNTMsMC44KSIsImNvbG9yMiI6InJnYmEoMjQ0LDIwOCw2MywwLjgpIiwibWl4ZWRDb2xvcnMiOltdLCJkZWdyZWUiOiItNDUiLCJjc3MiOiJiYWNrZ3JvdW5kOiAtd2Via2l0LWxpbmVhci1ncmFkaWVudCgtNDVkZWcscmdiYSgyNDQsMjA4LDYzLDAuOCkscmdiYSgyNDIsMTIyLDUzLDAuOCkpO2JhY2tncm91bmQ6IGxpbmVhci1ncmFkaWVudCgtNDVkZWcscmdiYSgyNDQsMjA4LDYzLDAuOCkscmdiYSgyNDIsMTIyLDUzLDAuOCkpOyIsImNzc1BhcmFtcyI6Ii00NWRlZyxyZ2JhKDI0NCwyMDgsNjMsMC44KSxyZ2JhKDI0MiwxMjIsNTMsMC44KSJ9",
                                "lightsky" => "",
                            ),
                            array(
                                'tdc_preset_name' => '', // Style 4 - light sky
                                'tdc_preset_class' => 'tdcp_img tdcp_style tdcp_style4',
                                'tdc_preset_individual' => '1',
                                "overlay_general" => "rgba(0,0,0,0.7)",
                                "overlay_h_general" => "rgba(77,178,236,0.3)",
                                "overlay_1" => "",
                                "overlay_2" => "",
                                "overlay_3" => "",
                                "overlay_4" => "",
                                "lightsky" => "yes",
                            ),
                            array(
                                'tdc_preset_name' => '', // Style 5 - rainbow
                                'tdc_preset_class' => 'tdcp_img tdcp_style tdcp_style5',
                                'tdc_preset_individual' => '1',
                                "overlay_h_general" => "",
                                "overlay_1" => "eyJ0eXBlIjoiZ3JhZGllbnQiLCJjb2xvcjEiOiJyZ2JhKDI1NSwxMTEsNDksMC42KSIsImNvbG9yMiI6InJnYmEoNjUsMTIsMTg4LDAuNikiLCJtaXhlZENvbG9ycyI6W10sImRlZ3JlZSI6IjIwIiwiY3NzIjoiYmFja2dyb3VuZDogLXdlYmtpdC1saW5lYXItZ3JhZGllbnQoMjBkZWcscmdiYSg2NSwxMiwxODgsMC42KSxyZ2JhKDI1NSwxMTEsNDksMC42KSk7YmFja2dyb3VuZDogbGluZWFyLWdyYWRpZW50KDIwZGVnLHJnYmEoNjUsMTIsMTg4LDAuNikscmdiYSgyNTUsMTExLDQ5LDAuNikpOyIsImNzc1BhcmFtcyI6IjIwZGVnLHJnYmEoNjUsMTIsMTg4LDAuNikscmdiYSgyNTUsMTExLDQ5LDAuNikifQ==",
                                "overlay_2" => "eyJ0eXBlIjoiZ3JhZGllbnQiLCJjb2xvcjEiOiJyZ2JhKDExMiwyNTUsMTUzLDAuNikiLCJjb2xvcjIiOiJyZ2JhKDI0NCwxMzYsMTMsMC42KSIsIm1peGVkQ29sb3JzIjpbXSwiZGVncmVlIjoiMjAiLCJjc3MiOiJiYWNrZ3JvdW5kOiAtd2Via2l0LWxpbmVhci1ncmFkaWVudCgyMGRlZyxyZ2JhKDI0NCwxMzYsMTMsMC42KSxyZ2JhKDExMiwyNTUsMTUzLDAuNikpO2JhY2tncm91bmQ6IGxpbmVhci1ncmFkaWVudCgyMGRlZyxyZ2JhKDI0NCwxMzYsMTMsMC42KSxyZ2JhKDExMiwyNTUsMTUzLDAuNikpOyIsImNzc1BhcmFtcyI6IjIwZGVnLHJnYmEoMjQ0LDEzNiwxMywwLjYpLHJnYmEoMTEyLDI1NSwxNTMsMC42KSJ9",
                                "overlay_3" => "eyJ0eXBlIjoiZ3JhZGllbnQiLCJjb2xvcjEiOiJyZ2JhKDEyNiwxOTEsMjU1LDAuNikiLCJjb2xvcjIiOiJyZ2JhKDE5NiwxNSwxMjEsMC42KSIsIm1peGVkQ29sb3JzIjpbXSwiZGVncmVlIjoiMjAiLCJjc3MiOiJiYWNrZ3JvdW5kOiAtd2Via2l0LWxpbmVhci1ncmFkaWVudCgyMGRlZyxyZ2JhKDE5NiwxNSwxMjEsMC42KSxyZ2JhKDEyNiwxOTEsMjU1LDAuNikpO2JhY2tncm91bmQ6IGxpbmVhci1ncmFkaWVudCgyMGRlZyxyZ2JhKDE5NiwxNSwxMjEsMC42KSxyZ2JhKDEyNiwxOTEsMjU1LDAuNikpOyIsImNzc1BhcmFtcyI6IjIwZGVnLHJnYmEoMTk2LDE1LDEyMSwwLjYpLHJnYmEoMTI2LDE5MSwyNTUsMC42KSJ9",
                                "overlay_4" => "eyJ0eXBlIjoiZ3JhZGllbnQiLCJjb2xvcjEiOiJyZ2JhKDQyLDIzNiwxMTYsMC42KSIsImNvbG9yMiI6InJnYmEoMCwyMiwxOTAsMC42KSIsIm1peGVkQ29sb3JzIjpbXSwiZGVncmVlIjoiMjAiLCJjc3MiOiJiYWNrZ3JvdW5kOiAtd2Via2l0LWxpbmVhci1ncmFkaWVudCgyMGRlZyxyZ2JhKDAsMjIsMTkwLDAuNikscmdiYSg0MiwyMzYsMTE2LDAuNikpO2JhY2tncm91bmQ6IGxpbmVhci1ncmFkaWVudCgyMGRlZyxyZ2JhKDAsMjIsMTkwLDAuNikscmdiYSg0MiwyMzYsMTE2LDAuNikpOyIsImNzc1BhcmFtcyI6IjIwZGVnLHJnYmEoMCwyMiwxOTAsMC42KSxyZ2JhKDQyLDIzNiwxMTYsMC42KSJ9",
                                "lightsky" => "",
                            ),
                        )
                    )
                ),
                "params" => array_merge(
                    array(
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Content length',
                            "value"      => "",
                            "class"      => "",
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Module Flex 6',
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                        ),
                        array(
                            "param_name"  => "mf6_tl",
                            "type"        => "textfield",
                            "value"       => '',
                            "heading"     => 'Title length',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-small",
                            "placeholder" => '25',
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Module Flex 7',
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                        ),
                        array(
                            "param_name"  => "mf7_tl",
                            "type"        => "textfield",
                            "value"       => '',
                            "heading"     => 'Title length',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-small",
                            "placeholder" => '25',
                        ),
                    ),
                    self::td_block_big_grid_params(),
                    array(
                        array(
                            "param_name"  => "modules_gap",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Modules gap',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-small",
                            "placeholder" => "4",
                            "group"       => "Layout",
                        ),
                        array(
                            "param_name" => "meta_info_horiz",
                            "type" => "dropdown",
                            "value" => array(
                                'Left' => 'content-horiz-left',
                                'Center' => 'content-horiz-center',
                                'Right' => 'content-horiz-right'
                            ),
                            "heading" => 'Meta info horiz align',
                            "description" => "",
                            "holder" => "div",
                            'tdc_dropdown_images' => true,
                            "class" => "tdc-visual-selector tdc-add-class",
                            "group"       => "Layout",
                        ),
                        array(
                            "param_name" => "meta_info_vert",
                            "type" => "dropdown",
                            "value" => array(
                                'Left' => 'content-vert-top',
                                'Center' => 'content-vert-center',
                                'Right' => 'content-vert-bottom'
                            ),
                            "heading" => 'Meta info vert align',
                            "description" => "",
                            "holder" => "div",
                            'tdc_dropdown_images' => true,
                            "class" => "tdc-visual-selector tdc-add-class",
                            "group"       => "Layout",
                        ),
                        array(
                            "param_name"  => "image_zoom",
                            "type"        => "checkbox",
                            "value"       => '',
                            "heading"     => "Zoom effect on hover",
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "",
                            "group"       => 'Layout'
                        ),
                        array(
                            "param_name"  => "modules_category",
                            "type"        => "dropdown",
                            "value"       => array(
                                'Inline'      => '',
                                'Above title' => 'above',
                            ),
                            "heading"     => 'Category tag position',
                            "description" => "Float image",
                            "holder"      => "div",
                            "class"       => "tdc-dropdown-big",
                            "group"       => "Layout",
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Module Category Grid 1',
                            "value"      => "",
                            "class"      => "",
                            "group"      => "Layout",
                        ),
                        array(
                            "param_name"  => "image_size",
                            "type"        => "dropdown",
                            "value"       => array(
                                'XSmall - 324px' => 'td_324x400',
                                'Small - 696px'  => '',
                                'Large - 1068px' => 'td_1068x0',
                                'Full - 1920px'  => 'td_1920x0'
                            ),
                            "heading"     => 'Image size',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-dropdown-big",
                            "group"       => "Layout",
                        ),
                        array(
                            'param_name'  => 'image_alignment1',
                            'type'        => 'range-responsive',
                            'value'       => '50',
                            'heading'     => 'Image V alignment',
                            'description' => '0 - Top / 50 - Center / 100 - Bottom',
                            'class'       => 'tdc-textfield-small',
                            'range_min'   => '0',
                            'range_max'   => '100',
                            'range_step'  => '1',
                            "group"       => "Layout",
                        ),
                        array(
                            "param_name"  => "image_width1",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Image width (percent)',
                            "description" => "Default value in percent",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-small",
                            "placeholder" => "70",
                            "group"       => "Layout",
                        ),
                        array(
                            "param_name"  => "image_height1",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Image height (percent)',
                            "description" => "Default value in percent",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-small",
                            "placeholder" => "482px",
                            "group"       => "Layout",
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "horizontal_separator",
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                            "group"      => "Layout",
                        ),
                        array(
                            "param_name"  => "meta_width1",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Meta info width',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-small",
                            "placeholder" => "100%",
                            "group"       => "Layout",
                        ),
                        array(
                            "param_name"  => "meta_margin1",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Meta info margin',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-big",
                            "placeholder" => "0px 0px 0px 0px",
                            "group"       => "Layout",
                        ),
                        array(
                            "param_name"  => "meta_padding1",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Meta info padding',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-big",
                            "placeholder" => "22px 20px",
                            "group"       => "Layout",
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "horizontal_separator",
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                            "group"      => "Layout",
                        ),
                        array(
                            "param_name"  => "art_title1",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Article title space',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-big",
                            "placeholder" => "0px 0px 9px 0px",
                            "group"       => "Layout",
                        ),
                        array(
                            "param_name"  => "art_title_padd1",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Article title padding',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-big",
                            "placeholder" => "0px 0px 0px 0px",
                            "group"       => "Layout",
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "horizontal_separator",
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                            "group"      => "Layout",
                        ),
                        array(
                            "param_name"  => "modules_category_margin1",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Category tag spacing',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-big",
                            "placeholder" => "0px 0px 5px 0px",
                            "group"       => "Layout",
                        ),
                        array(
                            "param_name"  => "modules_category_padding1",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Category tag padding',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-big",
                            "placeholder" => "3px 6px 3px 6px",
                            "group"       => "Layout",
                        ),
                        array(
                            "param_name"  => "show_cat1",
                            "type"        => "dropdown-responsive",
                            "value"       => array(
                                'Show' => 'inline-block',
                                'Hide' => 'none',
                            ),
                            "heading"     => 'Show category',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-dropdown-big",
                            "group"       => "Layout",
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "horizontal_separator",
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                            "group"      => "Layout",
                        ),
                        array(
                            "param_name"  => "show_author1",
                            "type"        => "dropdown-responsive",
                            "value"       => array(
                                'Show' => 'inline-block',
                                'Hide' => 'none',
                            ),
                            "heading"     => 'Show author',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-dropdown-big",
                            "group"       => "Layout",
                        ),
                        array(
                            "param_name"  => "show_date1",
                            "type"        => "dropdown-responsive",
                            "value"       => array(
                                'Show' => 'inline-block',
                                'Hide' => 'none',
                            ),
                            "heading"     => 'Show date',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-dropdown-big",
                            "group"       => "Layout",
                        ),
                        array(
                            "param_name"  => "auth_date_padding1",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Author & date padding',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-big",
                            "placeholder" => "0px 0px 0px 0px",
                            "group"       => "Layout",
                        ),

                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Module Category Grid 2',
                            "value"      => "",
                            "class"      => "",
                            "group"      => "Layout",
                        ),
                        array(
                            "param_name"  => "image_size2",
                            "type"        => "dropdown",
                            "value"       => array(
                                'XSmall - 324px' => 'td_324x400',
                                'Small - 696px'  => '',
                                'Large - 1068px' => 'td_1068x0',
                                'Full - 1920px'  => 'td_1920x0'
                            ),
                            "heading"     => 'Image size',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-dropdown-big",
                            "group"       => "Layout",
                        ),
                        array(
                            'param_name'  => 'image_alignment2',
                            'type'        => 'range-responsive',
                            'value'       => '50',
                            'heading'     => 'Image V alignment',
                            'description' => '0 - Top / 50 - Center / 100 - Bottom',
                            'class'       => 'tdc-textfield-small',
                            'range_min'   => '0',
                            'range_max'   => '100',
                            'range_step'  => '1',
                            "group"       => "Layout",
                        ),
                        array(
                            "param_name"  => "image_width2",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Image width (percent)',
                            "description" => "Default value in percent",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-small",
                            "placeholder" => "30",
                            "group"       => "Layout",
                        ),
                        array(
                            "param_name"  => "image_height2",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Image height (percent)',
                            "description" => "Default value in percent",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-small",
                            "placeholder" => "158px",
                            "group"       => "Layout",
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "horizontal_separator",
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                            "group"      => "Layout",
                        ),
                        array(
                            "param_name"  => "meta_width2",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Meta info width',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-small",
                            "placeholder" => "100%",
                            "group"       => "Layout",
                        ),
                        array(
                            "param_name"  => "meta_margin2",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Meta info margin',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-big",
                            "placeholder" => "0px 0px 0px 0px",
                            "group"       => "Layout",
                        ),
                        array(
                            "param_name"  => "meta_padding2",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Meta info padding',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-big",
                            "placeholder" => "11px 15px",
                            "group"       => "Layout",
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "horizontal_separator",
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                            "group"      => "Layout",
                        ),
                        array(
                            "param_name"  => "art_title2",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Article title space',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-big",
                            "placeholder" => "0px 0px 9px 0px",
                            "group"       => "Layout",
                        ),
                        array(
                            "param_name"  => "art_title_padd2",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Article title padding',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-big",
                            "placeholder" => "0px 0px 0px 0px",
                            "group"       => "Layout",
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "horizontal_separator",
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                            "group"      => "Layout",
                        ),
                        array(
                            "param_name"  => "modules_category_margin2",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Category tag spacing',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-big",
                            "placeholder" => "0px 0px 7px 0px",
                            "group"       => "Layout",
                        ),
                        array(
                            "param_name"  => "modules_category_padding2",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Category tag padding',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-big",
                            "placeholder" => "3px 6px 3px 6px",
                            "group"       => "Layout",
                        ),
                        array(
                            "param_name"  => "show_cat2",
                            "type"        => "dropdown-responsive",
                            "value"       => array(
                                'Show' => 'inline-block',
                                'Hide' => 'none',
                            ),
                            "heading"     => 'Show category',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-dropdown-big",
                            "group"       => "Layout",
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "horizontal_separator",
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                            "group"      => "Layout",
                        ),
                        array(
                            "param_name"  => "show_author2",
                            "type"        => "dropdown-responsive",
                            "value"       => array(
                                'Show' => 'inline-block',
                                'Hide' => 'none',
                            ),
                            "heading"     => 'Show author',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-dropdown-big",
                            "group"       => "Layout",
                        ),
                        array(
                            "param_name"  => "show_date2",
                            "type"        => "dropdown-responsive",
                            "value"       => array(
                                'Show' => 'inline-block',
                                'Hide' => 'none',
                            ),
                            "heading"     => 'Show date',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-dropdown-big",
                            "group"       => "Layout",
                        ),
                        array(
                            "param_name"  => "auth_date_padding2",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Author & date padding',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-big",
                            "placeholder" => "0px 0px 0px 0px",
                            "group"       => "Layout",
                        ),
                        array(
                            "param_name" => "separator",
                            "type" => "text_separator",
                            'heading' => 'Module fonts',
                            "value" => "",
                            "class" => "",
                            "group" => 'Style',
                        ),
                    ),
                    td_config_helper::get_map_block_font_array( 'f_title1', true, 'Module 1 title', 'Style' ),
                    td_config_helper::get_map_block_font_array( 'f_cat1', false, 'Module 1 category tag', 'Style' ),
                    td_config_helper::get_map_block_font_array( 'f_meta1', false, 'Module 1 meta info', 'Style' ),
                    td_config_helper::get_map_block_font_array( 'f_title2', false, 'Module 2 title', 'Style' ),
                    td_config_helper::get_map_block_font_array( 'f_cat2', false, 'Module 2 category tag', 'Style' ),
                    td_config_helper::get_map_block_font_array( 'f_meta2', false, 'Module 2 meta info', 'Style' ),
                    array(
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Colors',
                            "value"      => "",
                            "class"      => "",
                            "group"      => "Style",
                        ),
                        array(
                            "param_name" => "overlay_general",
                            "holder" => "div",
                            "type" => "gradient",
                            'heading' => "General module overlay color",
                            "value" => "",
                            "class" => "",
                            "group"      => "Style",
                        ),
                        array(
                            "param_name" => "overlay_h_general",
                            "holder" => "div",
                            "type" => "gradient",
                            'heading' => "General module overlay hover color",
                            "value" => "",
                            "class" => "",
                            "group"      => "Style",
                        ),
                        array(
                            "param_name" => "overlay_1",
                            "holder" => "div",
                            "type" => "gradient",
                            'heading' => "Module overlay color 1",
                            "value" => "",
                            "class" => "",
                            "group"      => "Style",
                        ),
                        array(
                            "param_name" => "overlay_2",
                            "holder" => "div",
                            "type" => "gradient",
                            'heading' => "Module overlay color 2",
                            "value" => "",
                            "class" => "",
                            "group"      => "Style",
                        ),
                        array(
                            "param_name" => "overlay_3",
                            "holder" => "div",
                            "type" => "gradient",
                            'heading' => "Module overlay color 3",
                            "value" => "",
                            "class" => "",
                            "group"      => "Style",
                        ),
                        array(
                            "param_name" => "overlay_4",
                            "holder" => "div",
                            "type" => "gradient",
                            'heading' => "Module overlay color 4",
                            "value" => "",
                            "class" => "",
                            "group"      => "Style",
                        ),
                        array(
                            "param_name"  => "lightsky",
                            "type"        => "checkbox",
                            "value"       => '',
                            "heading"     => "Lightsky",
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "",
                            "group"       => 'Style'
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "",
                            "heading"     => 'Meta info background',
                            "param_name"  => "meta_bg",
                            "value"       => '',
                            "description" => '',
                            "group"       => 'Style',
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "horizontal_separator",
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                            "group"      => "Style",
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "",
                            "heading"     => 'Article title text color',
                            "param_name"  => "title_txt",
                            "value"       => '',
                            "description" => '',
                            "group"       => 'Style',
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "",
                            "heading"     => 'Article title text hover',
                            "param_name"  => "title_txt_hover",
                            "value"       => '',
                            "description" => '',
                            "group"       => 'Style',
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "",
                            "heading"     => 'Article title background color',
                            "param_name"  => "title_bg",
                            "value"       => '',
                            "description" => '',
                            "group"       => 'Style',
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "horizontal_separator",
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                            "group"      => "Style",
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "",
                            "heading"     => 'Category background',
                            "param_name"  => "cat_bg",
                            "value"       => '',
                            "description" => '',
                            "group"       => 'Style',
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "",
                            "heading"     => 'Category text color',
                            "param_name"  => "cat_txt",
                            "value"       => '',
                            "description" => '',
                            "group"       => 'Style',
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "",
                            "heading"     => 'Category background hover',
                            "param_name"  => "cat_bg_hover",
                            "value"       => '',
                            "description" => '',
                            "group"       => 'Style',
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "",
                            "heading"     => 'Category text hover',
                            "param_name"  => "cat_txt_hover",
                            "value"       => '',
                            "description" => '',
                            "group"       => 'Style',
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "horizontal_separator",
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                            "group"      => "Style",
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "",
                            "heading"     => 'Author text color',
                            "param_name"  => "author_txt",
                            "value"       => '',
                            "description" => '',
                            "group"       => 'Style',
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "",
                            "heading"     => 'Author text hover',
                            "param_name"  => "author_txt_hover",
                            "value"       => '',
                            "description" => '',
                            "group"       => 'Style',
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "",
                            "heading"     => 'Date text color',
                            "param_name"  => "date_txt",
                            "value"       => '',
                            "description" => '',
                            "group"       => 'Style',
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "",
                            "heading"     => 'Author & date background color',
                            "param_name"  => "auth_date_bg",
                            "value"       => '',
                            "description" => '',
                            "group"       => 'Style',
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "",
                            "heading"     => 'Review stars color',
                            "param_name"  => "review_stars",
                            "value"       => '',
                            "description" => '',
                            "group"       => 'Style',
                        ),
                    ),
                    self::get_map_css_tab()
                )
            )
        );

        td_api_block::add('td_block_big_grid_flex_4',
            array(
                'map_in_visual_composer' => false,
                'map_in_td_composer' => true,
                "name" => 'Big Grid Flex 4',
                "base" => 'td_block_big_grid_flex_4',
                "class" => 'td_block_big_grid_flex_4',
                "controls" => "full",
                "category" => 'Blocks',
                'tdc_category' => 'Big Grids',
                'icon' => 'icon-pagebuilder-td_block_big_grid_flex_4',
                'file' => td_global::$get_template_directory . '/includes/shortcodes/td_block_big_grid_flex_4.php',
                'tdc_style_params' => array(
                    'custom_title',
                    'custom_url',
                    'post_ids',
                    'category_id',
                    'category_ids',
                    'tag_slug',
                    'autors_id',
                    'installed_post_types',
                    'sort',
                    'offset',
                    'el_class'
                ),
                'tdc_start_values' => base64_encode(
                    json_encode(
                        array(
                            array(
                                "meta_info_vert" => "content-vert-bottom",
                                "image_zoom" => "yes",
                                "show_author2" => "none",
                                "show_date2" => "none",
                                "modules_category" => "above",
                                "overlay_general" => "eyJ0eXBlIjoiZ3JhZGllbnQiLCJjb2xvcjEiOiJyZ2JhKDAsMCwwLDApIiwiY29sb3IyIjoicmdiYSgwLDAsMCwwLjcpIiwibWl4ZWRDb2xvcnMiOlt7ImNvbG9yIjoicmdiYSgwLDAsMCwwKSIsInBlcmNlbnRhZ2UiOjYwfV0sImNzcyI6ImJhY2tncm91bmQ6IC13ZWJraXQtbGluZWFyLWdyYWRpZW50KDBkZWcscmdiYSgwLDAsMCwwLjcpLHJnYmEoMCwwLDAsMCkgNjAlLHJnYmEoMCwwLDAsMCkpO2JhY2tncm91bmQ6IGxpbmVhci1ncmFkaWVudCgwZGVnLHJnYmEoMCwwLDAsMC43KSxyZ2JhKDAsMCwwLDApIDYwJSxyZ2JhKDAsMCwwLDApKTsiLCJjc3NQYXJhbXMiOiIwZGVnLHJnYmEoMCwwLDAsMC43KSxyZ2JhKDAsMCwwLDApIDYwJSxyZ2JhKDAsMCwwLDApIn0=",
                                "image_height2" => "eyJwaG9uZSI6IjE0MHB4IiwicG9ydHJhaXQiOiIxNTBweCIsImxhbmRzY2FwZSI6IjIwMHB4In0=",
                                "image_height1" => "eyJwaG9uZSI6IjI2MHB4IiwibGFuZHNjYXBlIjoiNDEwcHgiLCJwb3J0cmFpdCI6IjMxMHB4In0=",
                                "modules_gap" => "eyJwaG9uZSI6IjMifQ==",
                                "meta_padding2" => "eyJwaG9uZSI6IjE2cHggMTVweCAxMXB4IiwicG9ydHJhaXQiOiIxMXB4IDEwcHggNnB4In0=",
                                "meta_padding1" => "eyJwaG9uZSI6IjE1cHggMThweCIsInBvcnRyYWl0IjoiMjJweCAxMHB4In0=",
                                "cat_bg_hover" => "#4db2ec",
                                "review_stars" => "#fff",
                                "modules_category_margin2" => "eyJwb3J0cmFpdCI6IjBweCAwcHggNHB4IDBweCJ9",
                                "modules_category_margin1" => "eyJwb3J0cmFpdCI6IjBweCAwcHggN3B4IDBweCJ9",
                                "art_title1" => "eyJwb3J0cmFpdCI6IjBweCAwcHggNnB4IDBweCJ9",
                                "image_width1" => "eyJwaG9uZSI6IjEwMCJ9",
                                "image_size" => "",
                                "image_size2" => ""
                            ),

                            array(
                                'tdc_preset_name' => 'Font family',
                                'tdc_preset_class' => 'tdcp_separator tdcp_separator_font',
                            ),
                            array(
                                'tdc_preset_name' => '', // Font - Montserrat
                                'tdc_preset_class' => 'tdcp_img tdcp_font tdcp_font1',
                                'tdc_preset_individual' => '1',
                                "f_title1_font_family" =>        "394",
                                "f_title2_font_family" =>        "394",
                            ),
                            array(
                                'tdc_preset_name' => '', // Font - Source Serif
                                'tdc_preset_class' => 'tdcp_img tdcp_font tdcp_font2',
                                'tdc_preset_individual' =>      '1',
                                "f_title1_font_family" =>        "721",
                                "f_title2_font_family" =>        "721",
                            ),
                            array(
                                'tdc_preset_name' => '', // Font - Raleway
                                'tdc_preset_class' => 'tdcp_img tdcp_font tdcp_font3',
                                'tdc_preset_individual' => '1',
                                "f_title1_font_family" =>        "507",
                                "f_title2_font_family" =>        "507",
                            ),
                            array(
                                'tdc_preset_name' => '', // Font - Work Sans
                                'tdc_preset_class' => 'tdcp_img tdcp_font tdcp_font4',
                                'tdc_preset_individual' => '1',
                                "f_title1_font_family" =>        "653",
                                "f_title2_font_family" =>        "653",
                            ),
                            array(
                                'tdc_preset_name' => '', // Font - Courgette
                                'tdc_preset_class' => 'tdcp_img tdcp_font tdcp_font5',
                                'tdc_preset_individual' => '1',
                                "f_title1_font_family" =>        "147",
                                "f_title2_font_family" =>        "147",
                            ),
                            array(
                                'tdc_preset_name' => '', // Font - Oswald
                                'tdc_preset_class' => 'tdcp_img tdcp_font tdcp_font7',
                                'tdc_preset_individual' => '1',
                                "f_title1_font_family" =>        "445",
                                "f_title2_font_family" =>        "445",
                            ),
                            array(
                                'tdc_preset_name' => '', // Font - Muli
                                'tdc_preset_class' => 'tdcp_img tdcp_font tdcp_font8',
                                'tdc_preset_individual' => '1',
                                "f_title1_font_family" =>        "406",
                                "f_title2_font_family" =>        "406",
                            ),
                            array(
                                'tdc_preset_name' => '', // Font - Wendy One
                                'tdc_preset_class' => 'tdcp_img tdcp_font tdcp_font9',
                                'tdc_preset_individual' => '1',
                                "f_title1_font_family" =>        "646",
                                "f_title2_font_family" =>        "646",
                            ),
                            array(
                                'tdc_preset_name' => '', // Font - Anton
                                'tdc_preset_class' => 'tdcp_img tdcp_font tdcp_font10',
                                'tdc_preset_individual' => '1',
                                "f_title1_font_family" =>        "41",
                                "f_title2_font_family" =>        "41",
                            ),
                            array(
                                'tdc_preset_name' => '', // Font - Quicksand
                                'tdc_preset_class' => 'tdcp_img tdcp_font tdcp_font11',
                                'tdc_preset_individual' => '1',
                                "f_title1_font_family" =>        "502",
                                "f_title2_font_family" =>        "502",
                            ),
                            array(
                                'tdc_preset_name' => '', // Font - Libre Baskerville
                                'tdc_preset_class' => 'tdcp_img tdcp_font tdcp_font12',
                                'tdc_preset_individual' => '1',
                                "f_title1_font_family" =>        "331",
                                "f_title2_font_family" =>        "331",
                            ),
                            array(
                                'tdc_preset_name' => '', // Font - Caveat
                                'tdc_preset_class' => 'tdcp_img tdcp_font tdcp_font13',
                                'tdc_preset_individual' => '1',
                                "f_title1_font_family" =>        "663",
                                "f_title2_font_family" =>        "663",
                            ),
                            array(
                                'tdc_preset_name' => '', // Font - Volkorn
                                'tdc_preset_class' => 'tdcp_img tdcp_font tdcp_font14',
                                'tdc_preset_individual' => '1',
                                "f_title1_font_family" =>        "639",
                                "f_title2_font_family" =>        "639",
                            ),
                            array(
                                'tdc_preset_name' => '', // Font - Default
                                'tdc_preset_class' => 'tdcp_img tdcp_font tdcp_font6',
                                'tdc_preset_individual' => '1',
                                "f_title1_font_family" =>        "",
                                "f_title2_font_family" =>        "",
                            ),

                            array(
                                'tdc_preset_name' => 'Font size',
                                'tdc_preset_class' => 'tdcp_separator tdcp_separator_size',
                            ),
                            array(
                                'tdc_preset_name' => '', // Size - XS 13/13/12/14
                                'tdc_preset_class' => 'tdcp_img tdcp_size tdcp_size1',
                                'tdc_preset_individual' => '1',
                                "f_title1_font_size" => "eyJhbGwiOiIxNiIsInBvcnRyYWl0IjoiMTQifQ==",
                                "f_title1_font_line_height" => "1.3",
                                "f_title2_font_size" => "eyJhbGwiOiIxNiIsInBvcnRyYWl0IjoiMTQifQ==",
                                "f_title2_font_line_height" => "1.3",
                            ),
                            array(
                                'tdc_preset_name' => '', // Size - S 14/13/12/14
                                'tdc_preset_class' => 'tdcp_img tdcp_size tdcp_size2',
                                'tdc_preset_individual' => '1',
                                "f_title1_font_size" => "eyJhbGwiOiIxOCIsInBvcnRyYWl0IjoiMTYifQ==",
                                "f_title1_font_line_height" => "1.4",
                                "f_title2_font_size" => "eyJhbGwiOiIxNiIsInBvcnRyYWl0IjoiMTQifQ==",
                                "f_title2_font_line_height" => "1.3",
                            ),
                            array(
                                'tdc_preset_name' => '', // Size - M 21/21/17/21
                                'tdc_preset_class' => 'tdcp_img tdcp_size tdcp_size3',
                                'tdc_preset_individual' => '1',
                                "f_title1_font_size" => "eyJhbGwiOiIyNCIsInBvcnRyYWl0IjoiMjIifQ==",
                                "f_title1_font_line_height" => "1.2",
                                "f_title2_font_size" => "eyJhbGwiOiIyMCIsInBvcnRyYWl0IjoiMTYiLCJwaG9uZSI6IjE0In0=",
                                "f_title2_font_line_height" => "1.2",
                            ),
                            array(
                                'tdc_preset_name' => '', // Size - L 26/25/21/21
                                'tdc_preset_class' => 'tdcp_img tdcp_size tdcp_size4',
                                'tdc_preset_individual' => '1',
                                "f_title1_font_size" => "",
                                "f_title1_font_line_height" => "",
                                "f_title2_font_size" => "",
                                "f_title2_font_line_height" => "",

                            ),
                            array(
                                'tdc_preset_name' => '', // Size - XL 30/28/24/21
                                'tdc_preset_class' => 'tdcp_img tdcp_size tdcp_size5',
                                'tdc_preset_individual' => '1',
                                "f_title1_font_size" => "eyJhbGwiOiIzMCIsImxhbmRzY2FwZSI6IjI4IiwicG9ydHJhaXQiOiIyNCIsInBob25lIjoiMjEifQ==",
                                "f_title1_font_line_height" => "1.2",
                                "f_title2_font_size" => "",
                                "f_title2_font_line_height" => "",
                            ),
                            array(
                                'tdc_preset_name' => '', // Size - XXL 36/32/26/21
                                'tdc_preset_class' => 'tdcp_img tdcp_size tdcp_size6',
                                'tdc_preset_individual' => '1',
                                "f_title1_font_size" => "eyJhbGwiOiIzNiIsImxhbmRzY2FwZSI6IjMyIiwicGhvbmUiOiIyMSIsInBvcnRyYWl0IjoiMjYifQ==",
                                "f_title1_font_line_height" => "eyJhbGwiOiIxLjEiLCJwaG9uZSI6IjEuMiJ9",
                                "f_title2_font_size" => "",
                                "f_title2_font_line_height" => "",
                            ),

                            array(
                                'tdc_preset_name' => 'Text horizontal alignment',
                                'tdc_preset_class' => 'tdcp_separator tdcp_separator_align',
                            ),
                            array(
                                'tdc_preset_name' => '', // Text alignment - left
                                'tdc_preset_class' => 'tdcp_img tdcp_align tdcp_align1',
                                'tdc_preset_individual' => '1',
                                "meta_info_horiz" => "content-horiz-left",
                            ),
                            array(
                                'tdc_preset_name' => '', // Text alignment - center
                                'tdc_preset_class' => 'tdcp_img tdcp_align tdcp_align2',
                                'tdc_preset_individual' => '1',
                                "meta_info_horiz" => "content-horiz-center",
                            ),
                            array(
                                'tdc_preset_name' => '', // Text alignment - right
                                'tdc_preset_class' => 'tdcp_img tdcp_align tdcp_align3',
                                'tdc_preset_individual' => '1',
                                "meta_info_horiz" => "content-horiz-right",
                            ),

                            array(
                                'tdc_preset_name' => 'Text vertical alignment',
                                'tdc_preset_class' => 'tdcp_separator tdcp_separator_align_v',
                            ),
                            array(
                                'tdc_preset_name' => '', // Text vertical alignment - top
                                'tdc_preset_class' => 'tdcp_img tdcp_align tdcp_align_v1',
                                'tdc_preset_individual' => '1',
                                "meta_info_vert" => "content-vert-top",
                            ),
                            array(
                                'tdc_preset_name' => '', // Text vertical alignment - middle
                                'tdc_preset_class' => 'tdcp_img tdcp_align tdcp_align_v2',
                                'tdc_preset_individual' => '1',
                                "meta_info_vert" => "content-vert-center",
                            ),
                            array(
                                'tdc_preset_name' => '', // Text vertical alignment - bottom
                                'tdc_preset_class' => 'tdcp_img tdcp_align tdcp_align_v3',
                                'tdc_preset_individual' => '1',
                                "meta_info_vert" => "content-vert-bottom",
                            ),

                            array(
                                'tdc_preset_name' => 'Style',
                                'tdc_preset_class' => 'tdcp_separator tdcp_separator_style',
                            ),
                            array(
                                'tdc_preset_name' => '', // Style 1 - default
                                'tdc_preset_class' => 'tdcp_img tdcp_style tdcp_style1',
                                'tdc_preset_individual' => '1',
                                "overlay_general" => "eyJ0eXBlIjoiZ3JhZGllbnQiLCJjb2xvcjEiOiJyZ2JhKDAsMCwwLDApIiwiY29sb3IyIjoicmdiYSgwLDAsMCwwLjcpIiwibWl4ZWRDb2xvcnMiOlt7ImNvbG9yIjoicmdiYSgwLDAsMCwwKSIsInBlcmNlbnRhZ2UiOjYwfV0sImNzcyI6ImJhY2tncm91bmQ6IC13ZWJraXQtbGluZWFyLWdyYWRpZW50KDBkZWcscmdiYSgwLDAsMCwwLjcpLHJnYmEoMCwwLDAsMCkgNjAlLHJnYmEoMCwwLDAsMCkpO2JhY2tncm91bmQ6IGxpbmVhci1ncmFkaWVudCgwZGVnLHJnYmEoMCwwLDAsMC43KSxyZ2JhKDAsMCwwLDApIDYwJSxyZ2JhKDAsMCwwLDApKTsiLCJjc3NQYXJhbXMiOiIwZGVnLHJnYmEoMCwwLDAsMC43KSxyZ2JhKDAsMCwwLDApIDYwJSxyZ2JhKDAsMCwwLDApIn0=",
                                "overlay_h_general" => "",
                                "overlay_1" => "",
                                "overlay_2" => "",
                                "overlay_3" => "",
                                "overlay_4" => "",
                                "lightsky" => "",
                            ),
                            array(
                                'tdc_preset_name' => '', // Style 2 - colors
                                'tdc_preset_class' => 'tdcp_img tdcp_style tdcp_style2',
                                'tdc_preset_individual' => '1',
                                "overlay_h_general" => "",
                                "overlay_1" => "eyJ0eXBlIjoiZ3JhZGllbnQiLCJjb2xvcjEiOiJyZ2JhKDc0LDE0Myw5NCwwLjYpIiwiY29sb3IyIjoicmdiYSg3NywxNzgsMjM2LDAuNikiLCJtaXhlZENvbG9ycyI6W10sImRlZ3JlZSI6IjQ1IiwiY3NzIjoiYmFja2dyb3VuZDogLXdlYmtpdC1saW5lYXItZ3JhZGllbnQoNDVkZWcscmdiYSg3NywxNzgsMjM2LDAuNikscmdiYSg3NCwxNDMsOTQsMC42KSk7YmFja2dyb3VuZDogbGluZWFyLWdyYWRpZW50KDQ1ZGVnLHJnYmEoNzcsMTc4LDIzNiwwLjYpLHJnYmEoNzQsMTQzLDk0LDAuNikpOyIsImNzc1BhcmFtcyI6IjQ1ZGVnLHJnYmEoNzcsMTc4LDIzNiwwLjYpLHJnYmEoNzQsMTQzLDk0LDAuNikifQ==",
                                "overlay_2" => "eyJ0eXBlIjoiZ3JhZGllbnQiLCJjb2xvcjEiOiJyZ2JhKDE5OCw1Nyw1NywwLjYpIiwiY29sb3IyIjoicmdiYSgyMDksMTE4LDcwLDAuNikiLCJtaXhlZENvbG9ycyI6W10sImRlZ3JlZSI6IjQ1IiwiY3NzIjoiYmFja2dyb3VuZDogLXdlYmtpdC1saW5lYXItZ3JhZGllbnQoNDVkZWcscmdiYSgyMDksMTE4LDcwLDAuNikscmdiYSgxOTgsNTcsNTcsMC42KSk7YmFja2dyb3VuZDogbGluZWFyLWdyYWRpZW50KDQ1ZGVnLHJnYmEoMjA5LDExOCw3MCwwLjYpLHJnYmEoMTk4LDU3LDU3LDAuNikpOyIsImNzc1BhcmFtcyI6IjQ1ZGVnLHJnYmEoMjA5LDExOCw3MCwwLjYpLHJnYmEoMTk4LDU3LDU3LDAuNikifQ==",
                                "overlay_3" => "eyJ0eXBlIjoiZ3JhZGllbnQiLCJjb2xvcjEiOiJyZ2JhKDU5LDEyMCwxODAsMC41OSkiLCJjb2xvcjIiOiJyZ2JhKDIxNSw5NiwxODMsMC42KSIsIm1peGVkQ29sb3JzIjpbXSwiZGVncmVlIjoiLTQ1IiwiY3NzIjoiYmFja2dyb3VuZDogLXdlYmtpdC1saW5lYXItZ3JhZGllbnQoLTQ1ZGVnLHJnYmEoMjE1LDk2LDE4MywwLjYpLHJnYmEoNTksMTIwLDE4MCwwLjU5KSk7YmFja2dyb3VuZDogbGluZWFyLWdyYWRpZW50KC00NWRlZyxyZ2JhKDIxNSw5NiwxODMsMC42KSxyZ2JhKDU5LDEyMCwxODAsMC41OSkpOyIsImNzc1BhcmFtcyI6Ii00NWRlZyxyZ2JhKDIxNSw5NiwxODMsMC42KSxyZ2JhKDU5LDEyMCwxODAsMC41OSkifQ==",
                                "lightsky" => "",
                            ),
                            array(
                                'tdc_preset_name' => '', // Style 3 - flat colors
                                'tdc_preset_class' => 'tdcp_img tdcp_style tdcp_style3',
                                'tdc_preset_individual' => '1',
                                "overlay_h_general" => "",
                                "overlay_1" => "eyJ0eXBlIjoiZ3JhZGllbnQiLCJjb2xvcjEiOiJyZ2JhKDc0LDE0Myw5NCwwLjgpIiwiY29sb3IyIjoicmdiYSg3NywxNzgsMjM2LDAuOCkiLCJtaXhlZENvbG9ycyI6W10sImRlZ3JlZSI6IjQ1IiwiY3NzIjoiYmFja2dyb3VuZDogLXdlYmtpdC1saW5lYXItZ3JhZGllbnQoNDVkZWcscmdiYSg3NywxNzgsMjM2LDAuOCkscmdiYSg3NCwxNDMsOTQsMC44KSk7YmFja2dyb3VuZDogbGluZWFyLWdyYWRpZW50KDQ1ZGVnLHJnYmEoNzcsMTc4LDIzNiwwLjgpLHJnYmEoNzQsMTQzLDk0LDAuOCkpOyIsImNzc1BhcmFtcyI6IjQ1ZGVnLHJnYmEoNzcsMTc4LDIzNiwwLjgpLHJnYmEoNzQsMTQzLDk0LDAuOCkifQ==",
                                "overlay_2" => "eyJ0eXBlIjoiZ3JhZGllbnQiLCJjb2xvcjEiOiJyZ2JhKDE5OCw1Nyw1NywwLjgpIiwiY29sb3IyIjoicmdiYSgyMDksMTE4LDcwLDAuOCkiLCJtaXhlZENvbG9ycyI6W10sImRlZ3JlZSI6IjQ1IiwiY3NzIjoiYmFja2dyb3VuZDogLXdlYmtpdC1saW5lYXItZ3JhZGllbnQoNDVkZWcscmdiYSgyMDksMTE4LDcwLDAuOCkscmdiYSgxOTgsNTcsNTcsMC44KSk7YmFja2dyb3VuZDogbGluZWFyLWdyYWRpZW50KDQ1ZGVnLHJnYmEoMjA5LDExOCw3MCwwLjgpLHJnYmEoMTk4LDU3LDU3LDAuOCkpOyIsImNzc1BhcmFtcyI6IjQ1ZGVnLHJnYmEoMjA5LDExOCw3MCwwLjgpLHJnYmEoMTk4LDU3LDU3LDAuOCkifQ==",
                                "overlay_3" => "eyJ0eXBlIjoiZ3JhZGllbnQiLCJjb2xvcjEiOiJyZ2JhKDU5LDEyMCwxODAsMC44KSIsImNvbG9yMiI6InJnYmEoMjE1LDk2LDE4MywwLjgpIiwibWl4ZWRDb2xvcnMiOltdLCJkZWdyZWUiOiItNDUiLCJjc3MiOiJiYWNrZ3JvdW5kOiAtd2Via2l0LWxpbmVhci1ncmFkaWVudCgtNDVkZWcscmdiYSgyMTUsOTYsMTgzLDAuOCkscmdiYSg1OSwxMjAsMTgwLDAuOCkpO2JhY2tncm91bmQ6IGxpbmVhci1ncmFkaWVudCgtNDVkZWcscmdiYSgyMTUsOTYsMTgzLDAuOCkscmdiYSg1OSwxMjAsMTgwLDAuOCkpOyIsImNzc1BhcmFtcyI6Ii00NWRlZyxyZ2JhKDIxNSw5NiwxODMsMC44KSxyZ2JhKDU5LDEyMCwxODAsMC44KSJ9",
                                "lightsky" => "",
                            ),
                            array(
                                'tdc_preset_name' => '', // Style 4 - light sky
                                'tdc_preset_class' => 'tdcp_img tdcp_style tdcp_style4',
                                'tdc_preset_individual' => '1',
                                "overlay_general" => "rgba(0,0,0,0.7)",
                                "overlay_h_general" => "rgba(77,178,236,0.3)",
                                "overlay_1" => "",
                                "overlay_2" => "",
                                "overlay_3" => "",
                                "lightsky" => "yes",
                            ),
                            array(
                                'tdc_preset_name' => '', // Style 5 - rainbow
                                'tdc_preset_class' => 'tdcp_img tdcp_style tdcp_style5',
                                'tdc_preset_individual' => '1',
                                "overlay_h_general" => "",
                                "overlay_1" => "eyJ0eXBlIjoiZ3JhZGllbnQiLCJjb2xvcjEiOiJyZ2JhKDI1NSwxMTEsNDksMC42KSIsImNvbG9yMiI6InJnYmEoNjUsMTIsMTg4LDAuNikiLCJtaXhlZENvbG9ycyI6W10sImRlZ3JlZSI6IjIwIiwiY3NzIjoiYmFja2dyb3VuZDogLXdlYmtpdC1saW5lYXItZ3JhZGllbnQoMjBkZWcscmdiYSg2NSwxMiwxODgsMC42KSxyZ2JhKDI1NSwxMTEsNDksMC42KSk7YmFja2dyb3VuZDogbGluZWFyLWdyYWRpZW50KDIwZGVnLHJnYmEoNjUsMTIsMTg4LDAuNikscmdiYSgyNTUsMTExLDQ5LDAuNikpOyIsImNzc1BhcmFtcyI6IjIwZGVnLHJnYmEoNjUsMTIsMTg4LDAuNikscmdiYSgyNTUsMTExLDQ5LDAuNikifQ==",
                                "overlay_2" => "eyJ0eXBlIjoiZ3JhZGllbnQiLCJjb2xvcjEiOiJyZ2JhKDExMiwyNTUsMTUzLDAuNikiLCJjb2xvcjIiOiJyZ2JhKDI0NCwxMzYsMTMsMC42KSIsIm1peGVkQ29sb3JzIjpbXSwiZGVncmVlIjoiMjAiLCJjc3MiOiJiYWNrZ3JvdW5kOiAtd2Via2l0LWxpbmVhci1ncmFkaWVudCgyMGRlZyxyZ2JhKDI0NCwxMzYsMTMsMC42KSxyZ2JhKDExMiwyNTUsMTUzLDAuNikpO2JhY2tncm91bmQ6IGxpbmVhci1ncmFkaWVudCgyMGRlZyxyZ2JhKDI0NCwxMzYsMTMsMC42KSxyZ2JhKDExMiwyNTUsMTUzLDAuNikpOyIsImNzc1BhcmFtcyI6IjIwZGVnLHJnYmEoMjQ0LDEzNiwxMywwLjYpLHJnYmEoMTEyLDI1NSwxNTMsMC42KSJ9",
                                "overlay_3" => "eyJ0eXBlIjoiZ3JhZGllbnQiLCJjb2xvcjEiOiJyZ2JhKDEyNiwxOTEsMjU1LDAuNikiLCJjb2xvcjIiOiJyZ2JhKDE5NiwxNSwxMjEsMC42KSIsIm1peGVkQ29sb3JzIjpbXSwiZGVncmVlIjoiMjAiLCJjc3MiOiJiYWNrZ3JvdW5kOiAtd2Via2l0LWxpbmVhci1ncmFkaWVudCgyMGRlZyxyZ2JhKDE5NiwxNSwxMjEsMC42KSxyZ2JhKDEyNiwxOTEsMjU1LDAuNikpO2JhY2tncm91bmQ6IGxpbmVhci1ncmFkaWVudCgyMGRlZyxyZ2JhKDE5NiwxNSwxMjEsMC42KSxyZ2JhKDEyNiwxOTEsMjU1LDAuNikpOyIsImNzc1BhcmFtcyI6IjIwZGVnLHJnYmEoMTk2LDE1LDEyMSwwLjYpLHJnYmEoMTI2LDE5MSwyNTUsMC42KSJ9",
                                "lightsky" => "",
                            ),
                        )
                    )
                ),
                "params" => array_merge(
                    array(
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Content length',
                            "value"      => "",
                            "class"      => "",
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Module Flex 6',
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                        ),
                        array(
                            "param_name"  => "mf6_tl",
                            "type"        => "textfield",
                            "value"       => '',
                            "heading"     => 'Title length',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-small",
                            "placeholder" => '25',
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Module Flex 7',
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                        ),
                        array(
                            "param_name"  => "mf7_tl",
                            "type"        => "textfield",
                            "value"       => '',
                            "heading"     => 'Title length',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-small",
                            "placeholder" => '25',
                        ),
                    ),
                    self::td_block_big_grid_params(),
                    array(
                        array(
                            "param_name"  => "modules_gap",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Modules gap',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-small",
                            "placeholder" => "10",
                            "group"       => "Layout",
                        ),
                        array(
                            "param_name" => "meta_info_horiz",
                            "type" => "dropdown",
                            "value" => array(
                                'Left' => 'content-horiz-left',
                                'Center' => 'content-horiz-center',
                                'Right' => 'content-horiz-right'
                            ),
                            "heading" => 'Meta info horiz align',
                            "description" => "",
                            "holder" => "div",
                            'tdc_dropdown_images' => true,
                            "class" => "tdc-visual-selector tdc-add-class",
                            "group"       => "Layout",
                        ),
                        array(
                            "param_name" => "meta_info_vert",
                            "type" => "dropdown",
                            "value" => array(
                                'Left' => 'content-vert-top',
                                'Center' => 'content-vert-center',
                                'Right' => 'content-vert-bottom'
                            ),
                            "heading" => 'Meta info vert align',
                            "description" => "",
                            "holder" => "div",
                            'tdc_dropdown_images' => true,
                            "class" => "tdc-visual-selector tdc-add-class",
                            "group"       => "Layout",
                        ),
                        array(
                            "param_name"  => "image_zoom",
                            "type"        => "checkbox",
                            "value"       => '',
                            "heading"     => "Zoom effect on hover",
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "",
                            "group"       => 'Layout'
                        ),
                        array(
                            "param_name"  => "modules_category",
                            "type"        => "dropdown",
                            "value"       => array(
                                'Inline'      => '',
                                'Above title' => 'above',
                            ),
                            "heading"     => 'Category tag position',
                            "description" => "Float image",
                            "holder"      => "div",
                            "class"       => "tdc-dropdown-big",
                            "group"       => "Layout",
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Module Category Grid 1',
                            "value"      => "",
                            "class"      => "",
                            "group"      => "Layout",
                        ),
                        array(
                            "param_name"  => "image_size",
                            "type"        => "dropdown",
                            "value"       => array(
                                'XSmall - 324px' => 'td_324x400',
                                'Small - 696px'  => '',
                                'Large - 1068px' => 'td_1068x0',
                                'Full - 1920px'  => 'td_1920x0'
                            ),
                            "heading"     => 'Image size',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-dropdown-big",
                            "group"       => "Layout",
                        ),
                        array(
                            'param_name'  => 'image_alignment1',
                            'type'        => 'range-responsive',
                            'value'       => '50',
                            'heading'     => 'Image V alignment',
                            'description' => '0 - Top / 50 - Center / 100 - Bottom',
                            'class'       => 'tdc-textfield-small',
                            'range_min'   => '0',
                            'range_max'   => '100',
                            'range_step'  => '1',
                            "group"       => "Layout",
                        ),
                        array(
                            "param_name"  => "image_width1",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Image width (percent)',
                            "description" => "Default value in percent",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-small",
                            "placeholder" => "50",
                            "group"       => "Layout",
                        ),
                        array(
                            "param_name"  => "image_height1",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Image height (percent)',
                            "description" => "Default value in percent",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-small",
                            "placeholder" => "450px",
                            "group"       => "Layout",
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "horizontal_separator",
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                            "group"      => "Layout",
                        ),
                        array(
                            "param_name"  => "meta_width1",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Meta info width',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-small",
                            "placeholder" => "100%",
                            "group"       => "Layout",
                        ),
                        array(
                            "param_name"  => "meta_margin1",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Meta info margin',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-big",
                            "placeholder" => "0px 0px 0px 0px",
                            "group"       => "Layout",
                        ),
                        array(
                            "param_name"  => "meta_padding1",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Meta info padding',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-big",
                            "placeholder" => "22px 20px",
                            "group"       => "Layout",
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "horizontal_separator",
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                            "group"      => "Layout",
                        ),
                        array(
                            "param_name"  => "art_title1",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Article title space',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-big",
                            "placeholder" => "0px 0px 9px 0px",
                            "group"       => "Layout",
                        ),
                        array(
                            "param_name"  => "art_title_padd1",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Article title padding',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-big",
                            "placeholder" => "0px 0px 0px 0px",
                            "group"       => "Layout",
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "horizontal_separator",
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                            "group"      => "Layout",
                        ),
                        array(
                            "param_name"  => "modules_category_margin1",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Category tag spacing',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-big",
                            "placeholder" => "0px 0px 10px 0px",
                            "group"       => "Layout",
                        ),
                        array(
                            "param_name"  => "modules_category_padding1",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Category tag padding',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-big",
                            "placeholder" => "3px 6px 3px 6px",
                            "group"       => "Layout",
                        ),
                        array(
                            "param_name"  => "show_cat1",
                            "type"        => "dropdown-responsive",
                            "value"       => array(
                                'Show' => 'inline-block',
                                'Hide' => 'none',
                            ),
                            "heading"     => 'Show category',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-dropdown-big",
                            "group"       => "Layout",
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "horizontal_separator",
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                            "group"      => "Layout",
                        ),
                        array(
                            "param_name"  => "show_author1",
                            "type"        => "dropdown-responsive",
                            "value"       => array(
                                'Show' => 'inline-block',
                                'Hide' => 'none',
                            ),
                            "heading"     => 'Show author',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-dropdown-big",
                            "group"       => "Layout",
                        ),
                        array(
                            "param_name"  => "show_date1",
                            "type"        => "dropdown-responsive",
                            "value"       => array(
                                'Show' => 'inline-block',
                                'Hide' => 'none',
                            ),
                            "heading"     => 'Show date',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-dropdown-big",
                            "group"       => "Layout",
                        ),
                        array(
                            "param_name"  => "auth_date_padding1",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Author & date padding',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-big",
                            "placeholder" => "0px 0px 0px 0px",
                            "group"       => "Layout",
                        ),

                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Module Category Grid 2',
                            "value"      => "",
                            "class"      => "",
                            "group"      => "Layout",
                        ),
                        array(
                            "param_name"  => "image_size2",
                            "type"        => "dropdown",
                            "value"       => array(
                                'XSmall - 324px' => 'td_324x400',
                                'Small - 696px'  => '',
                                'Large - 1068px' => 'td_1068x0',
                                'Full - 1920px'  => 'td_1920x0'
                            ),
                            "heading"     => 'Image size',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-dropdown-big",
                            "group"       => "Layout",
                        ),
                        array(
                            'param_name'  => 'image_alignment2',
                            'type'        => 'range-responsive',
                            'value'       => '50',
                            'heading'     => 'Image V alignment',
                            'description' => '0 - Top / 50 - Center / 100 - Bottom',
                            'class'       => 'tdc-textfield-small',
                            'range_min'   => '0',
                            'range_max'   => '100',
                            'range_step'  => '1',
                            "group"       => "Layout",
                        ),
                        array(
                            "param_name"  => "image_width2",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Image width (percent)',
                            "description" => "Default value in percent",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-small",
                            "placeholder" => "50",
                            "group"       => "Layout",
                        ),
                        array(
                            "param_name"  => "image_height2",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Image height (percent)',
                            "description" => "Default value in percent",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-small",
                            "placeholder" => "220px",
                            "group"       => "Layout",
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "horizontal_separator",
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                            "group"      => "Layout",
                        ),
                        array(
                            "param_name"  => "meta_width2",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Meta info width',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-small",
                            "placeholder" => "100%",
                            "group"       => "Layout",
                        ),
                        array(
                            "param_name"  => "meta_margin2",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Meta info margin',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-big",
                            "placeholder" => "0px 0px 0px 0px",
                            "group"       => "Layout",
                        ),
                        array(
                            "param_name"  => "meta_padding2",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Meta info padding',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-big",
                            "placeholder" => "16px 19px",
                            "group"       => "Layout",
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "horizontal_separator",
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                            "group"      => "Layout",
                        ),
                        array(
                            "param_name"  => "art_title2",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Article title space',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-big",
                            "placeholder" => "0px 0px 9px 0px",
                            "group"       => "Layout",
                        ),
                        array(
                            "param_name"  => "art_title_padd2",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Article title padding',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-big",
                            "placeholder" => "0px 0px 0px 0px",
                            "group"       => "Layout",
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "horizontal_separator",
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                            "group"      => "Layout",
                        ),
                        array(
                            "param_name"  => "modules_category_margin2",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Category tag spacing',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-big",
                            "placeholder" => "0px 0px 10px 0px",
                            "group"       => "Layout",
                        ),
                        array(
                            "param_name"  => "modules_category_padding2",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Category tag padding',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-big",
                            "placeholder" => "3px 6px 3px 6px",
                            "group"       => "Layout",
                        ),
                        array(
                            "param_name"  => "show_cat2",
                            "type"        => "dropdown-responsive",
                            "value"       => array(
                                'Show' => 'inline-block',
                                'Hide' => 'none',
                            ),
                            "heading"     => 'Show category',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-dropdown-big",
                            "group"       => "Layout",
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "horizontal_separator",
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                            "group"      => "Layout",
                        ),
                        array(
                            "param_name"  => "show_author2",
                            "type"        => "dropdown-responsive",
                            "value"       => array(
                                'Show' => 'inline-block',
                                'Hide' => 'none',
                            ),
                            "heading"     => 'Show author',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-dropdown-big",
                            "group"       => "Layout",
                        ),
                        array(
                            "param_name"  => "show_date2",
                            "type"        => "dropdown-responsive",
                            "value"       => array(
                                'Show' => 'inline-block',
                                'Hide' => 'none',
                            ),
                            "heading"     => 'Show date',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-dropdown-big",
                            "group"       => "Layout",
                        ),
                        array(
                            "param_name"  => "auth_date_padding2",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Author & date padding',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-big",
                            "placeholder" => "0px 0px 0px 0px",
                            "group"       => "Layout",
                        ),
                        array(
                            "param_name" => "separator",
                            "type" => "text_separator",
                            'heading' => 'Module fonts',
                            "value" => "",
                            "class" => "",
                            "group" => 'Style',
                        ),
                    ),
                    td_config_helper::get_map_block_font_array( 'f_title1', true, 'Module 1 title', 'Style' ),
                    td_config_helper::get_map_block_font_array( 'f_cat1', false, 'Module 1 category tag', 'Style' ),
                    td_config_helper::get_map_block_font_array( 'f_meta1', false, 'Module 1 meta info', 'Style' ),
                    td_config_helper::get_map_block_font_array( 'f_title2', false, 'Module 2 title', 'Style' ),
                    td_config_helper::get_map_block_font_array( 'f_cat2', false, 'Module 2 category tag', 'Style' ),
                    td_config_helper::get_map_block_font_array( 'f_meta2', false, 'Module 2 meta info', 'Style' ),
                    array(
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Colors',
                            "value"      => "",
                            "class"      => "",
                            "group"      => "Style",
                        ),
                        array(
                            "param_name" => "overlay_general",
                            "holder" => "div",
                            "type" => "gradient",
                            'heading' => "General module overlay color",
                            "value" => "",
                            "class" => "",
                            "group"      => "Style",
                        ),
                        array(
                            "param_name" => "overlay_h_general",
                            "holder" => "div",
                            "type" => "gradient",
                            'heading' => "General module overlay hover color",
                            "value" => "",
                            "class" => "",
                            "group"      => "Style",
                        ),
                        array(
                            "param_name" => "overlay_1",
                            "holder" => "div",
                            "type" => "gradient",
                            'heading' => "Module overlay color 1",
                            "value" => "",
                            "class" => "",
                            "group"      => "Style",
                        ),
                        array(
                            "param_name" => "overlay_2",
                            "holder" => "div",
                            "type" => "gradient",
                            'heading' => "Module overlay color 2",
                            "value" => "",
                            "class" => "",
                            "group"      => "Style",
                        ),
                        array(
                            "param_name" => "overlay_3",
                            "holder" => "div",
                            "type" => "gradient",
                            'heading' => "Module overlay color 3",
                            "value" => "",
                            "class" => "",
                            "group"      => "Style",
                        ),
                        array(
                            "param_name"  => "lightsky",
                            "type"        => "checkbox",
                            "value"       => '',
                            "heading"     => "Lightsky",
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "",
                            "group"       => 'Style'
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "",
                            "heading"     => 'Meta info background',
                            "param_name"  => "meta_bg",
                            "value"       => '',
                            "description" => '',
                            "group"       => 'Style',
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "horizontal_separator",
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                            "group"      => "Style",
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "",
                            "heading"     => 'Article title text color',
                            "param_name"  => "title_txt",
                            "value"       => '',
                            "description" => '',
                            "group"       => 'Style',
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "",
                            "heading"     => 'Article title text hover',
                            "param_name"  => "title_txt_hover",
                            "value"       => '',
                            "description" => '',
                            "group"       => 'Style',
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "",
                            "heading"     => 'Article title background color',
                            "param_name"  => "title_bg",
                            "value"       => '',
                            "description" => '',
                            "group"       => 'Style',
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "horizontal_separator",
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                            "group"      => "Style",
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "",
                            "heading"     => 'Category background',
                            "param_name"  => "cat_bg",
                            "value"       => '',
                            "description" => '',
                            "group"       => 'Style',
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "",
                            "heading"     => 'Category text color',
                            "param_name"  => "cat_txt",
                            "value"       => '',
                            "description" => '',
                            "group"       => 'Style',
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "",
                            "heading"     => 'Category background hover',
                            "param_name"  => "cat_bg_hover",
                            "value"       => '',
                            "description" => '',
                            "group"       => 'Style',
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "",
                            "heading"     => 'Category text hover',
                            "param_name"  => "cat_txt_hover",
                            "value"       => '',
                            "description" => '',
                            "group"       => 'Style',
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "horizontal_separator",
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                            "group"      => "Style",
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "",
                            "heading"     => 'Author text color',
                            "param_name"  => "author_txt",
                            "value"       => '',
                            "description" => '',
                            "group"       => 'Style',
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "",
                            "heading"     => 'Author text hover',
                            "param_name"  => "author_txt_hover",
                            "value"       => '',
                            "description" => '',
                            "group"       => 'Style',
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "",
                            "heading"     => 'Date text color',
                            "param_name"  => "date_txt",
                            "value"       => '',
                            "description" => '',
                            "group"       => 'Style',
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "",
                            "heading"     => 'Author & date background color',
                            "param_name"  => "auth_date_bg",
                            "value"       => '',
                            "description" => '',
                            "group"       => 'Style',
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "",
                            "heading"     => 'Review stars color',
                            "param_name"  => "review_stars",
                            "value"       => '',
                            "description" => '',
                            "group"       => 'Style',
                        ),
                    ),
                    self::get_map_css_tab()
                )
            )
        );

        td_api_block::add('td_block_big_grid_flex_5',
            array(
                'map_in_visual_composer' => false,
                'map_in_td_composer' => true,
                "name" => 'Big Grid Flex 5',
                "base" => 'td_block_big_grid_flex_5',
                "class" => 'td_block_big_grid_flex_5',
                "controls" => "full",
                "category" => 'Blocks',
                'tdc_category' => 'Big Grids',
                'icon' => 'icon-pagebuilder-td_block_big_grid_flex_5',
                'file' => td_global::$get_template_directory . '/includes/shortcodes/td_block_big_grid_flex_5.php',
                'tdc_style_params' => array(
                    'custom_title',
                    'custom_url',
                    'post_ids',
                    'category_id',
                    'category_ids',
                    'tag_slug',
                    'autors_id',
                    'installed_post_types',
                    'sort',
                    'offset',
                    'el_class'
                ),
                'tdc_start_values' => base64_encode(
                    json_encode(
                        array(
                            array(
                                "meta_info_vert" => "content-vert-bottom",
                                "image_zoom" => "yes",
                                "show_author2" => "none",
                                "show_date2" => "none",
                                "modules_category" => "above",
                                "overlay_general" => "eyJ0eXBlIjoiZ3JhZGllbnQiLCJjb2xvcjEiOiJyZ2JhKDAsMCwwLDApIiwiY29sb3IyIjoicmdiYSgwLDAsMCwwLjcpIiwibWl4ZWRDb2xvcnMiOlt7ImNvbG9yIjoicmdiYSgwLDAsMCwwKSIsInBlcmNlbnRhZ2UiOjYwfV0sImNzcyI6ImJhY2tncm91bmQ6IC13ZWJraXQtbGluZWFyLWdyYWRpZW50KDBkZWcscmdiYSgwLDAsMCwwLjcpLHJnYmEoMCwwLDAsMCkgNjAlLHJnYmEoMCwwLDAsMCkpO2JhY2tncm91bmQ6IGxpbmVhci1ncmFkaWVudCgwZGVnLHJnYmEoMCwwLDAsMC43KSxyZ2JhKDAsMCwwLDApIDYwJSxyZ2JhKDAsMCwwLDApKTsiLCJjc3NQYXJhbXMiOiIwZGVnLHJnYmEoMCwwLDAsMC43KSxyZ2JhKDAsMCwwLDApIDYwJSxyZ2JhKDAsMCwwLDApIn0=",
                                "image_height2" => "eyJwaG9uZSI6IjE2NXB4IiwicG9ydHJhaXQiOiIxNzZweCIsImxhbmRzY2FwZSI6IjIzNHB4In0=",
                                "modules_gap" => "eyJwaG9uZSI6IjMifQ==",
                                "meta_padding2" => "eyJwaG9uZSI6IjE2cHggMTVweCAxMXB4IiwicG9ydHJhaXQiOiIxOXB4IDE4cHggMTRweCJ9",
                                "meta_padding1" => "eyJwaG9uZSI6IjE1cHggMThweCIsInBvcnRyYWl0IjoiMjJweCAyMHB4In0=",
                                "cat_bg_hover" => "#4db2ec",
                                "review_stars" => "#fff",
                                "modules_category_margin2" => "eyJwb3J0cmFpdCI6IjBweCAwcHggNHB4IDBweCJ9",
                                "modules_category_margin1" => "eyJwb3J0cmFpdCI6IjBweCAwcHggN3B4IDBweCJ9",
                                "art_title1" => "eyJwb3J0cmFpdCI6IjBweCAwcHggNnB4IDBweCJ9",
                                "show_author3" => "none",
                                "show_date3" => "none",
                                "image_size" => "",
                                "image_size2" => "",
                                "image_size3" => "td_324x400",
                                "image_width1" => "eyJwaG9uZSI6IjEwMCJ9",
                                "image_height1" => "eyJwaG9uZSI6IjI2MHB4IiwibGFuZHNjYXBlIjoiNDE0cHgiLCJwb3J0cmFpdCI6IjMxMnB4In0=",
                                "image_width2" => "eyJwaG9uZSI6IjgwIn0=",
                                "image_width3" => "eyJwaG9uZSI6IjgwIn0=",
                                "image_height3" => "eyJwaG9uZSI6IjE2NXB4IiwibGFuZHNjYXBlIjoiMTc2cHgiLCJwb3J0cmFpdCI6IjEzMnB4In0=",
                            ),

                            array(
                                'tdc_preset_name' => 'Font family',
                                'tdc_preset_class' => 'tdcp_separator tdcp_separator_font',
                            ),
                            array(
                                'tdc_preset_name' => '', // Font - Montserrat
                                'tdc_preset_class' => 'tdcp_img tdcp_font tdcp_font1',
                                'tdc_preset_individual' => '1',
                                "f_title1_font_family" =>        "394",
                                "f_title2_font_family" =>        "394",
                                "f_title3_font_family" =>        "394",
                            ),
                            array(
                                'tdc_preset_name' => '', // Font - Source Serif
                                'tdc_preset_class' => 'tdcp_img tdcp_font tdcp_font2',
                                'tdc_preset_individual' =>      '1',
                                "f_title1_font_family" =>        "721",
                                "f_title2_font_family" =>        "721",
                                "f_title3_font_family" =>        "721",
                            ),
                            array(
                                'tdc_preset_name' => '', // Font - Raleway
                                'tdc_preset_class' => 'tdcp_img tdcp_font tdcp_font3',
                                'tdc_preset_individual' => '1',
                                "f_title1_font_family" =>        "507",
                                "f_title2_font_family" =>        "507",
                                "f_title3_font_family" =>        "507",
                            ),
                            array(
                                'tdc_preset_name' => '', // Font - Work Sans
                                'tdc_preset_class' => 'tdcp_img tdcp_font tdcp_font4',
                                'tdc_preset_individual' => '1',
                                "f_title1_font_family" =>        "653",
                                "f_title2_font_family" =>        "653",
                                "f_title3_font_family" =>        "653",
                            ),
                            array(
                                'tdc_preset_name' => '', // Font - Courgette
                                'tdc_preset_class' => 'tdcp_img tdcp_font tdcp_font5',
                                'tdc_preset_individual' => '1',
                                "f_title1_font_family" =>        "147",
                                "f_title2_font_family" =>        "147",
                                "f_title3_font_family" =>        "147",
                            ),
                            array(
                                'tdc_preset_name' => '', // Font - Oswald
                                'tdc_preset_class' => 'tdcp_img tdcp_font tdcp_font7',
                                'tdc_preset_individual' => '1',
                                "f_title1_font_family" =>        "445",
                                "f_title2_font_family" =>        "445",
                                "f_title3_font_family" =>        "445",
                            ),
                            array(
                                'tdc_preset_name' => '', // Font - Muli
                                'tdc_preset_class' => 'tdcp_img tdcp_font tdcp_font8',
                                'tdc_preset_individual' => '1',
                                "f_title1_font_family" =>        "406",
                                "f_title2_font_family" =>        "406",
                                "f_title3_font_family" =>        "406",
                            ),
                            array(
                                'tdc_preset_name' => '', // Font - Wendy One
                                'tdc_preset_class' => 'tdcp_img tdcp_font tdcp_font9',
                                'tdc_preset_individual' => '1',
                                "f_title1_font_family" =>        "646",
                                "f_title2_font_family" =>        "646",
                                "f_title3_font_family" =>        "646",
                            ),
                            array(
                                'tdc_preset_name' => '', // Font - Anton
                                'tdc_preset_class' => 'tdcp_img tdcp_font tdcp_font10',
                                'tdc_preset_individual' => '1',
                                "f_title1_font_family" =>        "41",
                                "f_title2_font_family" =>        "41",
                                "f_title3_font_family" =>        "41",
                            ),
                            array(
                                'tdc_preset_name' => '', // Font - Quicksand
                                'tdc_preset_class' => 'tdcp_img tdcp_font tdcp_font11',
                                'tdc_preset_individual' => '1',
                                "f_title1_font_family" =>        "502",
                                "f_title2_font_family" =>        "502",
                                "f_title3_font_family" =>        "502",
                            ),
                            array(
                                'tdc_preset_name' => '', // Font - Libre Baskerville
                                'tdc_preset_class' => 'tdcp_img tdcp_font tdcp_font12',
                                'tdc_preset_individual' => '1',
                                "f_title1_font_family" =>        "331",
                                "f_title2_font_family" =>        "331",
                                "f_title3_font_family" =>        "331",
                            ),
                            array(
                                'tdc_preset_name' => '', // Font - Caveat
                                'tdc_preset_class' => 'tdcp_img tdcp_font tdcp_font13',
                                'tdc_preset_individual' => '1',
                                "f_title1_font_family" =>        "663",
                                "f_title2_font_family" =>        "663",
                                "f_title3_font_family" =>        "663",
                            ),
                            array(
                                'tdc_preset_name' => '', // Font - Volkorn
                                'tdc_preset_class' => 'tdcp_img tdcp_font tdcp_font14',
                                'tdc_preset_individual' => '1',
                                "f_title1_font_family" =>        "639",
                                "f_title2_font_family" =>        "639",
                                "f_title3_font_family" =>        "639",
                            ),
                            array(
                                'tdc_preset_name' => '', // Font - Default
                                'tdc_preset_class' => 'tdcp_img tdcp_font tdcp_font6',
                                'tdc_preset_individual' => '1',
                                "f_title1_font_family" =>        "",
                                "f_title2_font_family" =>        "",
                                "f_title3_font_family" =>        "",
                            ),

                            array(
                                'tdc_preset_name' => 'Font size',
                                'tdc_preset_class' => 'tdcp_separator tdcp_separator_size',
                            ),
                            array(
                                'tdc_preset_name' => '', // Size - XS 13/13/12/14
                                'tdc_preset_class' => 'tdcp_img tdcp_size tdcp_size1',
                                'tdc_preset_individual' => '1',
                                "f_title1_font_size" => "eyJhbGwiOiIxNiIsInBvcnRyYWl0IjoiMTQifQ==",
                                "f_title1_font_line_height" => "1.3",
                                "f_title2_font_size" => "eyJhbGwiOiIxNiIsInBvcnRyYWl0IjoiMTQifQ==",
                                "f_title2_font_line_height" => "1.3",
                                "f_title3_font_size" => "eyJhbGwiOiIxMyIsInBvcnRyYWl0IjoiMTIiLCJwaG9uZSI6IjE0In0=",
                                "f_title3_font_line_height" => "1.3",
                            ),
                            array(
                                'tdc_preset_name' => '', // Size - S 14/13/12/14
                                'tdc_preset_class' => 'tdcp_img tdcp_size tdcp_size2',
                                'tdc_preset_individual' => '1',
                                "f_title1_font_size" => "eyJhbGwiOiIxOCIsInBvcnRyYWl0IjoiMTYifQ==",
                                "f_title1_font_line_height" => "1.4",
                                "f_title2_font_size" => "eyJhbGwiOiIxNiIsInBvcnRyYWl0IjoiMTQifQ==",
                                "f_title2_font_line_height" => "1.3",
                                "f_title3_font_size" => "eyJhbGwiOiIxNCIsImxhbmRzY2FwZSI6IjEzIiwicG9ydHJhaXQiOiIxMiJ9",
                                "f_title3_font_line_height" => "1.4",
                            ),
                            array(
                                'tdc_preset_name' => '', // Size - M 21/21/17/21
                                'tdc_preset_class' => 'tdcp_img tdcp_size tdcp_size3',
                                'tdc_preset_individual' => '1',
                                "f_title1_font_size" => "eyJhbGwiOiIyNCIsInBvcnRyYWl0IjoiMjIifQ==",
                                "f_title1_font_line_height" => "1.2",
                                "f_title2_font_size" => "eyJhbGwiOiIyMCIsInBvcnRyYWl0IjoiMTYiLCJwaG9uZSI6IjE0In0=",
                                "f_title2_font_line_height" => "1.2",
                                "f_title3_font_size" => "eyJhbGwiOiIxNSIsInBvcnRyYWl0IjoiMTMifQ==",
                                "f_title3_font_line_height" => "1.3",
                            ),
                            array(
                                'tdc_preset_name' => '', // Size - L 26/25/21/21
                                'tdc_preset_class' => 'tdcp_img tdcp_size tdcp_size4',
                                'tdc_preset_individual' => '1',
                                "f_title1_font_size" => "",
                                "f_title1_font_line_height" => "",
                                "f_title2_font_size" => "",
                                "f_title2_font_line_height" => "",
                                "f_title3_font_size" => "",
                                "f_title3_font_line_height" => "",
                            ),
                            array(
                                'tdc_preset_name' => '', // Size - XL 30/28/24/21
                                'tdc_preset_class' => 'tdcp_img tdcp_size tdcp_size5',
                                'tdc_preset_individual' => '1',
                                "f_title1_font_size" => "eyJhbGwiOiIzMCIsImxhbmRzY2FwZSI6IjI4IiwicG9ydHJhaXQiOiIyNCIsInBob25lIjoiMjEifQ==",
                                "f_title1_font_line_height" => "1.2",
                                "f_title2_font_size" => "",
                                "f_title2_font_line_height" => "",
                                "f_title3_font_size" => "",
                                "f_title3_font_line_height" => "",
                            ),
                            array(
                                'tdc_preset_name' => '', // Size - XXL 36/32/26/21
                                'tdc_preset_class' => 'tdcp_img tdcp_size tdcp_size6',
                                'tdc_preset_individual' => '1',
                                "f_title1_font_size" => "eyJhbGwiOiIzNiIsImxhbmRzY2FwZSI6IjMyIiwicGhvbmUiOiIyMSIsInBvcnRyYWl0IjoiMjYifQ==",
                                "f_title1_font_line_height" => "eyJhbGwiOiIxLjEiLCJwaG9uZSI6IjEuMiJ9",
                                "f_title2_font_size" => "",
                                "f_title2_font_line_height" => "",
                                "f_title3_font_size" => "eyJhbGwiOiIxOCIsImxhbmRzY2FwZSI6IjE3IiwicG9ydHJhaXQiOiIxNiIsInBob25lIjoiMTYifQ==",
                                "f_title3_font_line_height" => "1.3",
                            ),

                            array(
                                'tdc_preset_name' => 'Text horizontal alignment',
                                'tdc_preset_class' => 'tdcp_separator tdcp_separator_align',
                            ),
                            array(
                                'tdc_preset_name' => '', // Text alignment - left
                                'tdc_preset_class' => 'tdcp_img tdcp_align tdcp_align1',
                                'tdc_preset_individual' => '1',
                                "meta_info_horiz" => "content-horiz-left",
                            ),
                            array(
                                'tdc_preset_name' => '', // Text alignment - center
                                'tdc_preset_class' => 'tdcp_img tdcp_align tdcp_align2',
                                'tdc_preset_individual' => '1',
                                "meta_info_horiz" => "content-horiz-center",
                            ),
                            array(
                                'tdc_preset_name' => '', // Text alignment - right
                                'tdc_preset_class' => 'tdcp_img tdcp_align tdcp_align3',
                                'tdc_preset_individual' => '1',
                                "meta_info_horiz" => "content-horiz-right",
                            ),

                            array(
                                'tdc_preset_name' => 'Text vertical alignment',
                                'tdc_preset_class' => 'tdcp_separator tdcp_separator_align_v',
                            ),
                            array(
                                'tdc_preset_name' => '', // Text vertical alignment - top
                                'tdc_preset_class' => 'tdcp_img tdcp_align tdcp_align_v1',
                                'tdc_preset_individual' => '1',
                                "meta_info_vert" => "content-vert-top",
                            ),
                            array(
                                'tdc_preset_name' => '', // Text vertical alignment - middle
                                'tdc_preset_class' => 'tdcp_img tdcp_align tdcp_align_v2',
                                'tdc_preset_individual' => '1',
                                "meta_info_vert" => "content-vert-center",
                            ),
                            array(
                                'tdc_preset_name' => '', // Text vertical alignment - bottom
                                'tdc_preset_class' => 'tdcp_img tdcp_align tdcp_align_v3',
                                'tdc_preset_individual' => '1',
                                "meta_info_vert" => "content-vert-bottom",
                            ),

                            array(
                                'tdc_preset_name' => 'Style',
                                'tdc_preset_class' => 'tdcp_separator tdcp_separator_style',
                            ),
                            array(
                                'tdc_preset_name' => '', // Style 1 - default
                                'tdc_preset_class' => 'tdcp_img tdcp_style tdcp_style1',
                                'tdc_preset_individual' => '1',
                                "overlay_general" => "eyJ0eXBlIjoiZ3JhZGllbnQiLCJjb2xvcjEiOiJyZ2JhKDAsMCwwLDApIiwiY29sb3IyIjoicmdiYSgwLDAsMCwwLjcpIiwibWl4ZWRDb2xvcnMiOlt7ImNvbG9yIjoicmdiYSgwLDAsMCwwKSIsInBlcmNlbnRhZ2UiOjYwfV0sImNzcyI6ImJhY2tncm91bmQ6IC13ZWJraXQtbGluZWFyLWdyYWRpZW50KDBkZWcscmdiYSgwLDAsMCwwLjcpLHJnYmEoMCwwLDAsMCkgNjAlLHJnYmEoMCwwLDAsMCkpO2JhY2tncm91bmQ6IGxpbmVhci1ncmFkaWVudCgwZGVnLHJnYmEoMCwwLDAsMC43KSxyZ2JhKDAsMCwwLDApIDYwJSxyZ2JhKDAsMCwwLDApKTsiLCJjc3NQYXJhbXMiOiIwZGVnLHJnYmEoMCwwLDAsMC43KSxyZ2JhKDAsMCwwLDApIDYwJSxyZ2JhKDAsMCwwLDApIn0=",
                                "overlay_h_general" => "",
                                "overlay_1" => "",
                                "overlay_2" => "",
                                "overlay_3" => "",
                                "overlay_4" => "",
                                "lightsky" => "",
                            ),
                            array(
                                'tdc_preset_name' => '', // Style 2 - colors
                                'tdc_preset_class' => 'tdcp_img tdcp_style tdcp_style2',
                                'tdc_preset_individual' => '1',
                                "overlay_h_general" => "",
                                "overlay_1" => "eyJ0eXBlIjoiZ3JhZGllbnQiLCJjb2xvcjEiOiJyZ2JhKDc0LDE0Myw5NCwwLjYpIiwiY29sb3IyIjoicmdiYSg3NywxNzgsMjM2LDAuNikiLCJtaXhlZENvbG9ycyI6W10sImRlZ3JlZSI6IjQ1IiwiY3NzIjoiYmFja2dyb3VuZDogLXdlYmtpdC1saW5lYXItZ3JhZGllbnQoNDVkZWcscmdiYSg3NywxNzgsMjM2LDAuNikscmdiYSg3NCwxNDMsOTQsMC42KSk7YmFja2dyb3VuZDogbGluZWFyLWdyYWRpZW50KDQ1ZGVnLHJnYmEoNzcsMTc4LDIzNiwwLjYpLHJnYmEoNzQsMTQzLDk0LDAuNikpOyIsImNzc1BhcmFtcyI6IjQ1ZGVnLHJnYmEoNzcsMTc4LDIzNiwwLjYpLHJnYmEoNzQsMTQzLDk0LDAuNikifQ==",
                                "overlay_2" => "eyJ0eXBlIjoiZ3JhZGllbnQiLCJjb2xvcjEiOiJyZ2JhKDE5OCw1Nyw1NywwLjYpIiwiY29sb3IyIjoicmdiYSgyMDksMTE4LDcwLDAuNikiLCJtaXhlZENvbG9ycyI6W10sImRlZ3JlZSI6IjQ1IiwiY3NzIjoiYmFja2dyb3VuZDogLXdlYmtpdC1saW5lYXItZ3JhZGllbnQoNDVkZWcscmdiYSgyMDksMTE4LDcwLDAuNikscmdiYSgxOTgsNTcsNTcsMC42KSk7YmFja2dyb3VuZDogbGluZWFyLWdyYWRpZW50KDQ1ZGVnLHJnYmEoMjA5LDExOCw3MCwwLjYpLHJnYmEoMTk4LDU3LDU3LDAuNikpOyIsImNzc1BhcmFtcyI6IjQ1ZGVnLHJnYmEoMjA5LDExOCw3MCwwLjYpLHJnYmEoMTk4LDU3LDU3LDAuNikifQ==",
                                "overlay_3" => "eyJ0eXBlIjoiZ3JhZGllbnQiLCJjb2xvcjEiOiJyZ2JhKDU5LDEyMCwxODAsMC41OSkiLCJjb2xvcjIiOiJyZ2JhKDIxNSw5NiwxODMsMC42KSIsIm1peGVkQ29sb3JzIjpbXSwiZGVncmVlIjoiLTQ1IiwiY3NzIjoiYmFja2dyb3VuZDogLXdlYmtpdC1saW5lYXItZ3JhZGllbnQoLTQ1ZGVnLHJnYmEoMjE1LDk2LDE4MywwLjYpLHJnYmEoNTksMTIwLDE4MCwwLjU5KSk7YmFja2dyb3VuZDogbGluZWFyLWdyYWRpZW50KC00NWRlZyxyZ2JhKDIxNSw5NiwxODMsMC42KSxyZ2JhKDU5LDEyMCwxODAsMC41OSkpOyIsImNzc1BhcmFtcyI6Ii00NWRlZyxyZ2JhKDIxNSw5NiwxODMsMC42KSxyZ2JhKDU5LDEyMCwxODAsMC41OSkifQ==",
                                "overlay_4" => "eyJ0eXBlIjoiZ3JhZGllbnQiLCJjb2xvcjEiOiJyZ2JhKDI0MiwxMjIsNTMsMC42KSIsImNvbG9yMiI6InJnYmEoMjQ0LDIwOCw2MywwLjYpIiwibWl4ZWRDb2xvcnMiOltdLCJkZWdyZWUiOiItNDUiLCJjc3MiOiJiYWNrZ3JvdW5kOiAtd2Via2l0LWxpbmVhci1ncmFkaWVudCgtNDVkZWcscmdiYSgyNDQsMjA4LDYzLDAuNikscmdiYSgyNDIsMTIyLDUzLDAuNikpO2JhY2tncm91bmQ6IGxpbmVhci1ncmFkaWVudCgtNDVkZWcscmdiYSgyNDQsMjA4LDYzLDAuNikscmdiYSgyNDIsMTIyLDUzLDAuNikpOyIsImNzc1BhcmFtcyI6Ii00NWRlZyxyZ2JhKDI0NCwyMDgsNjMsMC42KSxyZ2JhKDI0MiwxMjIsNTMsMC42KSJ9",
                                "lightsky" => "",
                            ),
                            array(
                                'tdc_preset_name' => '', // Style 3 - flat colors
                                'tdc_preset_class' => 'tdcp_img tdcp_style tdcp_style3',
                                'tdc_preset_individual' => '1',
                                "overlay_h_general" => "",
                                "overlay_1" => "eyJ0eXBlIjoiZ3JhZGllbnQiLCJjb2xvcjEiOiJyZ2JhKDc0LDE0Myw5NCwwLjgpIiwiY29sb3IyIjoicmdiYSg3NywxNzgsMjM2LDAuOCkiLCJtaXhlZENvbG9ycyI6W10sImRlZ3JlZSI6IjQ1IiwiY3NzIjoiYmFja2dyb3VuZDogLXdlYmtpdC1saW5lYXItZ3JhZGllbnQoNDVkZWcscmdiYSg3NywxNzgsMjM2LDAuOCkscmdiYSg3NCwxNDMsOTQsMC44KSk7YmFja2dyb3VuZDogbGluZWFyLWdyYWRpZW50KDQ1ZGVnLHJnYmEoNzcsMTc4LDIzNiwwLjgpLHJnYmEoNzQsMTQzLDk0LDAuOCkpOyIsImNzc1BhcmFtcyI6IjQ1ZGVnLHJnYmEoNzcsMTc4LDIzNiwwLjgpLHJnYmEoNzQsMTQzLDk0LDAuOCkifQ==",
                                "overlay_2" => "eyJ0eXBlIjoiZ3JhZGllbnQiLCJjb2xvcjEiOiJyZ2JhKDE5OCw1Nyw1NywwLjgpIiwiY29sb3IyIjoicmdiYSgyMDksMTE4LDcwLDAuOCkiLCJtaXhlZENvbG9ycyI6W10sImRlZ3JlZSI6IjQ1IiwiY3NzIjoiYmFja2dyb3VuZDogLXdlYmtpdC1saW5lYXItZ3JhZGllbnQoNDVkZWcscmdiYSgyMDksMTE4LDcwLDAuOCkscmdiYSgxOTgsNTcsNTcsMC44KSk7YmFja2dyb3VuZDogbGluZWFyLWdyYWRpZW50KDQ1ZGVnLHJnYmEoMjA5LDExOCw3MCwwLjgpLHJnYmEoMTk4LDU3LDU3LDAuOCkpOyIsImNzc1BhcmFtcyI6IjQ1ZGVnLHJnYmEoMjA5LDExOCw3MCwwLjgpLHJnYmEoMTk4LDU3LDU3LDAuOCkifQ==",
                                "overlay_3" => "eyJ0eXBlIjoiZ3JhZGllbnQiLCJjb2xvcjEiOiJyZ2JhKDU5LDEyMCwxODAsMC44KSIsImNvbG9yMiI6InJnYmEoMjE1LDk2LDE4MywwLjgpIiwibWl4ZWRDb2xvcnMiOltdLCJkZWdyZWUiOiItNDUiLCJjc3MiOiJiYWNrZ3JvdW5kOiAtd2Via2l0LWxpbmVhci1ncmFkaWVudCgtNDVkZWcscmdiYSgyMTUsOTYsMTgzLDAuOCkscmdiYSg1OSwxMjAsMTgwLDAuOCkpO2JhY2tncm91bmQ6IGxpbmVhci1ncmFkaWVudCgtNDVkZWcscmdiYSgyMTUsOTYsMTgzLDAuOCkscmdiYSg1OSwxMjAsMTgwLDAuOCkpOyIsImNzc1BhcmFtcyI6Ii00NWRlZyxyZ2JhKDIxNSw5NiwxODMsMC44KSxyZ2JhKDU5LDEyMCwxODAsMC44KSJ9",
                                "overlay_4" => "eyJ0eXBlIjoiZ3JhZGllbnQiLCJjb2xvcjEiOiJyZ2JhKDI0MiwxMjIsNTMsMC44KSIsImNvbG9yMiI6InJnYmEoMjQ0LDIwOCw2MywwLjgpIiwibWl4ZWRDb2xvcnMiOltdLCJkZWdyZWUiOiItNDUiLCJjc3MiOiJiYWNrZ3JvdW5kOiAtd2Via2l0LWxpbmVhci1ncmFkaWVudCgtNDVkZWcscmdiYSgyNDQsMjA4LDYzLDAuOCkscmdiYSgyNDIsMTIyLDUzLDAuOCkpO2JhY2tncm91bmQ6IGxpbmVhci1ncmFkaWVudCgtNDVkZWcscmdiYSgyNDQsMjA4LDYzLDAuOCkscmdiYSgyNDIsMTIyLDUzLDAuOCkpOyIsImNzc1BhcmFtcyI6Ii00NWRlZyxyZ2JhKDI0NCwyMDgsNjMsMC44KSxyZ2JhKDI0MiwxMjIsNTMsMC44KSJ9",
                                "lightsky" => "",
                            ),
                            array(
                                'tdc_preset_name' => '', // Style 4 - light sky
                                'tdc_preset_class' => 'tdcp_img tdcp_style tdcp_style4',
                                'tdc_preset_individual' => '1',
                                "overlay_general" => "rgba(0,0,0,0.7)",
                                "overlay_h_general" => "rgba(77,178,236,0.3)",
                                "overlay_1" => "",
                                "overlay_2" => "",
                                "overlay_3" => "",
                                "overlay_4" => "",
                                "lightsky" => "yes",
                            ),
                            array(
                                'tdc_preset_name' => '', // Style 5 - rainbow
                                'tdc_preset_class' => 'tdcp_img tdcp_style tdcp_style5',
                                'tdc_preset_individual' => '1',
                                "overlay_h_general" => "",
                                "overlay_1" => "eyJ0eXBlIjoiZ3JhZGllbnQiLCJjb2xvcjEiOiJyZ2JhKDI1NSwxMTEsNDksMC42KSIsImNvbG9yMiI6InJnYmEoNjUsMTIsMTg4LDAuNikiLCJtaXhlZENvbG9ycyI6W10sImRlZ3JlZSI6IjIwIiwiY3NzIjoiYmFja2dyb3VuZDogLXdlYmtpdC1saW5lYXItZ3JhZGllbnQoMjBkZWcscmdiYSg2NSwxMiwxODgsMC42KSxyZ2JhKDI1NSwxMTEsNDksMC42KSk7YmFja2dyb3VuZDogbGluZWFyLWdyYWRpZW50KDIwZGVnLHJnYmEoNjUsMTIsMTg4LDAuNikscmdiYSgyNTUsMTExLDQ5LDAuNikpOyIsImNzc1BhcmFtcyI6IjIwZGVnLHJnYmEoNjUsMTIsMTg4LDAuNikscmdiYSgyNTUsMTExLDQ5LDAuNikifQ==",
                                "overlay_2" => "eyJ0eXBlIjoiZ3JhZGllbnQiLCJjb2xvcjEiOiJyZ2JhKDExMiwyNTUsMTUzLDAuNikiLCJjb2xvcjIiOiJyZ2JhKDI0NCwxMzYsMTMsMC42KSIsIm1peGVkQ29sb3JzIjpbXSwiZGVncmVlIjoiMjAiLCJjc3MiOiJiYWNrZ3JvdW5kOiAtd2Via2l0LWxpbmVhci1ncmFkaWVudCgyMGRlZyxyZ2JhKDI0NCwxMzYsMTMsMC42KSxyZ2JhKDExMiwyNTUsMTUzLDAuNikpO2JhY2tncm91bmQ6IGxpbmVhci1ncmFkaWVudCgyMGRlZyxyZ2JhKDI0NCwxMzYsMTMsMC42KSxyZ2JhKDExMiwyNTUsMTUzLDAuNikpOyIsImNzc1BhcmFtcyI6IjIwZGVnLHJnYmEoMjQ0LDEzNiwxMywwLjYpLHJnYmEoMTEyLDI1NSwxNTMsMC42KSJ9",
                                "overlay_3" => "eyJ0eXBlIjoiZ3JhZGllbnQiLCJjb2xvcjEiOiJyZ2JhKDEyNiwxOTEsMjU1LDAuNikiLCJjb2xvcjIiOiJyZ2JhKDE5NiwxNSwxMjEsMC42KSIsIm1peGVkQ29sb3JzIjpbXSwiZGVncmVlIjoiMjAiLCJjc3MiOiJiYWNrZ3JvdW5kOiAtd2Via2l0LWxpbmVhci1ncmFkaWVudCgyMGRlZyxyZ2JhKDE5NiwxNSwxMjEsMC42KSxyZ2JhKDEyNiwxOTEsMjU1LDAuNikpO2JhY2tncm91bmQ6IGxpbmVhci1ncmFkaWVudCgyMGRlZyxyZ2JhKDE5NiwxNSwxMjEsMC42KSxyZ2JhKDEyNiwxOTEsMjU1LDAuNikpOyIsImNzc1BhcmFtcyI6IjIwZGVnLHJnYmEoMTk2LDE1LDEyMSwwLjYpLHJnYmEoMTI2LDE5MSwyNTUsMC42KSJ9",
                                "overlay_4" => "eyJ0eXBlIjoiZ3JhZGllbnQiLCJjb2xvcjEiOiJyZ2JhKDQyLDIzNiwxMTYsMC42KSIsImNvbG9yMiI6InJnYmEoMCwyMiwxOTAsMC42KSIsIm1peGVkQ29sb3JzIjpbXSwiZGVncmVlIjoiMjAiLCJjc3MiOiJiYWNrZ3JvdW5kOiAtd2Via2l0LWxpbmVhci1ncmFkaWVudCgyMGRlZyxyZ2JhKDAsMjIsMTkwLDAuNikscmdiYSg0MiwyMzYsMTE2LDAuNikpO2JhY2tncm91bmQ6IGxpbmVhci1ncmFkaWVudCgyMGRlZyxyZ2JhKDAsMjIsMTkwLDAuNikscmdiYSg0MiwyMzYsMTE2LDAuNikpOyIsImNzc1BhcmFtcyI6IjIwZGVnLHJnYmEoMCwyMiwxOTAsMC42KSxyZ2JhKDQyLDIzNiwxMTYsMC42KSJ9",
                                "lightsky" => "",
                            ),
                        )
                    )
                ),
                "params" => array_merge(
                    array(
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Content length',
                            "value"      => "",
                            "class"      => "",
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Module Flex 6',
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                        ),
                        array(
                            "param_name"  => "mf6_tl",
                            "type"        => "textfield",
                            "value"       => '',
                            "heading"     => 'Title length',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-small",
                            "placeholder" => '25',
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Module Flex 7',
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                        ),
                        array(
                            "param_name"  => "mf7_tl",
                            "type"        => "textfield",
                            "value"       => '',
                            "heading"     => 'Title length',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-small",
                            "placeholder" => '25',
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Module Flex 8',
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                        ),
                        array(
                            "param_name"  => "mf8_tl",
                            "type"        => "textfield",
                            "value"       => '',
                            "heading"     => 'Title length',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-small",
                            "placeholder" => '25',
                        ),
                    ),
                    self::td_block_big_grid_params(),
                    array(
                        array(
                            "param_name"  => "modules_gap",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Modules gap',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-small",
                            "placeholder" => "4",
                            "group"       => "Layout",
                        ),
                        array(
                            "param_name" => "meta_info_horiz",
                            "type" => "dropdown",
                            "value" => array(
                                'Left' => 'content-horiz-left',
                                'Center' => 'content-horiz-center',
                                'Right' => 'content-horiz-right'
                            ),
                            "heading" => 'Meta info horiz align',
                            "description" => "",
                            "holder" => "div",
                            'tdc_dropdown_images' => true,
                            "class" => "tdc-visual-selector tdc-add-class",
                            "group"       => "Layout",
                        ),
                        array(
                            "param_name" => "meta_info_vert",
                            "type" => "dropdown",
                            "value" => array(
                                'Left' => 'content-vert-top',
                                'Center' => 'content-vert-center',
                                'Right' => 'content-vert-bottom'
                            ),
                            "heading" => 'Meta info vert align',
                            "description" => "",
                            "holder" => "div",
                            'tdc_dropdown_images' => true,
                            "class" => "tdc-visual-selector tdc-add-class",
                            "group"       => "Layout",
                        ),
                        array(
                            "param_name"  => "image_zoom",
                            "type"        => "checkbox",
                            "value"       => '',
                            "heading"     => "Zoom effect on hover",
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "",
                            "group"       => 'Layout'
                        ),
                        array(
                            "param_name"  => "modules_category",
                            "type"        => "dropdown",
                            "value"       => array(
                                'Inline'      => '',
                                'Above title' => 'above',
                            ),
                            "heading"     => 'Category tag position',
                            "description" => "Float image",
                            "holder"      => "div",
                            "class"       => "tdc-dropdown-big",
                            "group"       => "Layout",
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Module Category Grid 1',
                            "value"      => "",
                            "class"      => "",
                            "group"      => "Layout",
                        ),
                        array(
                            "param_name"  => "image_size",
                            "type"        => "dropdown",
                            "value"       => array(
                                'XSmall - 324px' => 'td_324x400',
                                'Small - 696px'  => '',
                                'Large - 1068px' => 'td_1068x0',
                                'Full - 1920px'  => 'td_1920x0'
                            ),
                            "heading"     => 'Image size',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-dropdown-big",
                            "group"       => "Layout",
                        ),
                        array(
                            'param_name'  => 'image_alignment1',
                            'type'        => 'range-responsive',
                            'value'       => '50',
                            'heading'     => 'Image V alignment',
                            'description' => '0 - Top / 50 - Center / 100 - Bottom',
                            'class'       => 'tdc-textfield-small',
                            'range_min'   => '0',
                            'range_max'   => '100',
                            'range_step'  => '1',
                            "group"       => "Layout",
                        ),
                        array(
                            "param_name"  => "image_width1",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Image width (percent)',
                            "description" => "Default value in percent",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-small",
                            "placeholder" => "50",
                            "group"       => "Layout",
                        ),
                        array(
                            "param_name"  => "image_height1",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Image height (percent)',
                            "description" => "Default value in percent",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-small",
                            "placeholder" => "450px",
                            "group"       => "Layout",
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "horizontal_separator",
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                            "group"      => "Layout",
                        ),
                        array(
                            "param_name"  => "meta_width1",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Meta info width',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-small",
                            "placeholder" => "100%",
                            "group"       => "Layout",
                        ),
                        array(
                            "param_name"  => "meta_margin1",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Meta info margin',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-big",
                            "placeholder" => "0px 0px 0px 0px",
                            "group"       => "Layout",
                        ),
                        array(
                            "param_name"  => "meta_padding1",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Meta info padding',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-big",
                            "placeholder" => "22px 20px",
                            "group"       => "Layout",
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "horizontal_separator",
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                            "group"      => "Layout",
                        ),
                        array(
                            "param_name"  => "art_title1",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Article title space',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-big",
                            "placeholder" => "0px 0px 9px 0px",
                            "group"       => "Layout",
                        ),
                        array(
                            "param_name"  => "art_title_padd1",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Article title padding',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-big",
                            "placeholder" => "0px 0px 0px 0px",
                            "group"       => "Layout",
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "horizontal_separator",
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                            "group"      => "Layout",
                        ),
                        array(
                            "param_name"  => "modules_category_margin1",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Category tag spacing',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-big",
                            "placeholder" => "0px 0px 5px 0px",
                            "group"       => "Layout",
                        ),
                        array(
                            "param_name"  => "modules_category_padding1",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Category tag padding',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-big",
                            "placeholder" => "3px 6px 3px 6px",
                            "group"       => "Layout",
                        ),
                        array(
                            "param_name"  => "show_cat1",
                            "type"        => "dropdown-responsive",
                            "value"       => array(
                                'Show' => 'inline-block',
                                'Hide' => 'none',
                            ),
                            "heading"     => 'Show category',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-dropdown-big",
                            "group"       => "Layout",
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "horizontal_separator",
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                            "group"      => "Layout",
                        ),
                        array(
                            "param_name"  => "show_author1",
                            "type"        => "dropdown-responsive",
                            "value"       => array(
                                'Show' => 'inline-block',
                                'Hide' => 'none',
                            ),
                            "heading"     => 'Show author',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-dropdown-big",
                            "group"       => "Layout",
                        ),
                        array(
                            "param_name"  => "show_date1",
                            "type"        => "dropdown-responsive",
                            "value"       => array(
                                'Show' => 'inline-block',
                                'Hide' => 'none',
                            ),
                            "heading"     => 'Show date',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-dropdown-big",
                            "group"       => "Layout",
                        ),
                        array(
                            "param_name"  => "auth_date_padding1",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Author & date padding',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-big",
                            "placeholder" => "0px 0px 0px 0px",
                            "group"       => "Layout",
                        ),

                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Module Category Grid 2',
                            "value"      => "",
                            "class"      => "",
                            "group"      => "Layout",
                        ),
                        array(
                            "param_name"  => "image_size2",
                            "type"        => "dropdown",
                            "value"       => array(
                                'XSmall - 324px' => 'td_324x400',
                                'Small - 696px'  => '',
                                'Large - 1068px' => 'td_1068x0',
                                'Full - 1920px'  => 'td_1920x0'
                            ),
                            "heading"     => 'Image size',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-dropdown-big",
                            "group"       => "Layout",
                        ),
                        array(
                            'param_name'  => 'image_alignment2',
                            'type'        => 'range-responsive',
                            'value'       => '50',
                            'heading'     => 'Image V alignment',
                            'description' => '0 - Top / 50 - Center / 100 - Bottom',
                            'class'       => 'tdc-textfield-small',
                            'range_min'   => '0',
                            'range_max'   => '100',
                            'range_step'  => '1',
                            "group"       => "Layout",
                        ),
                        array(
                            "param_name"  => "image_width2",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Image width (percent)',
                            "description" => "Default value in percent",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-small",
                            "placeholder" => "50",
                            "group"       => "Layout",
                        ),
                        array(
                            "param_name"  => "image_height2",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Image height (percent)',
                            "description" => "Default value in percent",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-small",
                            "placeholder" => "254px",
                            "group"       => "Layout",
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "horizontal_separator",
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                            "group"      => "Layout",
                        ),
                        array(
                            "param_name"  => "meta_width2",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Meta info width',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-small",
                            "placeholder" => "100%",
                            "group"       => "Layout",
                        ),
                        array(
                            "param_name"  => "meta_margin2",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Meta info margin',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-big",
                            "placeholder" => "0px 0px 0px 0px",
                            "group"       => "Layout",
                        ),
                        array(
                            "param_name"  => "meta_padding2",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Meta info padding',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-big",
                            "placeholder" => "14px 19px",
                            "group"       => "Layout",
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "horizontal_separator",
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                            "group"      => "Layout",
                        ),
                        array(
                            "param_name"  => "art_title2",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Article title space',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-big",
                            "placeholder" => "0px 0px 9px 0px",
                            "group"       => "Layout",
                        ),
                        array(
                            "param_name"  => "art_title_padd2",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Article title padding',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-big",
                            "placeholder" => "0px 0px 0px 0px",
                            "group"       => "Layout",
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "horizontal_separator",
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                            "group"      => "Layout",
                        ),
                        array(
                            "param_name"  => "modules_category_margin2",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Category tag spacing',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-big",
                            "placeholder" => "0px 0px 5px 0px",
                            "group"       => "Layout",
                        ),
                        array(
                            "param_name"  => "modules_category_padding2",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Category tag padding',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-big",
                            "placeholder" => "3px 6px 3px 6px",
                            "group"       => "Layout",
                        ),
                        array(
                            "param_name"  => "show_cat2",
                            "type"        => "dropdown-responsive",
                            "value"       => array(
                                'Show' => 'inline-block',
                                'Hide' => 'none',
                            ),
                            "heading"     => 'Show category',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-dropdown-big",
                            "group"       => "Layout",
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "horizontal_separator",
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                            "group"      => "Layout",
                        ),
                        array(
                            "param_name"  => "show_author2",
                            "type"        => "dropdown-responsive",
                            "value"       => array(
                                'Show' => 'inline-block',
                                'Hide' => 'none',
                            ),
                            "heading"     => 'Show author',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-dropdown-big",
                            "group"       => "Layout",
                        ),
                        array(
                            "param_name"  => "show_date2",
                            "type"        => "dropdown-responsive",
                            "value"       => array(
                                'Show' => 'inline-block',
                                'Hide' => 'none',
                            ),
                            "heading"     => 'Show date',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-dropdown-big",
                            "group"       => "Layout",
                        ),
                        array(
                            "param_name"  => "auth_date_padding2",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Author & date padding',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-big",
                            "placeholder" => "0px 0px 0px 0px",
                            "group"       => "Layout",
                        ),

                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Module Category Grid 3',
                            "value"      => "",
                            "class"      => "",
                            "group"      => "Layout",
                        ),
                        array(
                            "param_name"  => "image_size3",
                            "type"        => "dropdown",
                            "value"       => array(
                                'XSmall - 324px' => 'td_324x400',
                                'Small - 696px'  => '',
                                'Large - 1068px' => 'td_1068x0',
                                'Full - 1920px'  => 'td_1920x0'
                            ),
                            "heading"     => 'Image size',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-dropdown-big",
                            "group"       => "Layout",
                        ),
                        array(
                            'param_name'  => 'image_alignment3',
                            'type'        => 'range-responsive',
                            'value'       => '50',
                            'heading'     => 'Image V alignment',
                            'description' => '0 - Top / 50 - Center / 100 - Bottom',
                            'class'       => 'tdc-textfield-small',
                            'range_min'   => '0',
                            'range_max'   => '100',
                            'range_step'  => '1',
                            "group"       => "Layout",
                        ),
                        array(
                            "param_name"  => "image_width3",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Image width (percent)',
                            "description" => "Default value in percent",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-small",
                            "placeholder" => "25",
                            "group"       => "Layout",
                        ),
                        array(
                            "param_name"  => "image_height3",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Image height (percent)',
                            "description" => "Default value in percent",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-small",
                            "placeholder" => "192px",
                            "group"       => "Layout",
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "horizontal_separator",
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                            "group"      => "Layout",
                        ),
                        array(
                            "param_name"  => "meta_width3",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Meta info width',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-small",
                            "placeholder" => "100%",
                            "group"       => "Layout",
                        ),
                        array(
                            "param_name"  => "meta_margin3",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Meta info margin',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-big",
                            "placeholder" => "0px 0px 0px 0px",
                            "group"       => "Layout",
                        ),
                        array(
                            "param_name"  => "meta_padding3",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Meta info padding',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-big",
                            "placeholder" => "11px 15px",
                            "group"       => "Layout",
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "horizontal_separator",
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                            "group"      => "Layout",
                        ),
                        array(
                            "param_name"  => "art_title3",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Article title space',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-big",
                            "placeholder" => "0px 0px 9px 0px",
                            "group"       => "Layout",
                        ),
                        array(
                            "param_name"  => "art_title_padd3",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Article title padding',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-big",
                            "placeholder" => "0px 0px 0px 0px",
                            "group"       => "Layout",
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "horizontal_separator",
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                            "group"      => "Layout",
                        ),
                        array(
                            "param_name"  => "modules_category_margin3",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Category tag spacing',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-big",
                            "placeholder" => "0px 0px 7px 0px",
                            "group"       => "Layout",
                        ),
                        array(
                            "param_name"  => "modules_category_padding3",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Category tag padding',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-big",
                            "placeholder" => "3px 6px 3px 6px",
                            "group"       => "Layout",
                        ),
                        array(
                            "param_name"  => "show_cat3",
                            "type"        => "dropdown-responsive",
                            "value"       => array(
                                'Show' => 'inline-block',
                                'Hide' => 'none',
                            ),
                            "heading"     => 'Show category',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-dropdown-big",
                            "group"       => "Layout",
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "horizontal_separator",
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                            "group"      => "Layout",
                        ),
                        array(
                            "param_name"  => "show_author3",
                            "type"        => "dropdown-responsive",
                            "value"       => array(
                                'Show' => 'inline-block',
                                'Hide' => 'none',
                            ),
                            "heading"     => 'Show author',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-dropdown-big",
                            "group"       => "Layout",
                        ),
                        array(
                            "param_name"  => "show_date3",
                            "type"        => "dropdown-responsive",
                            "value"       => array(
                                'Show' => 'inline-block',
                                'Hide' => 'none',
                            ),
                            "heading"     => 'Show date',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-dropdown-big",
                            "group"       => "Layout",
                        ),
                        array(
                            "param_name"  => "auth_date_padding3",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Author & date padding',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-big",
                            "placeholder" => "0px 0px 0px 0px",
                            "group"       => "Layout",
                        ),

                        array(
                            "param_name" => "separator",
                            "type" => "text_separator",
                            'heading' => 'Module fonts',
                            "value" => "",
                            "class" => "",
                            "group" => 'Style',
                        ),
                    ),
                    td_config_helper::get_map_block_font_array( 'f_title1', true, 'Module 1 title', 'Style' ),
                    td_config_helper::get_map_block_font_array( 'f_cat1', false, 'Module 1 category tag', 'Style' ),
                    td_config_helper::get_map_block_font_array( 'f_meta1', false, 'Module 1 meta info', 'Style' ),
                    td_config_helper::get_map_block_font_array( 'f_title2', false, 'Module 2 title', 'Style' ),
                    td_config_helper::get_map_block_font_array( 'f_cat2', false, 'Module 2 category tag', 'Style' ),
                    td_config_helper::get_map_block_font_array( 'f_meta2', false, 'Module 2 meta info', 'Style' ),
                    td_config_helper::get_map_block_font_array( 'f_title3', false, 'Module 3 title', 'Style' ),
                    td_config_helper::get_map_block_font_array( 'f_cat3', false, 'Module 3 category tag', 'Style' ),
                    td_config_helper::get_map_block_font_array( 'f_meta3', false, 'Module 3 meta info', 'Style' ),
                    array(
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Colors',
                            "value"      => "",
                            "class"      => "",
                            "group"      => "Style",
                        ),
                        array(
                            "param_name" => "overlay_general",
                            "holder" => "div",
                            "type" => "gradient",
                            'heading' => "General module overlay color",
                            "value" => "",
                            "class" => "",
                            "group"      => "Style",
                        ),
                        array(
                            "param_name" => "overlay_h_general",
                            "holder" => "div",
                            "type" => "gradient",
                            'heading' => "General module overlay hover color",
                            "value" => "",
                            "class" => "",
                            "group"      => "Style",
                        ),
                        array(
                            "param_name" => "overlay_1",
                            "holder" => "div",
                            "type" => "gradient",
                            'heading' => "Module overlay color 1",
                            "value" => "",
                            "class" => "",
                            "group"      => "Style",
                        ),
                        array(
                            "param_name" => "overlay_2",
                            "holder" => "div",
                            "type" => "gradient",
                            'heading' => "Module overlay color 2",
                            "value" => "",
                            "class" => "",
                            "group"      => "Style",
                        ),
                        array(
                            "param_name" => "overlay_3",
                            "holder" => "div",
                            "type" => "gradient",
                            'heading' => "Module overlay color 3",
                            "value" => "",
                            "class" => "",
                            "group"      => "Style",
                        ),
                        array(
                            "param_name" => "overlay_4",
                            "holder" => "div",
                            "type" => "gradient",
                            'heading' => "Module overlay color 4",
                            "value" => "",
                            "class" => "",
                            "group"      => "Style",
                        ),
                        array(
                            "param_name"  => "lightsky",
                            "type"        => "checkbox",
                            "value"       => '',
                            "heading"     => "Lightsky",
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "",
                            "group"       => 'Style'
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "",
                            "heading"     => 'Meta info background',
                            "param_name"  => "meta_bg",
                            "value"       => '',
                            "description" => '',
                            "group"       => 'Style',
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "horizontal_separator",
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                            "group"      => "Style",
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "",
                            "heading"     => 'Article title text color',
                            "param_name"  => "title_txt",
                            "value"       => '',
                            "description" => '',
                            "group"       => 'Style',
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "",
                            "heading"     => 'Article title text hover',
                            "param_name"  => "title_txt_hover",
                            "value"       => '',
                            "description" => '',
                            "group"       => 'Style',
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "",
                            "heading"     => 'Article title background color',
                            "param_name"  => "title_bg",
                            "value"       => '',
                            "description" => '',
                            "group"       => 'Style',
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "horizontal_separator",
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                            "group"      => "Style",
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "",
                            "heading"     => 'Category background',
                            "param_name"  => "cat_bg",
                            "value"       => '',
                            "description" => '',
                            "group"       => 'Style',
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "",
                            "heading"     => 'Category text color',
                            "param_name"  => "cat_txt",
                            "value"       => '',
                            "description" => '',
                            "group"       => 'Style',
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "",
                            "heading"     => 'Category background hover',
                            "param_name"  => "cat_bg_hover",
                            "value"       => '',
                            "description" => '',
                            "group"       => 'Style',
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "",
                            "heading"     => 'Category text hover',
                            "param_name"  => "cat_txt_hover",
                            "value"       => '',
                            "description" => '',
                            "group"       => 'Style',
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "horizontal_separator",
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                            "group"      => "Style",
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "",
                            "heading"     => 'Author text color',
                            "param_name"  => "author_txt",
                            "value"       => '',
                            "description" => '',
                            "group"       => 'Style',
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "",
                            "heading"     => 'Author text hover',
                            "param_name"  => "author_txt_hover",
                            "value"       => '',
                            "description" => '',
                            "group"       => 'Style',
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "",
                            "heading"     => 'Date text color',
                            "param_name"  => "date_txt",
                            "value"       => '',
                            "description" => '',
                            "group"       => 'Style',
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "",
                            "heading"     => 'Author & date background color',
                            "param_name"  => "auth_date_bg",
                            "value"       => '',
                            "description" => '',
                            "group"       => 'Style',
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "",
                            "heading"     => 'Review stars color',
                            "param_name"  => "review_stars",
                            "value"       => '',
                            "description" => '',
                            "group"       => 'Style',
                        ),
                    ),
                    self::get_map_css_tab()
                )
            )
        );

        td_api_block::add('td_block_big_grid_flex_6',
            array(
                'map_in_visual_composer' => false,
                'map_in_td_composer' => true,
                "name" => 'Big Grid Flex 6',
                "base" => 'td_block_big_grid_flex_6',
                "class" => 'td_block_big_grid_flex_6',
                "controls" => "full",
                "category" => 'Blocks',
                'tdc_category' => 'Big Grids',
                'icon' => 'icon-pagebuilder-td_block_big_grid_flex_6',
                'file' => td_global::$get_template_directory . '/includes/shortcodes/td_block_big_grid_flex_6.php',
                'tdc_style_params' => array(
                    'custom_title',
                    'custom_url',
                    'post_ids',
                    'category_id',
                    'category_ids',
                    'tag_slug',
                    'autors_id',
                    'installed_post_types',
                    'sort',
                    'offset',
                    'el_class'
                ),
                'tdc_start_values' => base64_encode(
                    json_encode(
                        array(
                            array(
                                "meta_info_vert" => "content-vert-bottom",
                                "image_zoom" => "yes",
                                "show_author2" => "eyJwaG9uZSI6Im5vbmUifQ==",
                                "show_date2" => "eyJwaG9uZSI6Im5vbmUifQ==",
                                "modules_category" => "above",
                                "overlay_general" => "eyJ0eXBlIjoiZ3JhZGllbnQiLCJjb2xvcjEiOiJyZ2JhKDAsMCwwLDApIiwiY29sb3IyIjoicmdiYSgwLDAsMCwwLjcpIiwibWl4ZWRDb2xvcnMiOlt7ImNvbG9yIjoicmdiYSgwLDAsMCwwKSIsInBlcmNlbnRhZ2UiOjYwfV0sImNzcyI6ImJhY2tncm91bmQ6IC13ZWJraXQtbGluZWFyLWdyYWRpZW50KDBkZWcscmdiYSgwLDAsMCwwLjcpLHJnYmEoMCwwLDAsMCkgNjAlLHJnYmEoMCwwLDAsMCkpO2JhY2tncm91bmQ6IGxpbmVhci1ncmFkaWVudCgwZGVnLHJnYmEoMCwwLDAsMC43KSxyZ2JhKDAsMCwwLDApIDYwJSxyZ2JhKDAsMCwwLDApKTsiLCJjc3NQYXJhbXMiOiIwZGVnLHJnYmEoMCwwLDAsMC43KSxyZ2JhKDAsMCwwLDApIDYwJSxyZ2JhKDAsMCwwLDApIn0=",
                                "image_height2" => "eyJwaG9uZSI6IjE2NXB4IiwibGFuZHNjYXBlIjoiMzYwcHgiLCJwb3J0cmFpdCI6IjI3NnB4In0=",
                                "image_height1" => "eyJwaG9uZSI6IjIwMHB4IiwicG9ydHJhaXQiOiIxMzZweCIsImxhbmRzY2FwZSI6IjE3NXB4In0=",
                                "meta_padding2" => "eyJwaG9uZSI6IjE2cHggMTVweCAxMXB4IiwicG9ydHJhaXQiOiIyMHB4IDE1cHgifQ==",
                                "meta_padding1" => "eyJwaG9uZSI6IjE1cHggMThweCJ9",
                                "cat_bg_hover" => "#4db2ec",
                                "review_stars" => "#fff",
                                "modules_category_margin2" => "eyJwb3J0cmFpdCI6IjBweCAwcHggNHB4IDBweCIsInBob25lIjoiMHB4IDBweCA3cHggMHB4In0=",
                                "modules_category_margin1" => "eyJwb3J0cmFpdCI6IjBweCAwcHggN3B4IDBweCIsInBob25lIjoiMHB4IDBweCA3cHggMHB4In0=",
                                "art_title1" => "eyJwaG9uZSI6IjBweCAwcHggOXB4IDBweCJ9",
                                "image_width1" => "eyJwaG9uZSI6IjEwMCJ9",
                                "image_width2" => "eyJwaG9uZSI6IjgwIn0=",
                                "show_author1" => "eyJwaG9uZSI6ImlubGluZS1ibG9jayIsImFsbCI6Im5vbmUifQ==",
                                "show_date1" => "eyJwaG9uZSI6ImlubGluZS1ibG9jayIsImFsbCI6Im5vbmUifQ==",
                                "image_size" => "td_324x400",
                                'image_size2' => '',
                                "modules_gap" => "eyJwb3J0cmFpdCI6IjQiLCJwaG9uZSI6IjMifQ==",
                                "image_width3" => "eyJwaG9uZSI6IjgwIn0=",
                                "art_title2" => "eyJwaG9uZSI6IjBweCAwcHggMHB4IDBweCJ9",
                                "show_author3" => "eyJwaG9uZSI6Im5vbmUifQ==",
                                "show_date3" => "eyJwaG9uZSI6Im5vbmUifQ==",
                                "image_height3" => "eyJwaG9uZSI6IjE2NXB4In0=",
                            ),

                            array(
                                'tdc_preset_name' => 'Font family',
                                'tdc_preset_class' => 'tdcp_separator tdcp_separator_font',
                            ),
                            array(
                                'tdc_preset_name' => '', // Font - Montserrat
                                'tdc_preset_class' => 'tdcp_img tdcp_font tdcp_font1',
                                'tdc_preset_individual' => '1',
                                "f_title1_font_family" =>        "394",
                                "f_title2_font_family" =>        "394",
                                "f_title3_font_family" =>        "394",
                            ),
                            array(
                                'tdc_preset_name' => '', // Font - Source Serif
                                'tdc_preset_class' => 'tdcp_img tdcp_font tdcp_font2',
                                'tdc_preset_individual' =>      '1',
                                "f_title1_font_family" =>        "721",
                                "f_title2_font_family" =>        "721",
                                "f_title3_font_family" =>        "721",
                            ),
                            array(
                                'tdc_preset_name' => '', // Font - Raleway
                                'tdc_preset_class' => 'tdcp_img tdcp_font tdcp_font3',
                                'tdc_preset_individual' => '1',
                                "f_title1_font_family" =>        "507",
                                "f_title2_font_family" =>        "507",
                                "f_title3_font_family" =>        "507",
                            ),
                            array(
                                'tdc_preset_name' => '', // Font - Work Sans
                                'tdc_preset_class' => 'tdcp_img tdcp_font tdcp_font4',
                                'tdc_preset_individual' => '1',
                                "f_title1_font_family" =>        "653",
                                "f_title2_font_family" =>        "653",
                                "f_title3_font_family" =>        "653",
                            ),
                            array(
                                'tdc_preset_name' => '', // Font - Courgette
                                'tdc_preset_class' => 'tdcp_img tdcp_font tdcp_font5',
                                'tdc_preset_individual' => '1',
                                "f_title1_font_family" =>        "147",
                                "f_title2_font_family" =>        "147",
                                "f_title3_font_family" =>        "147",
                            ),
                            array(
                                'tdc_preset_name' => '', // Font - Oswald
                                'tdc_preset_class' => 'tdcp_img tdcp_font tdcp_font7',
                                'tdc_preset_individual' => '1',
                                "f_title1_font_family" =>        "445",
                                "f_title2_font_family" =>        "445",
                                "f_title3_font_family" =>        "445",
                            ),
                            array(
                                'tdc_preset_name' => '', // Font - Muli
                                'tdc_preset_class' => 'tdcp_img tdcp_font tdcp_font8',
                                'tdc_preset_individual' => '1',
                                "f_title1_font_family" =>        "406",
                                "f_title2_font_family" =>        "406",
                                "f_title3_font_family" =>        "406",
                            ),
                            array(
                                'tdc_preset_name' => '', // Font - Wendy One
                                'tdc_preset_class' => 'tdcp_img tdcp_font tdcp_font9',
                                'tdc_preset_individual' => '1',
                                "f_title1_font_family" =>        "646",
                                "f_title2_font_family" =>        "646",
                                "f_title3_font_family" =>        "646",
                            ),
                            array(
                                'tdc_preset_name' => '', // Font - Anton
                                'tdc_preset_class' => 'tdcp_img tdcp_font tdcp_font10',
                                'tdc_preset_individual' => '1',
                                "f_title1_font_family" =>        "41",
                                "f_title2_font_family" =>        "41",
                                "f_title3_font_family" =>        "41",
                            ),
                            array(
                                'tdc_preset_name' => '', // Font - Quicksand
                                'tdc_preset_class' => 'tdcp_img tdcp_font tdcp_font11',
                                'tdc_preset_individual' => '1',
                                "f_title1_font_family" =>        "502",
                                "f_title2_font_family" =>        "502",
                                "f_title3_font_family" =>        "502",
                            ),
                            array(
                                'tdc_preset_name' => '', // Font - Libre Baskerville
                                'tdc_preset_class' => 'tdcp_img tdcp_font tdcp_font12',
                                'tdc_preset_individual' => '1',
                                "f_title1_font_family" =>        "331",
                                "f_title2_font_family" =>        "331",
                                "f_title3_font_family" =>        "331",
                            ),
                            array(
                                'tdc_preset_name' => '', // Font - Caveat
                                'tdc_preset_class' => 'tdcp_img tdcp_font tdcp_font13',
                                'tdc_preset_individual' => '1',
                                "f_title1_font_family" =>        "663",
                                "f_title2_font_family" =>        "663",
                                "f_title3_font_family" =>        "663",
                            ),
                            array(
                                'tdc_preset_name' => '', // Font - Volkorn
                                'tdc_preset_class' => 'tdcp_img tdcp_font tdcp_font14',
                                'tdc_preset_individual' => '1',
                                "f_title1_font_family" =>        "639",
                                "f_title2_font_family" =>        "639",
                                "f_title3_font_family" =>        "639",
                            ),
                            array(
                                'tdc_preset_name' => '', // Font - Default
                                'tdc_preset_class' => 'tdcp_img tdcp_font tdcp_font6',
                                'tdc_preset_individual' => '1',
                                "f_title1_font_family" =>        "",
                                "f_title2_font_family" =>        "",
                                "f_title3_font_family" =>        "",
                            ),

                            array(
                                'tdc_preset_name' => 'Font size',
                                'tdc_preset_class' => 'tdcp_separator tdcp_separator_size',
                            ),
                            array(
                                'tdc_preset_name' => '', // Size - XS 13/13/12/14
                                'tdc_preset_class' => 'tdcp_img tdcp_size tdcp_size1',
                                'tdc_preset_individual' => '1',
                                "f_title1_font_size" => "eyJwaG9uZSI6IjE2In0=",
                                "f_title1_font_line_height" => "eyJwaG9uZSI6IjEuNCJ9",
                                "f_title2_font_size" => "eyJhbGwiOiIxNCIsInBvcnRyYWl0IjoiMTMifQ==",
                                "f_title2_font_line_height" => "1.4",
                                "f_title3_font_size" => "eyJwaG9uZSI6IjE0In0=",
                                "f_title3_font_line_height" => "eyJwaG9uZSI6IjEuNCJ9",
                            ),
                            array(
                                'tdc_preset_name' => '', // Size - S 14/13/12/14
                                'tdc_preset_class' => 'tdcp_img tdcp_size tdcp_size2',
                                'tdc_preset_individual' => '1',
                                "f_title1_font_size" => "eyJwaG9uZSI6IjE3In0=",
                                "f_title1_font_line_height" => "eyJwaG9uZSI6IjEuNCJ9",
                                "f_title2_font_size" => "eyJwb3J0cmFpdCI6IjE0IiwiYWxsIjoiMTYiLCJwaG9uZSI6IjE0In0=",
                                "f_title2_font_line_height" => "1.4",
                                "f_title3_font_size" => "eyJwaG9uZSI6IjE0In0=",
                                "f_title3_font_line_height" => "eyJwaG9uZSI6IjEuNCJ9",
                            ),
                            array(
                                'tdc_preset_name' => '', // Size - M 21/21/17/21
                                'tdc_preset_class' => 'tdcp_img tdcp_size tdcp_size3',
                                'tdc_preset_individual' => '1',
                                "f_title1_font_size" => "",
                                "f_title1_font_line_height" => "",
                                "f_title2_font_size" => "",
                                "f_title2_font_line_height" => "",
                                "f_title3_font_size" => "",
                                "f_title3_font_line_height" => "",
                            ),
                            array(
                                'tdc_preset_name' => '', // Size - L 26/25/21/21
                                'tdc_preset_class' => 'tdcp_img tdcp_size tdcp_size4',
                                'tdc_preset_individual' => '1',
                                "f_title1_font_size" => "eyJwaG9uZSI6IjIwIiwiYWxsIjoiMTQifQ==",
                                "f_title1_font_line_height" => "eyJwaG9uZSI6IjEuNCIsImFsbCI6IjEuNCJ9",
                                "f_title2_font_size" => "eyJwaG9uZSI6IjE1IiwiYWxsIjoiMjIiLCJwb3J0cmFpdCI6IjIwIn0=",
                                "f_title2_font_line_height" => "1.3",
                                "f_title3_font_size" => "eyJwaG9uZSI6IjE1In0=",
                                "f_title3_font_line_height" => "eyJwaG9uZSI6IjEuNCJ9",

                            ),
                            array(
                                'tdc_preset_name' => '', // Size - XL 30/28/24/21
                                'tdc_preset_class' => 'tdcp_img tdcp_size tdcp_size5',
                                'tdc_preset_individual' => '1',
                                "f_title1_font_size" => "eyJwaG9uZSI6IjIyIiwiYWxsIjoiMTUifQ==",
                                "f_title1_font_line_height" => "1.3",
                                "f_title2_font_size" => "eyJhbGwiOiIyNSIsInBvcnRyYWl0IjoiMjIiLCJwaG9uZSI6IjE1In0=",
                                "f_title2_font_line_height" => "1.3",
                                "f_title3_font_line_height" => "eyJwaG9uZSI6IjEuMyJ9",
                                "f_title3_font_size" => "eyJwaG9uZSI6IjE1In0=",
                            ),
                            array(
                                'tdc_preset_name' => '', // Size - XXL 36/32/26/21
                                'tdc_preset_class' => 'tdcp_img tdcp_size tdcp_size6',
                                'tdc_preset_individual' => '1',
                                "f_title1_font_size" => "eyJwaG9uZSI6IjIyIiwiYWxsIjoiMTYiLCJwb3J0cmFpdCI6IjE1In0=",
                                "f_title1_font_line_height" => "1.3",
                                "f_title2_font_size" => "eyJhbGwiOiIyNyIsInBvcnRyYWl0IjoiMjQiLCJwaG9uZSI6IjE1In0=",
                                "f_title2_font_line_height" => "1.3",
                                "f_title3_font_size" => "eyJwaG9uZSI6IjE1In0=",
                                "f_title3_font_line_height" => "eyJwaG9uZSI6IjEuMyJ9",
                            ),

                            array(
                                'tdc_preset_name' => 'Text horizontal alignment',
                                'tdc_preset_class' => 'tdcp_separator tdcp_separator_align',
                            ),
                            array(
                                'tdc_preset_name' => '', // Text alignment - left
                                'tdc_preset_class' => 'tdcp_img tdcp_align tdcp_align1',
                                'tdc_preset_individual' => '1',
                                "meta_info_horiz" => "content-horiz-left",
                            ),
                            array(
                                'tdc_preset_name' => '', // Text alignment - center
                                'tdc_preset_class' => 'tdcp_img tdcp_align tdcp_align2',
                                'tdc_preset_individual' => '1',
                                "meta_info_horiz" => "content-horiz-center",
                            ),
                            array(
                                'tdc_preset_name' => '', // Text alignment - right
                                'tdc_preset_class' => 'tdcp_img tdcp_align tdcp_align3',
                                'tdc_preset_individual' => '1',
                                "meta_info_horiz" => "content-horiz-right",
                            ),

                            array(
                                'tdc_preset_name' => 'Text vertical alignment',
                                'tdc_preset_class' => 'tdcp_separator tdcp_separator_align_v',
                            ),
                            array(
                                'tdc_preset_name' => '', // Text vertical alignment - top
                                'tdc_preset_class' => 'tdcp_img tdcp_align tdcp_align_v1',
                                'tdc_preset_individual' => '1',
                                "meta_info_vert" => "content-vert-top",
                            ),
                            array(
                                'tdc_preset_name' => '', // Text vertical alignment - middle
                                'tdc_preset_class' => 'tdcp_img tdcp_align tdcp_align_v2',
                                'tdc_preset_individual' => '1',
                                "meta_info_vert" => "content-vert-center",
                            ),
                            array(
                                'tdc_preset_name' => '', // Text vertical alignment - bottom
                                'tdc_preset_class' => 'tdcp_img tdcp_align tdcp_align_v3',
                                'tdc_preset_individual' => '1',
                                "meta_info_vert" => "content-vert-bottom",
                            ),

                            array(
                                'tdc_preset_name' => 'Style',
                                'tdc_preset_class' => 'tdcp_separator tdcp_separator_style',
                            ),
                            array(
                                'tdc_preset_name' => '', // Style 1 - default
                                'tdc_preset_class' => 'tdcp_img tdcp_style tdcp_style1',
                                'tdc_preset_individual' => '1',
                                "overlay_general" => "eyJ0eXBlIjoiZ3JhZGllbnQiLCJjb2xvcjEiOiJyZ2JhKDAsMCwwLDApIiwiY29sb3IyIjoicmdiYSgwLDAsMCwwLjcpIiwibWl4ZWRDb2xvcnMiOlt7ImNvbG9yIjoicmdiYSgwLDAsMCwwKSIsInBlcmNlbnRhZ2UiOjYwfV0sImNzcyI6ImJhY2tncm91bmQ6IC13ZWJraXQtbGluZWFyLWdyYWRpZW50KDBkZWcscmdiYSgwLDAsMCwwLjcpLHJnYmEoMCwwLDAsMCkgNjAlLHJnYmEoMCwwLDAsMCkpO2JhY2tncm91bmQ6IGxpbmVhci1ncmFkaWVudCgwZGVnLHJnYmEoMCwwLDAsMC43KSxyZ2JhKDAsMCwwLDApIDYwJSxyZ2JhKDAsMCwwLDApKTsiLCJjc3NQYXJhbXMiOiIwZGVnLHJnYmEoMCwwLDAsMC43KSxyZ2JhKDAsMCwwLDApIDYwJSxyZ2JhKDAsMCwwLDApIn0=",
                                "overlay_h_general" => "",
                                "overlay_1" => "",
                                "overlay_2" => "",
                                "overlay_3" => "",
                                "overlay_4" => "",
                                "overlay_5" => "",
                                "lightsky" => "",
                            ),
                            array(
                                'tdc_preset_name' => '', // Style 2 - colors
                                'tdc_preset_class' => 'tdcp_img tdcp_style tdcp_style2',
                                'tdc_preset_individual' => '1',
                                "overlay_h_general" => "",
                                "overlay_1" => "eyJ0eXBlIjoiZ3JhZGllbnQiLCJjb2xvcjEiOiJyZ2JhKDc0LDE0Myw5NCwwLjYpIiwiY29sb3IyIjoicmdiYSg3NywxNzgsMjM2LDAuNikiLCJtaXhlZENvbG9ycyI6W10sImRlZ3JlZSI6IjQ1IiwiY3NzIjoiYmFja2dyb3VuZDogLXdlYmtpdC1saW5lYXItZ3JhZGllbnQoNDVkZWcscmdiYSg3NywxNzgsMjM2LDAuNikscmdiYSg3NCwxNDMsOTQsMC42KSk7YmFja2dyb3VuZDogbGluZWFyLWdyYWRpZW50KDQ1ZGVnLHJnYmEoNzcsMTc4LDIzNiwwLjYpLHJnYmEoNzQsMTQzLDk0LDAuNikpOyIsImNzc1BhcmFtcyI6IjQ1ZGVnLHJnYmEoNzcsMTc4LDIzNiwwLjYpLHJnYmEoNzQsMTQzLDk0LDAuNikifQ==",
                                "overlay_2" => "eyJ0eXBlIjoiZ3JhZGllbnQiLCJjb2xvcjEiOiJyZ2JhKDE5OCw1Nyw1NywwLjYpIiwiY29sb3IyIjoicmdiYSgyMDksMTE4LDcwLDAuNikiLCJtaXhlZENvbG9ycyI6W10sImRlZ3JlZSI6IjQ1IiwiY3NzIjoiYmFja2dyb3VuZDogLXdlYmtpdC1saW5lYXItZ3JhZGllbnQoNDVkZWcscmdiYSgyMDksMTE4LDcwLDAuNikscmdiYSgxOTgsNTcsNTcsMC42KSk7YmFja2dyb3VuZDogbGluZWFyLWdyYWRpZW50KDQ1ZGVnLHJnYmEoMjA5LDExOCw3MCwwLjYpLHJnYmEoMTk4LDU3LDU3LDAuNikpOyIsImNzc1BhcmFtcyI6IjQ1ZGVnLHJnYmEoMjA5LDExOCw3MCwwLjYpLHJnYmEoMTk4LDU3LDU3LDAuNikifQ==",
                                "overlay_3" => "eyJ0eXBlIjoiZ3JhZGllbnQiLCJjb2xvcjEiOiJyZ2JhKDU5LDEyMCwxODAsMC41OSkiLCJjb2xvcjIiOiJyZ2JhKDIxNSw5NiwxODMsMC42KSIsIm1peGVkQ29sb3JzIjpbXSwiZGVncmVlIjoiLTQ1IiwiY3NzIjoiYmFja2dyb3VuZDogLXdlYmtpdC1saW5lYXItZ3JhZGllbnQoLTQ1ZGVnLHJnYmEoMjE1LDk2LDE4MywwLjYpLHJnYmEoNTksMTIwLDE4MCwwLjU5KSk7YmFja2dyb3VuZDogbGluZWFyLWdyYWRpZW50KC00NWRlZyxyZ2JhKDIxNSw5NiwxODMsMC42KSxyZ2JhKDU5LDEyMCwxODAsMC41OSkpOyIsImNzc1BhcmFtcyI6Ii00NWRlZyxyZ2JhKDIxNSw5NiwxODMsMC42KSxyZ2JhKDU5LDEyMCwxODAsMC41OSkifQ==",
                                "overlay_4" => "eyJ0eXBlIjoiZ3JhZGllbnQiLCJjb2xvcjEiOiJyZ2JhKDI0MiwxMjIsNTMsMC42KSIsImNvbG9yMiI6InJnYmEoMjQ0LDIwOCw2MywwLjYpIiwibWl4ZWRDb2xvcnMiOltdLCJkZWdyZWUiOiItNDUiLCJjc3MiOiJiYWNrZ3JvdW5kOiAtd2Via2l0LWxpbmVhci1ncmFkaWVudCgtNDVkZWcscmdiYSgyNDQsMjA4LDYzLDAuNikscmdiYSgyNDIsMTIyLDUzLDAuNikpO2JhY2tncm91bmQ6IGxpbmVhci1ncmFkaWVudCgtNDVkZWcscmdiYSgyNDQsMjA4LDYzLDAuNikscmdiYSgyNDIsMTIyLDUzLDAuNikpOyIsImNzc1BhcmFtcyI6Ii00NWRlZyxyZ2JhKDI0NCwyMDgsNjMsMC42KSxyZ2JhKDI0MiwxMjIsNTMsMC42KSJ9",
                                "overlay_5" => "eyJ0eXBlIjoiZ3JhZGllbnQiLCJjb2xvcjEiOiJyZ2JhKDc0LDE0Myw5NCwwLjYpIiwiY29sb3IyIjoicmdiYSg3NywxNzgsMjM2LDAuNikiLCJtaXhlZENvbG9ycyI6W10sImRlZ3JlZSI6IjQ1IiwiY3NzIjoiYmFja2dyb3VuZDogLXdlYmtpdC1saW5lYXItZ3JhZGllbnQoNDVkZWcscmdiYSg3NywxNzgsMjM2LDAuNikscmdiYSg3NCwxNDMsOTQsMC42KSk7YmFja2dyb3VuZDogbGluZWFyLWdyYWRpZW50KDQ1ZGVnLHJnYmEoNzcsMTc4LDIzNiwwLjYpLHJnYmEoNzQsMTQzLDk0LDAuNikpOyIsImNzc1BhcmFtcyI6IjQ1ZGVnLHJnYmEoNzcsMTc4LDIzNiwwLjYpLHJnYmEoNzQsMTQzLDk0LDAuNikifQ==",
                                "lightsky" => "",
                            ),
                            array(
                                'tdc_preset_name' => '', // Style 3 - flat colors
                                'tdc_preset_class' => 'tdcp_img tdcp_style tdcp_style3',
                                'tdc_preset_individual' => '1',
                                "overlay_h_general" => "",
                                "overlay_1" => "eyJ0eXBlIjoiZ3JhZGllbnQiLCJjb2xvcjEiOiJyZ2JhKDc0LDE0Myw5NCwwLjgpIiwiY29sb3IyIjoicmdiYSg3NywxNzgsMjM2LDAuOCkiLCJtaXhlZENvbG9ycyI6W10sImRlZ3JlZSI6IjQ1IiwiY3NzIjoiYmFja2dyb3VuZDogLXdlYmtpdC1saW5lYXItZ3JhZGllbnQoNDVkZWcscmdiYSg3NywxNzgsMjM2LDAuOCkscmdiYSg3NCwxNDMsOTQsMC44KSk7YmFja2dyb3VuZDogbGluZWFyLWdyYWRpZW50KDQ1ZGVnLHJnYmEoNzcsMTc4LDIzNiwwLjgpLHJnYmEoNzQsMTQzLDk0LDAuOCkpOyIsImNzc1BhcmFtcyI6IjQ1ZGVnLHJnYmEoNzcsMTc4LDIzNiwwLjgpLHJnYmEoNzQsMTQzLDk0LDAuOCkifQ==",
                                "overlay_2" => "eyJ0eXBlIjoiZ3JhZGllbnQiLCJjb2xvcjEiOiJyZ2JhKDE5OCw1Nyw1NywwLjgpIiwiY29sb3IyIjoicmdiYSgyMDksMTE4LDcwLDAuOCkiLCJtaXhlZENvbG9ycyI6W10sImRlZ3JlZSI6IjQ1IiwiY3NzIjoiYmFja2dyb3VuZDogLXdlYmtpdC1saW5lYXItZ3JhZGllbnQoNDVkZWcscmdiYSgyMDksMTE4LDcwLDAuOCkscmdiYSgxOTgsNTcsNTcsMC44KSk7YmFja2dyb3VuZDogbGluZWFyLWdyYWRpZW50KDQ1ZGVnLHJnYmEoMjA5LDExOCw3MCwwLjgpLHJnYmEoMTk4LDU3LDU3LDAuOCkpOyIsImNzc1BhcmFtcyI6IjQ1ZGVnLHJnYmEoMjA5LDExOCw3MCwwLjgpLHJnYmEoMTk4LDU3LDU3LDAuOCkifQ==",
                                "overlay_3" => "eyJ0eXBlIjoiZ3JhZGllbnQiLCJjb2xvcjEiOiJyZ2JhKDU5LDEyMCwxODAsMC44KSIsImNvbG9yMiI6InJnYmEoMjE1LDk2LDE4MywwLjgpIiwibWl4ZWRDb2xvcnMiOltdLCJkZWdyZWUiOiItNDUiLCJjc3MiOiJiYWNrZ3JvdW5kOiAtd2Via2l0LWxpbmVhci1ncmFkaWVudCgtNDVkZWcscmdiYSgyMTUsOTYsMTgzLDAuOCkscmdiYSg1OSwxMjAsMTgwLDAuOCkpO2JhY2tncm91bmQ6IGxpbmVhci1ncmFkaWVudCgtNDVkZWcscmdiYSgyMTUsOTYsMTgzLDAuOCkscmdiYSg1OSwxMjAsMTgwLDAuOCkpOyIsImNzc1BhcmFtcyI6Ii00NWRlZyxyZ2JhKDIxNSw5NiwxODMsMC44KSxyZ2JhKDU5LDEyMCwxODAsMC44KSJ9",
                                "overlay_4" => "eyJ0eXBlIjoiZ3JhZGllbnQiLCJjb2xvcjEiOiJyZ2JhKDI0MiwxMjIsNTMsMC44KSIsImNvbG9yMiI6InJnYmEoMjQ0LDIwOCw2MywwLjgpIiwibWl4ZWRDb2xvcnMiOltdLCJkZWdyZWUiOiItNDUiLCJjc3MiOiJiYWNrZ3JvdW5kOiAtd2Via2l0LWxpbmVhci1ncmFkaWVudCgtNDVkZWcscmdiYSgyNDQsMjA4LDYzLDAuOCkscmdiYSgyNDIsMTIyLDUzLDAuOCkpO2JhY2tncm91bmQ6IGxpbmVhci1ncmFkaWVudCgtNDVkZWcscmdiYSgyNDQsMjA4LDYzLDAuOCkscmdiYSgyNDIsMTIyLDUzLDAuOCkpOyIsImNzc1BhcmFtcyI6Ii00NWRlZyxyZ2JhKDI0NCwyMDgsNjMsMC44KSxyZ2JhKDI0MiwxMjIsNTMsMC44KSJ9",
                                "overlay_5" => "eyJ0eXBlIjoiZ3JhZGllbnQiLCJjb2xvcjEiOiJyZ2JhKDc0LDE0Myw5NCwwLjgpIiwiY29sb3IyIjoicmdiYSg3NywxNzgsMjM2LDAuOCkiLCJtaXhlZENvbG9ycyI6W10sImRlZ3JlZSI6IjQ1IiwiY3NzIjoiYmFja2dyb3VuZDogLXdlYmtpdC1saW5lYXItZ3JhZGllbnQoNDVkZWcscmdiYSg3NywxNzgsMjM2LDAuOCkscmdiYSg3NCwxNDMsOTQsMC44KSk7YmFja2dyb3VuZDogbGluZWFyLWdyYWRpZW50KDQ1ZGVnLHJnYmEoNzcsMTc4LDIzNiwwLjgpLHJnYmEoNzQsMTQzLDk0LDAuOCkpOyIsImNzc1BhcmFtcyI6IjQ1ZGVnLHJnYmEoNzcsMTc4LDIzNiwwLjgpLHJnYmEoNzQsMTQzLDk0LDAuOCkifQ==",
                                "lightsky" => "",
                            ),
                            array(
                                'tdc_preset_name' => '', // Style 4 - light sky
                                'tdc_preset_class' => 'tdcp_img tdcp_style tdcp_style4',
                                'tdc_preset_individual' => '1',
                                "overlay_general" => "rgba(0,0,0,0.7)",
                                "overlay_h_general" => "rgba(77,178,236,0.3)",
                                "overlay_1" => "",
                                "overlay_2" => "",
                                "overlay_3" => "",
                                "overlay_4" => "",
                                "overlay_5" => "",
                                "lightsky" => "yes",
                            ),
                            array(
                                'tdc_preset_name' => '', // Style 5 - rainbow
                                'tdc_preset_class' => 'tdcp_img tdcp_style tdcp_style5',
                                'tdc_preset_individual' => '1',
                                "overlay_h_general" => "",
                                "overlay_1" => "eyJ0eXBlIjoiZ3JhZGllbnQiLCJjb2xvcjEiOiJyZ2JhKDI1NSwxMTEsNDksMC42KSIsImNvbG9yMiI6InJnYmEoNjUsMTIsMTg4LDAuNikiLCJtaXhlZENvbG9ycyI6W10sImRlZ3JlZSI6IjIwIiwiY3NzIjoiYmFja2dyb3VuZDogLXdlYmtpdC1saW5lYXItZ3JhZGllbnQoMjBkZWcscmdiYSg2NSwxMiwxODgsMC42KSxyZ2JhKDI1NSwxMTEsNDksMC42KSk7YmFja2dyb3VuZDogbGluZWFyLWdyYWRpZW50KDIwZGVnLHJnYmEoNjUsMTIsMTg4LDAuNikscmdiYSgyNTUsMTExLDQ5LDAuNikpOyIsImNzc1BhcmFtcyI6IjIwZGVnLHJnYmEoNjUsMTIsMTg4LDAuNikscmdiYSgyNTUsMTExLDQ5LDAuNikifQ==",
                                "overlay_2" => "eyJ0eXBlIjoiZ3JhZGllbnQiLCJjb2xvcjEiOiJyZ2JhKDExMiwyNTUsMTUzLDAuNikiLCJjb2xvcjIiOiJyZ2JhKDI0NCwxMzYsMTMsMC42KSIsIm1peGVkQ29sb3JzIjpbXSwiZGVncmVlIjoiMjAiLCJjc3MiOiJiYWNrZ3JvdW5kOiAtd2Via2l0LWxpbmVhci1ncmFkaWVudCgyMGRlZyxyZ2JhKDI0NCwxMzYsMTMsMC42KSxyZ2JhKDExMiwyNTUsMTUzLDAuNikpO2JhY2tncm91bmQ6IGxpbmVhci1ncmFkaWVudCgyMGRlZyxyZ2JhKDI0NCwxMzYsMTMsMC42KSxyZ2JhKDExMiwyNTUsMTUzLDAuNikpOyIsImNzc1BhcmFtcyI6IjIwZGVnLHJnYmEoMjQ0LDEzNiwxMywwLjYpLHJnYmEoMTEyLDI1NSwxNTMsMC42KSJ9",
                                "overlay_3" => "eyJ0eXBlIjoiZ3JhZGllbnQiLCJjb2xvcjEiOiJyZ2JhKDEyNiwxOTEsMjU1LDAuNikiLCJjb2xvcjIiOiJyZ2JhKDE5NiwxNSwxMjEsMC42KSIsIm1peGVkQ29sb3JzIjpbXSwiZGVncmVlIjoiMjAiLCJjc3MiOiJiYWNrZ3JvdW5kOiAtd2Via2l0LWxpbmVhci1ncmFkaWVudCgyMGRlZyxyZ2JhKDE5NiwxNSwxMjEsMC42KSxyZ2JhKDEyNiwxOTEsMjU1LDAuNikpO2JhY2tncm91bmQ6IGxpbmVhci1ncmFkaWVudCgyMGRlZyxyZ2JhKDE5NiwxNSwxMjEsMC42KSxyZ2JhKDEyNiwxOTEsMjU1LDAuNikpOyIsImNzc1BhcmFtcyI6IjIwZGVnLHJnYmEoMTk2LDE1LDEyMSwwLjYpLHJnYmEoMTI2LDE5MSwyNTUsMC42KSJ9",
                                "overlay_4" => "eyJ0eXBlIjoiZ3JhZGllbnQiLCJjb2xvcjEiOiJyZ2JhKDQyLDIzNiwxMTYsMC42KSIsImNvbG9yMiI6InJnYmEoMCwyMiwxOTAsMC42KSIsIm1peGVkQ29sb3JzIjpbXSwiZGVncmVlIjoiMjAiLCJjc3MiOiJiYWNrZ3JvdW5kOiAtd2Via2l0LWxpbmVhci1ncmFkaWVudCgyMGRlZyxyZ2JhKDAsMjIsMTkwLDAuNikscmdiYSg0MiwyMzYsMTE2LDAuNikpO2JhY2tncm91bmQ6IGxpbmVhci1ncmFkaWVudCgyMGRlZyxyZ2JhKDAsMjIsMTkwLDAuNikscmdiYSg0MiwyMzYsMTE2LDAuNikpOyIsImNzc1BhcmFtcyI6IjIwZGVnLHJnYmEoMCwyMiwxOTAsMC42KSxyZ2JhKDQyLDIzNiwxMTYsMC42KSJ9",
                                "overlay_5" => "eyJ0eXBlIjoiZ3JhZGllbnQiLCJjb2xvcjEiOiJyZ2JhKDI1NSwxMTEsNDksMC42KSIsImNvbG9yMiI6InJnYmEoNjUsMTIsMTg4LDAuNikiLCJtaXhlZENvbG9ycyI6W10sImRlZ3JlZSI6IjIwIiwiY3NzIjoiYmFja2dyb3VuZDogLXdlYmtpdC1saW5lYXItZ3JhZGllbnQoMjBkZWcscmdiYSg2NSwxMiwxODgsMC42KSxyZ2JhKDI1NSwxMTEsNDksMC42KSk7YmFja2dyb3VuZDogbGluZWFyLWdyYWRpZW50KDIwZGVnLHJnYmEoNjUsMTIsMTg4LDAuNikscmdiYSgyNTUsMTExLDQ5LDAuNikpOyIsImNzc1BhcmFtcyI6IjIwZGVnLHJnYmEoNjUsMTIsMTg4LDAuNikscmdiYSgyNTUsMTExLDQ5LDAuNikifQ==",
                                "lightsky" => "",
                            ),
                        )
                    )
                ),
                "params" => array_merge(
                    array(
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Content length',
                            "value"      => "",
                            "class"      => "",
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Module Flex 6',
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                        ),
                        array(
                            "param_name"  => "mf6_tl",
                            "type"        => "textfield",
                            "value"       => '',
                            "heading"     => 'Title length',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-small",
                            "placeholder" => '25',
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Module Flex 7',
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                        ),
                        array(
                            "param_name"  => "mf7_tl",
                            "type"        => "textfield",
                            "value"       => '',
                            "heading"     => 'Title length',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-small",
                            "placeholder" => '25',
                        ),
                    ),
                    self::td_block_big_grid_params(),
                    array(
                        array(
                            "param_name"  => "modules_gap",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Modules gap',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-small",
                            "placeholder" => "10",
                            "group"       => "Layout",
                        ),
                        array(
                            "param_name" => "meta_info_horiz",
                            "type" => "dropdown",
                            "value" => array(
                                'Left' => 'content-horiz-left',
                                'Center' => 'content-horiz-center',
                                'Right' => 'content-horiz-right'
                            ),
                            "heading" => 'Meta info horiz align',
                            "description" => "",
                            "holder" => "div",
                            'tdc_dropdown_images' => true,
                            "class" => "tdc-visual-selector tdc-add-class",
                            "group"       => "Layout",
                        ),
                        array(
                            "param_name" => "meta_info_vert",
                            "type" => "dropdown",
                            "value" => array(
                                'Left' => 'content-vert-top',
                                'Center' => 'content-vert-center',
                                'Right' => 'content-vert-bottom'
                            ),
                            "heading" => 'Meta info vert align',
                            "description" => "",
                            "holder" => "div",
                            'tdc_dropdown_images' => true,
                            "class" => "tdc-visual-selector tdc-add-class",
                            "group"       => "Layout",
                        ),
                        array(
                            "param_name"  => "image_zoom",
                            "type"        => "checkbox",
                            "value"       => '',
                            "heading"     => "Zoom effect on hover",
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "",
                            "group"       => 'Layout'
                        ),
                        array(
                            "param_name"  => "modules_category",
                            "type"        => "dropdown",
                            "value"       => array(
                                'Inline'      => '',
                                'Above title' => 'above',
                            ),
                            "heading"     => 'Category tag position',
                            "description" => "Float image",
                            "holder"      => "div",
                            "class"       => "tdc-dropdown-big",
                            "group"       => "Layout",
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Module Category Grid 1',
                            "value"      => "",
                            "class"      => "",
                            "group"      => "Layout",
                        ),
                        array(
                            "param_name"  => "image_size",
                            "type"        => "dropdown",
                            "value"       => array(
                                'XSmall - 324px' => 'td_324x400',
                                'Small - 696px'  => '',
                                'Large - 1068px' => 'td_1068x0',
                                'Full - 1920px'  => 'td_1920x0'
                            ),
                            "heading"     => 'Image size',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-dropdown-big",
                            "group"       => "Layout",
                        ),
                        array(
                            'param_name'  => 'image_alignment1',
                            'type'        => 'range-responsive',
                            'value'       => '50',
                            'heading'     => 'Image V alignment',
                            'description' => '0 - Top / 50 - Center / 100 - Bottom',
                            'class'       => 'tdc-textfield-small',
                            'range_min'   => '0',
                            'range_max'   => '100',
                            'range_step'  => '1',
                            "group"       => "Layout",
                        ),
                        array(
                            "param_name"  => "image_width1",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Image width (percent)',
                            "description" => "Default value in percent",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-small",
                            "placeholder" => "25",
                            "group"       => "Layout",
                        ),
                        array(
                            "param_name"  => "image_height1",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Image height (percent)',
                            "description" => "Default value in percent",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-small",
                            "placeholder" => "195px",
                            "group"       => "Layout",
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "horizontal_separator",
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                            "group"      => "Layout",
                        ),
                        array(
                            "param_name"  => "meta_width1",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Meta info width',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-small",
                            "placeholder" => "100%",
                            "group"       => "Layout",
                        ),
                        array(
                            "param_name"  => "meta_margin1",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Meta info margin',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-big",
                            "placeholder" => "0px 0px 0px 0px",
                            "group"       => "Layout",
                        ),
                        array(
                            "param_name"  => "meta_padding1",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Meta info padding',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-big",
                            "placeholder" => "13px 10px",
                            "group"       => "Layout",
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "horizontal_separator",
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                            "group"      => "Layout",
                        ),
                        array(
                            "param_name"  => "art_title1",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Article title space',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-big",
                            "placeholder" => "0px 0px 0px 0px",
                            "group"       => "Layout",
                        ),
                        array(
                            "param_name"  => "art_title_padd1",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Article title padding',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-big",
                            "placeholder" => "0px 0px 0px 0px",
                            "group"       => "Layout",
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "horizontal_separator",
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                            "group"      => "Layout",
                        ),
                        array(
                            "param_name"  => "modules_category_margin1",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Category tag spacing',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-big",
                            "placeholder" => "0px 0px 5px 0px",
                            "group"       => "Layout",
                        ),
                        array(
                            "param_name"  => "modules_category_padding1",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Category tag padding',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-big",
                            "placeholder" => "3px 6px 3px 6px",
                            "group"       => "Layout",
                        ),
                        array(
                            "param_name"  => "show_cat1",
                            "type"        => "dropdown-responsive",
                            "value"       => array(
                                'Show' => 'inline-block',
                                'Hide' => 'none',
                            ),
                            "heading"     => 'Show category',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-dropdown-big",
                            "group"       => "Layout",
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "horizontal_separator",
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                            "group"      => "Layout",
                        ),
                        array(
                            "param_name"  => "show_author1",
                            "type"        => "dropdown-responsive",
                            "value"       => array(
                                'Show' => 'inline-block',
                                'Hide' => 'none',
                            ),
                            "heading"     => 'Show author',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-dropdown-big",
                            "group"       => "Layout",
                        ),
                        array(
                            "param_name"  => "show_date1",
                            "type"        => "dropdown-responsive",
                            "value"       => array(
                                'Show' => 'inline-block',
                                'Hide' => 'none',
                            ),
                            "heading"     => 'Show date',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-dropdown-big",
                            "group"       => "Layout",
                        ),
                        array(
                            "param_name"  => "auth_date_padding1",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Author & date padding',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-big",
                            "placeholder" => "0px 0px 0px 0px",
                            "group"       => "Layout",
                        ),

                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Module Category Grid 1 - Mobile',
                            "value"      => "",
                            "class"      => "",
                            "group"      => "Layout",
                        ),
                        array(
                            "param_name"  => "image_width3",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Image width (percent)',
                            "description" => "Default value in percent",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-small",
                            "placeholder" => "80",
                            "group"       => "Layout",
                        ),
                        array(
                            "param_name"  => "image_height3",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Image height (percent)',
                            "description" => "Default value in percent",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-small",
                            "placeholder" => "165px",
                            "group"       => "Layout",
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "horizontal_separator",
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                            "group"      => "Layout",
                        ),
                        array(
                            "param_name"  => "meta_width3",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Meta info width',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-small",
                            "placeholder" => "100%",
                            "group"       => "Layout",
                        ),
                        array(
                            "param_name"  => "meta_margin3",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Meta info margin',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-big",
                            "placeholder" => "0px 0px 0px 0px",
                            "group"       => "Layout",
                        ),
                        array(
                            "param_name"  => "meta_padding3",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Meta info padding',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-big",
                            "placeholder" => "16px 15px 11px",
                            "group"       => "Layout",
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "horizontal_separator",
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                            "group"      => "Layout",
                        ),
                        array(
                            "param_name"  => "art_title3",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Article title space',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-big",
                            "placeholder" => "0px 0px 0px 0px",
                            "group"       => "Layout",
                        ),
                        array(
                            "param_name"  => "art_title_padd3",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Article title padding',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-big",
                            "placeholder" => "0px 0px 0px 0px",
                            "group"       => "Layout",
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "horizontal_separator",
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                            "group"      => "Layout",
                        ),
                        array(
                            "param_name"  => "modules_category_margin3",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Category tag spacing',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-big",
                            "placeholder" => "0px 0px 7px 0px",
                            "group"       => "Layout",
                        ),
                        array(
                            "param_name"  => "modules_category_padding3",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Category tag padding',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-big",
                            "placeholder" => "3px 6px 3px 6px",
                            "group"       => "Layout",
                        ),
                        array(
                            "param_name"  => "show_cat3",
                            "type"        => "dropdown-responsive",
                            "value"       => array(
                                'Show' => 'inline-block',
                                'Hide' => 'none',
                            ),
                            "heading"     => 'Show category',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-dropdown-big",
                            "group"       => "Layout",
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "horizontal_separator",
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                            "group"      => "Layout",
                        ),
                        array(
                            "param_name"  => "show_author3",
                            "type"        => "dropdown-responsive",
                            "value"       => array(
                                'Show' => 'inline-block',
                                'Hide' => 'none',
                            ),
                            "heading"     => 'Show author',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-dropdown-big",
                            "group"       => "Layout",
                        ),
                        array(
                            "param_name"  => "show_date3",
                            "type"        => "dropdown-responsive",
                            "value"       => array(
                                'Show' => 'inline-block',
                                'Hide' => 'none',
                            ),
                            "heading"     => 'Show date',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-dropdown-big",
                            "group"       => "Layout",
                        ),
                        array(
                            "param_name"  => "auth_date_padding3",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Author & date padding',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-big",
                            "placeholder" => "0px 0px 0px 0px",
                            "group"       => "Layout",
                        ),

                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Module Category Grid 2',
                            "value"      => "",
                            "class"      => "",
                            "group"      => "Layout",
                        ),
                        array(
                            "param_name"  => "image_size2",
                            "type"        => "dropdown",
                            "value"       => array(
                                'XSmall - 324px' => 'td_324x400',
                                'Small - 696px'  => '',
                                'Large - 1068px' => 'td_1068x0',
                                'Full - 1920px'  => 'td_1920x0'
                            ),
                            "heading"     => 'Image size',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-dropdown-big",
                            "group"       => "Layout",
                        ),
                        array(
                            'param_name'  => 'image_alignment2',
                            'type'        => 'range-responsive',
                            'value'       => '50',
                            'heading'     => 'Image V alignment',
                            'description' => '0 - Top / 50 - Center / 100 - Bottom',
                            'class'       => 'tdc-textfield-small',
                            'range_min'   => '0',
                            'range_max'   => '100',
                            'range_step'  => '1',
                            "group"       => "Layout",
                        ),
                        array(
                            "param_name"  => "image_width2",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Image width (percent)',
                            "description" => "Default value in percent",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-small",
                            "placeholder" => "50",
                            "group"       => "Layout",
                        ),
                        array(
                            "param_name"  => "image_height2",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Image height (percent)',
                            "description" => "Default value in percent",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-small",
                            "placeholder" => "400px",
                            "group"       => "Layout",
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "horizontal_separator",
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                            "group"      => "Layout",
                        ),
                        array(
                            "param_name"  => "meta_width2",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Meta info width',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-small",
                            "placeholder" => "100%",
                            "group"       => "Layout",
                        ),
                        array(
                            "param_name"  => "meta_margin2",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Meta info margin',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-big",
                            "placeholder" => "0px 0px 0px 0px",
                            "group"       => "Layout",
                        ),
                        array(
                            "param_name"  => "meta_padding2",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Meta info padding',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-big",
                            "placeholder" => "20px",
                            "group"       => "Layout",
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "horizontal_separator",
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                            "group"      => "Layout",
                        ),
                        array(
                            "param_name"  => "art_title2",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Article title space',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-big",
                            "placeholder" => "0px 0px 9px 0px",
                            "group"       => "Layout",
                        ),
                        array(
                            "param_name"  => "art_title_padd2",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Article title padding',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-big",
                            "placeholder" => "0px 0px 0px 0px",
                            "group"       => "Layout",
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "horizontal_separator",
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                            "group"      => "Layout",
                        ),
                        array(
                            "param_name"  => "modules_category_margin2",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Category tag spacing',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-big",
                            "placeholder" => "0px 0px 10px 0px",
                            "group"       => "Layout",
                        ),
                        array(
                            "param_name"  => "modules_category_padding2",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Category tag padding',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-big",
                            "placeholder" => "3px 6px 3px 6px",
                            "group"       => "Layout",
                        ),
                        array(
                            "param_name"  => "show_cat2",
                            "type"        => "dropdown-responsive",
                            "value"       => array(
                                'Show' => 'inline-block',
                                'Hide' => 'none',
                            ),
                            "heading"     => 'Show category',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-dropdown-big",
                            "group"       => "Layout",
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "horizontal_separator",
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                            "group"      => "Layout",
                        ),
                        array(
                            "param_name"  => "show_author2",
                            "type"        => "dropdown-responsive",
                            "value"       => array(
                                'Show' => 'inline-block',
                                'Hide' => 'none',
                            ),
                            "heading"     => 'Show author',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-dropdown-big",
                            "group"       => "Layout",
                        ),
                        array(
                            "param_name"  => "show_date2",
                            "type"        => "dropdown-responsive",
                            "value"       => array(
                                'Show' => 'inline-block',
                                'Hide' => 'none',
                            ),
                            "heading"     => 'Show date',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-dropdown-big",
                            "group"       => "Layout",
                        ),
                        array(
                            "param_name"  => "auth_date_padding2",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Author & date padding',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-big",
                            "placeholder" => "0px 0px 0px 0px",
                            "group"       => "Layout",
                        ),
                        array(
                            "param_name" => "separator",
                            "type" => "text_separator",
                            'heading' => 'Module fonts',
                            "value" => "",
                            "class" => "",
                            "group" => 'Style',
                        ),
                    ),
                    td_config_helper::get_map_block_font_array( 'f_title1', true, 'Module 1 title', 'Style' ),
                    td_config_helper::get_map_block_font_array( 'f_cat1', false, 'Module 1 category tag', 'Style' ),
                    td_config_helper::get_map_block_font_array( 'f_meta1', false, 'Module 1 meta info', 'Style' ),
                    td_config_helper::get_map_block_font_array( 'f_title3', false, 'Module 1 title - mobile', 'Style' ),
                    td_config_helper::get_map_block_font_array( 'f_cat3', false, 'Module 1 category tag - mobile', 'Style' ),
                    td_config_helper::get_map_block_font_array( 'f_meta3', false, 'Module 1 meta info - mobile', 'Style' ),
                    td_config_helper::get_map_block_font_array( 'f_title2', false, 'Module 2 title', 'Style' ),
                    td_config_helper::get_map_block_font_array( 'f_cat2', false, 'Module 2 category tag', 'Style' ),
                    td_config_helper::get_map_block_font_array( 'f_meta2', false, 'Module 2 meta info', 'Style' ),
                    array(
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Colors',
                            "value"      => "",
                            "class"      => "",
                            "group"      => "Style",
                        ),
                        array(
                            "param_name" => "overlay_general",
                            "holder" => "div",
                            "type" => "gradient",
                            'heading' => "General module overlay color",
                            "value" => "",
                            "class" => "",
                            "group"      => "Style",
                        ),
                        array(
                            "param_name" => "overlay_h_general",
                            "holder" => "div",
                            "type" => "gradient",
                            'heading' => "General module overlay hover color",
                            "value" => "",
                            "class" => "",
                            "group"      => "Style",
                        ),
                        array(
                            "param_name" => "overlay_1",
                            "holder" => "div",
                            "type" => "gradient",
                            'heading' => "Module overlay color 1",
                            "value" => "",
                            "class" => "",
                            "group"      => "Style",
                        ),
                        array(
                            "param_name" => "overlay_2",
                            "holder" => "div",
                            "type" => "gradient",
                            'heading' => "Module overlay color 2",
                            "value" => "",
                            "class" => "",
                            "group"      => "Style",
                        ),
                        array(
                            "param_name" => "overlay_3",
                            "holder" => "div",
                            "type" => "gradient",
                            'heading' => "Module overlay color 3",
                            "value" => "",
                            "class" => "",
                            "group"      => "Style",
                        ),
                        array(
                            "param_name" => "overlay_4",
                            "holder" => "div",
                            "type" => "gradient",
                            'heading' => "Module overlay color 4",
                            "value" => "",
                            "class" => "",
                            "group"      => "Style",
                        ),
                        array(
                            "param_name" => "overlay_5",
                            "holder" => "div",
                            "type" => "gradient",
                            'heading' => "Module overlay color 5",
                            "value" => "",
                            "class" => "",
                            "group"      => "Style",
                        ),
                        array(
                            "param_name"  => "lightsky",
                            "type"        => "checkbox",
                            "value"       => '',
                            "heading"     => "Lightsky",
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "",
                            "group"       => 'Style'
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "",
                            "heading"     => 'Meta info background',
                            "param_name"  => "meta_bg",
                            "value"       => '',
                            "description" => '',
                            "group"       => 'Style',
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "horizontal_separator",
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                            "group"      => "Style",
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "",
                            "heading"     => 'Article title text color',
                            "param_name"  => "title_txt",
                            "value"       => '',
                            "description" => '',
                            "group"       => 'Style',
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "",
                            "heading"     => 'Article title text hover',
                            "param_name"  => "title_txt_hover",
                            "value"       => '',
                            "description" => '',
                            "group"       => 'Style',
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "",
                            "heading"     => 'Article title background color',
                            "param_name"  => "title_bg",
                            "value"       => '',
                            "description" => '',
                            "group"       => 'Style',
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "horizontal_separator",
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                            "group"      => "Style",
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "",
                            "heading"     => 'Category background',
                            "param_name"  => "cat_bg",
                            "value"       => '',
                            "description" => '',
                            "group"       => 'Style',
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "",
                            "heading"     => 'Category text color',
                            "param_name"  => "cat_txt",
                            "value"       => '',
                            "description" => '',
                            "group"       => 'Style',
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "",
                            "heading"     => 'Category background hover',
                            "param_name"  => "cat_bg_hover",
                            "value"       => '',
                            "description" => '',
                            "group"       => 'Style',
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "",
                            "heading"     => 'Category text hover',
                            "param_name"  => "cat_txt_hover",
                            "value"       => '',
                            "description" => '',
                            "group"       => 'Style',
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "horizontal_separator",
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                            "group"      => "Style",
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "",
                            "heading"     => 'Author text color',
                            "param_name"  => "author_txt",
                            "value"       => '',
                            "description" => '',
                            "group"       => 'Style',
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "",
                            "heading"     => 'Author text hover',
                            "param_name"  => "author_txt_hover",
                            "value"       => '',
                            "description" => '',
                            "group"       => 'Style',
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "",
                            "heading"     => 'Date text color',
                            "param_name"  => "date_txt",
                            "value"       => '',
                            "description" => '',
                            "group"       => 'Style',
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "",
                            "heading"     => 'Author & date background color',
                            "param_name"  => "auth_date_bg",
                            "value"       => '',
                            "description" => '',
                            "group"       => 'Style',
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "",
                            "heading"     => 'Review stars color',
                            "param_name"  => "review_stars",
                            "value"       => '',
                            "description" => '',
                            "group"       => 'Style',
                        ),
                    ),
                    self::get_map_css_tab()
                )
            )
        );

        td_api_block::add('td_block_big_grid_flex_7',
            array(
                'map_in_visual_composer' => false,
                'map_in_td_composer' => true,
                "name" => 'Big Grid Flex 7',
                "base" => 'td_block_big_grid_flex_7',
                "class" => 'td_block_big_grid_flex_7',
                "controls" => "full",
                "category" => 'Blocks',
                'tdc_category' => 'Big Grids',
                'icon' => 'icon-pagebuilder-td_block_big_grid_flex_7',
                'file' => td_global::$get_template_directory . '/includes/shortcodes/td_block_big_grid_flex_7.php',
                'tdc_style_params' => array(
                    'custom_title',
                    'custom_url',
                    'post_ids',
                    'category_id',
                    'category_ids',
                    'tag_slug',
                    'autors_id',
                    'installed_post_types',
                    'sort',
                    'offset',
                    'el_class'
                ),
                'tdc_start_values' => base64_encode(
                    json_encode(
                        array(
                            array(
                                "meta_info_vert" => "content-vert-bottom",
                                "image_zoom" => "yes",
                                "show_author2" => "none",
                                "show_date2" => "eyJwaG9uZSI6Im5vbmUifQ==",
                                "modules_category" => "above",
                                "overlay_general" => "eyJ0eXBlIjoiZ3JhZGllbnQiLCJjb2xvcjEiOiJyZ2JhKDAsMCwwLDApIiwiY29sb3IyIjoicmdiYSgwLDAsMCwwLjcpIiwibWl4ZWRDb2xvcnMiOlt7ImNvbG9yIjoicmdiYSgwLDAsMCwwKSIsInBlcmNlbnRhZ2UiOjYwfV0sImNzcyI6ImJhY2tncm91bmQ6IC13ZWJraXQtbGluZWFyLWdyYWRpZW50KDBkZWcscmdiYSgwLDAsMCwwLjcpLHJnYmEoMCwwLDAsMCkgNjAlLHJnYmEoMCwwLDAsMCkpO2JhY2tncm91bmQ6IGxpbmVhci1ncmFkaWVudCgwZGVnLHJnYmEoMCwwLDAsMC43KSxyZ2JhKDAsMCwwLDApIDYwJSxyZ2JhKDAsMCwwLDApKTsiLCJjc3NQYXJhbXMiOiIwZGVnLHJnYmEoMCwwLDAsMC43KSxyZ2JhKDAsMCwwLDApIDYwJSxyZ2JhKDAsMCwwLDApIn0=",
                                "image_height2" => "eyJwaG9uZSI6IjIwMHB4IiwibGFuZHNjYXBlIjoiMzUwcHgiLCJwb3J0cmFpdCI6IjI3MHB4In0=",
                                "image_height1" => "eyJwaG9uZSI6IjIwMHB4IiwibGFuZHNjYXBlIjoiMzUwcHgiLCJwb3J0cmFpdCI6IjI3MHB4In0=",
                                "meta_padding2" => "eyJwaG9uZSI6IjE1cHggMTVweCAxMHB4IiwicG9ydHJhaXQiOiIyMHB4IDEwcHggMTZweCJ9",
                                "meta_padding1" => "eyJwaG9uZSI6IjE1cHggMTVweCAxMHB4IiwicG9ydHJhaXQiOiIyMnB4IDEwcHgifQ==",
                                "cat_bg_hover" => "#4db2ec",
                                "review_stars" => "#fff",
                                "modules_category_margin2" => "eyJwb3J0cmFpdCI6IjBweCAwcHggNHB4IDBweCJ9",
                                "modules_category_margin1" => "eyJwb3J0cmFpdCI6IjBweCAwcHggN3B4IDBweCIsInBob25lIjoiMHB4IDBweCA3cHggMHB4In0=",
                                "art_title1" => "eyJwb3J0cmFpdCI6IjBweCAwcHggNnB4IDBweCIsInBob25lIjoiMHB4IDBweCAwcHggMHB4In0=",
                                "image_width1" => "eyJwaG9uZSI6IjEwMCJ9",
                                "image_width2" => "eyJwaG9uZSI6IjEwMCJ9",
                                "show_author1" => "eyJwaG9uZSI6Im5vbmUifQ==",
                                "show_date1" => "eyJwaG9uZSI6Im5vbmUifQ==",
                                "image_size" => "",
                                "image_size2" => ""
                            ),

                            array(
                                'tdc_preset_name' => 'Font family',
                                'tdc_preset_class' => 'tdcp_separator tdcp_separator_font',
                            ),
                            array(
                                'tdc_preset_name' => '', // Font - Montserrat
                                'tdc_preset_class' => 'tdcp_img tdcp_font tdcp_font1',
                                'tdc_preset_individual' => '1',
                                "f_title1_font_family" =>        "394",
                                "f_title2_font_family" =>        "394",
                            ),
                            array(
                                'tdc_preset_name' => '', // Font - Source Serif
                                'tdc_preset_class' => 'tdcp_img tdcp_font tdcp_font2',
                                'tdc_preset_individual' =>      '1',
                                "f_title1_font_family" =>        "721",
                                "f_title2_font_family" =>        "721",
                            ),
                            array(
                                'tdc_preset_name' => '', // Font - Raleway
                                'tdc_preset_class' => 'tdcp_img tdcp_font tdcp_font3',
                                'tdc_preset_individual' => '1',
                                "f_title1_font_family" =>        "507",
                                "f_title2_font_family" =>        "507",
                            ),
                            array(
                                'tdc_preset_name' => '', // Font - Work Sans
                                'tdc_preset_class' => 'tdcp_img tdcp_font tdcp_font4',
                                'tdc_preset_individual' => '1',
                                "f_title1_font_family" =>        "653",
                                "f_title2_font_family" =>        "653",
                            ),
                            array(
                                'tdc_preset_name' => '', // Font - Courgette
                                'tdc_preset_class' => 'tdcp_img tdcp_font tdcp_font5',
                                'tdc_preset_individual' => '1',
                                "f_title1_font_family" =>        "147",
                                "f_title2_font_family" =>        "147",
                            ),
                            array(
                                'tdc_preset_name' => '', // Font - Oswald
                                'tdc_preset_class' => 'tdcp_img tdcp_font tdcp_font7',
                                'tdc_preset_individual' => '1',
                                "f_title1_font_family" =>        "445",
                                "f_title2_font_family" =>        "445",
                            ),
                            array(
                                'tdc_preset_name' => '', // Font - Muli
                                'tdc_preset_class' => 'tdcp_img tdcp_font tdcp_font8',
                                'tdc_preset_individual' => '1',
                                "f_title1_font_family" =>        "406",
                                "f_title2_font_family" =>        "406",
                            ),
                            array(
                                'tdc_preset_name' => '', // Font - Wendy One
                                'tdc_preset_class' => 'tdcp_img tdcp_font tdcp_font9',
                                'tdc_preset_individual' => '1',
                                "f_title1_font_family" =>        "646",
                                "f_title2_font_family" =>        "646",
                            ),
                            array(
                                'tdc_preset_name' => '', // Font - Anton
                                'tdc_preset_class' => 'tdcp_img tdcp_font tdcp_font10',
                                'tdc_preset_individual' => '1',
                                "f_title1_font_family" =>        "41",
                                "f_title2_font_family" =>        "41",
                            ),
                            array(
                                'tdc_preset_name' => '', // Font - Quicksand
                                'tdc_preset_class' => 'tdcp_img tdcp_font tdcp_font11',
                                'tdc_preset_individual' => '1',
                                "f_title1_font_family" =>        "502",
                                "f_title2_font_family" =>        "502",
                            ),
                            array(
                                'tdc_preset_name' => '', // Font - Libre Baskerville
                                'tdc_preset_class' => 'tdcp_img tdcp_font tdcp_font12',
                                'tdc_preset_individual' => '1',
                                "f_title1_font_family" =>        "331",
                                "f_title2_font_family" =>        "331",
                            ),
                            array(
                                'tdc_preset_name' => '', // Font - Caveat
                                'tdc_preset_class' => 'tdcp_img tdcp_font tdcp_font13',
                                'tdc_preset_individual' => '1',
                                "f_title1_font_family" =>        "663",
                                "f_title2_font_family" =>        "663",
                            ),
                            array(
                                'tdc_preset_name' => '', // Font - Volkorn
                                'tdc_preset_class' => 'tdcp_img tdcp_font tdcp_font14',
                                'tdc_preset_individual' => '1',
                                "f_title1_font_family" =>        "639",
                                "f_title2_font_family" =>        "639",
                            ),
                            array(
                                'tdc_preset_name' => '', // Font - Default
                                'tdc_preset_class' => 'tdcp_img tdcp_font tdcp_font6',
                                'tdc_preset_individual' => '1',
                                "f_title1_font_family" =>        "",
                                "f_title2_font_family" =>        "",
                            ),

                            array(
                                'tdc_preset_name' => 'Font size',
                                'tdc_preset_class' => 'tdcp_separator tdcp_separator_size',
                            ),
                            array(
                                'tdc_preset_name' => '', // Size - XS 13/13/12/14
                                'tdc_preset_class' => 'tdcp_img tdcp_size tdcp_size1',
                                'tdc_preset_individual' => '1',
                                "f_title1_font_size" => "eyJhbGwiOiIxNiIsInBvcnRyYWl0IjoiMTQifQ==",
                                "f_title1_font_line_height" => "1.3",
                                "f_title2_font_size" => "eyJhbGwiOiIxNiIsInBvcnRyYWl0IjoiMTQifQ==",
                                "f_title2_font_line_height" => "1.3",
                            ),
                            array(
                                'tdc_preset_name' => '', // Size - S 14/13/12/14
                                'tdc_preset_class' => 'tdcp_img tdcp_size tdcp_size2',
                                'tdc_preset_individual' => '1',
                                "f_title1_font_size" => "eyJhbGwiOiIxOCIsInBvcnRyYWl0IjoiMTYifQ==",
                                "f_title1_font_line_height" => "1.4",
                                "f_title2_font_size" => "eyJhbGwiOiIxNiIsInBvcnRyYWl0IjoiMTQifQ==",
                                "f_title2_font_line_height" => "1.3",
                            ),
                            array(
                                'tdc_preset_name' => '', // Size - M 21/21/17/21
                                'tdc_preset_class' => 'tdcp_img tdcp_size tdcp_size3',
                                'tdc_preset_individual' => '1',
                                "f_title1_font_size" => "eyJhbGwiOiIyNCIsInBvcnRyYWl0IjoiMjIifQ==",
                                "f_title1_font_line_height" => "1.2",
                                "f_title2_font_size" => "eyJhbGwiOiIyMCIsInBvcnRyYWl0IjoiMTYiLCJwaG9uZSI6IjE0In0=",
                                "f_title2_font_line_height" => "1.2",
                            ),
                            array(
                                'tdc_preset_name' => '', // Size - L 26/25/21/21
                                'tdc_preset_class' => 'tdcp_img tdcp_size tdcp_size4',
                                'tdc_preset_individual' => '1',
                                "f_title1_font_size" => "",
                                "f_title1_font_line_height" => "",
                                "f_title2_font_size" => "",
                                "f_title2_font_line_height" => "",

                            ),
                            array(
                                'tdc_preset_name' => '', // Size - XL 30/28/24/21
                                'tdc_preset_class' => 'tdcp_img tdcp_size tdcp_size5',
                                'tdc_preset_individual' => '1',
                                "f_title1_font_size" => "eyJhbGwiOiIzMCIsImxhbmRzY2FwZSI6IjI4IiwicG9ydHJhaXQiOiIyNCIsInBob25lIjoiMjEifQ==",
                                "f_title1_font_line_height" => "1.2",
                                "f_title2_font_size" => "",
                                "f_title2_font_line_height" => "",
                            ),
                            array(
                                'tdc_preset_name' => '', // Size - XXL 36/32/26/21
                                'tdc_preset_class' => 'tdcp_img tdcp_size tdcp_size6',
                                'tdc_preset_individual' => '1',
                                "f_title1_font_size" => "eyJhbGwiOiIzNiIsImxhbmRzY2FwZSI6IjMyIiwicGhvbmUiOiIyMSIsInBvcnRyYWl0IjoiMjYifQ==",
                                "f_title1_font_line_height" => "eyJhbGwiOiIxLjEiLCJwaG9uZSI6IjEuMiJ9",
                                "f_title2_font_size" => "",
                                "f_title2_font_line_height" => "",
                            ),

                            array(
                                'tdc_preset_name' => 'Text horizontal alignment',
                                'tdc_preset_class' => 'tdcp_separator tdcp_separator_align',
                            ),
                            array(
                                'tdc_preset_name' => '', // Text alignment - left
                                'tdc_preset_class' => 'tdcp_img tdcp_align tdcp_align1',
                                'tdc_preset_individual' => '1',
                                "meta_info_horiz" => "content-horiz-left",
                            ),
                            array(
                                'tdc_preset_name' => '', // Text alignment - center
                                'tdc_preset_class' => 'tdcp_img tdcp_align tdcp_align2',
                                'tdc_preset_individual' => '1',
                                "meta_info_horiz" => "content-horiz-center",
                            ),
                            array(
                                'tdc_preset_name' => '', // Text alignment - right
                                'tdc_preset_class' => 'tdcp_img tdcp_align tdcp_align3',
                                'tdc_preset_individual' => '1',
                                "meta_info_horiz" => "content-horiz-right",
                            ),

                            array(
                                'tdc_preset_name' => 'Style',
                                'tdc_preset_class' => 'tdcp_separator tdcp_separator_style',
                            ),
                            array(
                                'tdc_preset_name' => '', // Style 1 - default
                                'tdc_preset_class' => 'tdcp_img tdcp_style tdcp_style1',
                                'tdc_preset_individual' => '1',
                                "overlay_general" => "eyJ0eXBlIjoiZ3JhZGllbnQiLCJjb2xvcjEiOiJyZ2JhKDAsMCwwLDApIiwiY29sb3IyIjoicmdiYSgwLDAsMCwwLjcpIiwibWl4ZWRDb2xvcnMiOlt7ImNvbG9yIjoicmdiYSgwLDAsMCwwKSIsInBlcmNlbnRhZ2UiOjYwfV0sImNzcyI6ImJhY2tncm91bmQ6IC13ZWJraXQtbGluZWFyLWdyYWRpZW50KDBkZWcscmdiYSgwLDAsMCwwLjcpLHJnYmEoMCwwLDAsMCkgNjAlLHJnYmEoMCwwLDAsMCkpO2JhY2tncm91bmQ6IGxpbmVhci1ncmFkaWVudCgwZGVnLHJnYmEoMCwwLDAsMC43KSxyZ2JhKDAsMCwwLDApIDYwJSxyZ2JhKDAsMCwwLDApKTsiLCJjc3NQYXJhbXMiOiIwZGVnLHJnYmEoMCwwLDAsMC43KSxyZ2JhKDAsMCwwLDApIDYwJSxyZ2JhKDAsMCwwLDApIn0=",
                                "overlay_h_general" => "",
                                "overlay_1" => "",
                                "overlay_2" => "",
                                "overlay_3" => "",
                                "lightsky" => "",
                            ),
                            array(
                                'tdc_preset_name' => '', // Style 2 - colors
                                'tdc_preset_class' => 'tdcp_img tdcp_style tdcp_style2',
                                'tdc_preset_individual' => '1',
                                "overlay_h_general" => "",
                                "overlay_1" => "eyJ0eXBlIjoiZ3JhZGllbnQiLCJjb2xvcjEiOiJyZ2JhKDc0LDE0Myw5NCwwLjYpIiwiY29sb3IyIjoicmdiYSg3NywxNzgsMjM2LDAuNikiLCJtaXhlZENvbG9ycyI6W10sImRlZ3JlZSI6IjQ1IiwiY3NzIjoiYmFja2dyb3VuZDogLXdlYmtpdC1saW5lYXItZ3JhZGllbnQoNDVkZWcscmdiYSg3NywxNzgsMjM2LDAuNikscmdiYSg3NCwxNDMsOTQsMC42KSk7YmFja2dyb3VuZDogbGluZWFyLWdyYWRpZW50KDQ1ZGVnLHJnYmEoNzcsMTc4LDIzNiwwLjYpLHJnYmEoNzQsMTQzLDk0LDAuNikpOyIsImNzc1BhcmFtcyI6IjQ1ZGVnLHJnYmEoNzcsMTc4LDIzNiwwLjYpLHJnYmEoNzQsMTQzLDk0LDAuNikifQ==",
                                "overlay_2" => "eyJ0eXBlIjoiZ3JhZGllbnQiLCJjb2xvcjEiOiJyZ2JhKDE5OCw1Nyw1NywwLjYpIiwiY29sb3IyIjoicmdiYSgyMDksMTE4LDcwLDAuNikiLCJtaXhlZENvbG9ycyI6W10sImRlZ3JlZSI6IjQ1IiwiY3NzIjoiYmFja2dyb3VuZDogLXdlYmtpdC1saW5lYXItZ3JhZGllbnQoNDVkZWcscmdiYSgyMDksMTE4LDcwLDAuNikscmdiYSgxOTgsNTcsNTcsMC42KSk7YmFja2dyb3VuZDogbGluZWFyLWdyYWRpZW50KDQ1ZGVnLHJnYmEoMjA5LDExOCw3MCwwLjYpLHJnYmEoMTk4LDU3LDU3LDAuNikpOyIsImNzc1BhcmFtcyI6IjQ1ZGVnLHJnYmEoMjA5LDExOCw3MCwwLjYpLHJnYmEoMTk4LDU3LDU3LDAuNikifQ==",
                                "overlay_3" => "eyJ0eXBlIjoiZ3JhZGllbnQiLCJjb2xvcjEiOiJyZ2JhKDU5LDEyMCwxODAsMC41OSkiLCJjb2xvcjIiOiJyZ2JhKDIxNSw5NiwxODMsMC42KSIsIm1peGVkQ29sb3JzIjpbXSwiZGVncmVlIjoiLTQ1IiwiY3NzIjoiYmFja2dyb3VuZDogLXdlYmtpdC1saW5lYXItZ3JhZGllbnQoLTQ1ZGVnLHJnYmEoMjE1LDk2LDE4MywwLjYpLHJnYmEoNTksMTIwLDE4MCwwLjU5KSk7YmFja2dyb3VuZDogbGluZWFyLWdyYWRpZW50KC00NWRlZyxyZ2JhKDIxNSw5NiwxODMsMC42KSxyZ2JhKDU5LDEyMCwxODAsMC41OSkpOyIsImNzc1BhcmFtcyI6Ii00NWRlZyxyZ2JhKDIxNSw5NiwxODMsMC42KSxyZ2JhKDU5LDEyMCwxODAsMC41OSkifQ==",
                                "lightsky" => "",
                            ),
                            array(
                                'tdc_preset_name' => '', // Style 3 - flat colors
                                'tdc_preset_class' => 'tdcp_img tdcp_style tdcp_style3',
                                'tdc_preset_individual' => '1',
                                "overlay_h_general" => "",
                                "overlay_1" => "eyJ0eXBlIjoiZ3JhZGllbnQiLCJjb2xvcjEiOiJyZ2JhKDc0LDE0Myw5NCwwLjgpIiwiY29sb3IyIjoicmdiYSg3NywxNzgsMjM2LDAuOCkiLCJtaXhlZENvbG9ycyI6W10sImRlZ3JlZSI6IjQ1IiwiY3NzIjoiYmFja2dyb3VuZDogLXdlYmtpdC1saW5lYXItZ3JhZGllbnQoNDVkZWcscmdiYSg3NywxNzgsMjM2LDAuOCkscmdiYSg3NCwxNDMsOTQsMC44KSk7YmFja2dyb3VuZDogbGluZWFyLWdyYWRpZW50KDQ1ZGVnLHJnYmEoNzcsMTc4LDIzNiwwLjgpLHJnYmEoNzQsMTQzLDk0LDAuOCkpOyIsImNzc1BhcmFtcyI6IjQ1ZGVnLHJnYmEoNzcsMTc4LDIzNiwwLjgpLHJnYmEoNzQsMTQzLDk0LDAuOCkifQ==",
                                "overlay_2" => "eyJ0eXBlIjoiZ3JhZGllbnQiLCJjb2xvcjEiOiJyZ2JhKDE5OCw1Nyw1NywwLjgpIiwiY29sb3IyIjoicmdiYSgyMDksMTE4LDcwLDAuOCkiLCJtaXhlZENvbG9ycyI6W10sImRlZ3JlZSI6IjQ1IiwiY3NzIjoiYmFja2dyb3VuZDogLXdlYmtpdC1saW5lYXItZ3JhZGllbnQoNDVkZWcscmdiYSgyMDksMTE4LDcwLDAuOCkscmdiYSgxOTgsNTcsNTcsMC44KSk7YmFja2dyb3VuZDogbGluZWFyLWdyYWRpZW50KDQ1ZGVnLHJnYmEoMjA5LDExOCw3MCwwLjgpLHJnYmEoMTk4LDU3LDU3LDAuOCkpOyIsImNzc1BhcmFtcyI6IjQ1ZGVnLHJnYmEoMjA5LDExOCw3MCwwLjgpLHJnYmEoMTk4LDU3LDU3LDAuOCkifQ==",
                                "overlay_3" => "eyJ0eXBlIjoiZ3JhZGllbnQiLCJjb2xvcjEiOiJyZ2JhKDU5LDEyMCwxODAsMC44KSIsImNvbG9yMiI6InJnYmEoMjE1LDk2LDE4MywwLjgpIiwibWl4ZWRDb2xvcnMiOltdLCJkZWdyZWUiOiItNDUiLCJjc3MiOiJiYWNrZ3JvdW5kOiAtd2Via2l0LWxpbmVhci1ncmFkaWVudCgtNDVkZWcscmdiYSgyMTUsOTYsMTgzLDAuOCkscmdiYSg1OSwxMjAsMTgwLDAuOCkpO2JhY2tncm91bmQ6IGxpbmVhci1ncmFkaWVudCgtNDVkZWcscmdiYSgyMTUsOTYsMTgzLDAuOCkscmdiYSg1OSwxMjAsMTgwLDAuOCkpOyIsImNzc1BhcmFtcyI6Ii00NWRlZyxyZ2JhKDIxNSw5NiwxODMsMC44KSxyZ2JhKDU5LDEyMCwxODAsMC44KSJ9",
                                "lightsky" => "",
                            ),
                            array(
                                'tdc_preset_name' => '', // Style 4 - light sky
                                'tdc_preset_class' => 'tdcp_img tdcp_style tdcp_style4',
                                'tdc_preset_individual' => '1',
                                "overlay_general" => "rgba(0,0,0,0.7)",
                                "overlay_h_general" => "rgba(77,178,236,0.3)",
                                "overlay_1" => "",
                                "overlay_2" => "",
                                "overlay_3" => "",
                                "lightsky" => "yes",
                            ),
                            array(
                                'tdc_preset_name' => '', // Style 5 - rainbow
                                'tdc_preset_class' => 'tdcp_img tdcp_style tdcp_style5',
                                'tdc_preset_individual' => '1',
                                "overlay_h_general" => "",
                                "overlay_1" => "eyJ0eXBlIjoiZ3JhZGllbnQiLCJjb2xvcjEiOiJyZ2JhKDI1NSwxMTEsNDksMC42KSIsImNvbG9yMiI6InJnYmEoNjUsMTIsMTg4LDAuNikiLCJtaXhlZENvbG9ycyI6W10sImRlZ3JlZSI6IjIwIiwiY3NzIjoiYmFja2dyb3VuZDogLXdlYmtpdC1saW5lYXItZ3JhZGllbnQoMjBkZWcscmdiYSg2NSwxMiwxODgsMC42KSxyZ2JhKDI1NSwxMTEsNDksMC42KSk7YmFja2dyb3VuZDogbGluZWFyLWdyYWRpZW50KDIwZGVnLHJnYmEoNjUsMTIsMTg4LDAuNikscmdiYSgyNTUsMTExLDQ5LDAuNikpOyIsImNzc1BhcmFtcyI6IjIwZGVnLHJnYmEoNjUsMTIsMTg4LDAuNikscmdiYSgyNTUsMTExLDQ5LDAuNikifQ==",
                                "overlay_2" => "eyJ0eXBlIjoiZ3JhZGllbnQiLCJjb2xvcjEiOiJyZ2JhKDExMiwyNTUsMTUzLDAuNikiLCJjb2xvcjIiOiJyZ2JhKDI0NCwxMzYsMTMsMC42KSIsIm1peGVkQ29sb3JzIjpbXSwiZGVncmVlIjoiMjAiLCJjc3MiOiJiYWNrZ3JvdW5kOiAtd2Via2l0LWxpbmVhci1ncmFkaWVudCgyMGRlZyxyZ2JhKDI0NCwxMzYsMTMsMC42KSxyZ2JhKDExMiwyNTUsMTUzLDAuNikpO2JhY2tncm91bmQ6IGxpbmVhci1ncmFkaWVudCgyMGRlZyxyZ2JhKDI0NCwxMzYsMTMsMC42KSxyZ2JhKDExMiwyNTUsMTUzLDAuNikpOyIsImNzc1BhcmFtcyI6IjIwZGVnLHJnYmEoMjQ0LDEzNiwxMywwLjYpLHJnYmEoMTEyLDI1NSwxNTMsMC42KSJ9",
                                "overlay_3" => "eyJ0eXBlIjoiZ3JhZGllbnQiLCJjb2xvcjEiOiJyZ2JhKDEyNiwxOTEsMjU1LDAuNikiLCJjb2xvcjIiOiJyZ2JhKDE5NiwxNSwxMjEsMC42KSIsIm1peGVkQ29sb3JzIjpbXSwiZGVncmVlIjoiMjAiLCJjc3MiOiJiYWNrZ3JvdW5kOiAtd2Via2l0LWxpbmVhci1ncmFkaWVudCgyMGRlZyxyZ2JhKDE5NiwxNSwxMjEsMC42KSxyZ2JhKDEyNiwxOTEsMjU1LDAuNikpO2JhY2tncm91bmQ6IGxpbmVhci1ncmFkaWVudCgyMGRlZyxyZ2JhKDE5NiwxNSwxMjEsMC42KSxyZ2JhKDEyNiwxOTEsMjU1LDAuNikpOyIsImNzc1BhcmFtcyI6IjIwZGVnLHJnYmEoMTk2LDE1LDEyMSwwLjYpLHJnYmEoMTI2LDE5MSwyNTUsMC42KSJ9",
                                "lightsky" => "",
                            ),
                        )
                    )
                ),
                "params" => array_merge(
                    array(
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Content length',
                            "value"      => "",
                            "class"      => "",
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Module Flex 6',
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                        ),
                        array(
                            "param_name"  => "mf6_tl",
                            "type"        => "textfield",
                            "value"       => '',
                            "heading"     => 'Title length',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-small",
                            "placeholder" => '25',
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Module Flex 7',
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                        ),
                        array(
                            "param_name"  => "mf7_tl",
                            "type"        => "textfield",
                            "value"       => '',
                            "heading"     => 'Title length',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-small",
                            "placeholder" => '25',
                        ),
                    ),
                    self::td_block_big_grid_params(),
                    array(
                        array(
                            "param_name"  => "modules_gap",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Modules gap',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-small",
                            "placeholder" => "2",
                            "group"       => "Layout",
                        ),
                        array(
                            "param_name" => "meta_info_horiz",
                            "type" => "dropdown",
                            "value" => array(
                                'Left' => 'content-horiz-left',
                                'Center' => 'content-horiz-center',
                                'Right' => 'content-horiz-right'
                            ),
                            "heading" => 'Meta info horiz align',
                            "description" => "",
                            "holder" => "div",
                            'tdc_dropdown_images' => true,
                            "class" => "tdc-visual-selector tdc-add-class",
                            "group"       => "Layout",
                        ),
                        array(
                            "param_name" => "meta_info_vert",
                            "type" => "dropdown",
                            "value" => array(
                                'Left' => 'content-vert-top',
                                'Center' => 'content-vert-center',
                                'Right' => 'content-vert-bottom'
                            ),
                            "heading" => 'Meta info vert align',
                            "description" => "",
                            "holder" => "div",
                            'tdc_dropdown_images' => true,
                            "class" => "tdc-visual-selector tdc-add-class",
                            "group"       => "Layout",
                        ),
                        array(
                            "param_name"  => "image_zoom",
                            "type"        => "checkbox",
                            "value"       => '',
                            "heading"     => "Zoom effect on hover",
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "",
                            "group"       => 'Layout'
                        ),
                        array(
                            "param_name"  => "modules_category",
                            "type"        => "dropdown",
                            "value"       => array(
                                'Inline'      => '',
                                'Above title' => 'above',
                            ),
                            "heading"     => 'Category tag position',
                            "description" => "Float image",
                            "holder"      => "div",
                            "class"       => "tdc-dropdown-big",
                            "group"       => "Layout",
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Module Category Grid 1',
                            "value"      => "",
                            "class"      => "",
                            "group"      => "Layout",
                        ),
                        array(
                            "param_name"  => "image_size",
                            "type"        => "dropdown",
                            "value"       => array(
                                'XSmall - 324px' => 'td_324x400',
                                'Small - 696px'  => '',
                                'Large - 1068px' => 'td_1068x0',
                                'Full - 1920px'  => 'td_1920x0'
                            ),
                            "heading"     => 'Image size',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-dropdown-big",
                            "group"       => "Layout",
                        ),
                        array(
                            'param_name'  => 'image_alignment1',
                            'type'        => 'range-responsive',
                            'value'       => '50',
                            'heading'     => 'Image V alignment',
                            'description' => '0 - Top / 50 - Center / 100 - Bottom',
                            'class'       => 'tdc-textfield-small',
                            'range_min'   => '0',
                            'range_max'   => '100',
                            'range_step'  => '1',
                            "group"       => "Layout",
                        ),
                        array(
                            "param_name"  => "image_width1",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Image width (percent)',
                            "description" => "Default value in percent",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-small",
                            "placeholder" => "50",
                            "group"       => "Layout",
                        ),
                        array(
                            "param_name"  => "image_height1",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Image height (percent)',
                            "description" => "Default value in percent",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-small",
                            "placeholder" => "400px",
                            "group"       => "Layout",
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "horizontal_separator",
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                            "group"      => "Layout",
                        ),
                        array(
                            "param_name"  => "meta_width1",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Meta info width',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-small",
                            "placeholder" => "100%",
                            "group"       => "Layout",
                        ),
                        array(
                            "param_name"  => "meta_margin1",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Meta info margin',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-big",
                            "placeholder" => "0px 0px 0px 0px",
                            "group"       => "Layout",
                        ),
                        array(
                            "param_name"  => "meta_padding1",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Meta info padding',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-big",
                            "placeholder" => "20px",
                            "group"       => "Layout",
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "horizontal_separator",
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                            "group"      => "Layout",
                        ),
                        array(
                            "param_name"  => "art_title1",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Article title space',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-big",
                            "placeholder" => "0px 0px 9px 0px",
                            "group"       => "Layout",
                        ),
                        array(
                            "param_name"  => "art_title_padd1",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Article title padding',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-big",
                            "placeholder" => "0px 0px 0px 0px",
                            "group"       => "Layout",
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "horizontal_separator",
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                            "group"      => "Layout",
                        ),
                        array(
                            "param_name"  => "modules_category_margin1",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Category tag spacing',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-big",
                            "placeholder" => "0px 0px 10px 0px",
                            "group"       => "Layout",
                        ),
                        array(
                            "param_name"  => "modules_category_padding1",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Category tag padding',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-big",
                            "placeholder" => "3px 6px 3px 6px",
                            "group"       => "Layout",
                        ),
                        array(
                            "param_name"  => "show_cat1",
                            "type"        => "dropdown-responsive",
                            "value"       => array(
                                'Show' => 'inline-block',
                                'Hide' => 'none',
                            ),
                            "heading"     => 'Show category',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-dropdown-big",
                            "group"       => "Layout",
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "horizontal_separator",
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                            "group"      => "Layout",
                        ),
                        array(
                            "param_name"  => "show_author1",
                            "type"        => "dropdown-responsive",
                            "value"       => array(
                                'Show' => 'inline-block',
                                'Hide' => 'none',
                            ),
                            "heading"     => 'Show author',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-dropdown-big",
                            "group"       => "Layout",
                        ),
                        array(
                            "param_name"  => "show_date1",
                            "type"        => "dropdown-responsive",
                            "value"       => array(
                                'Show' => 'inline-block',
                                'Hide' => 'none',
                            ),
                            "heading"     => 'Show date',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-dropdown-big",
                            "group"       => "Layout",
                        ),
                        array(
                            "param_name"  => "auth_date_padding1",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Author & date padding',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-big",
                            "placeholder" => "0px 0px 0px 0px",
                            "group"       => "Layout",
                        ),

                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Module Category Grid 2',
                            "value"      => "",
                            "class"      => "",
                            "group"      => "Layout",
                        ),
                        array(
                            "param_name"  => "image_size2",
                            "type"        => "dropdown",
                            "value"       => array(
                                'XSmall - 324px' => 'td_324x400',
                                'Small - 696px'  => '',
                                'Large - 1068px' => 'td_1068x0',
                                'Full - 1920px'  => 'td_1920x0'
                            ),
                            "heading"     => 'Image size',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-dropdown-big",
                            "group"       => "Layout",
                        ),
                        array(
                            'param_name'  => 'image_alignment2',
                            'type'        => 'range-responsive',
                            'value'       => '50',
                            'heading'     => 'Image V alignment',
                            'description' => '0 - Top / 50 - Center / 100 - Bottom',
                            'class'       => 'tdc-textfield-small',
                            'range_min'   => '0',
                            'range_max'   => '100',
                            'range_step'  => '1',
                            "group"       => "Layout",
                        ),
                        array(
                            "param_name"  => "image_width2",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Image width (percent)',
                            "description" => "Default value in percent",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-small",
                            "placeholder" => "25",
                            "group"       => "Layout",
                        ),
                        array(
                            "param_name"  => "image_height2",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Image height (percent)',
                            "description" => "Default value in percent",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-small",
                            "placeholder" => "400px",
                            "group"       => "Layout",
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "horizontal_separator",
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                            "group"      => "Layout",
                        ),
                        array(
                            "param_name"  => "meta_width2",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Meta info width',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-small",
                            "placeholder" => "100%",
                            "group"       => "Layout",
                        ),
                        array(
                            "param_name"  => "meta_margin2",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Meta info margin',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-big",
                            "placeholder" => "0px 0px 0px 0px",
                            "group"       => "Layout",
                        ),
                        array(
                            "param_name"  => "meta_padding2",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Meta info padding',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-big",
                            "placeholder" => "20px",
                            "group"       => "Layout",
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "horizontal_separator",
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                            "group"      => "Layout",
                        ),
                        array(
                            "param_name"  => "art_title2",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Article title space',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-big",
                            "placeholder" => "0px 0px 9px 0px",
                            "group"       => "Layout",
                        ),
                        array(
                            "param_name"  => "art_title_padd2",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Article title padding',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-big",
                            "placeholder" => "0px 0px 0px 0px",
                            "group"       => "Layout",
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "horizontal_separator",
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                            "group"      => "Layout",
                        ),
                        array(
                            "param_name"  => "modules_category_margin2",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Category tag spacing',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-big",
                            "placeholder" => "0px 0px 10px 0px",
                            "group"       => "Layout",
                        ),
                        array(
                            "param_name"  => "modules_category_padding2",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Category tag padding',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-big",
                            "placeholder" => "3px 6px 3px 6px",
                            "group"       => "Layout",
                        ),
                        array(
                            "param_name"  => "show_cat2",
                            "type"        => "dropdown-responsive",
                            "value"       => array(
                                'Show' => 'inline-block',
                                'Hide' => 'none',
                            ),
                            "heading"     => 'Show category',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-dropdown-big",
                            "group"       => "Layout",
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "horizontal_separator",
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                            "group"      => "Layout",
                        ),
                        array(
                            "param_name"  => "show_author2",
                            "type"        => "dropdown-responsive",
                            "value"       => array(
                                'Show' => 'inline-block',
                                'Hide' => 'none',
                            ),
                            "heading"     => 'Show author',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-dropdown-big",
                            "group"       => "Layout",
                        ),
                        array(
                            "param_name"  => "show_date2",
                            "type"        => "dropdown-responsive",
                            "value"       => array(
                                'Show' => 'inline-block',
                                'Hide' => 'none',
                            ),
                            "heading"     => 'Show date',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-dropdown-big",
                            "group"       => "Layout",
                        ),
                        array(
                            "param_name"  => "auth_date_padding2",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Author & date padding',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-big",
                            "placeholder" => "0px 0px 0px 0px",
                            "group"       => "Layout",
                        ),
                        array(
                            "param_name" => "separator",
                            "type" => "text_separator",
                            'heading' => 'Module fonts',
                            "value" => "",
                            "class" => "",
                            "group" => 'Style',
                        ),
                    ),
                    td_config_helper::get_map_block_font_array( 'f_title1', true, 'Module 1 title', 'Style' ),
                    td_config_helper::get_map_block_font_array( 'f_cat1', false, 'Module 1 category tag', 'Style' ),
                    td_config_helper::get_map_block_font_array( 'f_meta1', false, 'Module 1 meta info', 'Style' ),
                    td_config_helper::get_map_block_font_array( 'f_title2', false, 'Module 2 title', 'Style' ),
                    td_config_helper::get_map_block_font_array( 'f_cat2', false, 'Module 2 category tag', 'Style' ),
                    td_config_helper::get_map_block_font_array( 'f_meta2', false, 'Module 2 meta info', 'Style' ),
                    array(
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Colors',
                            "value"      => "",
                            "class"      => "",
                            "group"      => "Style",
                        ),
                        array(
                            "param_name" => "overlay_general",
                            "holder" => "div",
                            "type" => "gradient",
                            'heading' => "General module overlay color",
                            "value" => "",
                            "class" => "",
                            "group"      => "Style",
                        ),
                        array(
                            "param_name" => "overlay_h_general",
                            "holder" => "div",
                            "type" => "gradient",
                            'heading' => "General module overlay hover color",
                            "value" => "",
                            "class" => "",
                            "group"      => "Style",
                        ),
                        array(
                            "param_name" => "overlay_1",
                            "holder" => "div",
                            "type" => "gradient",
                            'heading' => "Module overlay color 1",
                            "value" => "",
                            "class" => "",
                            "group"      => "Style",
                        ),
                        array(
                            "param_name" => "overlay_2",
                            "holder" => "div",
                            "type" => "gradient",
                            'heading' => "Module overlay color 2",
                            "value" => "",
                            "class" => "",
                            "group"      => "Style",
                        ),
                        array(
                            "param_name" => "overlay_3",
                            "holder" => "div",
                            "type" => "gradient",
                            'heading' => "Module overlay color 3",
                            "value" => "",
                            "class" => "",
                            "group"      => "Style",
                        ),
                        array(
                            "param_name"  => "lightsky",
                            "type"        => "checkbox",
                            "value"       => '',
                            "heading"     => "Lightsky",
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "",
                            "group"       => 'Style'
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "",
                            "heading"     => 'Meta info background',
                            "param_name"  => "meta_bg",
                            "value"       => '',
                            "description" => '',
                            "group"       => 'Style',
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "horizontal_separator",
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                            "group"      => "Style",
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "",
                            "heading"     => 'Article title text color',
                            "param_name"  => "title_txt",
                            "value"       => '',
                            "description" => '',
                            "group"       => 'Style',
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "",
                            "heading"     => 'Article title text hover',
                            "param_name"  => "title_txt_hover",
                            "value"       => '',
                            "description" => '',
                            "group"       => 'Style',
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "",
                            "heading"     => 'Article title background color',
                            "param_name"  => "title_bg",
                            "value"       => '',
                            "description" => '',
                            "group"       => 'Style',
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "horizontal_separator",
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                            "group"      => "Style",
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "",
                            "heading"     => 'Category background',
                            "param_name"  => "cat_bg",
                            "value"       => '',
                            "description" => '',
                            "group"       => 'Style',
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "",
                            "heading"     => 'Category text color',
                            "param_name"  => "cat_txt",
                            "value"       => '',
                            "description" => '',
                            "group"       => 'Style',
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "",
                            "heading"     => 'Category background hover',
                            "param_name"  => "cat_bg_hover",
                            "value"       => '',
                            "description" => '',
                            "group"       => 'Style',
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "",
                            "heading"     => 'Category text hover',
                            "param_name"  => "cat_txt_hover",
                            "value"       => '',
                            "description" => '',
                            "group"       => 'Style',
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "horizontal_separator",
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                            "group"      => "Style",
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "",
                            "heading"     => 'Author text color',
                            "param_name"  => "author_txt",
                            "value"       => '',
                            "description" => '',
                            "group"       => 'Style',
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "",
                            "heading"     => 'Author text hover',
                            "param_name"  => "author_txt_hover",
                            "value"       => '',
                            "description" => '',
                            "group"       => 'Style',
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "",
                            "heading"     => 'Date text color',
                            "param_name"  => "date_txt",
                            "value"       => '',
                            "description" => '',
                            "group"       => 'Style',
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "",
                            "heading"     => 'Author & date background color',
                            "param_name"  => "auth_date_bg",
                            "value"       => '',
                            "description" => '',
                            "group"       => 'Style',
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "",
                            "heading"     => 'Review stars color',
                            "param_name"  => "review_stars",
                            "value"       => '',
                            "description" => '',
                            "group"       => 'Style',
                        ),
                    ),
                    self::get_map_css_tab()
                )
            )
        );

        td_api_block::add('td_block_big_grid_flex_8',
            array(
                'map_in_visual_composer' => false,
                'map_in_td_composer' => true,
                "name" => 'Big Grid Flex 8',
                "base" => 'td_block_big_grid_flex_8',
                "class" => 'td_block_big_grid_flex_8',
                "controls" => "full",
                "category" => 'Blocks',
                'tdc_category' => 'Big Grids',
                'icon' => 'icon-pagebuilder-td_block_big_grid_flex_8',
                'file' => td_global::$get_template_directory . '/includes/shortcodes/td_block_big_grid_flex_8.php',
                'tdc_style_params' => array(
                    'custom_title',
                    'custom_url',
                    'post_ids',
                    'category_id',
                    'category_ids',
                    'tag_slug',
                    'autors_id',
                    'installed_post_types',
                    'sort',
                    'offset',
                    'el_class'
                ),
                'tdc_start_values' => base64_encode(
                    json_encode(
                        array(
                            array(
                                "meta_info_vert" => "content-vert-bottom",
                                "image_zoom" => "yes",
                                "show_author2" => "none",
                                "show_date2" => "none",
                                "modules_category" => "above",
                                "overlay_general" => "eyJ0eXBlIjoiZ3JhZGllbnQiLCJjb2xvcjEiOiJyZ2JhKDAsMCwwLDApIiwiY29sb3IyIjoicmdiYSgwLDAsMCwwLjcpIiwibWl4ZWRDb2xvcnMiOlt7ImNvbG9yIjoicmdiYSgwLDAsMCwwKSIsInBlcmNlbnRhZ2UiOjYwfV0sImNzcyI6ImJhY2tncm91bmQ6IC13ZWJraXQtbGluZWFyLWdyYWRpZW50KDBkZWcscmdiYSgwLDAsMCwwLjcpLHJnYmEoMCwwLDAsMCkgNjAlLHJnYmEoMCwwLDAsMCkpO2JhY2tncm91bmQ6IGxpbmVhci1ncmFkaWVudCgwZGVnLHJnYmEoMCwwLDAsMC43KSxyZ2JhKDAsMCwwLDApIDYwJSxyZ2JhKDAsMCwwLDApKTsiLCJjc3NQYXJhbXMiOiIwZGVnLHJnYmEoMCwwLDAsMC43KSxyZ2JhKDAsMCwwLDApIDYwJSxyZ2JhKDAsMCwwLDApIn0=",
                                "image_width1" => "eyJwaG9uZSI6IjUwIn0=",
                                "image_width2" => "eyJwaG9uZSI6IjUwIn0=",
                                "image_height2" => "eyJwaG9uZSI6IjE1MHB4IiwicG9ydHJhaXQiOiIxMzZweCIsImxhbmRzY2FwZSI6IjQ2LjYifQ==",
                                "image_height1" => "eyJwaG9uZSI6IjE1MHB4IiwibGFuZHNjYXBlIjoiMTI1IiwicG9ydHJhaXQiOiIyNzRweCJ9",
                                "meta_padding2" => "eyJwaG9uZSI6IjE1cHggMTVweCAxMHB4IiwicG9ydHJhaXQiOiIyMHB4IDEwcHggMTZweCJ9",
                                "meta_padding1" => "eyJwaG9uZSI6IjE1cHggMTVweCAxMHB4IiwicG9ydHJhaXQiOiIyMnB4IDEwcHgifQ==",
                                "cat_bg_hover" => "#4db2ec",
                                "review_stars" => "#fff",
                                "modules_category_margin1" => "eyJwb3J0cmFpdCI6IjBweCAwcHggN3B4IDBweCIsInBob25lIjoiMHB4IDBweCA3cHggMHB4In0=",
                                "modules_category_margin2" => "eyJwb3J0cmFpdCI6IjBweCAwcHggN3B4IDBweCIsInBob25lIjoiMHB4IDBweCA3cHggMHB4In0=",
                                "art_title1" => "eyJwb3J0cmFpdCI6IjBweCAwcHggNnB4IDBweCIsInBob25lIjoiMHB4IDBweCAwcHggMHB4In0=",
                                "show_author1" => "eyJwaG9uZSI6Im5vbmUifQ==",
                                "show_date1" => "eyJwaG9uZSI6Im5vbmUifQ==",
                                "image_size" => "",
                                "image_size2" => ""
                            ),

                            array(
                                'tdc_preset_name' => 'Font family',
                                'tdc_preset_class' => 'tdcp_separator tdcp_separator_font',
                            ),
                            array(
                                'tdc_preset_name' => '', // Font - Montserrat
                                'tdc_preset_class' => 'tdcp_img tdcp_font tdcp_font1',
                                'tdc_preset_individual' => '1',
                                "f_title1_font_family" =>        "394",
                                "f_title2_font_family" =>        "394",
                            ),
                            array(
                                'tdc_preset_name' => '', // Font - Source Serif
                                'tdc_preset_class' => 'tdcp_img tdcp_font tdcp_font2',
                                'tdc_preset_individual' =>      '1',
                                "f_title1_font_family" =>        "721",
                                "f_title2_font_family" =>        "721",
                            ),
                            array(
                                'tdc_preset_name' => '', // Font - Raleway
                                'tdc_preset_class' => 'tdcp_img tdcp_font tdcp_font3',
                                'tdc_preset_individual' => '1',
                                "f_title1_font_family" =>        "507",
                                "f_title2_font_family" =>        "507",
                            ),
                            array(
                                'tdc_preset_name' => '', // Font - Work Sans
                                'tdc_preset_class' => 'tdcp_img tdcp_font tdcp_font4',
                                'tdc_preset_individual' => '1',
                                "f_title1_font_family" =>        "653",
                                "f_title2_font_family" =>        "653",
                            ),
                            array(
                                'tdc_preset_name' => '', // Font - Courgette
                                'tdc_preset_class' => 'tdcp_img tdcp_font tdcp_font5',
                                'tdc_preset_individual' => '1',
                                "f_title1_font_family" =>        "147",
                                "f_title2_font_family" =>        "147",
                            ),
                            array(
                                'tdc_preset_name' => '', // Font - Oswald
                                'tdc_preset_class' => 'tdcp_img tdcp_font tdcp_font7',
                                'tdc_preset_individual' => '1',
                                "f_title1_font_family" =>        "445",
                                "f_title2_font_family" =>        "445",
                            ),
                            array(
                                'tdc_preset_name' => '', // Font - Muli
                                'tdc_preset_class' => 'tdcp_img tdcp_font tdcp_font8',
                                'tdc_preset_individual' => '1',
                                "f_title1_font_family" =>        "406",
                                "f_title2_font_family" =>        "406",
                            ),
                            array(
                                'tdc_preset_name' => '', // Font - Wendy One
                                'tdc_preset_class' => 'tdcp_img tdcp_font tdcp_font9',
                                'tdc_preset_individual' => '1',
                                "f_title1_font_family" =>        "646",
                                "f_title2_font_family" =>        "646",
                            ),
                            array(
                                'tdc_preset_name' => '', // Font - Anton
                                'tdc_preset_class' => 'tdcp_img tdcp_font tdcp_font10',
                                'tdc_preset_individual' => '1',
                                "f_title1_font_family" =>        "41",
                                "f_title2_font_family" =>        "41",
                            ),
                            array(
                                'tdc_preset_name' => '', // Font - Quicksand
                                'tdc_preset_class' => 'tdcp_img tdcp_font tdcp_font11',
                                'tdc_preset_individual' => '1',
                                "f_title1_font_family" =>        "502",
                                "f_title2_font_family" =>        "502",
                            ),
                            array(
                                'tdc_preset_name' => '', // Font - Libre Baskerville
                                'tdc_preset_class' => 'tdcp_img tdcp_font tdcp_font12',
                                'tdc_preset_individual' => '1',
                                "f_title1_font_family" =>        "331",
                                "f_title2_font_family" =>        "331",
                            ),
                            array(
                                'tdc_preset_name' => '', // Font - Caveat
                                'tdc_preset_class' => 'tdcp_img tdcp_font tdcp_font13',
                                'tdc_preset_individual' => '1',
                                "f_title1_font_family" =>        "663",
                                "f_title2_font_family" =>        "663",
                            ),
                            array(
                                'tdc_preset_name' => '', // Font - Volkorn
                                'tdc_preset_class' => 'tdcp_img tdcp_font tdcp_font14',
                                'tdc_preset_individual' => '1',
                                "f_title1_font_family" =>        "639",
                                "f_title2_font_family" =>        "639",
                            ),
                            array(
                                'tdc_preset_name' => '', // Font - Default
                                'tdc_preset_class' => 'tdcp_img tdcp_font tdcp_font6',
                                'tdc_preset_individual' => '1',
                                "f_title1_font_family" =>        "",
                                "f_title2_font_family" =>        "",
                            ),

                            array(
                                'tdc_preset_name' => 'Font size',
                                'tdc_preset_class' => 'tdcp_separator tdcp_separator_size',
                            ),
                            array(
                                'tdc_preset_name' => '', // Size - XS 13/13/12/14
                                'tdc_preset_class' => 'tdcp_img tdcp_size tdcp_size1',
                                'tdc_preset_individual' => '1',
                                "f_title1_font_size" => "eyJhbGwiOiIxNiIsInBvcnRyYWl0IjoiMTQifQ==",
                                "f_title1_font_line_height" => "1.3",
                                "f_title2_font_size" => "eyJhbGwiOiIxNiIsInBvcnRyYWl0IjoiMTQifQ==",
                                "f_title2_font_line_height" => "1.3",
                            ),
                            array(
                                'tdc_preset_name' => '', // Size - S 14/13/12/14
                                'tdc_preset_class' => 'tdcp_img tdcp_size tdcp_size2',
                                'tdc_preset_individual' => '1',
                                "f_title1_font_size" => "eyJhbGwiOiIxOCIsInBvcnRyYWl0IjoiMTYiLCJwaG9uZSI6IjE2In0=",
                                "f_title1_font_line_height" => "eyJhbGwiOiIxLjQiLCJwaG9uZSI6IjEuMyJ9",
                                "f_title2_font_size" => "eyJhbGwiOiIxNiIsInBvcnRyYWl0IjoiMTQifQ==",
                                "f_title2_font_line_height" => "1.3",
                            ),
                            array(
                                'tdc_preset_name' => '', // Size - M 21/21/17/21
                                'tdc_preset_class' => 'tdcp_img tdcp_size tdcp_size3',
                                'tdc_preset_individual' => '1',
                                "f_title1_font_size" => "eyJhbGwiOiIyNCIsInBvcnRyYWl0IjoiMjIiLCJwaG9uZSI6IjE0In0=",
                                "f_title1_font_line_height" => "1.2",
                                "f_title2_font_size" => "eyJhbGwiOiIyMCIsInBvcnRyYWl0IjoiMTYiLCJwaG9uZSI6IjE0In0=",
                                "f_title2_font_line_height" => "1.2",
                            ),
                            array(
                                'tdc_preset_name' => '', // Size - L 26/25/21/21
                                'tdc_preset_class' => 'tdcp_img tdcp_size tdcp_size4',
                                'tdc_preset_individual' => '1',
                                "f_title1_font_size" => "eyJhbGwiOiIyNiIsInBvcnRyYWl0IjoiMjQiLCJwaG9uZSI6IjE2In0=",
                                "f_title1_font_line_height" => "eyJhbGwiOiIxLjEiLCJwaG9uZSI6IjEuMyJ9",
                                "f_title2_font_size" => "",
                                "f_title2_font_line_height" => "eyJwaG9uZSI6IjEuMyJ9",

                            ),
                            array(
                                'tdc_preset_name' => '', // Size - XL 30/28/24/21
                                'tdc_preset_class' => 'tdcp_img tdcp_size tdcp_size5',
                                'tdc_preset_individual' => '1',
                                "f_title1_font_size" => "eyJhbGwiOiIzMCIsImxhbmRzY2FwZSI6IjI4IiwicG9ydHJhaXQiOiIyNCIsInBob25lIjoiMTYifQ==",
                                "f_title1_font_line_height" => "1.2",
                                "f_title2_font_size" => "",
                                "f_title2_font_line_height" => "eyJwaG9uZSI6IjEuMiJ9",
                            ),
                            array(
                                'tdc_preset_name' => '', // Size - XXL 36/32/26/21
                                'tdc_preset_class' => 'tdcp_img tdcp_size tdcp_size6',
                                'tdc_preset_individual' => '1',
                                "f_title1_font_size" => "eyJhbGwiOiIzNiIsImxhbmRzY2FwZSI6IjMyIiwicGhvbmUiOiIxNiIsInBvcnRyYWl0IjoiMjYifQ==",
                                "f_title1_font_line_height" => "eyJhbGwiOiIxLjEiLCJwaG9uZSI6IjEuMiJ9",
                                "f_title2_font_size" => "",
                                "f_title2_font_line_height" => "eyJwaG9uZSI6IjEuMiJ9",
                            ),

                            array(
                                'tdc_preset_name' => 'Text horizontal alignment',
                                'tdc_preset_class' => 'tdcp_separator tdcp_separator_align',
                            ),
                            array(
                                'tdc_preset_name' => '', // Text alignment - left
                                'tdc_preset_class' => 'tdcp_img tdcp_align tdcp_align1',
                                'tdc_preset_individual' => '1',
                                "meta_info_horiz" => "content-horiz-left",
                            ),
                            array(
                                'tdc_preset_name' => '', // Text alignment - center
                                'tdc_preset_class' => 'tdcp_img tdcp_align tdcp_align2',
                                'tdc_preset_individual' => '1',
                                "meta_info_horiz" => "content-horiz-center",
                            ),
                            array(
                                'tdc_preset_name' => '', // Text alignment - right
                                'tdc_preset_class' => 'tdcp_img tdcp_align tdcp_align3',
                                'tdc_preset_individual' => '1',
                                "meta_info_horiz" => "content-horiz-right",
                            ),

                            array(
                                'tdc_preset_name' => 'Text vertical alignment',
                                'tdc_preset_class' => 'tdcp_separator tdcp_separator_align_v',
                            ),
                            array(
                                'tdc_preset_name' => '', // Text vertical alignment - top
                                'tdc_preset_class' => 'tdcp_img tdcp_align tdcp_align_v1',
                                'tdc_preset_individual' => '1',
                                "meta_info_vert" => "content-vert-top",
                            ),
                            array(
                                'tdc_preset_name' => '', // Text vertical alignment - middle
                                'tdc_preset_class' => 'tdcp_img tdcp_align tdcp_align_v2',
                                'tdc_preset_individual' => '1',
                                "meta_info_vert" => "content-vert-center",
                            ),
                            array(
                                'tdc_preset_name' => '', // Text vertical alignment - bottom
                                'tdc_preset_class' => 'tdcp_img tdcp_align tdcp_align_v3',
                                'tdc_preset_individual' => '1',
                                "meta_info_vert" => "content-vert-bottom",
                            ),

                            array(
                                'tdc_preset_name' => 'Style',
                                'tdc_preset_class' => 'tdcp_separator tdcp_separator_style',
                            ),
                            array(
                                'tdc_preset_name' => '', // Style 1 - default
                                'tdc_preset_class' => 'tdcp_img tdcp_style tdcp_style1',
                                'tdc_preset_individual' => '1',
                                "overlay_general" => "eyJ0eXBlIjoiZ3JhZGllbnQiLCJjb2xvcjEiOiJyZ2JhKDAsMCwwLDApIiwiY29sb3IyIjoicmdiYSgwLDAsMCwwLjcpIiwibWl4ZWRDb2xvcnMiOlt7ImNvbG9yIjoicmdiYSgwLDAsMCwwKSIsInBlcmNlbnRhZ2UiOjYwfV0sImNzcyI6ImJhY2tncm91bmQ6IC13ZWJraXQtbGluZWFyLWdyYWRpZW50KDBkZWcscmdiYSgwLDAsMCwwLjcpLHJnYmEoMCwwLDAsMCkgNjAlLHJnYmEoMCwwLDAsMCkpO2JhY2tncm91bmQ6IGxpbmVhci1ncmFkaWVudCgwZGVnLHJnYmEoMCwwLDAsMC43KSxyZ2JhKDAsMCwwLDApIDYwJSxyZ2JhKDAsMCwwLDApKTsiLCJjc3NQYXJhbXMiOiIwZGVnLHJnYmEoMCwwLDAsMC43KSxyZ2JhKDAsMCwwLDApIDYwJSxyZ2JhKDAsMCwwLDApIn0=",
                                "overlay_h_general" => "",
                                "overlay_1" => "",
                                "overlay_2" => "",
                                "overlay_3" => "",
                                "overlay_4" => "",
                                "lightsky" => "",
                            ),
                            array(
                                'tdc_preset_name' => '', // Style 2 - colors
                                'tdc_preset_class' => 'tdcp_img tdcp_style tdcp_style2',
                                'tdc_preset_individual' => '1',
                                "overlay_h_general" => "",
                                "overlay_1" => "eyJ0eXBlIjoiZ3JhZGllbnQiLCJjb2xvcjEiOiJyZ2JhKDc0LDE0Myw5NCwwLjYpIiwiY29sb3IyIjoicmdiYSg3NywxNzgsMjM2LDAuNikiLCJtaXhlZENvbG9ycyI6W10sImRlZ3JlZSI6IjQ1IiwiY3NzIjoiYmFja2dyb3VuZDogLXdlYmtpdC1saW5lYXItZ3JhZGllbnQoNDVkZWcscmdiYSg3NywxNzgsMjM2LDAuNikscmdiYSg3NCwxNDMsOTQsMC42KSk7YmFja2dyb3VuZDogbGluZWFyLWdyYWRpZW50KDQ1ZGVnLHJnYmEoNzcsMTc4LDIzNiwwLjYpLHJnYmEoNzQsMTQzLDk0LDAuNikpOyIsImNzc1BhcmFtcyI6IjQ1ZGVnLHJnYmEoNzcsMTc4LDIzNiwwLjYpLHJnYmEoNzQsMTQzLDk0LDAuNikifQ==",
                                "overlay_2" => "eyJ0eXBlIjoiZ3JhZGllbnQiLCJjb2xvcjEiOiJyZ2JhKDE5OCw1Nyw1NywwLjYpIiwiY29sb3IyIjoicmdiYSgyMDksMTE4LDcwLDAuNikiLCJtaXhlZENvbG9ycyI6W10sImRlZ3JlZSI6IjQ1IiwiY3NzIjoiYmFja2dyb3VuZDogLXdlYmtpdC1saW5lYXItZ3JhZGllbnQoNDVkZWcscmdiYSgyMDksMTE4LDcwLDAuNikscmdiYSgxOTgsNTcsNTcsMC42KSk7YmFja2dyb3VuZDogbGluZWFyLWdyYWRpZW50KDQ1ZGVnLHJnYmEoMjA5LDExOCw3MCwwLjYpLHJnYmEoMTk4LDU3LDU3LDAuNikpOyIsImNzc1BhcmFtcyI6IjQ1ZGVnLHJnYmEoMjA5LDExOCw3MCwwLjYpLHJnYmEoMTk4LDU3LDU3LDAuNikifQ==",
                                "overlay_3" => "eyJ0eXBlIjoiZ3JhZGllbnQiLCJjb2xvcjEiOiJyZ2JhKDU5LDEyMCwxODAsMC41OSkiLCJjb2xvcjIiOiJyZ2JhKDIxNSw5NiwxODMsMC42KSIsIm1peGVkQ29sb3JzIjpbXSwiZGVncmVlIjoiLTQ1IiwiY3NzIjoiYmFja2dyb3VuZDogLXdlYmtpdC1saW5lYXItZ3JhZGllbnQoLTQ1ZGVnLHJnYmEoMjE1LDk2LDE4MywwLjYpLHJnYmEoNTksMTIwLDE4MCwwLjU5KSk7YmFja2dyb3VuZDogbGluZWFyLWdyYWRpZW50KC00NWRlZyxyZ2JhKDIxNSw5NiwxODMsMC42KSxyZ2JhKDU5LDEyMCwxODAsMC41OSkpOyIsImNzc1BhcmFtcyI6Ii00NWRlZyxyZ2JhKDIxNSw5NiwxODMsMC42KSxyZ2JhKDU5LDEyMCwxODAsMC41OSkifQ==",
                                "overlay_4" => "eyJ0eXBlIjoiZ3JhZGllbnQiLCJjb2xvcjEiOiJyZ2JhKDI0MiwxMjIsNTMsMC42KSIsImNvbG9yMiI6InJnYmEoMjQ0LDIwOCw2MywwLjYpIiwibWl4ZWRDb2xvcnMiOltdLCJkZWdyZWUiOiItNDUiLCJjc3MiOiJiYWNrZ3JvdW5kOiAtd2Via2l0LWxpbmVhci1ncmFkaWVudCgtNDVkZWcscmdiYSgyNDQsMjA4LDYzLDAuNikscmdiYSgyNDIsMTIyLDUzLDAuNikpO2JhY2tncm91bmQ6IGxpbmVhci1ncmFkaWVudCgtNDVkZWcscmdiYSgyNDQsMjA4LDYzLDAuNikscmdiYSgyNDIsMTIyLDUzLDAuNikpOyIsImNzc1BhcmFtcyI6Ii00NWRlZyxyZ2JhKDI0NCwyMDgsNjMsMC42KSxyZ2JhKDI0MiwxMjIsNTMsMC42KSJ9",
                                "lightsky" => "",
                            ),
                            array(
                                'tdc_preset_name' => '', // Style 3 - flat colors
                                'tdc_preset_class' => 'tdcp_img tdcp_style tdcp_style3',
                                'tdc_preset_individual' => '1',
                                "overlay_h_general" => "",
                                "overlay_1" => "eyJ0eXBlIjoiZ3JhZGllbnQiLCJjb2xvcjEiOiJyZ2JhKDc0LDE0Myw5NCwwLjgpIiwiY29sb3IyIjoicmdiYSg3NywxNzgsMjM2LDAuOCkiLCJtaXhlZENvbG9ycyI6W10sImRlZ3JlZSI6IjQ1IiwiY3NzIjoiYmFja2dyb3VuZDogLXdlYmtpdC1saW5lYXItZ3JhZGllbnQoNDVkZWcscmdiYSg3NywxNzgsMjM2LDAuOCkscmdiYSg3NCwxNDMsOTQsMC44KSk7YmFja2dyb3VuZDogbGluZWFyLWdyYWRpZW50KDQ1ZGVnLHJnYmEoNzcsMTc4LDIzNiwwLjgpLHJnYmEoNzQsMTQzLDk0LDAuOCkpOyIsImNzc1BhcmFtcyI6IjQ1ZGVnLHJnYmEoNzcsMTc4LDIzNiwwLjgpLHJnYmEoNzQsMTQzLDk0LDAuOCkifQ==",
                                "overlay_2" => "eyJ0eXBlIjoiZ3JhZGllbnQiLCJjb2xvcjEiOiJyZ2JhKDE5OCw1Nyw1NywwLjgpIiwiY29sb3IyIjoicmdiYSgyMDksMTE4LDcwLDAuOCkiLCJtaXhlZENvbG9ycyI6W10sImRlZ3JlZSI6IjQ1IiwiY3NzIjoiYmFja2dyb3VuZDogLXdlYmtpdC1saW5lYXItZ3JhZGllbnQoNDVkZWcscmdiYSgyMDksMTE4LDcwLDAuOCkscmdiYSgxOTgsNTcsNTcsMC44KSk7YmFja2dyb3VuZDogbGluZWFyLWdyYWRpZW50KDQ1ZGVnLHJnYmEoMjA5LDExOCw3MCwwLjgpLHJnYmEoMTk4LDU3LDU3LDAuOCkpOyIsImNzc1BhcmFtcyI6IjQ1ZGVnLHJnYmEoMjA5LDExOCw3MCwwLjgpLHJnYmEoMTk4LDU3LDU3LDAuOCkifQ==",
                                "overlay_3" => "eyJ0eXBlIjoiZ3JhZGllbnQiLCJjb2xvcjEiOiJyZ2JhKDU5LDEyMCwxODAsMC44KSIsImNvbG9yMiI6InJnYmEoMjE1LDk2LDE4MywwLjgpIiwibWl4ZWRDb2xvcnMiOltdLCJkZWdyZWUiOiItNDUiLCJjc3MiOiJiYWNrZ3JvdW5kOiAtd2Via2l0LWxpbmVhci1ncmFkaWVudCgtNDVkZWcscmdiYSgyMTUsOTYsMTgzLDAuOCkscmdiYSg1OSwxMjAsMTgwLDAuOCkpO2JhY2tncm91bmQ6IGxpbmVhci1ncmFkaWVudCgtNDVkZWcscmdiYSgyMTUsOTYsMTgzLDAuOCkscmdiYSg1OSwxMjAsMTgwLDAuOCkpOyIsImNzc1BhcmFtcyI6Ii00NWRlZyxyZ2JhKDIxNSw5NiwxODMsMC44KSxyZ2JhKDU5LDEyMCwxODAsMC44KSJ9",
                                "overlay_4" => "eyJ0eXBlIjoiZ3JhZGllbnQiLCJjb2xvcjEiOiJyZ2JhKDI0MiwxMjIsNTMsMC44KSIsImNvbG9yMiI6InJnYmEoMjQ0LDIwOCw2MywwLjgpIiwibWl4ZWRDb2xvcnMiOltdLCJkZWdyZWUiOiItNDUiLCJjc3MiOiJiYWNrZ3JvdW5kOiAtd2Via2l0LWxpbmVhci1ncmFkaWVudCgtNDVkZWcscmdiYSgyNDQsMjA4LDYzLDAuOCkscmdiYSgyNDIsMTIyLDUzLDAuOCkpO2JhY2tncm91bmQ6IGxpbmVhci1ncmFkaWVudCgtNDVkZWcscmdiYSgyNDQsMjA4LDYzLDAuOCkscmdiYSgyNDIsMTIyLDUzLDAuOCkpOyIsImNzc1BhcmFtcyI6Ii00NWRlZyxyZ2JhKDI0NCwyMDgsNjMsMC44KSxyZ2JhKDI0MiwxMjIsNTMsMC44KSJ9",
                                "lightsky" => "",
                            ),
                            array(
                                'tdc_preset_name' => '', // Style 4 - light sky
                                'tdc_preset_class' => 'tdcp_img tdcp_style tdcp_style4',
                                'tdc_preset_individual' => '1',
                                "overlay_general" => "rgba(0,0,0,0.7)",
                                "overlay_h_general" => "rgba(77,178,236,0.3)",
                                "overlay_1" => "",
                                "overlay_2" => "",
                                "overlay_3" => "",
                                "overlay_4" => "",
                                "lightsky" => "yes",
                            ),
                            array(
                                'tdc_preset_name' => '', // Style 5 - rainbow
                                'tdc_preset_class' => 'tdcp_img tdcp_style tdcp_style5',
                                'tdc_preset_individual' => '1',
                                "overlay_h_general" => "",
                                "overlay_1" => "eyJ0eXBlIjoiZ3JhZGllbnQiLCJjb2xvcjEiOiJyZ2JhKDI1NSwxMTEsNDksMC42KSIsImNvbG9yMiI6InJnYmEoNjUsMTIsMTg4LDAuNikiLCJtaXhlZENvbG9ycyI6W10sImRlZ3JlZSI6IjIwIiwiY3NzIjoiYmFja2dyb3VuZDogLXdlYmtpdC1saW5lYXItZ3JhZGllbnQoMjBkZWcscmdiYSg2NSwxMiwxODgsMC42KSxyZ2JhKDI1NSwxMTEsNDksMC42KSk7YmFja2dyb3VuZDogbGluZWFyLWdyYWRpZW50KDIwZGVnLHJnYmEoNjUsMTIsMTg4LDAuNikscmdiYSgyNTUsMTExLDQ5LDAuNikpOyIsImNzc1BhcmFtcyI6IjIwZGVnLHJnYmEoNjUsMTIsMTg4LDAuNikscmdiYSgyNTUsMTExLDQ5LDAuNikifQ==",
                                "overlay_2" => "eyJ0eXBlIjoiZ3JhZGllbnQiLCJjb2xvcjEiOiJyZ2JhKDExMiwyNTUsMTUzLDAuNikiLCJjb2xvcjIiOiJyZ2JhKDI0NCwxMzYsMTMsMC42KSIsIm1peGVkQ29sb3JzIjpbXSwiZGVncmVlIjoiMjAiLCJjc3MiOiJiYWNrZ3JvdW5kOiAtd2Via2l0LWxpbmVhci1ncmFkaWVudCgyMGRlZyxyZ2JhKDI0NCwxMzYsMTMsMC42KSxyZ2JhKDExMiwyNTUsMTUzLDAuNikpO2JhY2tncm91bmQ6IGxpbmVhci1ncmFkaWVudCgyMGRlZyxyZ2JhKDI0NCwxMzYsMTMsMC42KSxyZ2JhKDExMiwyNTUsMTUzLDAuNikpOyIsImNzc1BhcmFtcyI6IjIwZGVnLHJnYmEoMjQ0LDEzNiwxMywwLjYpLHJnYmEoMTEyLDI1NSwxNTMsMC42KSJ9",
                                "overlay_3" => "eyJ0eXBlIjoiZ3JhZGllbnQiLCJjb2xvcjEiOiJyZ2JhKDEyNiwxOTEsMjU1LDAuNikiLCJjb2xvcjIiOiJyZ2JhKDE5NiwxNSwxMjEsMC42KSIsIm1peGVkQ29sb3JzIjpbXSwiZGVncmVlIjoiMjAiLCJjc3MiOiJiYWNrZ3JvdW5kOiAtd2Via2l0LWxpbmVhci1ncmFkaWVudCgyMGRlZyxyZ2JhKDE5NiwxNSwxMjEsMC42KSxyZ2JhKDEyNiwxOTEsMjU1LDAuNikpO2JhY2tncm91bmQ6IGxpbmVhci1ncmFkaWVudCgyMGRlZyxyZ2JhKDE5NiwxNSwxMjEsMC42KSxyZ2JhKDEyNiwxOTEsMjU1LDAuNikpOyIsImNzc1BhcmFtcyI6IjIwZGVnLHJnYmEoMTk2LDE1LDEyMSwwLjYpLHJnYmEoMTI2LDE5MSwyNTUsMC42KSJ9",
                                "overlay_4" => "eyJ0eXBlIjoiZ3JhZGllbnQiLCJjb2xvcjEiOiJyZ2JhKDQyLDIzNiwxMTYsMC42KSIsImNvbG9yMiI6InJnYmEoMCwyMiwxOTAsMC42KSIsIm1peGVkQ29sb3JzIjpbXSwiZGVncmVlIjoiMjAiLCJjc3MiOiJiYWNrZ3JvdW5kOiAtd2Via2l0LWxpbmVhci1ncmFkaWVudCgyMGRlZyxyZ2JhKDAsMjIsMTkwLDAuNikscmdiYSg0MiwyMzYsMTE2LDAuNikpO2JhY2tncm91bmQ6IGxpbmVhci1ncmFkaWVudCgyMGRlZyxyZ2JhKDAsMjIsMTkwLDAuNikscmdiYSg0MiwyMzYsMTE2LDAuNikpOyIsImNzc1BhcmFtcyI6IjIwZGVnLHJnYmEoMCwyMiwxOTAsMC42KSxyZ2JhKDQyLDIzNiwxMTYsMC42KSJ9",
                                "lightsky" => "",
                            ),
                        )
                    )
                ),
                "params" => array_merge(
                    array(
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Content length',
                            "value"      => "",
                            "class"      => "",
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Module Flex 6',
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                        ),
                        array(
                            "param_name"  => "mf6_tl",
                            "type"        => "textfield",
                            "value"       => '',
                            "heading"     => 'Title length',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-small",
                            "placeholder" => '25',
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Module Flex 7',
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                        ),
                        array(
                            "param_name"  => "mf7_tl",
                            "type"        => "textfield",
                            "value"       => '',
                            "heading"     => 'Title length',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-small",
                            "placeholder" => '25',
                        ),
                    ),
                    self::td_block_big_grid_params(),
                    array(
                        array(
                            "param_name"  => "modules_gap",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Modules gap',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-small",
                            "placeholder" => "2",
                            "group"       => "Layout",
                        ),
                        array(
                            "param_name" => "meta_info_horiz",
                            "type" => "dropdown",
                            "value" => array(
                                'Left' => 'content-horiz-left',
                                'Center' => 'content-horiz-center',
                                'Right' => 'content-horiz-right'
                            ),
                            "heading" => 'Meta info horiz align',
                            "description" => "",
                            "holder" => "div",
                            'tdc_dropdown_images' => true,
                            "class" => "tdc-visual-selector tdc-add-class",
                            "group"       => "Layout",
                        ),
                        array(
                            "param_name" => "meta_info_vert",
                            "type" => "dropdown",
                            "value" => array(
                                'Left' => 'content-vert-top',
                                'Center' => 'content-vert-center',
                                'Right' => 'content-vert-bottom'
                            ),
                            "heading" => 'Meta info vert align',
                            "description" => "",
                            "holder" => "div",
                            'tdc_dropdown_images' => true,
                            "class" => "tdc-visual-selector tdc-add-class",
                            "group"       => "Layout",
                        ),
                        array(
                            "param_name"  => "image_zoom",
                            "type"        => "checkbox",
                            "value"       => '',
                            "heading"     => "Zoom effect on hover",
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "",
                            "group"       => 'Layout'
                        ),
                        array(
                            "param_name"  => "modules_category",
                            "type"        => "dropdown",
                            "value"       => array(
                                'Inline'      => '',
                                'Above title' => 'above',
                            ),
                            "heading"     => 'Category tag position',
                            "description" => "Float image",
                            "holder"      => "div",
                            "class"       => "tdc-dropdown-big",
                            "group"       => "Layout",
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Module Category Grid 1',
                            "value"      => "",
                            "class"      => "",
                            "group"      => "Layout",
                        ),
                        array(
                            "param_name"  => "image_size",
                            "type"        => "dropdown",
                            "value"       => array(
                                'XSmall - 324px' => 'td_324x400',
                                'Small - 696px'  => '',
                                'Large - 1068px' => 'td_1068x0',
                                'Full - 1920px'  => 'td_1920x0'
                            ),
                            "heading"     => 'Image size',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-dropdown-big",
                            "group"       => "Layout",
                        ),
                        array(
                            'param_name'  => 'image_alignment1',
                            'type'        => 'range-responsive',
                            'value'       => '50',
                            'heading'     => 'Image V alignment',
                            'description' => '0 - Top / 50 - Center / 100 - Bottom',
                            'class'       => 'tdc-textfield-small',
                            'range_min'   => '0',
                            'range_max'   => '100',
                            'range_step'  => '1',
                            "group"       => "Layout",
                        ),
                        array(
                            "param_name"  => "image_width1",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Image width (percent)',
                            "description" => "Default value in percent",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-small",
                            "placeholder" => "30",
                            "group"       => "Layout",
                        ),
                        array(
                            "param_name"  => "image_height1",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Image height (percent)',
                            "description" => "Default value in percent",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-small",
                            "placeholder" => "400px",
                            "group"       => "Layout",
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "horizontal_separator",
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                            "group"      => "Layout",
                        ),
                        array(
                            "param_name"  => "meta_width1",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Meta info width',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-small",
                            "placeholder" => "100%",
                            "group"       => "Layout",
                        ),
                        array(
                            "param_name"  => "meta_margin1",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Meta info margin',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-big",
                            "placeholder" => "0px 0px 0px 0px",
                            "group"       => "Layout",
                        ),
                        array(
                            "param_name"  => "meta_padding1",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Meta info padding',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-big",
                            "placeholder" => "20px 19px",
                            "group"       => "Layout",
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "horizontal_separator",
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                            "group"      => "Layout",
                        ),
                        array(
                            "param_name"  => "art_title1",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Article title space',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-big",
                            "placeholder" => "0px 0px 9px 0px",
                            "group"       => "Layout",
                        ),
                        array(
                            "param_name"  => "art_title_padd1",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Article title padding',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-big",
                            "placeholder" => "0px 0px 0px 0px",
                            "group"       => "Layout",
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "horizontal_separator",
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                            "group"      => "Layout",
                        ),
                        array(
                            "param_name"  => "modules_category_margin1",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Category tag spacing',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-big",
                            "placeholder" => "0px 0px 10px 0px",
                            "group"       => "Layout",
                        ),
                        array(
                            "param_name"  => "modules_category_padding1",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Category tag padding',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-big",
                            "placeholder" => "3px 6px 3px 6px",
                            "group"       => "Layout",
                        ),
                        array(
                            "param_name"  => "show_cat1",
                            "type"        => "dropdown-responsive",
                            "value"       => array(
                                'Show' => 'inline-block',
                                'Hide' => 'none',
                            ),
                            "heading"     => 'Show category',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-dropdown-big",
                            "group"       => "Layout",
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "horizontal_separator",
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                            "group"      => "Layout",
                        ),
                        array(
                            "param_name"  => "show_author1",
                            "type"        => "dropdown-responsive",
                            "value"       => array(
                                'Show' => 'inline-block',
                                'Hide' => 'none',
                            ),
                            "heading"     => 'Show author',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-dropdown-big",
                            "group"       => "Layout",
                        ),
                        array(
                            "param_name"  => "show_date1",
                            "type"        => "dropdown-responsive",
                            "value"       => array(
                                'Show' => 'inline-block',
                                'Hide' => 'none',
                            ),
                            "heading"     => 'Show date',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-dropdown-big",
                            "group"       => "Layout",
                        ),
                        array(
                            "param_name"  => "auth_date_padding1",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Author & date padding',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-big",
                            "placeholder" => "0px 0px 0px 0px",
                            "group"       => "Layout",
                        ),

                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Module Category Grid 2',
                            "value"      => "",
                            "class"      => "",
                            "group"      => "Layout",
                        ),
                        array(
                            "param_name"  => "image_size2",
                            "type"        => "dropdown",
                            "value"       => array(
                                'XSmall - 324px' => 'td_324x400',
                                'Small - 696px'  => '',
                                'Large - 1068px' => 'td_1068x0',
                                'Full - 1920px'  => 'td_1920x0'
                            ),
                            "heading"     => 'Image size',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-dropdown-big",
                            "group"       => "Layout",
                        ),
                        array(
                            'param_name'  => 'image_alignment2',
                            'type'        => 'range-responsive',
                            'value'       => '50',
                            'heading'     => 'Image V alignment',
                            'description' => '0 - Top / 50 - Center / 100 - Bottom',
                            'class'       => 'tdc-textfield-small',
                            'range_min'   => '0',
                            'range_max'   => '100',
                            'range_step'  => '1',
                            "group"       => "Layout",
                        ),
                        array(
                            "param_name"  => "image_width2",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Image width (percent)',
                            "description" => "Default value in percent",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-small",
                            "placeholder" => "40",
                            "group"       => "Layout",
                        ),
                        array(
                            "param_name"  => "image_height2",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Image height (percent)',
                            "description" => "Default value in percent",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-small",
                            "placeholder" => "199px",
                            "group"       => "Layout",
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "horizontal_separator",
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                            "group"      => "Layout",
                        ),
                        array(
                            "param_name"  => "meta_width2",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Meta info width',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-small",
                            "placeholder" => "100%",
                            "group"       => "Layout",
                        ),
                        array(
                            "param_name"  => "meta_margin2",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Meta info margin',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-big",
                            "placeholder" => "0px 0px 0px 0px",
                            "group"       => "Layout",
                        ),
                        array(
                            "param_name"  => "meta_padding2",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Meta info padding',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-big",
                            "placeholder" => "14px 19px",
                            "group"       => "Layout",
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "horizontal_separator",
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                            "group"      => "Layout",
                        ),
                        array(
                            "param_name"  => "art_title2",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Article title space',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-big",
                            "placeholder" => "0px 0px 0px 0px",
                            "group"       => "Layout",
                        ),
                        array(
                            "param_name"  => "art_title_padd2",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Article title padding',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-big",
                            "placeholder" => "0px 0px 0px 0px",
                            "group"       => "Layout",
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "horizontal_separator",
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                            "group"      => "Layout",
                        ),
                        array(
                            "param_name"  => "modules_category_margin2",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Category tag spacing',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-big",
                            "placeholder" => "0px 0px 10px 0px",
                            "group"       => "Layout",
                        ),
                        array(
                            "param_name"  => "modules_category_padding2",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Category tag padding',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-big",
                            "placeholder" => "3px 6px 3px 6px",
                            "group"       => "Layout",
                        ),
                        array(
                            "param_name"  => "show_cat2",
                            "type"        => "dropdown-responsive",
                            "value"       => array(
                                'Show' => 'inline-block',
                                'Hide' => 'none',
                            ),
                            "heading"     => 'Show category',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-dropdown-big",
                            "group"       => "Layout",
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "horizontal_separator",
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                            "group"      => "Layout",
                        ),
                        array(
                            "param_name"  => "show_author2",
                            "type"        => "dropdown-responsive",
                            "value"       => array(
                                'Show' => 'inline-block',
                                'Hide' => 'none',
                            ),
                            "heading"     => 'Show author',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-dropdown-big",
                            "group"       => "Layout",
                        ),
                        array(
                            "param_name"  => "show_date2",
                            "type"        => "dropdown-responsive",
                            "value"       => array(
                                'Show' => 'inline-block',
                                'Hide' => 'none',
                            ),
                            "heading"     => 'Show date',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-dropdown-big",
                            "group"       => "Layout",
                        ),
                        array(
                            "param_name"  => "auth_date_padding2",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Author & date padding',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-big",
                            "placeholder" => "0px 0px 0px 0px",
                            "group"       => "Layout",
                        ),
                        array(
                            "param_name" => "separator",
                            "type" => "text_separator",
                            'heading' => 'Module fonts',
                            "value" => "",
                            "class" => "",
                            "group" => 'Style',
                        ),
                    ),
                    td_config_helper::get_map_block_font_array( 'f_title1', true, 'Module 1 title', 'Style' ),
                    td_config_helper::get_map_block_font_array( 'f_cat1', false, 'Module 1 category tag', 'Style' ),
                    td_config_helper::get_map_block_font_array( 'f_meta1', false, 'Module 1 meta info', 'Style' ),
                    td_config_helper::get_map_block_font_array( 'f_title2', false, 'Module 2 title', 'Style' ),
                    td_config_helper::get_map_block_font_array( 'f_cat2', false, 'Module 2 category tag', 'Style' ),
                    td_config_helper::get_map_block_font_array( 'f_meta2', false, 'Module 2 meta info', 'Style' ),
                    array(
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Colors',
                            "value"      => "",
                            "class"      => "",
                            "group"      => "Style",
                        ),
                        array(
                            "param_name" => "overlay_general",
                            "holder" => "div",
                            "type" => "gradient",
                            'heading' => "General module overlay color",
                            "value" => "",
                            "class" => "",
                            "group"      => "Style",
                        ),
                        array(
                            "param_name" => "overlay_h_general",
                            "holder" => "div",
                            "type" => "gradient",
                            'heading' => "General module overlay hover color",
                            "value" => "",
                            "class" => "",
                            "group"      => "Style",
                        ),
                        array(
                            "param_name" => "overlay_1",
                            "holder" => "div",
                            "type" => "gradient",
                            'heading' => "Module overlay color 1",
                            "value" => "",
                            "class" => "",
                            "group"      => "Style",
                        ),
                        array(
                            "param_name" => "overlay_2",
                            "holder" => "div",
                            "type" => "gradient",
                            'heading' => "Module overlay color 2",
                            "value" => "",
                            "class" => "",
                            "group"      => "Style",
                        ),
                        array(
                            "param_name" => "overlay_3",
                            "holder" => "div",
                            "type" => "gradient",
                            'heading' => "Module overlay color 3",
                            "value" => "",
                            "class" => "",
                            "group"      => "Style",
                        ),
                        array(
                            "param_name" => "overlay_4",
                            "holder" => "div",
                            "type" => "gradient",
                            'heading' => "Module overlay color 4",
                            "value" => "",
                            "class" => "",
                            "group"      => "Style",
                        ),
                        array(
                            "param_name"  => "lightsky",
                            "type"        => "checkbox",
                            "value"       => '',
                            "heading"     => "Lightsky",
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "",
                            "group"       => 'Style'
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "",
                            "heading"     => 'Meta info background',
                            "param_name"  => "meta_bg",
                            "value"       => '',
                            "description" => '',
                            "group"       => 'Style',
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "horizontal_separator",
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                            "group"      => "Style",
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "",
                            "heading"     => 'Article title text color',
                            "param_name"  => "title_txt",
                            "value"       => '',
                            "description" => '',
                            "group"       => 'Style',
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "",
                            "heading"     => 'Article title text hover',
                            "param_name"  => "title_txt_hover",
                            "value"       => '',
                            "description" => '',
                            "group"       => 'Style',
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "",
                            "heading"     => 'Article title background color',
                            "param_name"  => "title_bg",
                            "value"       => '',
                            "description" => '',
                            "group"       => 'Style',
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "horizontal_separator",
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                            "group"      => "Style",
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "",
                            "heading"     => 'Category background',
                            "param_name"  => "cat_bg",
                            "value"       => '',
                            "description" => '',
                            "group"       => 'Style',
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "",
                            "heading"     => 'Category text color',
                            "param_name"  => "cat_txt",
                            "value"       => '',
                            "description" => '',
                            "group"       => 'Style',
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "",
                            "heading"     => 'Category background hover',
                            "param_name"  => "cat_bg_hover",
                            "value"       => '',
                            "description" => '',
                            "group"       => 'Style',
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "",
                            "heading"     => 'Category text hover',
                            "param_name"  => "cat_txt_hover",
                            "value"       => '',
                            "description" => '',
                            "group"       => 'Style',
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "horizontal_separator",
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                            "group"      => "Style",
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "",
                            "heading"     => 'Author text color',
                            "param_name"  => "author_txt",
                            "value"       => '',
                            "description" => '',
                            "group"       => 'Style',
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "",
                            "heading"     => 'Author text hover',
                            "param_name"  => "author_txt_hover",
                            "value"       => '',
                            "description" => '',
                            "group"       => 'Style',
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "",
                            "heading"     => 'Date text color',
                            "param_name"  => "date_txt",
                            "value"       => '',
                            "description" => '',
                            "group"       => 'Style',
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "",
                            "heading"     => 'Author & date background color',
                            "param_name"  => "auth_date_bg",
                            "value"       => '',
                            "description" => '',
                            "group"       => 'Style',
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "",
                            "heading"     => 'Review stars color',
                            "param_name"  => "review_stars",
                            "value"       => '',
                            "description" => '',
                            "group"       => 'Style',
                        ),
                    ),
                    self::get_map_css_tab()
                )
            )
        );

        td_api_block::add('td_block_big_grid_flex_9',
            array(
                'map_in_visual_composer' => false,
                'map_in_td_composer' => true,
                "name" => 'Big Grid Flex 9',
                "base" => 'td_block_big_grid_flex_9',
                "class" => 'td_block_big_grid_flex_9',
                "controls" => "full",
                "category" => 'Blocks',
                'tdc_category' => 'Big Grids',
                'icon' => 'icon-pagebuilder-td_block_big_grid_flex_9',
                'file' => td_global::$get_template_directory . '/includes/shortcodes/td_block_big_grid_flex_9.php',
                'tdc_style_params' => array(
                    'custom_title',
                    'custom_url',
                    'post_ids',
                    'category_id',
                    'category_ids',
                    'tag_slug',
                    'autors_id',
                    'installed_post_types',
                    'sort',
                    'offset',
                    'el_class'
                ),
                'tdc_start_values' => base64_encode(
                    json_encode(
                        array(
                            array(
                                "meta_info_vert" => "content-vert-bottom",
                                "image_zoom" => "yes",
                                "show_author2" => "none",
                                "show_date2" => "none",
                                "modules_category" => "above",
                                "overlay_general" => "eyJ0eXBlIjoiZ3JhZGllbnQiLCJjb2xvcjEiOiJyZ2JhKDAsMCwwLDApIiwiY29sb3IyIjoicmdiYSgwLDAsMCwwLjcpIiwibWl4ZWRDb2xvcnMiOlt7ImNvbG9yIjoicmdiYSgwLDAsMCwwKSIsInBlcmNlbnRhZ2UiOjYwfV0sImNzcyI6ImJhY2tncm91bmQ6IC13ZWJraXQtbGluZWFyLWdyYWRpZW50KDBkZWcscmdiYSgwLDAsMCwwLjcpLHJnYmEoMCwwLDAsMCkgNjAlLHJnYmEoMCwwLDAsMCkpO2JhY2tncm91bmQ6IGxpbmVhci1ncmFkaWVudCgwZGVnLHJnYmEoMCwwLDAsMC43KSxyZ2JhKDAsMCwwLDApIDYwJSxyZ2JhKDAsMCwwLDApKTsiLCJjc3NQYXJhbXMiOiIwZGVnLHJnYmEoMCwwLDAsMC43KSxyZ2JhKDAsMCwwLDApIDYwJSxyZ2JhKDAsMCwwLDApIn0=",
                                "image_width1" => "eyJwaG9uZSI6IjEwMCJ9",
                                "image_width2" => "eyJwaG9uZSI6IjgwIn0=",
                                "image_height2" => "eyJwaG9uZSI6IjE2NXB4IiwibGFuZHNjYXBlIjoiMTM1cHgiLCJwb3J0cmFpdCI6IjExMHB4In0=",
                                "image_height1" => "eyJwaG9uZSI6IjIwMHB4IiwibGFuZHNjYXBlIjoiMzQwcHgiLCJwb3J0cmFpdCI6IjI2MHB4In0=",
                                "meta_padding2" => "eyJwaG9uZSI6IjE2cHggMTVweCAxMXB4In0=",
                                "meta_padding1" => "eyJwaG9uZSI6IjE1cHggMThweCIsInBvcnRyYWl0IjoiMTVweCAxNHB4IDE2cHggIn0=",
                                "cat_bg_hover" => "#4db2ec",
                                "review_stars" => "#fff",
                                "modules_category_margin1" => "eyJwaG9uZSI6IjBweCAwcHggN3B4IDBweCIsInBvcnRyYWl0IjoiMHB4IDBweCAzcHggMHB4In0=",
                                "art_title1" => "eyJwaG9uZSI6IjBweCAwcHggMHB4IDBweCIsInBvcnRyYWl0IjoiMHB4IDBweCA1cHggMHB4In0=",
                                "show_author1" => "",
                                "show_date1" => "",
                                "image_size" => "",
                                "image_size2" => "td_324x400",
                                "modules_category_padding2" => "eyJwaG9uZSI6IjNweCA2cHggM3B4IDZweCJ9",
                            ),

                            array(
                                'tdc_preset_name' => 'Font family',
                                'tdc_preset_class' => 'tdcp_separator tdcp_separator_font',
                            ),
                            array(
                                'tdc_preset_name' => '', // Font - Montserrat
                                'tdc_preset_class' => 'tdcp_img tdcp_font tdcp_font1',
                                'tdc_preset_individual' => '1',
                                "f_title1_font_family" =>        "394",
                                "f_title2_font_family" =>        "394",
                            ),
                            array(
                                'tdc_preset_name' => '', // Font - Source Serif
                                'tdc_preset_class' => 'tdcp_img tdcp_font tdcp_font2',
                                'tdc_preset_individual' =>      '1',
                                "f_title1_font_family" =>        "721",
                                "f_title2_font_family" =>        "721",
                            ),
                            array(
                                'tdc_preset_name' => '', // Font - Raleway
                                'tdc_preset_class' => 'tdcp_img tdcp_font tdcp_font3',
                                'tdc_preset_individual' => '1',
                                "f_title1_font_family" =>        "507",
                                "f_title2_font_family" =>        "507",
                            ),
                            array(
                                'tdc_preset_name' => '', // Font - Work Sans
                                'tdc_preset_class' => 'tdcp_img tdcp_font tdcp_font4',
                                'tdc_preset_individual' => '1',
                                "f_title1_font_family" =>        "653",
                                "f_title2_font_family" =>        "653",
                            ),
                            array(
                                'tdc_preset_name' => '', // Font - Courgette
                                'tdc_preset_class' => 'tdcp_img tdcp_font tdcp_font5',
                                'tdc_preset_individual' => '1',
                                "f_title1_font_family" =>        "147",
                                "f_title2_font_family" =>        "147",
                            ),
                            array(
                                'tdc_preset_name' => '', // Font - Oswald
                                'tdc_preset_class' => 'tdcp_img tdcp_font tdcp_font7',
                                'tdc_preset_individual' => '1',
                                "f_title1_font_family" =>        "445",
                                "f_title2_font_family" =>        "445",
                            ),
                            array(
                                'tdc_preset_name' => '', // Font - Muli
                                'tdc_preset_class' => 'tdcp_img tdcp_font tdcp_font8',
                                'tdc_preset_individual' => '1',
                                "f_title1_font_family" =>        "406",
                                "f_title2_font_family" =>        "406",
                            ),
                            array(
                                'tdc_preset_name' => '', // Font - Wendy One
                                'tdc_preset_class' => 'tdcp_img tdcp_font tdcp_font9',
                                'tdc_preset_individual' => '1',
                                "f_title1_font_family" =>        "646",
                                "f_title2_font_family" =>        "646",
                            ),
                            array(
                                'tdc_preset_name' => '', // Font - Anton
                                'tdc_preset_class' => 'tdcp_img tdcp_font tdcp_font10',
                                'tdc_preset_individual' => '1',
                                "f_title1_font_family" =>        "41",
                                "f_title2_font_family" =>        "41",
                            ),
                            array(
                                'tdc_preset_name' => '', // Font - Quicksand
                                'tdc_preset_class' => 'tdcp_img tdcp_font tdcp_font11',
                                'tdc_preset_individual' => '1',
                                "f_title1_font_family" =>        "502",
                                "f_title2_font_family" =>        "502",
                            ),
                            array(
                                'tdc_preset_name' => '', // Font - Libre Baskerville
                                'tdc_preset_class' => 'tdcp_img tdcp_font tdcp_font12',
                                'tdc_preset_individual' => '1',
                                "f_title1_font_family" =>        "331",
                                "f_title2_font_family" =>        "331",
                            ),
                            array(
                                'tdc_preset_name' => '', // Font - Caveat
                                'tdc_preset_class' => 'tdcp_img tdcp_font tdcp_font13',
                                'tdc_preset_individual' => '1',
                                "f_title1_font_family" =>        "663",
                                "f_title2_font_family" =>        "663",
                            ),
                            array(
                                'tdc_preset_name' => '', // Font - Volkorn
                                'tdc_preset_class' => 'tdcp_img tdcp_font tdcp_font14',
                                'tdc_preset_individual' => '1',
                                "f_title1_font_family" =>        "639",
                                "f_title2_font_family" =>        "639",
                            ),
                            array(
                                'tdc_preset_name' => '', // Font - Default
                                'tdc_preset_class' => 'tdcp_img tdcp_font tdcp_font6',
                                'tdc_preset_individual' => '1',
                                "f_title1_font_family" =>        "",
                                "f_title2_font_family" =>        "",
                            ),

                            array(
                                'tdc_preset_name' => 'Font size',
                                'tdc_preset_class' => 'tdcp_separator tdcp_separator_size',
                            ),
                            array(
                                'tdc_preset_name' => '', // Size - XS 13/13/12/14
                                'tdc_preset_class' => 'tdcp_img tdcp_size tdcp_size1',
                                'tdc_preset_individual' => '1',
                                "f_title1_font_size" => "eyJhbGwiOiIxNiIsInBvcnRyYWl0IjoiMTQifQ==",
                                "f_title1_font_line_height" => "1.3",
                                "f_title2_font_size" => "eyJhbGwiOiIxNCIsInBvcnRyYWl0IjoiMTIiLCJwaG9uZSI6IjEzIn0=",
                                "f_title2_font_line_height" => "1.3",
                            ),
                            array(
                                'tdc_preset_name' => '', // Size - S 14/13/12/14
                                'tdc_preset_class' => 'tdcp_img tdcp_size tdcp_size2',
                                'tdc_preset_individual' => '1',
                                "f_title1_font_size" => "eyJhbGwiOiIxOCIsInBvcnRyYWl0IjoiMTYifQ==",
                                "f_title1_font_line_height" => "1.4",
                                "f_title2_font_size" => "eyJhbGwiOiIxNCIsInBvcnRyYWl0IjoiMTIiLCJwaG9uZSI6IjEzIn0=",
                                "f_title2_font_line_height" => "1.3",
                            ),
                            array(
                                'tdc_preset_name' => '', // Size - M 21/21/17/21
                                'tdc_preset_class' => 'tdcp_img tdcp_size tdcp_size3',
                                'tdc_preset_individual' => '1',
                                "f_title1_font_size" => "eyJhbGwiOiIyNCIsInBvcnRyYWl0IjoiMjIifQ==",
                                "f_title1_font_line_height" => "1.2",
                                "f_title2_font_size" => "",
                                "f_title2_font_line_height" => "",
                            ),
                            array(
                                'tdc_preset_name' => '', // Size - L 26/25/21/21
                                'tdc_preset_class' => 'tdcp_img tdcp_size tdcp_size4',
                                'tdc_preset_individual' => '1',
                                "f_title1_font_size" => "",
                                "f_title1_font_line_height" => "",
                                "f_title2_font_size" => "",
                                "f_title2_font_line_height" => "",

                            ),
                            array(
                                'tdc_preset_name' => '', // Size - XL 30/28/24/21
                                'tdc_preset_class' => 'tdcp_img tdcp_size tdcp_size5',
                                'tdc_preset_individual' => '1',
                                "f_title1_font_size" => "eyJhbGwiOiIzMCIsImxhbmRzY2FwZSI6IjI4IiwicG9ydHJhaXQiOiIyNCIsInBob25lIjoiMjEifQ==",
                                "f_title1_font_line_height" => "1.2",
                                "f_title2_font_size" => "eyJhbGwiOiIxNiIsInBvcnRyYWl0IjoiMTMifQ==",
                                "f_title2_font_line_height" => "1.2",
                            ),
                            array(
                                'tdc_preset_name' => '', // Size - XXL 36/32/26/21
                                'tdc_preset_class' => 'tdcp_img tdcp_size tdcp_size6',
                                'tdc_preset_individual' => '1',
                                "f_title1_font_size" => "eyJhbGwiOiIzNiIsImxhbmRzY2FwZSI6IjMyIiwicGhvbmUiOiIyMSIsInBvcnRyYWl0IjoiMjYifQ==",
                                "f_title1_font_line_height" => "eyJhbGwiOiIxLjEiLCJwaG9uZSI6IjEuMiJ9",
                                "f_title2_font_size" => "eyJhbGwiOiIxNyIsInBvcnRyYWl0IjoiMTQiLCJwaG9uZSI6IjE2In0=",
                                "f_title2_font_line_height" => "1.2",
                            ),

                            array(
                                'tdc_preset_name' => 'Text horizontal alignment',
                                'tdc_preset_class' => 'tdcp_separator tdcp_separator_align',
                            ),
                            array(
                                'tdc_preset_name' => '', // Text alignment - left
                                'tdc_preset_class' => 'tdcp_img tdcp_align tdcp_align1',
                                'tdc_preset_individual' => '1',
                                "meta_info_horiz" => "content-horiz-left",
                            ),
                            array(
                                'tdc_preset_name' => '', // Text alignment - center
                                'tdc_preset_class' => 'tdcp_img tdcp_align tdcp_align2',
                                'tdc_preset_individual' => '1',
                                "meta_info_horiz" => "content-horiz-center",
                            ),
                            array(
                                'tdc_preset_name' => '', // Text alignment - right
                                'tdc_preset_class' => 'tdcp_img tdcp_align tdcp_align3',
                                'tdc_preset_individual' => '1',
                                "meta_info_horiz" => "content-horiz-right",
                            ),

                            array(
                                'tdc_preset_name' => 'Text vertical alignment',
                                'tdc_preset_class' => 'tdcp_separator tdcp_separator_align_v',
                            ),
                            array(
                                'tdc_preset_name' => '', // Text vertical alignment - top
                                'tdc_preset_class' => 'tdcp_img tdcp_align tdcp_align_v1',
                                'tdc_preset_individual' => '1',
                                "meta_info_vert" => "content-vert-top",
                            ),
                            array(
                                'tdc_preset_name' => '', // Text vertical alignment - middle
                                'tdc_preset_class' => 'tdcp_img tdcp_align tdcp_align_v2',
                                'tdc_preset_individual' => '1',
                                "meta_info_vert" => "content-vert-center",
                            ),
                            array(
                                'tdc_preset_name' => '', // Text vertical alignment - bottom
                                'tdc_preset_class' => 'tdcp_img tdcp_align tdcp_align_v3',
                                'tdc_preset_individual' => '1',
                                "meta_info_vert" => "content-vert-bottom",
                            ),

                            array(
                                'tdc_preset_name' => 'Style',
                                'tdc_preset_class' => 'tdcp_separator tdcp_separator_style',
                            ),
                            array(
                                'tdc_preset_name' => '', // Style 1 - default
                                'tdc_preset_class' => 'tdcp_img tdcp_style tdcp_style1',
                                'tdc_preset_individual' => '1',
                                "overlay_general" => "eyJ0eXBlIjoiZ3JhZGllbnQiLCJjb2xvcjEiOiJyZ2JhKDAsMCwwLDApIiwiY29sb3IyIjoicmdiYSgwLDAsMCwwLjcpIiwibWl4ZWRDb2xvcnMiOlt7ImNvbG9yIjoicmdiYSgwLDAsMCwwKSIsInBlcmNlbnRhZ2UiOjYwfV0sImNzcyI6ImJhY2tncm91bmQ6IC13ZWJraXQtbGluZWFyLWdyYWRpZW50KDBkZWcscmdiYSgwLDAsMCwwLjcpLHJnYmEoMCwwLDAsMCkgNjAlLHJnYmEoMCwwLDAsMCkpO2JhY2tncm91bmQ6IGxpbmVhci1ncmFkaWVudCgwZGVnLHJnYmEoMCwwLDAsMC43KSxyZ2JhKDAsMCwwLDApIDYwJSxyZ2JhKDAsMCwwLDApKTsiLCJjc3NQYXJhbXMiOiIwZGVnLHJnYmEoMCwwLDAsMC43KSxyZ2JhKDAsMCwwLDApIDYwJSxyZ2JhKDAsMCwwLDApIn0=",
                                "overlay_h_general" => "",
                                "overlay_1" => "",
                                "overlay_2" => "",
                                "overlay_3" => "",
                                "overlay_4" => "",
                                "overlay_5" => "",
                                "lightsky" => "",
                            ),
                            array(
                                'tdc_preset_name' => '', // Style 2 - colors
                                'tdc_preset_class' => 'tdcp_img tdcp_style tdcp_style2',
                                'tdc_preset_individual' => '1',
                                "overlay_h_general" => "",
                                "overlay_1" => "eyJ0eXBlIjoiZ3JhZGllbnQiLCJjb2xvcjEiOiJyZ2JhKDc0LDE0Myw5NCwwLjYpIiwiY29sb3IyIjoicmdiYSg3NywxNzgsMjM2LDAuNikiLCJtaXhlZENvbG9ycyI6W10sImRlZ3JlZSI6IjQ1IiwiY3NzIjoiYmFja2dyb3VuZDogLXdlYmtpdC1saW5lYXItZ3JhZGllbnQoNDVkZWcscmdiYSg3NywxNzgsMjM2LDAuNikscmdiYSg3NCwxNDMsOTQsMC42KSk7YmFja2dyb3VuZDogbGluZWFyLWdyYWRpZW50KDQ1ZGVnLHJnYmEoNzcsMTc4LDIzNiwwLjYpLHJnYmEoNzQsMTQzLDk0LDAuNikpOyIsImNzc1BhcmFtcyI6IjQ1ZGVnLHJnYmEoNzcsMTc4LDIzNiwwLjYpLHJnYmEoNzQsMTQzLDk0LDAuNikifQ==",
                                "overlay_2" => "eyJ0eXBlIjoiZ3JhZGllbnQiLCJjb2xvcjEiOiJyZ2JhKDE5OCw1Nyw1NywwLjYpIiwiY29sb3IyIjoicmdiYSgyMDksMTE4LDcwLDAuNikiLCJtaXhlZENvbG9ycyI6W10sImRlZ3JlZSI6IjQ1IiwiY3NzIjoiYmFja2dyb3VuZDogLXdlYmtpdC1saW5lYXItZ3JhZGllbnQoNDVkZWcscmdiYSgyMDksMTE4LDcwLDAuNikscmdiYSgxOTgsNTcsNTcsMC42KSk7YmFja2dyb3VuZDogbGluZWFyLWdyYWRpZW50KDQ1ZGVnLHJnYmEoMjA5LDExOCw3MCwwLjYpLHJnYmEoMTk4LDU3LDU3LDAuNikpOyIsImNzc1BhcmFtcyI6IjQ1ZGVnLHJnYmEoMjA5LDExOCw3MCwwLjYpLHJnYmEoMTk4LDU3LDU3LDAuNikifQ==",
                                "overlay_3" => "eyJ0eXBlIjoiZ3JhZGllbnQiLCJjb2xvcjEiOiJyZ2JhKDU5LDEyMCwxODAsMC41OSkiLCJjb2xvcjIiOiJyZ2JhKDIxNSw5NiwxODMsMC42KSIsIm1peGVkQ29sb3JzIjpbXSwiZGVncmVlIjoiLTQ1IiwiY3NzIjoiYmFja2dyb3VuZDogLXdlYmtpdC1saW5lYXItZ3JhZGllbnQoLTQ1ZGVnLHJnYmEoMjE1LDk2LDE4MywwLjYpLHJnYmEoNTksMTIwLDE4MCwwLjU5KSk7YmFja2dyb3VuZDogbGluZWFyLWdyYWRpZW50KC00NWRlZyxyZ2JhKDIxNSw5NiwxODMsMC42KSxyZ2JhKDU5LDEyMCwxODAsMC41OSkpOyIsImNzc1BhcmFtcyI6Ii00NWRlZyxyZ2JhKDIxNSw5NiwxODMsMC42KSxyZ2JhKDU5LDEyMCwxODAsMC41OSkifQ==",
                                "overlay_4" => "eyJ0eXBlIjoiZ3JhZGllbnQiLCJjb2xvcjEiOiJyZ2JhKDI0MiwxMjIsNTMsMC42KSIsImNvbG9yMiI6InJnYmEoMjQ0LDIwOCw2MywwLjYpIiwibWl4ZWRDb2xvcnMiOltdLCJkZWdyZWUiOiItNDUiLCJjc3MiOiJiYWNrZ3JvdW5kOiAtd2Via2l0LWxpbmVhci1ncmFkaWVudCgtNDVkZWcscmdiYSgyNDQsMjA4LDYzLDAuNikscmdiYSgyNDIsMTIyLDUzLDAuNikpO2JhY2tncm91bmQ6IGxpbmVhci1ncmFkaWVudCgtNDVkZWcscmdiYSgyNDQsMjA4LDYzLDAuNikscmdiYSgyNDIsMTIyLDUzLDAuNikpOyIsImNzc1BhcmFtcyI6Ii00NWRlZyxyZ2JhKDI0NCwyMDgsNjMsMC42KSxyZ2JhKDI0MiwxMjIsNTMsMC42KSJ9",
                                "overlay_5" => "eyJ0eXBlIjoiZ3JhZGllbnQiLCJjb2xvcjEiOiJyZ2JhKDc0LDE0Myw5NCwwLjYpIiwiY29sb3IyIjoicmdiYSg3NywxNzgsMjM2LDAuNikiLCJtaXhlZENvbG9ycyI6W10sImRlZ3JlZSI6IjQ1IiwiY3NzIjoiYmFja2dyb3VuZDogLXdlYmtpdC1saW5lYXItZ3JhZGllbnQoNDVkZWcscmdiYSg3NywxNzgsMjM2LDAuNikscmdiYSg3NCwxNDMsOTQsMC42KSk7YmFja2dyb3VuZDogbGluZWFyLWdyYWRpZW50KDQ1ZGVnLHJnYmEoNzcsMTc4LDIzNiwwLjYpLHJnYmEoNzQsMTQzLDk0LDAuNikpOyIsImNzc1BhcmFtcyI6IjQ1ZGVnLHJnYmEoNzcsMTc4LDIzNiwwLjYpLHJnYmEoNzQsMTQzLDk0LDAuNikifQ==",
                                "lightsky" => "",
                            ),
                            array(
                                'tdc_preset_name' => '', // Style 3 - flat colors
                                'tdc_preset_class' => 'tdcp_img tdcp_style tdcp_style3',
                                'tdc_preset_individual' => '1',
                                "overlay_h_general" => "",
                                "overlay_1" => "eyJ0eXBlIjoiZ3JhZGllbnQiLCJjb2xvcjEiOiJyZ2JhKDc0LDE0Myw5NCwwLjgpIiwiY29sb3IyIjoicmdiYSg3NywxNzgsMjM2LDAuOCkiLCJtaXhlZENvbG9ycyI6W10sImRlZ3JlZSI6IjQ1IiwiY3NzIjoiYmFja2dyb3VuZDogLXdlYmtpdC1saW5lYXItZ3JhZGllbnQoNDVkZWcscmdiYSg3NywxNzgsMjM2LDAuOCkscmdiYSg3NCwxNDMsOTQsMC44KSk7YmFja2dyb3VuZDogbGluZWFyLWdyYWRpZW50KDQ1ZGVnLHJnYmEoNzcsMTc4LDIzNiwwLjgpLHJnYmEoNzQsMTQzLDk0LDAuOCkpOyIsImNzc1BhcmFtcyI6IjQ1ZGVnLHJnYmEoNzcsMTc4LDIzNiwwLjgpLHJnYmEoNzQsMTQzLDk0LDAuOCkifQ==",
                                "overlay_2" => "eyJ0eXBlIjoiZ3JhZGllbnQiLCJjb2xvcjEiOiJyZ2JhKDE5OCw1Nyw1NywwLjgpIiwiY29sb3IyIjoicmdiYSgyMDksMTE4LDcwLDAuOCkiLCJtaXhlZENvbG9ycyI6W10sImRlZ3JlZSI6IjQ1IiwiY3NzIjoiYmFja2dyb3VuZDogLXdlYmtpdC1saW5lYXItZ3JhZGllbnQoNDVkZWcscmdiYSgyMDksMTE4LDcwLDAuOCkscmdiYSgxOTgsNTcsNTcsMC44KSk7YmFja2dyb3VuZDogbGluZWFyLWdyYWRpZW50KDQ1ZGVnLHJnYmEoMjA5LDExOCw3MCwwLjgpLHJnYmEoMTk4LDU3LDU3LDAuOCkpOyIsImNzc1BhcmFtcyI6IjQ1ZGVnLHJnYmEoMjA5LDExOCw3MCwwLjgpLHJnYmEoMTk4LDU3LDU3LDAuOCkifQ==",
                                "overlay_3" => "eyJ0eXBlIjoiZ3JhZGllbnQiLCJjb2xvcjEiOiJyZ2JhKDU5LDEyMCwxODAsMC44KSIsImNvbG9yMiI6InJnYmEoMjE1LDk2LDE4MywwLjgpIiwibWl4ZWRDb2xvcnMiOltdLCJkZWdyZWUiOiItNDUiLCJjc3MiOiJiYWNrZ3JvdW5kOiAtd2Via2l0LWxpbmVhci1ncmFkaWVudCgtNDVkZWcscmdiYSgyMTUsOTYsMTgzLDAuOCkscmdiYSg1OSwxMjAsMTgwLDAuOCkpO2JhY2tncm91bmQ6IGxpbmVhci1ncmFkaWVudCgtNDVkZWcscmdiYSgyMTUsOTYsMTgzLDAuOCkscmdiYSg1OSwxMjAsMTgwLDAuOCkpOyIsImNzc1BhcmFtcyI6Ii00NWRlZyxyZ2JhKDIxNSw5NiwxODMsMC44KSxyZ2JhKDU5LDEyMCwxODAsMC44KSJ9",
                                "overlay_4" => "eyJ0eXBlIjoiZ3JhZGllbnQiLCJjb2xvcjEiOiJyZ2JhKDI0MiwxMjIsNTMsMC44KSIsImNvbG9yMiI6InJnYmEoMjQ0LDIwOCw2MywwLjgpIiwibWl4ZWRDb2xvcnMiOltdLCJkZWdyZWUiOiItNDUiLCJjc3MiOiJiYWNrZ3JvdW5kOiAtd2Via2l0LWxpbmVhci1ncmFkaWVudCgtNDVkZWcscmdiYSgyNDQsMjA4LDYzLDAuOCkscmdiYSgyNDIsMTIyLDUzLDAuOCkpO2JhY2tncm91bmQ6IGxpbmVhci1ncmFkaWVudCgtNDVkZWcscmdiYSgyNDQsMjA4LDYzLDAuOCkscmdiYSgyNDIsMTIyLDUzLDAuOCkpOyIsImNzc1BhcmFtcyI6Ii00NWRlZyxyZ2JhKDI0NCwyMDgsNjMsMC44KSxyZ2JhKDI0MiwxMjIsNTMsMC44KSJ9",
                                "overlay_5" => "eyJ0eXBlIjoiZ3JhZGllbnQiLCJjb2xvcjEiOiJyZ2JhKDc0LDE0Myw5NCwwLjgpIiwiY29sb3IyIjoicmdiYSg3NywxNzgsMjM2LDAuOCkiLCJtaXhlZENvbG9ycyI6W10sImRlZ3JlZSI6IjQ1IiwiY3NzIjoiYmFja2dyb3VuZDogLXdlYmtpdC1saW5lYXItZ3JhZGllbnQoNDVkZWcscmdiYSg3NywxNzgsMjM2LDAuOCkscmdiYSg3NCwxNDMsOTQsMC44KSk7YmFja2dyb3VuZDogbGluZWFyLWdyYWRpZW50KDQ1ZGVnLHJnYmEoNzcsMTc4LDIzNiwwLjgpLHJnYmEoNzQsMTQzLDk0LDAuOCkpOyIsImNzc1BhcmFtcyI6IjQ1ZGVnLHJnYmEoNzcsMTc4LDIzNiwwLjgpLHJnYmEoNzQsMTQzLDk0LDAuOCkifQ==",
                                "lightsky" => "",
                            ),
                            array(
                                'tdc_preset_name' => '', // Style 4 - light sky
                                'tdc_preset_class' => 'tdcp_img tdcp_style tdcp_style4',
                                'tdc_preset_individual' => '1',
                                "overlay_general" => "rgba(0,0,0,0.7)",
                                "overlay_h_general" => "rgba(77,178,236,0.3)",
                                "overlay_1" => "",
                                "overlay_2" => "",
                                "overlay_3" => "",
                                "overlay_4" => "",
                                "overlay_5" => "",
                                "lightsky" => "yes",
                            ),
                            array(
                                'tdc_preset_name' => '', // Style 5 - rainbow
                                'tdc_preset_class' => 'tdcp_img tdcp_style tdcp_style5',
                                'tdc_preset_individual' => '1',
                                "overlay_h_general" => "",
                                "overlay_1" => "eyJ0eXBlIjoiZ3JhZGllbnQiLCJjb2xvcjEiOiJyZ2JhKDI1NSwxMTEsNDksMC42KSIsImNvbG9yMiI6InJnYmEoNjUsMTIsMTg4LDAuNikiLCJtaXhlZENvbG9ycyI6W10sImRlZ3JlZSI6IjIwIiwiY3NzIjoiYmFja2dyb3VuZDogLXdlYmtpdC1saW5lYXItZ3JhZGllbnQoMjBkZWcscmdiYSg2NSwxMiwxODgsMC42KSxyZ2JhKDI1NSwxMTEsNDksMC42KSk7YmFja2dyb3VuZDogbGluZWFyLWdyYWRpZW50KDIwZGVnLHJnYmEoNjUsMTIsMTg4LDAuNikscmdiYSgyNTUsMTExLDQ5LDAuNikpOyIsImNzc1BhcmFtcyI6IjIwZGVnLHJnYmEoNjUsMTIsMTg4LDAuNikscmdiYSgyNTUsMTExLDQ5LDAuNikifQ==",
                                "overlay_2" => "eyJ0eXBlIjoiZ3JhZGllbnQiLCJjb2xvcjEiOiJyZ2JhKDExMiwyNTUsMTUzLDAuNikiLCJjb2xvcjIiOiJyZ2JhKDI0NCwxMzYsMTMsMC42KSIsIm1peGVkQ29sb3JzIjpbXSwiZGVncmVlIjoiMjAiLCJjc3MiOiJiYWNrZ3JvdW5kOiAtd2Via2l0LWxpbmVhci1ncmFkaWVudCgyMGRlZyxyZ2JhKDI0NCwxMzYsMTMsMC42KSxyZ2JhKDExMiwyNTUsMTUzLDAuNikpO2JhY2tncm91bmQ6IGxpbmVhci1ncmFkaWVudCgyMGRlZyxyZ2JhKDI0NCwxMzYsMTMsMC42KSxyZ2JhKDExMiwyNTUsMTUzLDAuNikpOyIsImNzc1BhcmFtcyI6IjIwZGVnLHJnYmEoMjQ0LDEzNiwxMywwLjYpLHJnYmEoMTEyLDI1NSwxNTMsMC42KSJ9",
                                "overlay_3" => "eyJ0eXBlIjoiZ3JhZGllbnQiLCJjb2xvcjEiOiJyZ2JhKDEyNiwxOTEsMjU1LDAuNikiLCJjb2xvcjIiOiJyZ2JhKDE5NiwxNSwxMjEsMC42KSIsIm1peGVkQ29sb3JzIjpbXSwiZGVncmVlIjoiMjAiLCJjc3MiOiJiYWNrZ3JvdW5kOiAtd2Via2l0LWxpbmVhci1ncmFkaWVudCgyMGRlZyxyZ2JhKDE5NiwxNSwxMjEsMC42KSxyZ2JhKDEyNiwxOTEsMjU1LDAuNikpO2JhY2tncm91bmQ6IGxpbmVhci1ncmFkaWVudCgyMGRlZyxyZ2JhKDE5NiwxNSwxMjEsMC42KSxyZ2JhKDEyNiwxOTEsMjU1LDAuNikpOyIsImNzc1BhcmFtcyI6IjIwZGVnLHJnYmEoMTk2LDE1LDEyMSwwLjYpLHJnYmEoMTI2LDE5MSwyNTUsMC42KSJ9",
                                "overlay_4" => "eyJ0eXBlIjoiZ3JhZGllbnQiLCJjb2xvcjEiOiJyZ2JhKDQyLDIzNiwxMTYsMC42KSIsImNvbG9yMiI6InJnYmEoMCwyMiwxOTAsMC42KSIsIm1peGVkQ29sb3JzIjpbXSwiZGVncmVlIjoiMjAiLCJjc3MiOiJiYWNrZ3JvdW5kOiAtd2Via2l0LWxpbmVhci1ncmFkaWVudCgyMGRlZyxyZ2JhKDAsMjIsMTkwLDAuNikscmdiYSg0MiwyMzYsMTE2LDAuNikpO2JhY2tncm91bmQ6IGxpbmVhci1ncmFkaWVudCgyMGRlZyxyZ2JhKDAsMjIsMTkwLDAuNikscmdiYSg0MiwyMzYsMTE2LDAuNikpOyIsImNzc1BhcmFtcyI6IjIwZGVnLHJnYmEoMCwyMiwxOTAsMC42KSxyZ2JhKDQyLDIzNiwxMTYsMC42KSJ9",
                                "overlay_5" => "eyJ0eXBlIjoiZ3JhZGllbnQiLCJjb2xvcjEiOiJyZ2JhKDI1NSwxMTEsNDksMC42KSIsImNvbG9yMiI6InJnYmEoNjUsMTIsMTg4LDAuNikiLCJtaXhlZENvbG9ycyI6W10sImRlZ3JlZSI6IjIwIiwiY3NzIjoiYmFja2dyb3VuZDogLXdlYmtpdC1saW5lYXItZ3JhZGllbnQoMjBkZWcscmdiYSg2NSwxMiwxODgsMC42KSxyZ2JhKDI1NSwxMTEsNDksMC42KSk7YmFja2dyb3VuZDogbGluZWFyLWdyYWRpZW50KDIwZGVnLHJnYmEoNjUsMTIsMTg4LDAuNikscmdiYSgyNTUsMTExLDQ5LDAuNikpOyIsImNzc1BhcmFtcyI6IjIwZGVnLHJnYmEoNjUsMTIsMTg4LDAuNikscmdiYSgyNTUsMTExLDQ5LDAuNikifQ==",
                                "lightsky" => "",
                            ),
                        )
                    )
                ),
                "params" => array_merge(
                    array(
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Content length',
                            "value"      => "",
                            "class"      => "",
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Module Flex 6',
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                        ),
                        array(
                            "param_name"  => "mf6_tl",
                            "type"        => "textfield",
                            "value"       => '',
                            "heading"     => 'Title length',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-small",
                            "placeholder" => '25',
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Module Flex 7',
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                        ),
                        array(
                            "param_name"  => "mf7_tl",
                            "type"        => "textfield",
                            "value"       => '',
                            "heading"     => 'Title length',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-small",
                            "placeholder" => '25',
                        ),
                    ),
                    self::td_block_big_grid_params(),
                    array(
                        array(
                            "param_name"  => "modules_gap",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Modules gap',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-small",
                            "placeholder" => "2",
                            "group"       => "Layout",
                        ),
                        array(
                            "param_name" => "meta_info_horiz",
                            "type" => "dropdown",
                            "value" => array(
                                'Left' => 'content-horiz-left',
                                'Center' => 'content-horiz-center',
                                'Right' => 'content-horiz-right'
                            ),
                            "heading" => 'Meta info horiz align',
                            "description" => "",
                            "holder" => "div",
                            'tdc_dropdown_images' => true,
                            "class" => "tdc-visual-selector tdc-add-class",
                            "group"       => "Layout",
                        ),
                        array(
                            "param_name" => "meta_info_vert",
                            "type" => "dropdown",
                            "value" => array(
                                'Left' => 'content-vert-top',
                                'Center' => 'content-vert-center',
                                'Right' => 'content-vert-bottom'
                            ),
                            "heading" => 'Meta info vert align',
                            "description" => "",
                            "holder" => "div",
                            'tdc_dropdown_images' => true,
                            "class" => "tdc-visual-selector tdc-add-class",
                            "group"       => "Layout",
                        ),
                        array(
                            "param_name"  => "image_zoom",
                            "type"        => "checkbox",
                            "value"       => '',
                            "heading"     => "Zoom effect on hover",
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "",
                            "group"       => 'Layout'
                        ),
                        array(
                            "param_name"  => "modules_category",
                            "type"        => "dropdown",
                            "value"       => array(
                                'Inline'      => '',
                                'Above title' => 'above',
                            ),
                            "heading"     => 'Category tag position',
                            "description" => "Float image",
                            "holder"      => "div",
                            "class"       => "tdc-dropdown-big",
                            "group"       => "Layout",
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Module Category Grid 1',
                            "value"      => "",
                            "class"      => "",
                            "group"      => "Layout",
                        ),
                        array(
                            "param_name"  => "image_size",
                            "type"        => "dropdown",
                            "value"       => array(
                                'XSmall - 324px' => 'td_324x400',
                                'Small - 696px'  => '',
                                'Large - 1068px' => 'td_1068x0',
                                'Full - 1920px'  => 'td_1920x0'
                            ),
                            "heading"     => 'Image size',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-dropdown-big",
                            "group"       => "Layout",
                        ),
                        array(
                            'param_name'  => 'image_alignment1',
                            'type'        => 'range-responsive',
                            'value'       => '50',
                            'heading'     => 'Image V alignment',
                            'description' => '0 - Top / 50 - Center / 100 - Bottom',
                            'class'       => 'tdc-textfield-small',
                            'range_min'   => '0',
                            'range_max'   => '100',
                            'range_step'  => '1',
                            "group"       => "Layout",
                        ),
                        array(
                            "param_name"  => "image_width1",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Image width (percent)',
                            "description" => "Default value in percent",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-small",
                            "placeholder" => "50",
                            "group"       => "Layout",
                        ),
                        array(
                            "param_name"  => "image_height1",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Image height (percent)',
                            "description" => "Default value in percent",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-small",
                            "placeholder" => "370px",
                            "group"       => "Layout",
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "horizontal_separator",
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                            "group"      => "Layout",
                        ),
                        array(
                            "param_name"  => "meta_width1",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Meta info width',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-small",
                            "placeholder" => "100%",
                            "group"       => "Layout",
                        ),
                        array(
                            "param_name"  => "meta_margin1",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Meta info margin',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-big",
                            "placeholder" => "0px 0px 0px 0px",
                            "group"       => "Layout",
                        ),
                        array(
                            "param_name"  => "meta_padding1",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Meta info padding',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-big",
                            "placeholder" => "20px",
                            "group"       => "Layout",
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "horizontal_separator",
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                            "group"      => "Layout",
                        ),
                        array(
                            "param_name"  => "art_title1",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Article title space',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-big",
                            "placeholder" => "0px 0px 9px 0px",
                            "group"       => "Layout",
                        ),
                        array(
                            "param_name"  => "art_title_padd1",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Article title padding',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-big",
                            "placeholder" => "0px 0px 0px 0px",
                            "group"       => "Layout",
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "horizontal_separator",
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                            "group"      => "Layout",
                        ),
                        array(
                            "param_name"  => "modules_category_margin1",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Category tag spacing',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-big",
                            "placeholder" => "0px 0px 5px 0px",
                            "group"       => "Layout",
                        ),
                        array(
                            "param_name"  => "modules_category_padding1",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Category tag padding',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-big",
                            "placeholder" => "3px 6px 3px 6px",
                            "group"       => "Layout",
                        ),
                        array(
                            "param_name"  => "show_cat1",
                            "type"        => "dropdown-responsive",
                            "value"       => array(
                                'Show' => 'inline-block',
                                'Hide' => 'none',
                            ),
                            "heading"     => 'Show category',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-dropdown-big",
                            "group"       => "Layout",
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "horizontal_separator",
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                            "group"      => "Layout",
                        ),
                        array(
                            "param_name"  => "show_author1",
                            "type"        => "dropdown-responsive",
                            "value"       => array(
                                'Show' => 'inline-block',
                                'Hide' => 'none',
                            ),
                            "heading"     => 'Show author',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-dropdown-big",
                            "group"       => "Layout",
                        ),
                        array(
                            "param_name"  => "show_date1",
                            "type"        => "dropdown-responsive",
                            "value"       => array(
                                'Show' => 'inline-block',
                                'Hide' => 'none',
                            ),
                            "heading"     => 'Show date',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-dropdown-big",
                            "group"       => "Layout",
                        ),
                        array(
                            "param_name"  => "auth_date_padding1",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Author & date padding',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-big",
                            "placeholder" => "0px 0px 0px 0px",
                            "group"       => "Layout",
                        ),

                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Module Category Grid 2',
                            "value"      => "",
                            "class"      => "",
                            "group"      => "Layout",
                        ),
                        array(
                            "param_name"  => "image_size2",
                            "type"        => "dropdown",
                            "value"       => array(
                                'XSmall - 324px' => 'td_324x400',
                                'Small - 696px'  => '',
                                'Large - 1068px' => 'td_1068x0',
                                'Full - 1920px'  => 'td_1920x0'
                            ),
                            "heading"     => 'Image size',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-dropdown-big",
                            "group"       => "Layout",
                        ),
                        array(
                            'param_name'  => 'image_alignment2',
                            'type'        => 'range-responsive',
                            'value'       => '50',
                            'heading'     => 'Image V alignment',
                            'description' => '0 - Top / 50 - Center / 100 - Bottom',
                            'class'       => 'tdc-textfield-small',
                            'range_min'   => '0',
                            'range_max'   => '100',
                            'range_step'  => '1',
                            "group"       => "Layout",
                        ),
                        array(
                            "param_name"  => "image_width2",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Image width (percent)',
                            "description" => "Default value in percent",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-small",
                            "placeholder" => "20",
                            "group"       => "Layout",
                        ),
                        array(
                            "param_name"  => "image_height2",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Image height (percent)',
                            "description" => "Default value in percent",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-small",
                            "placeholder" => "150px",
                            "group"       => "Layout",
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "horizontal_separator",
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                            "group"      => "Layout",
                        ),
                        array(
                            "param_name"  => "meta_width2",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Meta info width',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-small",
                            "placeholder" => "100%",
                            "group"       => "Layout",
                        ),
                        array(
                            "param_name"  => "meta_margin2",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Meta info margin',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-big",
                            "placeholder" => "0px 0px 0px 0px",
                            "group"       => "Layout",
                        ),
                        array(
                            "param_name"  => "meta_padding2",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Meta info padding',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-big",
                            "placeholder" => "10px 14px",
                            "group"       => "Layout",
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "horizontal_separator",
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                            "group"      => "Layout",
                        ),
                        array(
                            "param_name"  => "art_title2",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Article title space',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-big",
                            "placeholder" => "0px 0px 0px 0px",
                            "group"       => "Layout",
                        ),
                        array(
                            "param_name"  => "art_title_padd2",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Article title padding',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-big",
                            "placeholder" => "0px 0px 0px 0px",
                            "group"       => "Layout",
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "horizontal_separator",
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                            "group"      => "Layout",
                        ),
                        array(
                            "param_name"  => "modules_category_margin2",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Category tag spacing',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-big",
                            "placeholder" => "0px 0px 5px 0px",
                            "group"       => "Layout",
                        ),
                        array(
                            "param_name"  => "modules_category_padding2",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Category tag padding',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-big",
                            "placeholder" => "1px 5px 1px 5px",
                            "group"       => "Layout",
                        ),
                        array(
                            "param_name"  => "show_cat2",
                            "type"        => "dropdown-responsive",
                            "value"       => array(
                                'Show' => 'inline-block',
                                'Hide' => 'none',
                            ),
                            "heading"     => 'Show category',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-dropdown-big",
                            "group"       => "Layout",
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "horizontal_separator",
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                            "group"      => "Layout",
                        ),
                        array(
                            "param_name"  => "show_author2",
                            "type"        => "dropdown-responsive",
                            "value"       => array(
                                'Show' => 'inline-block',
                                'Hide' => 'none',
                            ),
                            "heading"     => 'Show author',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-dropdown-big",
                            "group"       => "Layout",
                        ),
                        array(
                            "param_name"  => "show_date2",
                            "type"        => "dropdown-responsive",
                            "value"       => array(
                                'Show' => 'inline-block',
                                'Hide' => 'none',
                            ),
                            "heading"     => 'Show date',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-dropdown-big",
                            "group"       => "Layout",
                        ),
                        array(
                            "param_name"  => "auth_date_padding2",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Author & date padding',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-big",
                            "placeholder" => "0px 0px 0px 0px",
                            "group"       => "Layout",
                        ),
                        array(
                            "param_name" => "separator",
                            "type" => "text_separator",
                            'heading' => 'Module fonts',
                            "value" => "",
                            "class" => "",
                            "group" => 'Style',
                        ),
                    ),
                    td_config_helper::get_map_block_font_array( 'f_title1', true, 'Module 1 title', 'Style' ),
                    td_config_helper::get_map_block_font_array( 'f_cat1', false, 'Module 1 category tag', 'Style' ),
                    td_config_helper::get_map_block_font_array( 'f_meta1', false, 'Module 1 meta info', 'Style' ),
                    td_config_helper::get_map_block_font_array( 'f_title2', false, 'Module 2 title', 'Style' ),
                    td_config_helper::get_map_block_font_array( 'f_cat2', false, 'Module 2 category tag', 'Style' ),
                    td_config_helper::get_map_block_font_array( 'f_meta2', false, 'Module 2 meta info', 'Style' ),
                    array(
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Colors',
                            "value"      => "",
                            "class"      => "",
                            "group"      => "Style",
                        ),
                        array(
                            "param_name" => "overlay_general",
                            "holder" => "div",
                            "type" => "gradient",
                            'heading' => "General module overlay color",
                            "value" => "",
                            "class" => "",
                            "group"      => "Style",
                        ),
                        array(
                            "param_name" => "overlay_h_general",
                            "holder" => "div",
                            "type" => "gradient",
                            'heading' => "General module overlay hover color",
                            "value" => "",
                            "class" => "",
                            "group"      => "Style",
                        ),
                        array(
                            "param_name" => "overlay_1",
                            "holder" => "div",
                            "type" => "gradient",
                            'heading' => "Module overlay color 1",
                            "value" => "",
                            "class" => "",
                            "group"      => "Style",
                        ),
                        array(
                            "param_name" => "overlay_2",
                            "holder" => "div",
                            "type" => "gradient",
                            'heading' => "Module overlay color 2",
                            "value" => "",
                            "class" => "",
                            "group"      => "Style",
                        ),
                        array(
                            "param_name" => "overlay_3",
                            "holder" => "div",
                            "type" => "gradient",
                            'heading' => "Module overlay color 3",
                            "value" => "",
                            "class" => "",
                            "group"      => "Style",
                        ),
                        array(
                            "param_name" => "overlay_4",
                            "holder" => "div",
                            "type" => "gradient",
                            'heading' => "Module overlay color 4",
                            "value" => "",
                            "class" => "",
                            "group"      => "Style",
                        ),
                        array(
                            "param_name" => "overlay_5",
                            "holder" => "div",
                            "type" => "gradient",
                            'heading' => "Module overlay color 5",
                            "value" => "",
                            "class" => "",
                            "group"      => "Style",
                        ),
                        array(
                            "param_name"  => "lightsky",
                            "type"        => "checkbox",
                            "value"       => '',
                            "heading"     => "Lightsky",
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "",
                            "group"       => 'Style'
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "",
                            "heading"     => 'Meta info background',
                            "param_name"  => "meta_bg",
                            "value"       => '',
                            "description" => '',
                            "group"       => 'Style',
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "horizontal_separator",
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                            "group"      => "Style",
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "",
                            "heading"     => 'Article title text color',
                            "param_name"  => "title_txt",
                            "value"       => '',
                            "description" => '',
                            "group"       => 'Style',
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "",
                            "heading"     => 'Article title text hover',
                            "param_name"  => "title_txt_hover",
                            "value"       => '',
                            "description" => '',
                            "group"       => 'Style',
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "",
                            "heading"     => 'Article title background color',
                            "param_name"  => "title_bg",
                            "value"       => '',
                            "description" => '',
                            "group"       => 'Style',
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "horizontal_separator",
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                            "group"      => "Style",
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "",
                            "heading"     => 'Category background',
                            "param_name"  => "cat_bg",
                            "value"       => '',
                            "description" => '',
                            "group"       => 'Style',
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "",
                            "heading"     => 'Category text color',
                            "param_name"  => "cat_txt",
                            "value"       => '',
                            "description" => '',
                            "group"       => 'Style',
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "",
                            "heading"     => 'Category background hover',
                            "param_name"  => "cat_bg_hover",
                            "value"       => '',
                            "description" => '',
                            "group"       => 'Style',
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "",
                            "heading"     => 'Category text hover',
                            "param_name"  => "cat_txt_hover",
                            "value"       => '',
                            "description" => '',
                            "group"       => 'Style',
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "horizontal_separator",
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                            "group"      => "Style",
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "",
                            "heading"     => 'Author text color',
                            "param_name"  => "author_txt",
                            "value"       => '',
                            "description" => '',
                            "group"       => 'Style',
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "",
                            "heading"     => 'Author text hover',
                            "param_name"  => "author_txt_hover",
                            "value"       => '',
                            "description" => '',
                            "group"       => 'Style',
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "",
                            "heading"     => 'Date text color',
                            "param_name"  => "date_txt",
                            "value"       => '',
                            "description" => '',
                            "group"       => 'Style',
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "",
                            "heading"     => 'Author & date background color',
                            "param_name"  => "auth_date_bg",
                            "value"       => '',
                            "description" => '',
                            "group"       => 'Style',
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "",
                            "heading"     => 'Review stars color',
                            "param_name"  => "review_stars",
                            "value"       => '',
                            "description" => '',
                            "group"       => 'Style',
                        ),
                    ),
                    self::get_map_css_tab()
                )
            )
        );

        td_api_block::add('td_block_big_grid_flex_10',
            array(
                'map_in_visual_composer' => false,
                'map_in_td_composer' => true,
                "name" => 'Big Grid Flex 10',
                "base" => 'td_block_big_grid_flex_10',
                "class" => 'td_block_big_grid_flex_10',
                "controls" => "full",
                "category" => 'Blocks',
                'tdc_category' => 'Big Grids',
                'icon' => 'icon-pagebuilder-td_block_big_grid_flex_10',
                'file' => td_global::$get_template_directory . '/includes/shortcodes/td_block_big_grid_flex_10.php',
                'tdc_style_params' => array(
                    'custom_title',
                    'custom_url',
                    'post_ids',
                    'category_id',
                    'category_ids',
                    'tag_slug',
                    'autors_id',
                    'installed_post_types',
                    'sort',
                    'offset',
                    'el_class'
                ),
                'tdc_start_values' => base64_encode(
                    json_encode(
                        array(
                            array(
                                "meta_info_vert" => "content-vert-bottom",
                                "image_zoom" => "yes",
                                "show_author2" => "none",
                                "show_date2" => "none",
                                "modules_category" => "above",
                                "overlay_general" => "eyJ0eXBlIjoiZ3JhZGllbnQiLCJjb2xvcjEiOiJyZ2JhKDAsMCwwLDApIiwiY29sb3IyIjoicmdiYSgwLDAsMCwwLjcpIiwibWl4ZWRDb2xvcnMiOlt7ImNvbG9yIjoicmdiYSgwLDAsMCwwKSIsInBlcmNlbnRhZ2UiOjYwfV0sImNzcyI6ImJhY2tncm91bmQ6IC13ZWJraXQtbGluZWFyLWdyYWRpZW50KDBkZWcscmdiYSgwLDAsMCwwLjcpLHJnYmEoMCwwLDAsMCkgNjAlLHJnYmEoMCwwLDAsMCkpO2JhY2tncm91bmQ6IGxpbmVhci1ncmFkaWVudCgwZGVnLHJnYmEoMCwwLDAsMC43KSxyZ2JhKDAsMCwwLDApIDYwJSxyZ2JhKDAsMCwwLDApKTsiLCJjc3NQYXJhbXMiOiIwZGVnLHJnYmEoMCwwLDAsMC43KSxyZ2JhKDAsMCwwLDApIDYwJSxyZ2JhKDAsMCwwLDApIn0=",
                                "image_width1" => "eyJwaG9uZSI6IjEwMCJ9",
                                "image_height1" => "eyJwaG9uZSI6IjI2MHB4IiwibGFuZHNjYXBlIjoiMjEwcHgiLCJwb3J0cmFpdCI6IjE1NXB4In0=",
                                "meta_padding2" => "eyJwaG9uZSI6IjE2cHggMTVweCAxMXB4In0=",
                                "meta_padding1" => "eyJwaG9uZSI6IjE1cHggMThweCIsInBvcnRyYWl0IjoiMTVweCAxNXB4IDEwcHggIn0=",
                                "cat_bg_hover" => "#4db2ec",
                                "review_stars" => "#fff",
                                "modules_category_margin1" => "eyJwaG9uZSI6IjBweCAwcHggN3B4IDBweCJ9",
                                "art_title1" => "eyJwb3J0cmFpdCI6IjBweCAwcHggMHB4IDBweCJ9",
                                "show_author1" => "eyJwb3J0cmFpdCI6Im5vbmUifQ==",
                                "show_date1" => "eyJwb3J0cmFpdCI6Im5vbmUifQ==",
                                "image_size" => "",
                                "image_size2" => "td_324x400",
                                "modules_category_padding2" => "eyJwaG9uZSI6IjNweCA2cHggM3B4IDZweCJ9",
                                "modules_gap" => "eyJwaG9uZSI6IjIifQ==",
                                "show_author3" => "eyJwaG9uZSI6Im5vbmUifQ==",
                                "show_date3" => "eyJwaG9uZSI6Im5vbmUifQ==",
                                "image_width2" => "eyJwaG9uZSI6IjgwIn0=",
                                "image_height2" => "eyJwaG9uZSI6IjE2NXB4IiwibGFuZHNjYXBlIjoiMTYwcHgiLCJwb3J0cmFpdCI6IjEyMHB4In0=",
                            ),

                            array(
                                'tdc_preset_name' => 'Font family',
                                'tdc_preset_class' => 'tdcp_separator tdcp_separator_font',
                            ),
                            array(
                                'tdc_preset_name' => '', // Font - Montserrat
                                'tdc_preset_class' => 'tdcp_img tdcp_font tdcp_font1',
                                'tdc_preset_individual' => '1',
                                "f_title1_font_family" =>        "394",
                                "f_title2_font_family" =>        "394",
                            ),
                            array(
                                'tdc_preset_name' => '', // Font - Source Serif
                                'tdc_preset_class' => 'tdcp_img tdcp_font tdcp_font2',
                                'tdc_preset_individual' =>      '1',
                                "f_title1_font_family" =>        "721",
                                "f_title2_font_family" =>        "721",
                            ),
                            array(
                                'tdc_preset_name' => '', // Font - Raleway
                                'tdc_preset_class' => 'tdcp_img tdcp_font tdcp_font3',
                                'tdc_preset_individual' => '1',
                                "f_title1_font_family" =>        "507",
                                "f_title2_font_family" =>        "507",
                            ),
                            array(
                                'tdc_preset_name' => '', // Font - Work Sans
                                'tdc_preset_class' => 'tdcp_img tdcp_font tdcp_font4',
                                'tdc_preset_individual' => '1',
                                "f_title1_font_family" =>        "653",
                                "f_title2_font_family" =>        "653",
                            ),
                            array(
                                'tdc_preset_name' => '', // Font - Courgette
                                'tdc_preset_class' => 'tdcp_img tdcp_font tdcp_font5',
                                'tdc_preset_individual' => '1',
                                "f_title1_font_family" =>        "147",
                                "f_title2_font_family" =>        "147",
                            ),
                            array(
                                'tdc_preset_name' => '', // Font - Oswald
                                'tdc_preset_class' => 'tdcp_img tdcp_font tdcp_font7',
                                'tdc_preset_individual' => '1',
                                "f_title1_font_family" =>        "445",
                                "f_title2_font_family" =>        "445",
                            ),
                            array(
                                'tdc_preset_name' => '', // Font - Muli
                                'tdc_preset_class' => 'tdcp_img tdcp_font tdcp_font8',
                                'tdc_preset_individual' => '1',
                                "f_title1_font_family" =>        "406",
                                "f_title2_font_family" =>        "406",
                            ),
                            array(
                                'tdc_preset_name' => '', // Font - Wendy One
                                'tdc_preset_class' => 'tdcp_img tdcp_font tdcp_font9',
                                'tdc_preset_individual' => '1',
                                "f_title1_font_family" =>        "646",
                                "f_title2_font_family" =>        "646",
                            ),
                            array(
                                'tdc_preset_name' => '', // Font - Anton
                                'tdc_preset_class' => 'tdcp_img tdcp_font tdcp_font10',
                                'tdc_preset_individual' => '1',
                                "f_title1_font_family" =>        "41",
                                "f_title2_font_family" =>        "41",
                            ),
                            array(
                                'tdc_preset_name' => '', // Font - Quicksand
                                'tdc_preset_class' => 'tdcp_img tdcp_font tdcp_font11',
                                'tdc_preset_individual' => '1',
                                "f_title1_font_family" =>        "502",
                                "f_title2_font_family" =>        "502",
                            ),
                            array(
                                'tdc_preset_name' => '', // Font - Libre Baskerville
                                'tdc_preset_class' => 'tdcp_img tdcp_font tdcp_font12',
                                'tdc_preset_individual' => '1',
                                "f_title1_font_family" =>        "331",
                                "f_title2_font_family" =>        "331",
                            ),
                            array(
                                'tdc_preset_name' => '', // Font - Caveat
                                'tdc_preset_class' => 'tdcp_img tdcp_font tdcp_font13',
                                'tdc_preset_individual' => '1',
                                "f_title1_font_family" =>        "663",
                                "f_title2_font_family" =>        "663",
                            ),
                            array(
                                'tdc_preset_name' => '', // Font - Volkorn
                                'tdc_preset_class' => 'tdcp_img tdcp_font tdcp_font14',
                                'tdc_preset_individual' => '1',
                                "f_title1_font_family" =>        "639",
                                "f_title2_font_family" =>        "639",
                            ),
                            array(
                                'tdc_preset_name' => '', // Font - Default
                                'tdc_preset_class' => 'tdcp_img tdcp_font tdcp_font6',
                                'tdc_preset_individual' => '1',
                                "f_title1_font_family" =>        "",
                                "f_title2_font_family" =>        "",
                            ),

                            array(
                                'tdc_preset_name' => 'Font size',
                                'tdc_preset_class' => 'tdcp_separator tdcp_separator_size',
                            ),
                            array(
                                'tdc_preset_name' => '', // Size - XS 13/13/12/14
                                'tdc_preset_class' => 'tdcp_img tdcp_size tdcp_size1',
                                'tdc_preset_individual' => '1',
                                "f_title1_font_size" => "eyJhbGwiOiIxNiIsInBvcnRyYWl0IjoiMTQifQ==",
                                "f_title1_font_line_height" => "1.3",
                                "f_title2_font_size" => "eyJhbGwiOiIxNCIsInBvcnRyYWl0IjoiMTIiLCJwaG9uZSI6IjEzIn0=",
                                "f_title2_font_line_height" => "1.3",
                                "f_title3_font_size" => "eyJwaG9uZSI6IjEzIn0=",
                                "f_title3_font_line_height" => "eyJwaG9uZSI6IjEuMyJ9",
                            ),
                            array(
                                'tdc_preset_name' => '', // Size - S 14/13/12/14
                                'tdc_preset_class' => 'tdcp_img tdcp_size tdcp_size2',
                                'tdc_preset_individual' => '1',
                                "f_title1_font_size" => "eyJhbGwiOiIxNiIsInBvcnRyYWl0IjoiMTQifQ==",
                                "f_title1_font_line_height" => "1.3",
                                "f_title2_font_size" => "eyJhbGwiOiIxNCIsInBvcnRyYWl0IjoiMTIiLCJwaG9uZSI6IjEzIn0=",
                                "f_title2_font_line_height" => "1.3",
                                "f_title3_font_size" => "eyJwaG9uZSI6IjEzIn0=",
                                "f_title3_font_line_height" => "eyJwaG9uZSI6IjEuMyJ9",
                            ),
                            array(
                                'tdc_preset_name' => '', // Size - M 21/21/17/21
                                'tdc_preset_class' => 'tdcp_img tdcp_size tdcp_size3',
                                'tdc_preset_individual' => '1',
                                "f_title1_font_size" => "eyJhbGwiOiIyMCIsInBvcnRyYWl0IjoiMTYiLCJwaG9uZSI6IjE2In0=",
                                "f_title1_font_line_height" => "1.2",
                                "f_title2_font_size" => "",
                                "f_title2_font_line_height" => "eyJwaG9uZSI6IjEuMyJ9",
                                "f_title3_font_size" => "eyJwaG9uZSI6IjEzIn0=",
                                "f_title3_font_line_height" => "eyJwaG9uZSI6IjEuMyJ9",
                            ),
                            array(
                                'tdc_preset_name' => '', // Size - L 26/25/21/21
                                'tdc_preset_class' => 'tdcp_img tdcp_size tdcp_size4',
                                'tdc_preset_individual' => '1',
                                "f_title1_font_size" => "22",
                                "f_title1_font_line_height" => "eyJwaG9uZSI6IjEuMyIsImFsbCI6IjEuMiJ9",
                                "f_title2_font_size" => "",
                                "f_title2_font_line_height" => "eyJwaG9uZSI6IjEuMyJ9",
                                "f_title3_font_size" => "eyJwaG9uZSI6IjEzIn0=",
                                "f_title3_font_line_height" => "eyJwaG9uZSI6IjEuMyJ9",

                            ),
                            array(
                                'tdc_preset_name' => '', // Size - XL 30/28/24/21
                                'tdc_preset_class' => 'tdcp_img tdcp_size tdcp_size5',
                                'tdc_preset_individual' => '1',
                                "f_title1_font_size" => "24",
                                "f_title1_font_line_height" => "eyJwaG9uZSI6IjEuMiIsImFsbCI6IjEuMSJ9",
                                "f_title2_font_size" => "eyJhbGwiOiIxNiIsInBvcnRyYWl0IjoiMTMifQ==",
                                "f_title2_font_line_height" => "1.2",
                                "f_title3_font_size" => "eyJwaG9uZSI6IjE2In0=",
                                "f_title3_font_line_height" => "eyJwaG9uZSI6IjEuMiJ9",
                            ),
                            array(
                                'tdc_preset_name' => '', // Size - XXL 36/32/26/21
                                'tdc_preset_class' => 'tdcp_img tdcp_size tdcp_size6',
                                'tdc_preset_individual' => '1',
                                "f_title1_font_size" => "eyJhbGwiOiIyNiIsInBvcnRyYWl0IjoiMjIiLCJwaG9uZSI6IjIyIn0=",
                                "f_title1_font_line_height" => "eyJwaG9uZSI6IjEuMiIsImFsbCI6IjEuMSJ9",
                                "f_title2_font_size" => "eyJhbGwiOiIxNyIsInBvcnRyYWl0IjoiMTQiLCJwaG9uZSI6IjE2In0=",
                                "f_title2_font_line_height" => "1.2",
                                "f_title3_font_size" => "eyJwaG9uZSI6IjE2In0=",
                                "f_title3_font_line_height" => "eyJwaG9uZSI6IjEuMiJ9",
                            ),

                            array(
                                'tdc_preset_name' => 'Text horizontal alignment',
                                'tdc_preset_class' => 'tdcp_separator tdcp_separator_align',
                            ),
                            array(
                                'tdc_preset_name' => '', // Text alignment - left
                                'tdc_preset_class' => 'tdcp_img tdcp_align tdcp_align1',
                                'tdc_preset_individual' => '1',
                                "meta_info_horiz" => "content-horiz-left",
                            ),
                            array(
                                'tdc_preset_name' => '', // Text alignment - center
                                'tdc_preset_class' => 'tdcp_img tdcp_align tdcp_align2',
                                'tdc_preset_individual' => '1',
                                "meta_info_horiz" => "content-horiz-center",
                            ),
                            array(
                                'tdc_preset_name' => '', // Text alignment - right
                                'tdc_preset_class' => 'tdcp_img tdcp_align tdcp_align3',
                                'tdc_preset_individual' => '1',
                                "meta_info_horiz" => "content-horiz-right",
                            ),

                            array(
                                'tdc_preset_name' => 'Text vertical alignment',
                                'tdc_preset_class' => 'tdcp_separator tdcp_separator_align_v',
                            ),
                            array(
                                'tdc_preset_name' => '', // Text vertical alignment - top
                                'tdc_preset_class' => 'tdcp_img tdcp_align tdcp_align_v1',
                                'tdc_preset_individual' => '1',
                                "meta_info_vert" => "content-vert-top",
                            ),
                            array(
                                'tdc_preset_name' => '', // Text vertical alignment - middle
                                'tdc_preset_class' => 'tdcp_img tdcp_align tdcp_align_v2',
                                'tdc_preset_individual' => '1',
                                "meta_info_vert" => "content-vert-center",
                            ),
                            array(
                                'tdc_preset_name' => '', // Text vertical alignment - bottom
                                'tdc_preset_class' => 'tdcp_img tdcp_align tdcp_align_v3',
                                'tdc_preset_individual' => '1',
                                "meta_info_vert" => "content-vert-bottom",
                            ),

                            array(
                                'tdc_preset_name' => 'Style',
                                'tdc_preset_class' => 'tdcp_separator tdcp_separator_style',
                            ),
                            array(
                                'tdc_preset_name' => '', // Style 1 - default
                                'tdc_preset_class' => 'tdcp_img tdcp_style tdcp_style1',
                                'tdc_preset_individual' => '1',
                                "overlay_general" => "eyJ0eXBlIjoiZ3JhZGllbnQiLCJjb2xvcjEiOiJyZ2JhKDAsMCwwLDApIiwiY29sb3IyIjoicmdiYSgwLDAsMCwwLjcpIiwibWl4ZWRDb2xvcnMiOlt7ImNvbG9yIjoicmdiYSgwLDAsMCwwKSIsInBlcmNlbnRhZ2UiOjYwfV0sImNzcyI6ImJhY2tncm91bmQ6IC13ZWJraXQtbGluZWFyLWdyYWRpZW50KDBkZWcscmdiYSgwLDAsMCwwLjcpLHJnYmEoMCwwLDAsMCkgNjAlLHJnYmEoMCwwLDAsMCkpO2JhY2tncm91bmQ6IGxpbmVhci1ncmFkaWVudCgwZGVnLHJnYmEoMCwwLDAsMC43KSxyZ2JhKDAsMCwwLDApIDYwJSxyZ2JhKDAsMCwwLDApKTsiLCJjc3NQYXJhbXMiOiIwZGVnLHJnYmEoMCwwLDAsMC43KSxyZ2JhKDAsMCwwLDApIDYwJSxyZ2JhKDAsMCwwLDApIn0=",
                                "overlay_h_general" => "",
                                "overlay_1" => "",
                                "overlay_2" => "",
                                "overlay_3" => "",
                                "overlay_4" => "",
                                "overlay_5" => "",
                                "lightsky" => "",
                            ),
                            array(
                                'tdc_preset_name' => '', // Style 2 - colors
                                'tdc_preset_class' => 'tdcp_img tdcp_style tdcp_style2',
                                'tdc_preset_individual' => '1',
                                "overlay_h_general" => "",
                                "overlay_1" => "eyJ0eXBlIjoiZ3JhZGllbnQiLCJjb2xvcjEiOiJyZ2JhKDc0LDE0Myw5NCwwLjYpIiwiY29sb3IyIjoicmdiYSg3NywxNzgsMjM2LDAuNikiLCJtaXhlZENvbG9ycyI6W10sImRlZ3JlZSI6IjQ1IiwiY3NzIjoiYmFja2dyb3VuZDogLXdlYmtpdC1saW5lYXItZ3JhZGllbnQoNDVkZWcscmdiYSg3NywxNzgsMjM2LDAuNikscmdiYSg3NCwxNDMsOTQsMC42KSk7YmFja2dyb3VuZDogbGluZWFyLWdyYWRpZW50KDQ1ZGVnLHJnYmEoNzcsMTc4LDIzNiwwLjYpLHJnYmEoNzQsMTQzLDk0LDAuNikpOyIsImNzc1BhcmFtcyI6IjQ1ZGVnLHJnYmEoNzcsMTc4LDIzNiwwLjYpLHJnYmEoNzQsMTQzLDk0LDAuNikifQ==",
                                "overlay_2" => "eyJ0eXBlIjoiZ3JhZGllbnQiLCJjb2xvcjEiOiJyZ2JhKDE5OCw1Nyw1NywwLjYpIiwiY29sb3IyIjoicmdiYSgyMDksMTE4LDcwLDAuNikiLCJtaXhlZENvbG9ycyI6W10sImRlZ3JlZSI6IjQ1IiwiY3NzIjoiYmFja2dyb3VuZDogLXdlYmtpdC1saW5lYXItZ3JhZGllbnQoNDVkZWcscmdiYSgyMDksMTE4LDcwLDAuNikscmdiYSgxOTgsNTcsNTcsMC42KSk7YmFja2dyb3VuZDogbGluZWFyLWdyYWRpZW50KDQ1ZGVnLHJnYmEoMjA5LDExOCw3MCwwLjYpLHJnYmEoMTk4LDU3LDU3LDAuNikpOyIsImNzc1BhcmFtcyI6IjQ1ZGVnLHJnYmEoMjA5LDExOCw3MCwwLjYpLHJnYmEoMTk4LDU3LDU3LDAuNikifQ==",
                                "overlay_3" => "eyJ0eXBlIjoiZ3JhZGllbnQiLCJjb2xvcjEiOiJyZ2JhKDU5LDEyMCwxODAsMC41OSkiLCJjb2xvcjIiOiJyZ2JhKDIxNSw5NiwxODMsMC42KSIsIm1peGVkQ29sb3JzIjpbXSwiZGVncmVlIjoiLTQ1IiwiY3NzIjoiYmFja2dyb3VuZDogLXdlYmtpdC1saW5lYXItZ3JhZGllbnQoLTQ1ZGVnLHJnYmEoMjE1LDk2LDE4MywwLjYpLHJnYmEoNTksMTIwLDE4MCwwLjU5KSk7YmFja2dyb3VuZDogbGluZWFyLWdyYWRpZW50KC00NWRlZyxyZ2JhKDIxNSw5NiwxODMsMC42KSxyZ2JhKDU5LDEyMCwxODAsMC41OSkpOyIsImNzc1BhcmFtcyI6Ii00NWRlZyxyZ2JhKDIxNSw5NiwxODMsMC42KSxyZ2JhKDU5LDEyMCwxODAsMC41OSkifQ==",
                                "overlay_4" => "eyJ0eXBlIjoiZ3JhZGllbnQiLCJjb2xvcjEiOiJyZ2JhKDI0MiwxMjIsNTMsMC42KSIsImNvbG9yMiI6InJnYmEoMjQ0LDIwOCw2MywwLjYpIiwibWl4ZWRDb2xvcnMiOltdLCJkZWdyZWUiOiItNDUiLCJjc3MiOiJiYWNrZ3JvdW5kOiAtd2Via2l0LWxpbmVhci1ncmFkaWVudCgtNDVkZWcscmdiYSgyNDQsMjA4LDYzLDAuNikscmdiYSgyNDIsMTIyLDUzLDAuNikpO2JhY2tncm91bmQ6IGxpbmVhci1ncmFkaWVudCgtNDVkZWcscmdiYSgyNDQsMjA4LDYzLDAuNikscmdiYSgyNDIsMTIyLDUzLDAuNikpOyIsImNzc1BhcmFtcyI6Ii00NWRlZyxyZ2JhKDI0NCwyMDgsNjMsMC42KSxyZ2JhKDI0MiwxMjIsNTMsMC42KSJ9",
                                "overlay_5" => "eyJ0eXBlIjoiZ3JhZGllbnQiLCJjb2xvcjEiOiJyZ2JhKDc0LDE0Myw5NCwwLjYpIiwiY29sb3IyIjoicmdiYSg3NywxNzgsMjM2LDAuNikiLCJtaXhlZENvbG9ycyI6W10sImRlZ3JlZSI6IjQ1IiwiY3NzIjoiYmFja2dyb3VuZDogLXdlYmtpdC1saW5lYXItZ3JhZGllbnQoNDVkZWcscmdiYSg3NywxNzgsMjM2LDAuNikscmdiYSg3NCwxNDMsOTQsMC42KSk7YmFja2dyb3VuZDogbGluZWFyLWdyYWRpZW50KDQ1ZGVnLHJnYmEoNzcsMTc4LDIzNiwwLjYpLHJnYmEoNzQsMTQzLDk0LDAuNikpOyIsImNzc1BhcmFtcyI6IjQ1ZGVnLHJnYmEoNzcsMTc4LDIzNiwwLjYpLHJnYmEoNzQsMTQzLDk0LDAuNikifQ==",
                                "lightsky" => "",
                            ),
                            array(
                                'tdc_preset_name' => '', // Style 3 - flat colors
                                'tdc_preset_class' => 'tdcp_img tdcp_style tdcp_style3',
                                'tdc_preset_individual' => '1',
                                "overlay_h_general" => "",
                                "overlay_1" => "eyJ0eXBlIjoiZ3JhZGllbnQiLCJjb2xvcjEiOiJyZ2JhKDc0LDE0Myw5NCwwLjgpIiwiY29sb3IyIjoicmdiYSg3NywxNzgsMjM2LDAuOCkiLCJtaXhlZENvbG9ycyI6W10sImRlZ3JlZSI6IjQ1IiwiY3NzIjoiYmFja2dyb3VuZDogLXdlYmtpdC1saW5lYXItZ3JhZGllbnQoNDVkZWcscmdiYSg3NywxNzgsMjM2LDAuOCkscmdiYSg3NCwxNDMsOTQsMC44KSk7YmFja2dyb3VuZDogbGluZWFyLWdyYWRpZW50KDQ1ZGVnLHJnYmEoNzcsMTc4LDIzNiwwLjgpLHJnYmEoNzQsMTQzLDk0LDAuOCkpOyIsImNzc1BhcmFtcyI6IjQ1ZGVnLHJnYmEoNzcsMTc4LDIzNiwwLjgpLHJnYmEoNzQsMTQzLDk0LDAuOCkifQ==",
                                "overlay_2" => "eyJ0eXBlIjoiZ3JhZGllbnQiLCJjb2xvcjEiOiJyZ2JhKDE5OCw1Nyw1NywwLjgpIiwiY29sb3IyIjoicmdiYSgyMDksMTE4LDcwLDAuOCkiLCJtaXhlZENvbG9ycyI6W10sImRlZ3JlZSI6IjQ1IiwiY3NzIjoiYmFja2dyb3VuZDogLXdlYmtpdC1saW5lYXItZ3JhZGllbnQoNDVkZWcscmdiYSgyMDksMTE4LDcwLDAuOCkscmdiYSgxOTgsNTcsNTcsMC44KSk7YmFja2dyb3VuZDogbGluZWFyLWdyYWRpZW50KDQ1ZGVnLHJnYmEoMjA5LDExOCw3MCwwLjgpLHJnYmEoMTk4LDU3LDU3LDAuOCkpOyIsImNzc1BhcmFtcyI6IjQ1ZGVnLHJnYmEoMjA5LDExOCw3MCwwLjgpLHJnYmEoMTk4LDU3LDU3LDAuOCkifQ==",
                                "overlay_3" => "eyJ0eXBlIjoiZ3JhZGllbnQiLCJjb2xvcjEiOiJyZ2JhKDU5LDEyMCwxODAsMC44KSIsImNvbG9yMiI6InJnYmEoMjE1LDk2LDE4MywwLjgpIiwibWl4ZWRDb2xvcnMiOltdLCJkZWdyZWUiOiItNDUiLCJjc3MiOiJiYWNrZ3JvdW5kOiAtd2Via2l0LWxpbmVhci1ncmFkaWVudCgtNDVkZWcscmdiYSgyMTUsOTYsMTgzLDAuOCkscmdiYSg1OSwxMjAsMTgwLDAuOCkpO2JhY2tncm91bmQ6IGxpbmVhci1ncmFkaWVudCgtNDVkZWcscmdiYSgyMTUsOTYsMTgzLDAuOCkscmdiYSg1OSwxMjAsMTgwLDAuOCkpOyIsImNzc1BhcmFtcyI6Ii00NWRlZyxyZ2JhKDIxNSw5NiwxODMsMC44KSxyZ2JhKDU5LDEyMCwxODAsMC44KSJ9",
                                "overlay_4" => "eyJ0eXBlIjoiZ3JhZGllbnQiLCJjb2xvcjEiOiJyZ2JhKDI0MiwxMjIsNTMsMC44KSIsImNvbG9yMiI6InJnYmEoMjQ0LDIwOCw2MywwLjgpIiwibWl4ZWRDb2xvcnMiOltdLCJkZWdyZWUiOiItNDUiLCJjc3MiOiJiYWNrZ3JvdW5kOiAtd2Via2l0LWxpbmVhci1ncmFkaWVudCgtNDVkZWcscmdiYSgyNDQsMjA4LDYzLDAuOCkscmdiYSgyNDIsMTIyLDUzLDAuOCkpO2JhY2tncm91bmQ6IGxpbmVhci1ncmFkaWVudCgtNDVkZWcscmdiYSgyNDQsMjA4LDYzLDAuOCkscmdiYSgyNDIsMTIyLDUzLDAuOCkpOyIsImNzc1BhcmFtcyI6Ii00NWRlZyxyZ2JhKDI0NCwyMDgsNjMsMC44KSxyZ2JhKDI0MiwxMjIsNTMsMC44KSJ9",
                                "overlay_5" => "eyJ0eXBlIjoiZ3JhZGllbnQiLCJjb2xvcjEiOiJyZ2JhKDc0LDE0Myw5NCwwLjgpIiwiY29sb3IyIjoicmdiYSg3NywxNzgsMjM2LDAuOCkiLCJtaXhlZENvbG9ycyI6W10sImRlZ3JlZSI6IjQ1IiwiY3NzIjoiYmFja2dyb3VuZDogLXdlYmtpdC1saW5lYXItZ3JhZGllbnQoNDVkZWcscmdiYSg3NywxNzgsMjM2LDAuOCkscmdiYSg3NCwxNDMsOTQsMC44KSk7YmFja2dyb3VuZDogbGluZWFyLWdyYWRpZW50KDQ1ZGVnLHJnYmEoNzcsMTc4LDIzNiwwLjgpLHJnYmEoNzQsMTQzLDk0LDAuOCkpOyIsImNzc1BhcmFtcyI6IjQ1ZGVnLHJnYmEoNzcsMTc4LDIzNiwwLjgpLHJnYmEoNzQsMTQzLDk0LDAuOCkifQ==",
                                "lightsky" => "",
                            ),
                            array(
                                'tdc_preset_name' => '', // Style 4 - light sky
                                'tdc_preset_class' => 'tdcp_img tdcp_style tdcp_style4',
                                'tdc_preset_individual' => '1',
                                "overlay_general" => "rgba(0,0,0,0.7)",
                                "overlay_h_general" => "rgba(77,178,236,0.3)",
                                "overlay_1" => "",
                                "overlay_2" => "",
                                "overlay_3" => "",
                                "overlay_4" => "",
                                "overlay_5" => "",
                                "lightsky" => "yes",
                            ),
                            array(
                                'tdc_preset_name' => '', // Style 5 - rainbow
                                'tdc_preset_class' => 'tdcp_img tdcp_style tdcp_style5',
                                'tdc_preset_individual' => '1',
                                "overlay_h_general" => "",
                                "overlay_1" => "eyJ0eXBlIjoiZ3JhZGllbnQiLCJjb2xvcjEiOiJyZ2JhKDI1NSwxMTEsNDksMC42KSIsImNvbG9yMiI6InJnYmEoNjUsMTIsMTg4LDAuNikiLCJtaXhlZENvbG9ycyI6W10sImRlZ3JlZSI6IjIwIiwiY3NzIjoiYmFja2dyb3VuZDogLXdlYmtpdC1saW5lYXItZ3JhZGllbnQoMjBkZWcscmdiYSg2NSwxMiwxODgsMC42KSxyZ2JhKDI1NSwxMTEsNDksMC42KSk7YmFja2dyb3VuZDogbGluZWFyLWdyYWRpZW50KDIwZGVnLHJnYmEoNjUsMTIsMTg4LDAuNikscmdiYSgyNTUsMTExLDQ5LDAuNikpOyIsImNzc1BhcmFtcyI6IjIwZGVnLHJnYmEoNjUsMTIsMTg4LDAuNikscmdiYSgyNTUsMTExLDQ5LDAuNikifQ==",
                                "overlay_2" => "eyJ0eXBlIjoiZ3JhZGllbnQiLCJjb2xvcjEiOiJyZ2JhKDExMiwyNTUsMTUzLDAuNikiLCJjb2xvcjIiOiJyZ2JhKDI0NCwxMzYsMTMsMC42KSIsIm1peGVkQ29sb3JzIjpbXSwiZGVncmVlIjoiMjAiLCJjc3MiOiJiYWNrZ3JvdW5kOiAtd2Via2l0LWxpbmVhci1ncmFkaWVudCgyMGRlZyxyZ2JhKDI0NCwxMzYsMTMsMC42KSxyZ2JhKDExMiwyNTUsMTUzLDAuNikpO2JhY2tncm91bmQ6IGxpbmVhci1ncmFkaWVudCgyMGRlZyxyZ2JhKDI0NCwxMzYsMTMsMC42KSxyZ2JhKDExMiwyNTUsMTUzLDAuNikpOyIsImNzc1BhcmFtcyI6IjIwZGVnLHJnYmEoMjQ0LDEzNiwxMywwLjYpLHJnYmEoMTEyLDI1NSwxNTMsMC42KSJ9",
                                "overlay_3" => "eyJ0eXBlIjoiZ3JhZGllbnQiLCJjb2xvcjEiOiJyZ2JhKDEyNiwxOTEsMjU1LDAuNikiLCJjb2xvcjIiOiJyZ2JhKDE5NiwxNSwxMjEsMC42KSIsIm1peGVkQ29sb3JzIjpbXSwiZGVncmVlIjoiMjAiLCJjc3MiOiJiYWNrZ3JvdW5kOiAtd2Via2l0LWxpbmVhci1ncmFkaWVudCgyMGRlZyxyZ2JhKDE5NiwxNSwxMjEsMC42KSxyZ2JhKDEyNiwxOTEsMjU1LDAuNikpO2JhY2tncm91bmQ6IGxpbmVhci1ncmFkaWVudCgyMGRlZyxyZ2JhKDE5NiwxNSwxMjEsMC42KSxyZ2JhKDEyNiwxOTEsMjU1LDAuNikpOyIsImNzc1BhcmFtcyI6IjIwZGVnLHJnYmEoMTk2LDE1LDEyMSwwLjYpLHJnYmEoMTI2LDE5MSwyNTUsMC42KSJ9",
                                "overlay_4" => "eyJ0eXBlIjoiZ3JhZGllbnQiLCJjb2xvcjEiOiJyZ2JhKDQyLDIzNiwxMTYsMC42KSIsImNvbG9yMiI6InJnYmEoMCwyMiwxOTAsMC42KSIsIm1peGVkQ29sb3JzIjpbXSwiZGVncmVlIjoiMjAiLCJjc3MiOiJiYWNrZ3JvdW5kOiAtd2Via2l0LWxpbmVhci1ncmFkaWVudCgyMGRlZyxyZ2JhKDAsMjIsMTkwLDAuNikscmdiYSg0MiwyMzYsMTE2LDAuNikpO2JhY2tncm91bmQ6IGxpbmVhci1ncmFkaWVudCgyMGRlZyxyZ2JhKDAsMjIsMTkwLDAuNikscmdiYSg0MiwyMzYsMTE2LDAuNikpOyIsImNzc1BhcmFtcyI6IjIwZGVnLHJnYmEoMCwyMiwxOTAsMC42KSxyZ2JhKDQyLDIzNiwxMTYsMC42KSJ9",
                                "overlay_5" => "eyJ0eXBlIjoiZ3JhZGllbnQiLCJjb2xvcjEiOiJyZ2JhKDI1NSwxMTEsNDksMC42KSIsImNvbG9yMiI6InJnYmEoNjUsMTIsMTg4LDAuNikiLCJtaXhlZENvbG9ycyI6W10sImRlZ3JlZSI6IjIwIiwiY3NzIjoiYmFja2dyb3VuZDogLXdlYmtpdC1saW5lYXItZ3JhZGllbnQoMjBkZWcscmdiYSg2NSwxMiwxODgsMC42KSxyZ2JhKDI1NSwxMTEsNDksMC42KSk7YmFja2dyb3VuZDogbGluZWFyLWdyYWRpZW50KDIwZGVnLHJnYmEoNjUsMTIsMTg4LDAuNikscmdiYSgyNTUsMTExLDQ5LDAuNikpOyIsImNzc1BhcmFtcyI6IjIwZGVnLHJnYmEoNjUsMTIsMTg4LDAuNikscmdiYSgyNTUsMTExLDQ5LDAuNikifQ==",
                                "lightsky" => "",
                            ),
                        )
                    )
                ),
                "params" => array_merge(
                    array(
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Content length',
                            "value"      => "",
                            "class"      => "",
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Module Flex 6',
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                        ),
                        array(
                            "param_name"  => "mf6_tl",
                            "type"        => "textfield",
                            "value"       => '',
                            "heading"     => 'Title length',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-small",
                            "placeholder" => '25',
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Module Flex 7',
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                        ),
                        array(
                            "param_name"  => "mf7_tl",
                            "type"        => "textfield",
                            "value"       => '',
                            "heading"     => 'Title length',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-small",
                            "placeholder" => '25',
                        ),
                    ),
                    self::td_block_big_grid_params(),
                    array(
                        array(
                            "param_name"  => "modules_gap",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Modules gap',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-small",
                            "placeholder" => "10",
                            "group"       => "Layout",
                        ),
                        array(
                            "param_name" => "meta_info_horiz",
                            "type" => "dropdown",
                            "value" => array(
                                'Left' => 'content-horiz-left',
                                'Center' => 'content-horiz-center',
                                'Right' => 'content-horiz-right'
                            ),
                            "heading" => 'Meta info horiz align',
                            "description" => "",
                            "holder" => "div",
                            'tdc_dropdown_images' => true,
                            "class" => "tdc-visual-selector tdc-add-class",
                            "group"       => "Layout",
                        ),
                        array(
                            "param_name" => "meta_info_vert",
                            "type" => "dropdown",
                            "value" => array(
                                'Left' => 'content-vert-top',
                                'Center' => 'content-vert-center',
                                'Right' => 'content-vert-bottom'
                            ),
                            "heading" => 'Meta info vert align',
                            "description" => "",
                            "holder" => "div",
                            'tdc_dropdown_images' => true,
                            "class" => "tdc-visual-selector tdc-add-class",
                            "group"       => "Layout",
                        ),
                        array(
                            "param_name"  => "image_zoom",
                            "type"        => "checkbox",
                            "value"       => '',
                            "heading"     => "Zoom effect on hover",
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "",
                            "group"       => 'Layout'
                        ),
                        array(
                            "param_name"  => "modules_category",
                            "type"        => "dropdown",
                            "value"       => array(
                                'Inline'      => '',
                                'Above title' => 'above',
                            ),
                            "heading"     => 'Category tag position',
                            "description" => "Float image",
                            "holder"      => "div",
                            "class"       => "tdc-dropdown-big",
                            "group"       => "Layout",
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Module Category Grid 1',
                            "value"      => "",
                            "class"      => "",
                            "group"      => "Layout",
                        ),
                        array(
                            "param_name"  => "image_size",
                            "type"        => "dropdown",
                            "value"       => array(
                                'XSmall - 324px' => 'td_324x400',
                                'Small - 696px'  => '',
                                'Large - 1068px' => 'td_1068x0',
                                'Full - 1920px'  => 'td_1920x0'
                            ),
                            "heading"     => 'Image size',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-dropdown-big",
                            "group"       => "Layout",
                        ),
                        array(
                            'param_name'  => 'image_alignment1',
                            'type'        => 'range-responsive',
                            'value'       => '50',
                            'heading'     => 'Image V alignment',
                            'description' => '0 - Top / 50 - Center / 100 - Bottom',
                            'class'       => 'tdc-textfield-small',
                            'range_min'   => '0',
                            'range_max'   => '100',
                            'range_step'  => '1',
                            "group"       => "Layout",
                        ),
                        array(
                            "param_name"  => "image_width1",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Image width (percent)',
                            "description" => "Default value in percent",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-small",
                            "placeholder" => "33.33",
                            "group"       => "Layout",
                        ),
                        array(
                            "param_name"  => "image_height1",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Image height (percent)',
                            "description" => "Default value in percent",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-small",
                            "placeholder" => "230px",
                            "group"       => "Layout",
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "horizontal_separator",
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                            "group"      => "Layout",
                        ),
                        array(
                            "param_name"  => "meta_width1",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Meta info width',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-small",
                            "placeholder" => "100%",
                            "group"       => "Layout",
                        ),
                        array(
                            "param_name"  => "meta_margin1",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Meta info margin',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-big",
                            "placeholder" => "0px 0px 0px 0px",
                            "group"       => "Layout",
                        ),
                        array(
                            "param_name"  => "meta_padding1",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Meta info padding',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-big",
                            "placeholder" => "20px",
                            "group"       => "Layout",
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "horizontal_separator",
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                            "group"      => "Layout",
                        ),
                        array(
                            "param_name"  => "art_title1",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Article title space',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-big",
                            "placeholder" => "0px 0px 9px 0px",
                            "group"       => "Layout",
                        ),
                        array(
                            "param_name"  => "art_title_padd1",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Article title padding',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-big",
                            "placeholder" => "0px 0px 0px 0px",
                            "group"       => "Layout",
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "horizontal_separator",
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                            "group"      => "Layout",
                        ),
                        array(
                            "param_name"  => "modules_category_margin1",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Category tag spacing',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-big",
                            "placeholder" => "0px 0px 7px 0px",
                            "group"       => "Layout",
                        ),
                        array(
                            "param_name"  => "modules_category_padding1",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Category tag padding',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-big",
                            "placeholder" => "3px 6px 3px 6px",
                            "group"       => "Layout",
                        ),
                        array(
                            "param_name"  => "show_cat1",
                            "type"        => "dropdown-responsive",
                            "value"       => array(
                                'Show' => 'inline-block',
                                'Hide' => 'none',
                            ),
                            "heading"     => 'Show category',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-dropdown-big",
                            "group"       => "Layout",
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "horizontal_separator",
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                            "group"      => "Layout",
                        ),
                        array(
                            "param_name"  => "show_author1",
                            "type"        => "dropdown-responsive",
                            "value"       => array(
                                'Show' => 'inline-block',
                                'Hide' => 'none',
                            ),
                            "heading"     => 'Show author',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-dropdown-big",
                            "group"       => "Layout",
                        ),
                        array(
                            "param_name"  => "show_date1",
                            "type"        => "dropdown-responsive",
                            "value"       => array(
                                'Show' => 'inline-block',
                                'Hide' => 'none',
                            ),
                            "heading"     => 'Show date',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-dropdown-big",
                            "group"       => "Layout",
                        ),
                        array(
                            "param_name"  => "auth_date_padding1",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Author & date padding',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-big",
                            "placeholder" => "0px 0px 0px 0px",
                            "group"       => "Layout",
                        ),

                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Module Category Grid 1 - Mobile',
                            "value"      => "",
                            "class"      => "",
                            "group"      => "Layout",
                        ),
                        array(
                            "param_name"  => "image_width3",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Image width (percent)',
                            "description" => "Default value in percent",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-small",
                            "placeholder" => "80",
                            "group"       => "Layout",
                        ),
                        array(
                            "param_name"  => "image_height3",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Image height (percent)',
                            "description" => "Default value in percent",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-small",
                            "placeholder" => "165px",
                            "group"       => "Layout",
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "horizontal_separator",
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                            "group"      => "Layout",
                        ),
                        array(
                            "param_name"  => "meta_width3",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Meta info width',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-small",
                            "placeholder" => "100%",
                            "group"       => "Layout",
                        ),
                        array(
                            "param_name"  => "meta_margin3",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Meta info margin',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-big",
                            "placeholder" => "0px 0px 0px 0px",
                            "group"       => "Layout",
                        ),
                        array(
                            "param_name"  => "meta_padding3",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Meta info padding',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-big",
                            "placeholder" => "16px 15px 11px",
                            "group"       => "Layout",
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "horizontal_separator",
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                            "group"      => "Layout",
                        ),
                        array(
                            "param_name"  => "art_title3",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Article title space',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-big",
                            "placeholder" => "0px 0px 0px 0px",
                            "group"       => "Layout",
                        ),
                        array(
                            "param_name"  => "art_title_padd3",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Article title padding',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-big",
                            "placeholder" => "0px 0px 0px 0px",
                            "group"       => "Layout",
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "horizontal_separator",
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                            "group"      => "Layout",
                        ),
                        array(
                            "param_name"  => "modules_category_margin3",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Category tag spacing',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-big",
                            "placeholder" => "0px 0px 7px 0px",
                            "group"       => "Layout",
                        ),
                        array(
                            "param_name"  => "modules_category_padding3",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Category tag padding',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-big",
                            "placeholder" => "3px 6px 3px 6px",
                            "group"       => "Layout",
                        ),
                        array(
                            "param_name"  => "show_cat3",
                            "type"        => "dropdown-responsive",
                            "value"       => array(
                                'Show' => 'inline-block',
                                'Hide' => 'none',
                            ),
                            "heading"     => 'Show category',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-dropdown-big",
                            "group"       => "Layout",
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "horizontal_separator",
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                            "group"      => "Layout",
                        ),
                        array(
                            "param_name"  => "show_author3",
                            "type"        => "dropdown-responsive",
                            "value"       => array(
                                'Show' => 'inline-block',
                                'Hide' => 'none',
                            ),
                            "heading"     => 'Show author',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-dropdown-big",
                            "group"       => "Layout",
                        ),
                        array(
                            "param_name"  => "show_date3",
                            "type"        => "dropdown-responsive",
                            "value"       => array(
                                'Show' => 'inline-block',
                                'Hide' => 'none',
                            ),
                            "heading"     => 'Show date',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-dropdown-big",
                            "group"       => "Layout",
                        ),
                        array(
                            "param_name"  => "auth_date_padding3",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Author & date padding',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-big",
                            "placeholder" => "0px 0px 0px 0px",
                            "group"       => "Layout",
                        ),

                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Module Category Grid 2',
                            "value"      => "",
                            "class"      => "",
                            "group"      => "Layout",
                        ),
                        array(
                            "param_name"  => "image_size2",
                            "type"        => "dropdown",
                            "value"       => array(
                                'XSmall - 324px' => 'td_324x400',
                                'Small - 696px'  => '',
                                'Large - 1068px' => 'td_1068x0',
                                'Full - 1920px'  => 'td_1920x0'
                            ),
                            "heading"     => 'Image size',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-dropdown-big",
                            "group"       => "Layout",
                        ),
                        array(
                            'param_name'  => 'image_alignment2',
                            'type'        => 'range-responsive',
                            'value'       => '50',
                            'heading'     => 'Image V alignment',
                            'description' => '0 - Top / 50 - Center / 100 - Bottom',
                            'class'       => 'tdc-textfield-small',
                            'range_min'   => '0',
                            'range_max'   => '100',
                            'range_step'  => '1',
                            "group"       => "Layout",
                        ),
                        array(
                            "param_name"  => "image_width2",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Image width (percent)',
                            "description" => "Default value in percent",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-small",
                            "placeholder" => "25",
                            "group"       => "Layout",
                        ),
                        array(
                            "param_name"  => "image_height2",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Image height (percent)',
                            "description" => "Default value in percent",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-small",
                            "placeholder" => "175px",
                            "group"       => "Layout",
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "horizontal_separator",
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                            "group"      => "Layout",
                        ),
                        array(
                            "param_name"  => "meta_width2",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Meta info width',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-small",
                            "placeholder" => "100%",
                            "group"       => "Layout",
                        ),
                        array(
                            "param_name"  => "meta_margin2",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Meta info margin',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-big",
                            "placeholder" => "0px 0px 0px 0px",
                            "group"       => "Layout",
                        ),
                        array(
                            "param_name"  => "meta_padding2",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Meta info padding',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-big",
                            "placeholder" => "10px 14px",
                            "group"       => "Layout",
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "horizontal_separator",
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                            "group"      => "Layout",
                        ),
                        array(
                            "param_name"  => "art_title2",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Article title space',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-big",
                            "placeholder" => "0px 0px 0px 0px",
                            "group"       => "Layout",
                        ),
                        array(
                            "param_name"  => "art_title_padd2",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Article title padding',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-big",
                            "placeholder" => "0px 0px 0px 0px",
                            "group"       => "Layout",
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "horizontal_separator",
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                            "group"      => "Layout",
                        ),
                        array(
                            "param_name"  => "modules_category_margin2",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Category tag spacing',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-big",
                            "placeholder" => "0px 0px 5px 0px",
                            "group"       => "Layout",
                        ),
                        array(
                            "param_name"  => "modules_category_padding2",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Category tag padding',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-big",
                            "placeholder" => "1px 5px 1px 5px",
                            "group"       => "Layout",
                        ),
                        array(
                            "param_name"  => "show_cat2",
                            "type"        => "dropdown-responsive",
                            "value"       => array(
                                'Show' => 'inline-block',
                                'Hide' => 'none',
                            ),
                            "heading"     => 'Show category',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-dropdown-big",
                            "group"       => "Layout",
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "horizontal_separator",
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                            "group"      => "Layout",
                        ),
                        array(
                            "param_name"  => "show_author2",
                            "type"        => "dropdown-responsive",
                            "value"       => array(
                                'Show' => 'inline-block',
                                'Hide' => 'none',
                            ),
                            "heading"     => 'Show author',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-dropdown-big",
                            "group"       => "Layout",
                        ),
                        array(
                            "param_name"  => "show_date2",
                            "type"        => "dropdown-responsive",
                            "value"       => array(
                                'Show' => 'inline-block',
                                'Hide' => 'none',
                            ),
                            "heading"     => 'Show date',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-dropdown-big",
                            "group"       => "Layout",
                        ),
                        array(
                            "param_name"  => "auth_date_padding2",
                            "type"        => "textfield-responsive",
                            "value"       => '',
                            "heading"     => 'Author & date padding',
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "tdc-textfield-big",
                            "placeholder" => "0px 0px 0px 0px",
                            "group"       => "Layout",
                        ),
                        array(
                            "param_name" => "separator",
                            "type" => "text_separator",
                            'heading' => 'Module fonts',
                            "value" => "",
                            "class" => "",
                            "group" => 'Style',
                        ),
                    ),
                    td_config_helper::get_map_block_font_array( 'f_title1', true, 'Module 1 title', 'Style' ),
                    td_config_helper::get_map_block_font_array( 'f_cat1', false, 'Module 1 category tag', 'Style' ),
                    td_config_helper::get_map_block_font_array( 'f_meta1', false, 'Module 1 meta info', 'Style' ),
                    td_config_helper::get_map_block_font_array( 'f_title3', false, 'Module 1 title - mobile', 'Style' ),
                    td_config_helper::get_map_block_font_array( 'f_cat3', false, 'Module 1 category tag - mobile', 'Style' ),
                    td_config_helper::get_map_block_font_array( 'f_meta3', false, 'Module 1 meta info - mobile', 'Style' ),
                    td_config_helper::get_map_block_font_array( 'f_title2', false, 'Module 2 title', 'Style' ),
                    td_config_helper::get_map_block_font_array( 'f_cat2', false, 'Module 2 category tag', 'Style' ),
                    td_config_helper::get_map_block_font_array( 'f_meta2', false, 'Module 2 meta info', 'Style' ),
                    array(
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Colors',
                            "value"      => "",
                            "class"      => "",
                            "group"      => "Style",
                        ),
                        array(
                            "param_name" => "overlay_general",
                            "holder" => "div",
                            "type" => "gradient",
                            'heading' => "General module overlay color",
                            "value" => "",
                            "class" => "",
                            "group"      => "Style",
                        ),
                        array(
                            "param_name" => "overlay_h_general",
                            "holder" => "div",
                            "type" => "gradient",
                            'heading' => "General module overlay hover color",
                            "value" => "",
                            "class" => "",
                            "group"      => "Style",
                        ),
                        array(
                            "param_name" => "overlay_1",
                            "holder" => "div",
                            "type" => "gradient",
                            'heading' => "Module overlay color 1",
                            "value" => "",
                            "class" => "",
                            "group"      => "Style",
                        ),
                        array(
                            "param_name" => "overlay_2",
                            "holder" => "div",
                            "type" => "gradient",
                            'heading' => "Module overlay color 2",
                            "value" => "",
                            "class" => "",
                            "group"      => "Style",
                        ),
                        array(
                            "param_name" => "overlay_3",
                            "holder" => "div",
                            "type" => "gradient",
                            'heading' => "Module overlay color 3",
                            "value" => "",
                            "class" => "",
                            "group"      => "Style",
                        ),
                        array(
                            "param_name" => "overlay_4",
                            "holder" => "div",
                            "type" => "gradient",
                            'heading' => "Module overlay color 4",
                            "value" => "",
                            "class" => "",
                            "group"      => "Style",
                        ),
                        array(
                            "param_name" => "overlay_5",
                            "holder" => "div",
                            "type" => "gradient",
                            'heading' => "Module overlay color 5",
                            "value" => "",
                            "class" => "",
                            "group"      => "Style",
                        ),
                        array(
                            "param_name"  => "lightsky",
                            "type"        => "checkbox",
                            "value"       => '',
                            "heading"     => "Lightsky",
                            "description" => "",
                            "holder"      => "div",
                            "class"       => "",
                            "group"       => 'Style'
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "",
                            "heading"     => 'Meta info background',
                            "param_name"  => "meta_bg",
                            "value"       => '',
                            "description" => '',
                            "group"       => 'Style',
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "horizontal_separator",
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                            "group"      => "Style",
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "",
                            "heading"     => 'Article title text color',
                            "param_name"  => "title_txt",
                            "value"       => '',
                            "description" => '',
                            "group"       => 'Style',
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "",
                            "heading"     => 'Article title text hover',
                            "param_name"  => "title_txt_hover",
                            "value"       => '',
                            "description" => '',
                            "group"       => 'Style',
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "",
                            "heading"     => 'Article title background color',
                            "param_name"  => "title_bg",
                            "value"       => '',
                            "description" => '',
                            "group"       => 'Style',
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "horizontal_separator",
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                            "group"      => "Style",
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "",
                            "heading"     => 'Category background',
                            "param_name"  => "cat_bg",
                            "value"       => '',
                            "description" => '',
                            "group"       => 'Style',
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "",
                            "heading"     => 'Category text color',
                            "param_name"  => "cat_txt",
                            "value"       => '',
                            "description" => '',
                            "group"       => 'Style',
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "",
                            "heading"     => 'Category background hover',
                            "param_name"  => "cat_bg_hover",
                            "value"       => '',
                            "description" => '',
                            "group"       => 'Style',
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "",
                            "heading"     => 'Category text hover',
                            "param_name"  => "cat_txt_hover",
                            "value"       => '',
                            "description" => '',
                            "group"       => 'Style',
                        ),
                        array(
                            "param_name" => "separator",
                            "type"       => "horizontal_separator",
                            "value"      => "",
                            "class"      => "tdc-separator-small",
                            "group"      => "Style",
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "",
                            "heading"     => 'Author text color',
                            "param_name"  => "author_txt",
                            "value"       => '',
                            "description" => '',
                            "group"       => 'Style',
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "",
                            "heading"     => 'Author text hover',
                            "param_name"  => "author_txt_hover",
                            "value"       => '',
                            "description" => '',
                            "group"       => 'Style',
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "",
                            "heading"     => 'Date text color',
                            "param_name"  => "date_txt",
                            "value"       => '',
                            "description" => '',
                            "group"       => 'Style',
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "",
                            "heading"     => 'Author & date background color',
                            "param_name"  => "auth_date_bg",
                            "value"       => '',
                            "description" => '',
                            "group"       => 'Style',
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "",
                            "heading"     => 'Review stars color',
                            "param_name"  => "review_stars",
                            "value"       => '',
                            "description" => '',
                            "group"       => 'Style',
                        ),
                    ),
                    self::get_map_css_tab()
                )
            )
        );

	    td_api_block::add('td_block_big_grid_slide',
		    array(
			    'map_in_visual_composer' => true,
			    'map_in_td_composer' => true,
			    "name" => 'Big Grid Slide',
			    "base" => 'td_block_big_grid_slide',
			    "class" => 'td_block_big_grid_slide',
			    "controls" => "full",
			    "category" => 'Blocks',
			    'tdc_category' => 'Big Grids',
			    'icon' => 'icon-pagebuilder-td_block_big_grid_slide',
			    'file' => td_global::$get_template_directory . '/includes/shortcodes/td_block_big_grid_slide.php',
			    "params" => self::td_block_big_grid_slide_params(),
		    )
	    );



        td_api_block::add('td_block_trending_now',
            array(
                'map_in_visual_composer' => true,
	            'map_in_td_composer' => true,
                "name" => 'News ticker',
                "base" => 'td_block_trending_now',
                "class" => 'td_block_trending_now',
                "controls" => "full",
                "category" => 'Blocks',
	            'tdc_category' => 'Extended',
                'icon' => 'icon-pagebuilder-td_block_trending_now',
                'file' => td_global::$get_template_directory . '/includes/shortcodes/td_block_trending_now.php',
                'tdc_style_params' => array(
                    'custom_title',
                    'custom_url',
                    'post_ids',
                    'category_id',
                    'category_ids',
                    'tag_slug',
                    'autors_id',
                    'sort',
                    'offset',
                    'el_class'
                ),
                "params" => array_merge(
	                array (
		                array(
			                "param_name" => "navigation",
			                "type" => "dropdown",
			                "value" => array('Auto' => '', 'Manual' => 'manual'),
			                "heading" => 'Navigation:',
			                "description" => "If set on `Auto` will set the `Trending Now` block to auto start rotating posts",
			                "holder" => "div",
			                "class" => "tdc-dropdown-big"
		                ),
		                array(
			                "param_name" => "style",
			                "type" => "dropdown",
			                "value" => array('Default' => '', 'Style 2' => 'style2'),
			                "heading" => 'Style:',
			                "description" => "Style of the `Trending Now` box",
			                "holder" => "div",
			                "class" => "tdc-dropdown-big"
		                ),
	                ),
	                self::get_map_filter_array(),
	                array(
		                array(
			                "type" => "colorpicker",
			                "holder" => "div",
			                "class" => "",
			                "heading" => 'Title text color',
			                "param_name" => "header_text_color",
			                "value" => '',
			                "description" => 'Optional - Choose a custom title text color for this block',
			                'group' => 'Style'
		                ),
		                array(
			                "type" => "colorpicker",
			                "holder" => "div",
			                "class" => "",
			                "heading" => 'Title background color',
			                "param_name" => "header_color",
			                "value" => '',
			                "description" => 'Optional - Choose a custom title background color for this block',
			                'group' => 'Style'
		                ),
		                array(
			                "type" => "colorpicker",
			                "holder" => "div",
			                "class" => "",
			                "heading" => 'Articles title color',
			                "param_name" => "articles_color",
			                "value" => '',
			                "description" => 'Optional - Choose a custom article title color for this block',
			                'group' => 'Style'
		                ),
		                array(
			                "type" => "colorpicker",
			                "holder" => "div",
			                "class" => "",
			                "heading" => 'Next/prev arrow color',
			                "param_name" => "next_prev_color",
			                "value" => '',
			                "description" => 'Optional - Choose a custom next/prev arrow color for this block',
			                'group' => 'Style'
		                ),
		                array(
			                "type" => "colorpicker",
			                "holder" => "div",
			                "class" => "",
			                "heading" => 'Next/prev border color',
			                "param_name" => "next_prev_border_color",
			                "value" => '',
			                "description" => 'Optional - Choose a custom next/prev border color for this block',
			                'group' => 'Style'
		                ),
		                array(
			                "param_name" => "separator",
			                "type" => "horizontal_separator",
			                "value" => "",
			                "class" => "",
			                'group' => 'Style'
		                ),
	                ),
	                td_config_helper::get_map_block_font_array( 'f_title', true, 'Block title', 'Style' ),
	                td_config_helper::get_map_block_font_array( 'f_article', false, 'Articles title', 'Style' ),
	                array (
		                array (
			                'param_name' => 'css',
			                'value' => '',
			                'type' => 'css_editor',
			                'heading' => 'Css',
			                'group' => 'Design options',
		                ),
		                array (
			                'param_name' => 'tdc_css',
			                'value' => '',
			                'type' => 'tdc_css_editor',
			                'heading' => '',
			                'group' => 'Design options',
		                ),
	                )
                )
            )
        );

        td_api_block::add('td_block_video_youtube',
            array(
                'map_in_visual_composer' => true,
	            'map_in_td_composer' => true,
                "name" => 'Video Playlist',
                "base" => "td_block_video_youtube",
                "class" => "td_block_video_playlist_youtube",
                "controls" => "full",
                "category" => 'Blocks',
	            'tdc_category' => 'Extended',
                'icon' => 'icon-pagebuilder-td-youtube',
                'file' => td_global::$get_template_directory . '/includes/shortcodes/td_block_video_youtube.php',
                "params" => array_merge(
                    array(
                        array(
                            "param_name" => "playlist_title",
                            "type" => "textfield",
                            "value" => "",
                            //"heading" => __("Optional - custom title for this block:", TD_THEME_NAME),
                            "heading" => "Optional - custom title for this block:",
                            "description" => "",
                            "holder" => "div",
                            "class" => "",
                        ),
                        array(
                            "param_name" => "playlist_yt",
                            "type" => "textfield",
                            "value" => "",
                            //"heading" => __("Optional - custom title for this block:", TD_THEME_NAME),
                            "heading" => "List of youtube id's separated by comma (ex: NRuE38Bl5Mo, 1ZgoluYjuZM, 0K-0vkFfUmY):",
                            "description" => "",
                            "holder" => "div",
                            "class" => "",
                        ),
                        array(
                            "param_name" => "playlist_auto_play",
                            "type" => "dropdown",
                            "value" => array('OFF' => '0', 'ON' => '1'),
                            //"heading" => __("Select playlist type:", TD_THEME_NAME),
                            "heading" => "Autoplay ON / OFF:",
                            "description" => "Autoplay does not work on mobile devices (android, windows phone, iOS)",
                            "holder" => "div",
                            "class" => "tdc-dropdown-small",
                        ),
                        array(
                            "param_name" => "separator",
                            "type" => "horizontal_separator",
                            "value" => "",
                            "class" => ""
                        ),
                    ),
//                    td_config_helper::get_map_block_font_array( 'f_vid', true, 'Videos title text' ),
//                    td_config_helper::get_map_block_font_array( 'f_curr_vid', false, 'Current video title text' ),
//                    td_config_helper::get_map_block_font_array( 'f_timestamp', false, 'Videos timestamp text' ),
                    array(
                        array(
                            "param_name" => "separator",
                            "type" => "horizontal_separator",
                            "value" => "",
                            "class" => ""
                        ),
                        array(
                            'param_name' => 'el_class',
                            'type' => 'textfield',
                            'value' => '',
                            'heading' => 'Extra class',
                            'description' => 'Style particular content element differently - add a class name and refer to it in custom CSS',
                            'class' => 'tdc-textfield-extrabig',
                        ),
                        array (
                            'param_name' => 'css',
                            'value' => '',
                            'type' => 'css_editor',
                            'heading' => 'Css',
                            'group' => 'Design options',
                        ),
                        array (
                            'param_name' => 'tdc_css',
                            'value' => '',
                            'type' => 'tdc_css_editor',
                            'heading' => '',
                            'group' => 'Design options',
                        ),
                    )
                )
            )
        );

        td_api_block::add('td_block_video_vimeo',
            array(
                'map_in_visual_composer' => true,
	            'map_in_td_composer' => true,
                "name" => 'Video Playlist',
                "base" => "td_block_video_vimeo",
                "class" => "td_block_video_playlist_vimeo",
                "controls" => "full",
                "category" => 'Blocks',
	            'tdc_category' => 'Extended',
                'icon' => 'icon-pagebuilder-td-vimeo',
                'file' => td_global::$get_template_directory . '/includes/shortcodes/td_block_video_vimeo.php',
                "params" => array_merge(
                    array(
                        array(
                            "param_name" => "playlist_title",
                            "type" => "textfield",
                            "value" => "",
                            //"heading" => __("Optional - custom title for this block:", TD_THEME_NAME),
                            "heading" => "Optional - custom title for this block:",
                            "description" => "",
                            "holder" => "div",
                            "class" => "",
                        ),
                        array(
                            "param_name" => "playlist_v",
                            "type" => "textfield",
                            "value" => "",
                            //"heading" => __("Optional - custom title for this block:", TD_THEME_NAME),
                            "heading" => "List of vimeo id's separated by comma (ex: 100888579,  84062802, 57863017):",
                            "description" => "",
                            "holder" => "div",
                            "class" => "",
                        ),
                        array(
                            "param_name" => "playlist_auto_play",
                            "type" => "dropdown",
                            "value" => array('OFF' => '0', 'ON' => '1'),
                            //"heading" => __("Select playlist type:", TD_THEME_NAME),
                            "heading" => "Autoplay ON / OFF:",
                            "description" => "",
                            "holder" => "div",
                            "class" => "tdc-dropdown-small",
                        ),
                        array(
                            "param_name" => "separator",
                            "type" => "horizontal_separator",
                            "value" => "",
                            "class" => ""
                        ),
                    ),
//                    td_config_helper::get_map_block_font_array( 'f_vid', true, 'Videos title text' ),
//                    td_config_helper::get_map_block_font_array( 'f_curr_vid', false, 'Current video title text' ),
//                    td_config_helper::get_map_block_font_array( 'f_timestamp', false, 'Videos timestamp text' ),
                    array(
                        array(
                            "param_name" => "separator",
                            "type" => "horizontal_separator",
                            "value" => "",
                            "class" => ""
                        ),
                        array(
                            'param_name' => 'el_class',
                            'type' => 'textfield',
                            'value' => '',
                            'heading' => 'Extra class',
                            'description' => 'Style particular content element differently - add a class name and refer to it in custom CSS',
                            'class' => 'tdc-textfield-extrabig',
                        ),
                        array (
                            'param_name' => 'css',
                            'value' => '',
                            'type' => 'css_editor',
                            'heading' => 'Css',
                            'group' => 'Design options',
                        ),
                        array (
                            'param_name' => 'tdc_css',
                            'value' => '',
                            'type' => 'tdc_css_editor',
                            'heading' => '',
                            'group' => 'Design options',
                        ),
                    )
                )
            )
        );

        td_api_block::add('td_block_ad_box',
            array(
                'map_in_visual_composer' => true,
	            'map_in_td_composer' => true,
                "name" => 'Ad box',
                "base" => 'td_block_ad_box',
                "class" => "",
                "controls" => "full",
                "category" => 'Blocks',
	            'tdc_category' => 'Extended',
                'icon' => 'icon-pagebuilder-ads',
                'file' => td_global::$get_template_directory . '/includes/shortcodes/td_block_ad_box.php',
                'tdc_style_params' => array(
                    'custom_title',
                    'custom_url',
                    'spot_id',
                    'spot_title',
                    'el_class'
                ),
                "params" => array_merge(
                    self::get_map_block_general_array(),
	                array(
	                    array(
	                        "param_name" => "spot_id",
	                        "type" => "dropdown",
	                        "value" => array(
	                            '- Select an ad spot -' => '',
	                            'sidebar' => 'sidebar',
	                            'custom_ad_1' => 'custom_ad_1',
	                            'custom_ad_2' => 'custom_ad_2',
	                            'custom_ad_3' => 'custom_ad_3',
	                            'custom_ad_4' => 'custom_ad_4',
	                            'custom_ad_5' => 'custom_ad_5'
	                        ),
	                        "heading" => 'Use adspot from:',
	                        "description" => 'Choose the adspot from list',
	                        "holder" => "div",
	                        "class" => "tdc-dropdown-big",
	                    ),

	                    array(
	                        "param_name" => "spot_title",
	                        "type" => "textfield",
	                        "value" => "",
	                        "heading" => 'Ad title:',
	                        "description" => "Optional - a title for the Ad, like - Advertisement - if you leave it blank the block will not have a title",
	                        "holder" => "div",
	                        "class" => "tdc-textfield-extrabig",
	                    ),
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Style',
                            "value"      => "",
                            "class"      => "",
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "",
                            "heading"     => 'Ad title color',
                            "param_name"  => "ad_title_color",
                            "value"       => '',
                            "description" => '',
                            "group"       => "",
                        ),
                    ),
                    td_config_helper::get_map_block_font_array( 'f_title', true, 'Ad title text' ),
                    array(
		                array(
			                "param_name" => "separator",
			                "type" => "horizontal_separator",
			                "value" => "",
			                "class" => ""
		                ),
		                array(
			                'param_name' => 'el_class',
			                'type' => 'textfield',
			                'value' => '',
			                'heading' => 'Extra class',
			                'description' => 'Style particular content element differently - add a class name and refer to it in custom CSS',
			                'class' => 'tdc-textfield-extrabig',
		                ),
		                array (
			                'param_name' => 'css',
			                'value' => '',
			                'type' => 'css_editor',
			                'heading' => 'Css',
			                'group' => 'Design options',
		                ),
		                array (
			                'param_name' => 'tdc_css',
			                'value' => '',
			                'type' => 'tdc_css_editor',
			                'heading' => '',
			                'group' => 'Design options',
			            ),
                    )
                ),
            )
        );

        td_api_block::add('td_block_image_box',
            array(
                'map_in_visual_composer' => true,
	            'map_in_td_composer' => true,
                "name" => 'Image box',
                "base" => "td_block_image_box",
                "class" => "",
                "controls" => "full",
                "category" => 'Blocks',
	            'tdc_category' => 'Extended',
                'icon' => 'icon-pagebuilder-td_block_image_box',
                'file' => td_global::$get_template_directory . '/includes/shortcodes/td_block_image_box.php',
                'tdc_style_params' => array(
                    'custom_title',
                    'custom_url',
                    'image_item0',
                    'image_title_item0',
                    'custom_url_item0',
                    'image_item1',
                    'image_title_item1',
                    'custom_url_item1',
                    'image_item2',
                    'image_title_item2',
                    'custom_url_item2',
                    'image_item3',
                    'image_title_item3',
                    'custom_url_item3',
                    'el_class'
                ),
                "params" => array_merge(
	                self::get_map_block_general_array(),
	                array(
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Shortcode',
                            "value"      => "",
                            "class"      => "",
                        ),
	                    array(
	                        "param_name" => "height",
	                        "type" => "textfield-responsive",
	                        "value" => '',
	                        "heading" => 'Image height',
	                        "description" => "The image height 100 or 100px",
	                        "holder" => "div",
	                        "class" => "tdc-textfield-small"
	                    ),
	                    array(
	                        "param_name" => "gap",
	                        "type" => "textfield-responsive",
	                        "value" => '',
	                        "heading" => 'Image gap',
	                        "description" => "The gap between block images",
	                        "holder" => "div",
	                        "class" => "tdc-textfield-small",
                            "placeholder" => "40"
	                    ),
	                    array(
	                        "param_name" => "alignment",
	                        "type" => "dropdown",
	                        "value" => array(
	                            '- Center -' => '',
                                'Top' => 'top',
	                            'Bottom' => 'bottom'
	                        ),
	                        "heading" => 'Image alignment',
	                        "description" => "The image alignment",
	                        "holder" => "div",
	                        "class" => "tdc-dropdown-big",
	                    ),
	                    array(
	                        "param_name" => "display",
	                        "type" => "dropdown",
	                        "value" => array(
	                            '- Horizontal -' => '',
	                            'Vertical' => 'vertical'
	                        ),
	                        "heading" => 'Layout',
	                        "description" => "Block images layout style",
	                        "holder" => "div",
	                        "class" => "tdc-dropdown-big",
	                    ),
	                    array(
	                        "param_name" => "style",
	                        "type" => "dropdown",
	                        "value" => array(
	                            '1 - With border' => '',
	                            '2 - White box' => 'style-2'
	                        ),
	                        "heading" => 'Box style',
	                        "description" => "Block images box style",
	                        "holder" => "div",
	                        "class" => "tdc-dropdown-big",
	                    ),
                        array(
                            "param_name" => "separator",
                            "type"       => "text_separator",
                            'heading'    => 'Style',
                            "value"      => "",
                            "class"      => "",
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "",
                            "heading"     => 'Custom titles color',
                            "param_name"  => "custom_titles_color",
                            "value"       => '',
                            "description" => '',
                            "group"       => "",
                        ),
                        array(
                            "type"        => "colorpicker",
                            "holder"      => "div",
                            "class"       => "",
                            "heading"     => 'Custom titles background color',
                            "param_name"  => "custom_titles_bg",
                            "value"       => '',
                            "description" => '',
                            "group"       => "",
                        ),
                    ),
                    td_config_helper::get_map_block_font_array( 'f_header', true, 'Block header' ),
                    td_config_helper::get_map_block_font_array( 'f_titles', false, 'Custom titles text' ),
                    array(
	                    array(
	                        "param_name" => "separator",
	                        "type" => "horizontal_separator",
	                        "value" => "",
	                        "class" => ""
	                    ),
	                    array(
	                        'param_name' => 'el_class',
	                        'type' => 'textfield',
	                        'value' => '',
	                        'heading' => 'Extra class',
	                        'description' => 'Style particular content element differently - add a class name and refer to it in custom CSS',
	                        'class' => 'tdc-textfield-extrabig'
	                    ),
	                    array(
	                        "param_name" => "image_item0",
	                        "type" => "attach_image",
	                        "value" => '',
	                        "heading" => "Image 1",
	                        "description" => "",
	                        "holder" => "div",
	                        "class" => "",
	                        "group" => 'Images'
	                    ),
	                    array(
	                        "param_name" => "image_title_item0",
	                        "type" => "textfield",
	                        "value" => '',
	                        "heading" => "Custom title",
	                        "description" => "",
	                        "holder" => "div",
	                        "class" => "tdc-textfield-extrabig",
	                        "group" => 'Images'
	                    ),
	                    array(
	                        "param_name" => "custom_url_item0",
	                        "type" => "textfield",
	                        "value" => '',
	                        "heading" => "Custom url",
	                        "description" => "",
	                        "holder" => "div",
	                        "class" => "tdc-textfield-extrabig",
	                        "group" => 'Images'
	                    ),
	                    array(
	                        "param_name" => "open_in_new_window_item0",
	                        "type" => "checkbox",
	                        "value" => '',
	                        "heading" => "Open in new window",
	                        "description" => "",
	                        "holder" => "div",
	                        "class" => "",
	                        "group" => 'Images'
	                    ),
	                    array(
	                        "param_name" => "horizontal_separator_item1",
	                        "type" => "horizontal_separator",
	                        "value" => "",
	                        "class" => "",
	                        "group" => 'Images'
	                    ),
	                    array(
	                        "param_name" => "image_item1",
	                        "type" => "attach_image",
	                        "value" => '',
	                        "heading" => "Image 2",
	                        "description" => "",
	                        "holder" => "div",
	                        "class" => "",
	                        "group" => 'Images'
	                    ),
	                    array(
	                        "param_name" => "image_title_item1",
	                        "type" => "textfield",
	                        "value" => '',
	                        "heading" => "Custom title",
	                        "description" => "",
	                        "holder" => "div",
	                        "class" => "tdc-textfield-extrabig",
	                        "group" => 'Images'
	                    ),
	                    array(
	                        "param_name" => "custom_url_item1",
	                        "type" => "textfield",
	                        "value" => '',
	                        "heading" => "Custom url",
	                        "description" => "",
	                        "holder" => "div",
	                        "class" => "tdc-textfield-extrabig",
	                        "group" => 'Images'
	                    ),
	                    array(
	                        "param_name" => "open_in_new_window_item1",
	                        "type" => "checkbox",
	                        "value" => '',
	                        "heading" => "Open in new window",
	                        "description" => "",
	                        "holder" => "div",
	                        "class" => "",
	                        "group" => 'Images'
	                    ),
	                    array(
	                        "param_name" => "horizontal_separator_item2",
	                        "type" => "horizontal_separator",
	                        "value" => "",
	                        "class" => "",
	                        "group" => 'Images'
	                    ),
	                    array(
	                        "param_name" => "image_item2",
	                        "type" => "attach_image",
	                        "value" => '',
	                        "heading" => "Image 3",
	                        "description" => "",
	                        "holder" => "div",
	                        "class" => "",
	                        "group" => 'Images'
	                    ),
	                    array(
	                        "param_name" => "image_title_item2",
	                        "type" => "textfield",
	                        "value" => '',
	                        "heading" => "Custom title",
	                        "description" => "",
	                        "holder" => "div",
	                        "class" => "tdc-textfield-extrabig",
	                        "group" => 'Images'
	                    ),
	                    array(
	                        "param_name" => "custom_url_item2",
	                        "type" => "textfield",
	                        "value" => '',
	                        "heading" => "Custom url",
	                        "description" => "",
	                        "holder" => "div",
	                        "class" => "tdc-textfield-extrabig",
	                        "group" => 'Images'
	                    ),
	                    array(
	                        "param_name" => "open_in_new_window_item2",
	                        "type" => "checkbox",
	                        "value" => '',
	                        "heading" => "Open in new window",
	                        "description" => "",
	                        "holder" => "div",
	                        "class" => "",
	                        "group" => 'Images'
	                    ),
	                    array(
	                        "param_name" => "horizontal_separator_item3",
	                        "type" => "horizontal_separator",
	                        "value" => "",
	                        "class" => "",
	                        "group" => 'Images'
	                    ),
	                    array(
	                        "param_name" => "image_item3",
	                        "type" => "attach_image",
	                        "value" => '',
	                        "heading" => "Image 4",
	                        "description" => "",
	                        "holder" => "div",
	                        "class" => "",
	                        "group" => 'Images'
	                    ),
	                    array(
	                        "param_name" => "image_title_item3",
	                        "type" => "textfield",
	                        "value" => '',
	                        "heading" => "Custom title",
	                        "description" => "",
	                        "holder" => "div",
	                        "class" => "tdc-textfield-extrabig",
	                        "group" => 'Images'
	                    ),
	                    array(
	                        "param_name" => "custom_url_item3",
	                        "type" => "textfield",
	                        "value" => '',
	                        "heading" => "Custom url",
	                        "description" => "",
	                        "holder" => "div",
	                        "class" => "tdc-textfield-extrabig",
	                        "group" => 'Images'
	                    ),
	                    array(
	                        "param_name" => "open_in_new_window_item3",
	                        "type" => "checkbox",
	                        "value" => '',
	                        "heading" => "Open in new window",
	                        "description" => "",
	                        "holder" => "div",
	                        "class" => "",
	                        "group" => 'Images'
	                    ),
	                    array (
	                        'param_name' => 'css',
	                        'value' => '',
	                        'type' => 'css_editor',
	                        'heading' => 'Css',
	                        'group' => 'Design options',
	                    ),
		                array (
			                'param_name' => 'tdc_css',
			                'value' => '',
			                'type' => 'tdc_css_editor',
			                'heading' => '',
			                'group' => 'Design options',
			            ),
	                )
                )
            )
        );

        td_api_block::add('td_block_author',
            array(
                'map_in_visual_composer' => true,
	            'map_in_td_composer' => true,
                "name" => 'Author box',
                "base" => "td_block_author",
                "class" => "",
                "controls" => "full",
                "category" => 'Blocks',
	            'tdc_category' => 'Extended',
                'icon' => 'icon-pagebuilder-td_block_author',
                'file' => td_global::$get_template_directory . '/includes/shortcodes/td_block_author.php',
                'tdc_style_params' => array(
                    'custom_title',
                    'custom_url',
                    'author_id',
                    'author_url_text',
                    'author_url',
                    'el_class'
                ),
                "params" => array_merge(
	                self::get_map_block_general_array(),
	                array(
	                    array(
	                        "param_name" => "author_id",
	                        "type" => "textfield",
	                        "value" => '',
	                        "heading" => "Author ID",
	                        "description" => "",
	                        "holder" => "div",
	                        "class" => "tdc-textfield-small",
	                    ),
	                    array(
	                        "param_name" => "author_url_text",
	                        "type" => "textfield",
	                        "value" => '',
	                        "heading" => "Author page link text",
	                        "description" => "",
	                        "holder" => "div",
	                        "class" => "tdc-textfield-big",
	                    ),
	                    array(
	                        "param_name" => "author_url",
	                        "type" => "textfield",
	                        "value" => '',
	                        "heading" => "Author page link url",
	                        "description" => "",
	                        "holder" => "div",
	                        "class" => "tdc-textfield-big",
	                    ),
	                    array(
	                        "param_name" => "open_in_new_window",
	                        "type" => "checkbox",
	                        "value" => '',
	         